#line 1 "D:/MikroC/Fox/ /Fox/Fox.c"
#line 22 "D:/MikroC/Fox/ /Fox/Fox.c"
void interrupt( void );
void Init_CPU( void );
void dash( void );
void point( void );

const unsigned int Tmr1_in = 3036;
const unsigned int Cikl_5 = 600;
const unsigned char Cikl_P = 110;
const unsigned char Cikl_N = 120;
unsigned int Time, TimePTT;
volatile unsigned int counter;
volatile unsigned char i;
unsigned char U_in, Flag;
unsigned char n;
#line 39 "D:/MikroC/Fox/ /Fox/Fox.c"
void interrupt( void )
{
 if ( TMR1IF_bit & TMR1IE_bit )
 {
 counter ++;
 TMR1ON_bit = 0;
 TMR1H = ( Tmr1_in >> 8 );
 TMR1L = ( Tmr1_in & 0x00FF );
 TMR1ON_bit = 1;
 TMR1IF_bit = 0;

 if ( Flag )
 {
 if ( counter > TimePTT )
 {
  GPIO.F1  = 0;
 Flag = 0;
 }
 }
 }
}
#line 63 "D:/MikroC/Fox/ /Fox/Fox.c"
void dash( void )
{
 unsigned char k;

 for ( k = 0; k < 150; k++ )
 {
  GPIO.F2  = 1;
 Delay_ms( 1 );
  GPIO.F2  = 0;
 Delay_ms( 1 );
 }
}
#line 87 "D:/MikroC/Fox/ /Fox/Fox.c"
void point( void )
{
 unsigned char k;

 for ( k = 0; k < 50; k++ )
 {
  GPIO.F2  = 1;
 Delay_ms( 1 );
  GPIO.F2  = 0;
 Delay_ms( 1 );
 }
}
#line 111 "D:/MikroC/Fox/ /Fox/Fox.c"
void Init_CPU( void )
{
 GPIO = 0;
 INTCON = 0;
 OPTION_REG = 0b10001111;
 TRISIO = 0b00111001;
 WPU = 0;
 ANSEL = 0b01010001;
 ADCON0 = 0;
 CMCON = 0x07;
 T1CON = 0b00110001;
 TMR1IE_bit = 1;
 PEIE_bit = 1;
 GIE_bit = 1;
}


void main( void )
{
 counter = 0;
 Init_CPU();

 if (  GPIO.F3  )
 {
 ADCON0 = 0x01;
 ADIF_bit = 0;
 ADRESH = 0;
 Delay_us( 20 );
 GO_DONE_bit = 1;

 while ( !ADIF_bit );

 U_in = ADRESH;

 if ( U_in < 32 )
 {
 n = 1;
 }
 else if ( ( U_in > 44 ) && ( U_in < 84 ) )
 {
 n = 2;
 }
 else if ( ( U_in > 100 ) && ( U_in < 150 ) )
 {
 n = 3;
 }
 else if ( ( U_in > 170 ) && ( U_in < 210 ) )
 {
 n = 4;
 }
 else if ( U_in > 220 )
 {
 n = 5;
 }

 Time = ( counter + ( (n - 1) * Cikl_N ) );

 while ( counter < Time )
 {
 asm CLRWDT;
 continue;
 }

 while ( 1 )
 {
 Flag = 1;
 Time = ( counter + Cikl_5 );

 while ( counter < Time )
 {
 if ( Flag )
 {
  GPIO.F1  = 1;
 TimePTT = ( counter + Cikl_P );

 while ( Flag )
 {
 dash();
 Delay_ms( 100 );
 dash();
 Delay_ms( 300 );
 dash();
 asm CLRWDT;
 Delay_ms( 100 );
 dash();
 Delay_ms( 100 );
 dash();
 asm CLRWDT;
 Delay_ms( 300 );

 for ( i = 0; i < n; i ++ )
 {
 point();
 Delay_ms( 100 );
 }

 Delay_ms( 600 );
 asm CLRWDT;
 }
 }

 asm CLRWDT;
 continue;
 }
 }
 }
 else
 {
 TMR1ON_bit = 0;
 GIE_bit = 0;
  GPIO.F1  = 1;

 while ( 1 )
 {
 dash();
 Delay_ms( 100 );
 dash();
 Delay_ms( 300 );
 dash();
 asm CLRWDT;
 Delay_ms( 100 );
 dash();
 Delay_ms( 100 );
 dash();
 asm CLRWDT;
 Delay_ms( 700 );
 asm CLRWDT;
 }
 }
}
