/* *********************************************************************
""  PIC12F675      4.

 MikroC Pro 6.0.0 
 Edit Project
HS oscillator  -   GP4,GP5
WDT enabled -    
PWRT enabled -        
GP3/MCLR/disable -   MCLR   
Brown-out Reset enabled -      
Program memory code protection is disable -     
Data memory code protection is disable -   EEPROM  
  
  Used RAM (bytes): 15 (31%)  Free RAM (bytes): 33 (69%)
  Used ROM (program words): 500 (49%)  Free ROM (program words): 524 (51%)
**********************************************************************/

#define  S6   GPIO.F3            // 
#define  PTT  GPIO.F1            // 
#define  Out1 GPIO.F2            // 

void interrupt( void );
void Init_CPU( void );
void dash( void );
void point( void );

const unsigned int Tmr1_in = 3036;// 4,00084  (3060  10 )
const unsigned int Cikl_5 = 600;  //  5  (1500  10 )
const unsigned char Cikl_P = 110; //  "" 55 (275  10 ) 
const unsigned char Cikl_N = 120; // "" 1 (300  10 )
unsigned int Time, TimePTT;
volatile unsigned int counter;    //
volatile unsigned char i;
unsigned char  U_in, Flag;
unsigned char n;                  // ""
/* *******************************************************
  
 ********************************************************/
void interrupt( void )
{
   if ( TMR1IF_bit & TMR1IE_bit )
   {
      counter ++;
      TMR1ON_bit = 0;
      TMR1H = ( Tmr1_in >> 8 );
      TMR1L = ( Tmr1_in & 0x00FF );
      TMR1ON_bit = 1;
      TMR1IF_bit = 0;

      if ( Flag )
      {
         if ( counter > TimePTT ) //  
         {
            PTT = 0;              // 
            Flag = 0;             //      
         }
      }
   }
}
/* *******************************************************
   500 
********************************************************/
void dash( void )
{
   unsigned char k;

   for ( k = 0; k < 150; k++ )
   {
      Out1 = 1;
      Delay_ms( 1 );
      Out1 = 0;
      Delay_ms( 1 );
   }
}
/* *******************************************************
   
********************************************************
void dash( void )
{
      Out1 = 1;
      Delay_ms( 300 );
      Out1 = 0;
} */   
/* *******************************************************
    500 
********************************************************/
void point( void )
{
   unsigned char k;

   for ( k = 0; k < 50; k++ )
   {
      Out1 = 1;
      Delay_ms( 1 );
      Out1 = 0;
      Delay_ms( 1 );
   }
}
/* *******************************************************
   
********************************************************
void point( void )
{
      Out1 = 1;
      Delay_ms( 100 );
      Out1 = 0;
} */
/*======================
   
======================*/
void Init_CPU( void )
{
   GPIO = 0;
   INTCON = 0;
   OPTION_REG = 0b10001111;  //..,. WDT,.=128:
   TRISIO = 0b00111001;
   WPU = 0;
   ANSEL = 0b01010001;       //1   ,Fosc/16  0x51
   ADCON0 = 0;
   CMCON = 0x07;             // .
   T1CON = 0b00110001;       // 8,  524 . 0x31 ( 200   10 )
   TMR1IE_bit = 1;
   PEIE_bit  = 1;
   GIE_bit  = 1;
}

/* *************************************************************/
void main( void )
{
   counter = 0;
   Init_CPU();

   if ( S6 )                    //""  
   {
      ADCON0 =  0x01;
      ADIF_bit = 0;              // 
      ADRESH = 0;                // 
      Delay_us( 20 );            //
      GO_DONE_bit = 1;           //

      while ( !ADIF_bit );       // 

      U_in = ADRESH;

      if ( U_in  < 32 )          //  
      {
         n = 1;                  //  1
      }
      else if ( ( U_in > 44 ) && ( U_in < 84 ) )
      {
         n = 2;                  //  2
      }
      else if ( ( U_in > 100 ) && ( U_in < 150 ) )
      {
         n = 3;                  //  3
      }
      else if ( ( U_in > 170 ) && ( U_in < 210 ) )
      {
         n = 4;                  //  4
      }
      else if ( U_in > 220 )
      {
         n = 5;                  //  5
      }

      Time = ( counter + ( (n - 1) * Cikl_N ) ); //     

      while ( counter < Time )
      {
         asm CLRWDT;
         continue;
      }

      while ( 1 )
      {
         Flag = 1;
         Time = ( counter + Cikl_5 ); //  5   

         while ( counter < Time )
         {
            if ( Flag )
            {
               PTT = 1;            // 
               TimePTT = ( counter + Cikl_P ); // 55 

               while ( Flag )
               {
                  dash();          // 
                  Delay_ms( 100 );
                  dash();
                  Delay_ms( 300 ); // 3 
                  dash();
                  asm CLRWDT;      // 
                  Delay_ms( 100 );
                  dash();
                  Delay_ms( 100 );
                  dash();
                  asm CLRWDT;
                  Delay_ms( 300 ); // 3 

                  for ( i = 0; i < n; i ++ )  //   
                  {
                     point();
                     Delay_ms( 100 );
                  }

                  Delay_ms( 600 ); // 7 
                  asm CLRWDT;
               }
            }

            asm CLRWDT;
            continue;              //  
         }
      }
   }
   else                            //"" 
   {
      TMR1ON_bit = 0;
      GIE_bit = 0;
      PTT = 1;                     // 

      while ( 1 )
      {
         dash();                   // 
         Delay_ms( 100 );
         dash();
         Delay_ms( 300 );          // 3 
         dash();
         asm CLRWDT;               // 
         Delay_ms( 100 );
         dash();
         Delay_ms( 100 );
         dash();
         asm CLRWDT;
         Delay_ms( 700 );          // 7 
         asm CLRWDT;
      }
   }
}