int Trig[5] = {8, 15, 19, 13, 17}; //массив номеров портов для полдключения выводов Trig датчиков HC-SR04
int Echo[5] = {12, 18, 7, 14, 16}; //массив номеров портов для полдключения выводов Echo датчиков HC-SR04
int M[5] = {6, 11, 3, 10, 9}; //массив номеров портов для полдключения вибромоторов
int signal[5] = {0, 0, 0, 0, 0};//массив переменных для хранения интенсивности работы вибромоторов
int PM[5] = {0, 0, 0, 0, 0}; // массив переменных для хранения результатов измерения
int i,j; //счетчики в массивах
int k=155; // максимальная интенсивность работы вибромотора
int dt = 15;
int c = 93;
int voltage_port = 7; //аналоговый порт с которого считывается напряжение питания
int voltage = 0; //переменная для хранения значения напряжения питания

void setup()
{
  Serial.begin(9600);
  //Инициализация портов для HC-SR04
  for (i = 0; i <= 4; i = i + 1)
  {
    pinMode(Trig[i],OUTPUT);
    pinMode(Echo[i],INPUT);
  }
  //Звуковой сигнал Устройство включено 
  pinMode(2,OUTPUT);
  tone(2,1000);
  delay(2000);
  noTone(2); //выключение звука
}

void loop()
{
  // проверка источника питания
  for (i = 0; i <= 4; i = i + 1) 
  {
    analogWrite(M[i], 0);
  }
  voltage = analogRead(voltage_port);  // считываем значение напряжение питания
  voltage = voltage*0.0049;
  Serial.print("voltage = "); 
  Serial.println(voltage);  
  if (voltage < 2.9)  //проверка не разряжен ли аккумулятор
  {
    //Звуковой сигнал Аккумулятор разряжен 
    tone(2,500);
    delay(1000);
    tone(2,1000);
    delay(1000);
    tone(2,1000);
    delay(1500);
    noTone(2); //выключение звука
    
    //отключение вибромоторов
    for (i = 0; i <= 4; i = i + 1) 
    {
      analogWrite(M[i], 0);
    }
  }
  
  else
  {
    //Измерение расстояния
    for (i = 0; i <= 4; i = i + 1) 
    {
      //Отключение всех датчиков
      for (j = 0; j <= 4; j = j + 1)
      {
        digitalWrite(Trig[j], LOW);
      }
      
      //Измерение расстояния i-м датчиком
      digitalWrite(Trig[i], LOW);
      delayMicroseconds(2);
      digitalWrite(Trig[i], HIGH);
      delayMicroseconds(10);
      digitalWrite(Trig[i], LOW);
      PM[i] = pulseIn(Echo[i], HIGH)/c;
      Serial.print("PM"); 
      Serial.print(i); 
      Serial.print(" = "); 
      Serial.println(PM[i]);
      if (PM[i] < 400)  // отсечка ошибочных значений
      {
        signal[i]=-PM[i]*k/400+k;          // чем ближе припятствие, тем интенсивнее сигнал
        analogWrite(M[i], signal[i]);
      }
      delay(dt);
    }
  }
    
}
