/*
 ESP8266 --> ThingSpeak Channel via MKR1000 Wi-Fi
 
 This sketch sends строку с Serial 9600 c преобразованием в LongInt to a ThingSpeak
 channel using the ThingSpeak API (https://www.mathworks.com/help/thingspeak).
 
 Requirements:
 
   * ESP8266 Wi-Fi Device
   * Arduino 1.6.9+ IDE
   * Additional Boards URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
   * Library: esp8266 by ESP8266 Community
 
 ThingSpeak Setup:
 
   * Sign Up for New User Account - https://thingspeak.com/users/sign_up
   * Create a new Channel by selecting Channels, My Channels, and then New Channel
   * Enable two field
   * Note the Channel ID and Write API Key
    
 Setup Wi-Fi:
  * Enter SSID
  * Enter Password
  
*/

#include <ESP8266WiFi.h>

// Wi-Fi Settings
const char* ssid = "ROSTELECOM_2A40"; // your wireless network name (SSID)
const char* password = "4KFJ7PHH"; // your Wi-Fi network password

WiFiClient client;
 
// ThingSpeak Settings
const int channelID = 490577;
String writeAPIKey = "C9CSOEPMSFZ155HZ"; // write API key for your ThingSpeak Channel
const char* server = "api.thingspeak.com";
const int postingInterval = 2 * 1000; // post data every 20 seconds 
const float kVolt = 0.312;  //пересчет принятого отсчета в Вольты
const float kPower = (3600 * 1000) / (3200 * 0.01365);  //3600 сек в часе; 1КВт; 3200 имп на 1КВтЧас; 
                                                       //13,65 мс - единица измерения длительности

long int tTek;          //текущий отсчет времени, мс
//float tTek;          //текущий отсчет времени, мс

float powr3 = 10;      //нач. знач. потр. мощности
float volt220 = 220;   //нач. знач. напряжения

void SendMesToThingSpeak(String str) {   //отсылка сведений в сервис
    if (client.connect(server, 80)) {

    //преобразование строки с Нех числом в целое число
    //567 -> 567;  0x20 -> 32; 0x0200 -> 512
    //см  http://arduino.ru/forum/programmirovanie/preobrazovanie-tipov-string-hex-v-int
    // String str = "0xC2";
    long int vol = strtol(str.c_str(),NULL,0);  //старшие два байта - длительность; младшие - напряжение
    //небольшой фильтр от ложных выбросов по напряжению и мощности
    if (vol != 0) {   
       unsigned int volt2 = vol & 0xFFFF;
       unsigned int powr2 = vol >> 16;
       float volt220t = volt2 * kVolt;  //получаем вольты
       if ((volt220t > 50) && (volt220t < 400)) volt220 = volt220t;
       if (powr2 == 0) powr2 = 16000;  //ну очень длинные импульсы превращаем в 5 ватт
       float powr3t = kPower / powr2;   //получаем ватты
       if (powr3t < 6000) powr3 = powr3t;
    }
    // Construct API request body
    String body = "field1=";
           body += String(powr3);
           body += "&field5=";
           body += String(volt220);
    Serial.print("Input string: ");
    Serial.print(str); 
    Serial.print(" Power & Voltage: ");
    Serial.println(body); 

    client.println("POST /update HTTP/1.1");
    client.println("Host: api.thingspeak.com");
    client.println("User-Agent: ESP8266 (nothans)/1.0");
    client.println("Connection: close");
    client.println("X-THINGSPEAKAPIKEY: " + writeAPIKey);
    client.println("Content-Type: application/x-www-form-urlencoded");
    client.println("Content-Length: " + String(body.length()));
    client.println("");
    client.print(body);

  }
  client.stop();
  
}


void setup() {
  Serial.begin(9600);
  Serial.println(F("Power & Voltage test (v.1)"));
  
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
}

void loop() {
   if (Serial.available()>0) {
       String Var=""; //переменная для приема строки
       delay(100);//ожидаем прием всей строки
       while (Serial.available())  { //пока есть данные, читаем
           Var = Var + (char)(Serial.read());
           }
       Serial.println(Var);

       SendMesToThingSpeak(Var);
       delay(2000); //на всякий случай
   } 
}
