;  Имена спец.регистров и битов PIC16F676. Руководство Microchip DS40039c (ссылки на RG p.9-10). 
;  Вызов из директории проекта #include "mP16F676.inc". 
;=========================================================================================================================
W                EQU  H'0000'	; в командах - результат записывается в регистр W
F                EQU  H'0001'	; в командах - результат записывается в исходный регистр F
;-----Bank0------------------
INDF             EQU  H'0000'	; RG (операнд) без имени по адресу в FSR р.18
TMR0             EQU  H'0001'	; содержимое счетчика TMR0 р.29
PCL              EQU  H'0002'	; мл. адрес счетчика программ (р.17 low 0...7)
STATUS           EQU  H'0003'	; выбор банка данных, контроль SLEEP/WDT, заем/перенос/=0 р.11
FSR              EQU  H'0004'	; указатель на адрес (номер RG) для INDF р.18 
PORTA            EQU  H'0005'	; RG порта А (р.2 соответствие pin и RA0...RA5) р.19
PORTC            EQU  H'0007'	; RG порта С (р.2 соответствие pin и RС0...RС5) р.26
PCLATH           EQU  H'000A'	; ст. адрес счетчика программ (р.17 high 8...12)
INTCON           EQU  H'000B'	; разрешение прерываний, флаги (2)=TMR0, (1)=pin11/RA2,(0)=ChangePortA p.13
PIR1             EQU  H'000C'	; флаги прерываний (7)EEPROM, (6)АЦП, (3)компаратор, (0)TMR1 p.15
TMR1L            EQU  H'000E'	; мл. байт счетчика TMR1 р.32
TMR1H            EQU  H'000F'	; ст. байт счетчика TMR1 р.32
T1CON            EQU  H'0010'	; конфигурация и управление счетчиком TMR1 р.34
CMCON            EQU  H'0019'	; управление компаратором H'07'=отключить р.37
ADRESH           EQU  H'001E'	; ст. байт результата АЦП р.44
ADCON0           EQU  H'001F'	; управление АЦП (7)=1 (65)=0 (432)=№канала (1)=ADgo/пуск (0)=1 включить р.45
;-----Bank1------------------
OPTION_REG	     EQU  H'0081'	; (7)=pull up (6,4)=фронтRA2 (5)=ист.импТМR0(3)=предWDT/TMR0 (210)=коэфф.пределителя р.12
TRISA            EQU  H'0085'	; управление битами порта А (1=вход) р.19
TRISC            EQU  H'0087'	; управление битами порта С (0=выход) р.27
PIE1             EQU  H'008C'	; разрешение прерываний (7)=EEPROM (6)=АЦП (3)=компаратор (0)=TMR1 р.14
PCON             EQU  H'008E'	; флаги по питанию (1)=POR (0)=BOD р.16
OSCCAL           EQU  H'0090'	; коррекция внутр. генератора (7...2), заводская по адресу Н'3FF' новой м/сх р.16,56
ANSEL            EQU  H'0091'	; выбор канала АЦП пример: (канал)AN5=ANS5=(RGпорт)RC1=(pin)9 код Н'20' р.46
WPUA             EQU  H'0095'	; выбор pull up к pin порта А (+5В, Rподтяг=50кОм). WPUA0...A5=RA0...5 р.20 
IOCA             EQU  H'0096'	; разрешение прерываний (=1) от изменения pin порта А IOCA0...A5=RA0...5 р.21
VRCON            EQU  H'0099'	; выбор опорного напряжения для компаратора р.42
EEDATA           EQU  H'009A'	; RG данных EEPROM р.49
EEADR            EQU  H'009B'	; адрес данных EEPROM р.49
EECON1           EQU  H'009C'	; флаги EEPROM (3)=ошиб.записи(2)=eWR/разреш.записи (1)=WRee/записать (0)=RDee/читать р.50
EECON2           EQU  H'009D'	; не физич. RG, спецкоды (Н'55'/Н'АА') при записи EEPROM р.50
ADRESL           EQU  H'009E'	; мл. байт результата АЦП р.44
ADCON1           EQU  H'009F'	; выбор скорости работы АЦП (при 4MГц и 2мкс код=H'10')

;----- Часто используемые биты, остальное в файле программы----------------------------------------------------------------
#define		C		STATUS,0		; С=1 (сложение и перенос)   С=0 (вычитание и заем)
#define		Z		STATUS,2		; Z=1 при нулевом результате операции
#define		MEM		STATUS,5		; MEM=0 BANK0 RG данных, MEM=1 BANK1 RG данных
#define		GIE		INTCON,7		; GIE=1 общее разрешение прерываний
#define		E_SB	INTCON,3		; E_SB=1 разрешены прерывания по изменению pin PORTA (используем для кнопок SB)
#define		F_SB	INTCON,0		; флаг прерывания от изменения pin PORTА, требуется сброс
#define		F_TMR0	INTCON,2		; флаг прерывания от TMR0, требуется сброс
#define		TMR1go	T1CON,0			; TMR1go=1 пуск таймера TMR1, по =0 остановка таймера
#define		ADgo	ADCON0,1		; ADgo=1 пуск АЦП, по =0 преобразование закончено
#define		eWR		EECON1,2		;(MEM=1) разрешение записи ЕЕPROM, включать =1 перед записью
#define		WRee	EECON1,1		;(MEM=1) команда "записать в ЕЕPROM", по =0 запись окончена
#define		RDee	EECON1,0		;(MEM=1) команда "читать из ЕЕPROM", по =0 чтение окончено
;========Запрещаемые зоны памяти RG (директива)==============================================================
	__MAXRAM  H'00DF'
	__BADRAM  H'0006'
	__BADRAM  H'0008'-H'0009'
	__BADRAM  H'000D'
	__BADRAM  H'0011'-H'0018'
	__BADRAM  H'001A'-H'001D'
	__BADRAM  H'0060'-H'007F'
	__BADRAM  H'0086'
	__BADRAM  H'0088'-H'0089'
	__BADRAM  H'008D'
	__BADRAM  H'008F'
	__BADRAM  H'0092'-H'0094'
	__BADRAM  H'0097'-H'0098'
;========Конфигурация микроконтроллера, например, директива __config H'2184' р.54============================
_CONFIG          EQU  H'2007'		; здесь это метка (не используется, только информация)		
; (13,12) !!! в начале читать 2 ст.бита, потом добавляем остальное х184 					B'00'...'11' - H'0'...H'2'
; (11...9)=0 Uninplemented (нет)				(8)=1 данные не защищены					B'0001' - H'1'
; (7)=1 прога не защищена						(6)=0 BOD нет           					B'1000' - H'8'
; (5)=0 вход RA3 I/O (к +5v), MCLRE внутри р.58 (4)=0 PWRT ON 72mc р.57
; (3)=0 WDT OFF																				B'0100' - H'4'
; (2...0)=В'100' генератор RC внутренний типа INTOSC, PORTA4,5 - обычный ввод/вывод.
;----- DEVID Equates ---Device Identification (взято из P16F676.inc, метка не используется)-----------
_DEVID1          EQU  H'2006'
;----- IDLOC Equates ---ID Location (взято из P16F676.inc, метка не используется)---------------------
_IDLOC0          EQU  H'2000'
_IDLOC1          EQU  H'2001'
_IDLOC2          EQU  H'2002'
_IDLOC3          EQU  H'2003'
