;  Level_SR04_p.asm 22.06.18 PiC16F676 8 config=H'2', OCSCAL=H'2C'"
        LIST p=PIC16F676, b=4, w=2	;   - =4, ERRORLEVEL=2
#include    "mmP16F676.inc"	;     
        __config H'2184'    ; !!!  2 . (13,12  H'2007'),    184 !!!
	udata_SHR H'20'
HtL		res 1;  (.), EEPROM,    _4  SetLimit  FSR=H'20'
HtH		res 1;  (.), FSR=H'21'		
Qmax	res 1;     % ( ).EEPROM, _3  SetLimit  FSR=H'22'
Qmin	res 1;     % ( ).EEPROM, _2  SetLimit  FSR=H'23'
HL		res 1; /  /    (TABL_T,SCR,H3_D4)
CTw		res 1;      H1 (SCR)
CTf		res 1;       (SetLimit)
Cycle	res 1;   WORK,   10
Menu	res 1;    _0..._4
Qw		res 1;     , %,    
Q1		res 1;     , %, 1- 
Q2		res 1;     , %, 2- 
Q3		res 1;     , %, 3- 
dQ12	res 1;   Q1 - Q2
dQ23	res 1;   Q2 - Q3
XE		res 1;  ,  (       CalcQi)
XH		res 1;   (. )
XL		res 1;   (. )
YE		res 1;  , 
YH		res 1;   (. )
YL		res 1;   (. )
ZE		res 1;  , 
ZH		res 1;   (. )
ZL		res 1;   (. )
VH		res 1;   ,  H3_D4, ME_4 
VL		res 1;   ,  H3_D4, ME_0...4
WH		res 1;   ,  H3_D4, WT20
WL		res 1;   ,  TABL_T, H3_D4
ERR		res 1;    
Flag1	res 1;  
Flag2	res 1;  
S_temp	res 1;   STATUS  
W_temp	res 1;   W ()  
;    :
#define		F1		Flag1,0		;  " SB1",    WORK
#define		F2		Flag1,1		;  " SB2",    WORK		
#define		FCD		Flag1,2		;  " - Command/=0, Data/=1"
#define		F_Pump	Flag1,3		;  "Pump"  - =1, =0
#define		F_inME	Flag1,4		;  "  ",   =0
#define		F_Ht	Flag1,5		;    Ht(=1   )  SetLimit,   _2...4
#define		FZE		Flag1,6		;   PZ_H4 ( =0,  >65535)
#define		FZD 	Flag1,7		;   DIV_PZ
#define		F_Zero	Flag2,0		;  "", Ht  1000  " " (H3_D4)
#define		F_ERR	Flag2,1		;  " ",   RG ERR (WORK, ME_1)
#define		E_SB1	IOCA,4		; (BANK1)    SB1 
#define		E_SB2	IOCA,5		; (BANK1)    SB2
;  
#define		SE		PORTA,0		;      
#define		ECHO	PORTA,1		;    HC-SR04 (0...38,  )
#define		TRIG	PORTA,2		;  HC-SR04   ( 10...15)
#define		SB1		PORTA,4		;  SB1(=1).  ,  , / _0,  _1
#define		SB2		PORTA,5		;  SB2(=1).   ,,  _0,1 SB1+SB2 =  _2...4
;
#define		CD			PORTC,0		; =0, =1       DD1
#define		Pump_ON		PORTC,3		;   1 (=1  )
#define		TC			PORTC,5		;      DD1
;
    	org 00
    	goto START
    	org 04
    	goto INT_TSB
;==========   (iSCR)    (TABL_T) === WL,HL==========================
iSCR	call WT20	; 1-     40
		call WT20
		call WT20
		movlw H'38'	; Function set '1LNFxx' L=1(8), N=1(2), F=0(5x7)
		call CW_SCR
		call WT20	; 2-     4,1
		movlw H'C'	; Display control '1DCB' D=1( ON), C=0( OFF), B=0(  OFF)
		call CW_SCR
		call WT20	; 3-     0,1
		movlw H'6'	; Entry mode set '1IS' I=1(), S=0(  )
		call CW_SCR
		return
;------------------------------------------------------------------------
TABL_T	movwf WL        	;    dt  W (.   dt)
c1		call T_WL        ;   T_WL  WL
         movwf HL        	;   HL
		xorlw H'24'      ;    "$" (Z=1)
		btfsc Z
		goto m1
		call DH_SCR     	;    ( HL)
		goto c1
m1		clrf HL			;  HL  $
		return          	;   TABL_T ( "$")
T_WL    clrf PCLATH    	;  .   (. PCL    256)
		movf WL,W
		incf WL,F
		addwf PCL,F     ; PCL = retlw (  dt)
		dt "Pump $","OFF$","ON $","AutoQw $","Set $","min $","max $","Ht =$","  Qw=$","mm  $","EEPROM  $","ERROR $"
; Dec: 0        6     10     14         22      27      32      37      42       48      53          62         
;===INT_TSB=======  TMR0 ( )  SB1,SB2 ===============================================
; :   04.     : CYCLE (+1  10), F1, F2 
;  W  STATUS   W_temp  S_temp -   !
;---------------------------------------------------------------------------------------
INT_TSB	movwf W_temp        	;  W (   Status)
		swapf STATUS,W      	;  
		movwf S_temp        	; . Status   
		bcf MEM             	;  0  (  )
		btfsc F_TMR0		;      TMR0
		goto m3				;    TMR0 - 
		btfsc SB1		;    SB1 (0=)
		goto m2
		bsf F1			; SB1 ,   F1
		bcf F_SB		;      F_SB
		bsf MEM			; BANK1  
		bcf E_SB1		;     SB1
		bcf MEM			; BANK0  
		goto m4		
m2		btfsc SB2		;    SB2 (0=)
		goto m4
		bsf F2			; SB2 ,   F2
		bcf F_SB		;      F_SB
		bsf MEM			; BANK1  
		bcf E_SB2		;     SB2
		bcf MEM			; BANK0  
		goto m4
m3		bcf F_TMR0           ;    TMR0 (INTCON,2)
		movlw D'103'       	;   TMR0    ~10
		movwf TMR0
		incf Cycle,F        ; +1   
m4		swapf S_temp,W		;  Status 
		movwf STATUS
		swapf W_temp,F		; ,     Status
		swapf W_temp,W
		retfie
;==========     1 (SCR - Screen) ==== CTw,HL=====================================
; (call):  -  HL(DH_SCR), - W(DW_SCR), -  DIGIT  W=HL+'30'
;  - W(W_SCR)  A1_SCR-'00'( 1),  A2_SCR-'40'( 2)
; 3  : CD-  DD1  / (0/1)  , T-.  DD1, SE- H1
_p		movlw H'25'		;  "%"
		goto DW_SCR
jY		movlw H'59'		;  "Y"
		goto DW_SCR		
j_		movlw H'20'      ; 
		goto DW_SCR
DIGIT	movlw H'30'      ;    H'30'   0...9 (  L)
		addwf HL,W       ;   W,    RG "HL"
		goto DW_SCR		;    DD1    
A1_SCR	movlw H'80'      ;    1-  ( 1...8)
		goto CW_SCR
A2_SCR	movlw H'C0'      ;    2-  ( 9...16)
CW_SCR	bcf FCD		  	;   -    R/S=0
DW_SCR	movwf HL		;    W, HL=W
DH_SCR	movlw D'8'       ;    HL. 8   
		movwf CTw		;    CTw
c2		bcf TC			;    DD1
		rlf HL,F		;      HL  DD1
		bcf CD	  		;   = 0
		btfsc C
		bsf CD			;    =1,  =1   "1"
		bsf TC			;    DD1 (  )
		decfsz CTw,F
		goto c2
		bcf CD			;     (=0)
		btfsc FCD		;   
		bsf CD			;  = 1,   (CD=1)
		bsf FCD			;     
		bsf SE			;  Enable -  /  
		clrf HL			;  HL   /
		bcf SE			;  Enable -    DD1
		return			
;==========H3_D4=======max H'FFF'-D'4095'===== VH,VL,WH,WL,HL=========================================
; -   VH,VL, -WH,WL,  -HL ----------------------------
H3_D4	incf HL,F		;  1  (   HL=0)
		movf VL,W
		movwf WL		;  .  VL  WL
		movf VH,W
		movwf WH		;  .  VH  WH
		movlw H'E8'		;  , .  D'1000'=H'3E8' =H'E8'
		subwf VL,F		; VL = VL-H'E8'
 		btfss C			;    (  )
		decf VH,F		; C=0 ,    
		btfsc VH,7		;    . .  =1
		goto m5     		;  -1   ., 
 		movlw H'3'		;  , c.  D'1000'=H'3E8' =H'3'			
		subwf VH,F		; VH = VH-H'3'
 		btfsc C			;    (  )
		goto H3_D4		; C=1,  ,  1000
m5		decf HL,F		;   HL
		btfsc Z
		bsf F_Zero		; Ht<1000 -  "0"  "" 
		movf WL,W
		movwf VL		;  VL  WL
		movf WH,W
		movwf VH		;  VH  WH
		btfss F_Zero
		call DIGIT		;   		
		btfsc F_Zero
		call j_			;   Ht  ,  "" 
		bcf F_Zero 
H3_D3	movlw D'100'    ;    W=D'100' =H'64'
m6		incf HL,F		;  1 
		subwf VL,F		; VL = VL-100
 		btfss C
		decf VH,F		; C=0   . VH
		btfss VH,7		;    .=1
		goto m6			; VH >=0,  ,  100
		addwf VL,F		;  VL = VL+100 (VH  )
		decf HL,F		;   HL
		call DIGIT		;   
H2_D2	movlw D'10'		;    H'A'=D'10'
m7		incf HL,F		;  1 
		subwf VL,F		; VL = VL-10
		btfsc C			;    (  )
		goto m7			; C=1,  ,  10
		addwf VL,F		; C=0,  ,  VL
		decf HL,F		;   HL
		call DIGIT		;   
		movf VL,W		;    VL
		movwf HL
		call DIGIT		;   		
		return
;==========EERD=======   EEPROM (bsf MEM   )=====================================
EERD		bsf RDee		;  
			movf EEDATA,W	;   W
			incf EEADR,F	;   
			return
;==========EEWR=======   EEPROM (bsf MEM   )======================================
EEWR	movwf EEDATA	;   
		bsf eWR			;  
		movlw H'55'		;  55
		movwf EECON2
		movlw H'AA'		;  AA
		movwf EECON2
		bsf WRee		;  		
c3		btfsc WRee		;   
		goto c3
		bcf eWR			;  
		incf EEADR,F	;  
		return			
;==========  20  iSCR === Cycle,WH=======================================
WT20	movf Cycle,W	;   Cycle  W
		addlw H'2'		;  210=20
		movwf WH		;     WH=Cycle+2
c4		movf Cycle,W	;   Cycle  W
		xorwf WH,W		;   Cycle+2
		btfss Z
		goto c4        	; Z=0,    20 (  WT20   - min 10)
		return	
;==========  7   TRIG ==================================================================
WT_7	nop				;  7   call  return
		nop
		nop
		return
;===MUL_PZ===== ,  1  (+-),  2  (+) =======================================
; :YE YHYL - , XE XHXL - M	: ZE ZHZL -    
; : WH,WL,VH,VL.     MM  MT .. 0  ZHZL -  -1  ZE.   <1  =0
MUL_PZ	clrf ZL		;   (     )
		clrf ZH
		clrf WL
		clrf WH
		clrf VH
		clrf VL
		movlw D'16'		;   ZE    16  
		movwf ZE
cz1		btfss XL,0		; . ,  VHVLYHYL ()  ZHZLWHWL     .
		goto mz4		; . =0,   ,     VHVLYHYL ()   XHXL ()  
		movf YL,W
		addwf WL,F		; WL=YL+WL,  4-  
		btfss C
		goto mz1		;    4-  (WL)
		incfsz WH,F		;  , +1  3-   (WH)
		goto mz1	 	;    3-  (WH)
		incfsz ZL,F		;  , +1  2-   (ZL)
		goto mz1		;    2-  (ZL)
		incf ZH,F		;  , +1  1-   (ZH). . ZH    .
mz1		movf YH,W
		addwf WH,F		; WH=YH+WH,  3-  
		btfss C
		goto mz2		;    3-  (WH)
		incfsz ZL,F		;  , +1  2-   (ZL)
		goto mz2	 	;    2-  (ZL)
		incf ZH,F		;  , +1  1-   (ZH). . ZH    .
mz2		movf VL,W
		addwf ZL,F		; ZL=VL+ZL,  2-  
		btfss C
		goto mz3	 	;    2-  (ZL)
		incf ZH,F		;  , +1  1-   (ZH). . ZH    .		
mz3		movf VH,W
		addwf ZH,F		; ZH=VH+ZH,  1-  .  .		
mz4		bcf C
		rlf YL,F		;   
		rlf YH,F
		rlf VL,F
		rlf VH,F
		rrf XH,F		;   
		rrf XL,F		;     . XL,   XH  
		decfsz ZE,F
		goto cz1		; 16   
		movf YE,W
		addwf XE,W
		movwf ZE		;    ZE=YE+XE
		btfsc ZH,7		;   
		goto mz5		; . = 1,         (0,1  0,1 = 0,1)
		rlf WH,F		; . = 0,  ,  (0,1  0,1 = 0,01)
		rlf ZL,F
		rlf ZH,F
		decf ZE,F		;      
mz5		btfss WH,7		;  
		return			; . WH=0,    ZHZL  
		incfsz ZL,F		; ZL=ZL+1
		return			;    ZL (. )
		incf ZH,F		; ZH=ZH+1 ( . )
		return
;===DIV_PZ===== ,  1  (+-),  2  (+) =============================================
; :YE YHYL - D, XE XHXL - D	: ZE ZHZL -    
; : VH,VL.   DM<DT,  ZHZL  0,01 -   -1  ZE.    =0
DIV_PZ	bcf FZD        ;       Y - X
        movlw D'16'       ;   ZE    16 
		movwf ZE
cz2		btfsc FZD
        goto mz6        ; FZD=1,      (  )
        btfss YH,7		; . D,  YHYL(D)-XHXL(DT), 0/1  ZHZL,  DM   .. 16 
		goto mz8		; . DM=0,  FZD=0 ( ) -  =0  . ZL
mz6		movf YH,W
		movwf VH		;  . DM  VH (  DM)
		movf YL,W
		movwf VL		;  . DM  VL (  DM)
		movf XL,W
		subwf YL,F		; YL=YL-XL  .
		btfss C
		decf YH,F		; C=0   ., . DM YH=YH-1,  YH=0   -   =0
		movf XH,W
		subwf YH,F		; YH=YH-XH  .
		btfsc C			
		goto mz9		; C=1    , =1
		btfss FZD
		goto mz7         ; =0,FZD=0  , , =0
		bsf C         	; =0,FZD=1   FZD,  =1  =1
		goto mz9
mz7		movf VL,W
		movwf YL		;  . DM  
		movf VH,W
		movwf YH		;  . DM  		
mz8		bcf C			;  =0  =0
mz9		rlf ZL,F		;  =1  =1
		rlf ZH,F
		bcf C			;       DM
		rlf YL,F
		rlf YH,F		;   DM
		bcf FZD			;  FZD=0
		btfsc C
		bsf FZD			; C=1,    FZD=1
		decfsz ZE,F
		goto cz2		; 16   
		movf XE,W
		subwf YE,W		;    (DM<DT)   
		movwf ZE		;    () ZE=YE-XE
		incf ZE,F		;  DM>DT (Y>X)   1,, =0,1  ZE=ZE+1
		btfsc ZH,7		;   ()
		return			; . = 1, DM>DT (0,1) -  
		rlf ZL,F		; . = 0, DM<DT (0,01) -    (0,1)
		rlf ZH,F
		decf ZE,F		;  ZE=ZE+1,  ZE=ZE-1
		return
;===H4_PZ===== (2 )  PZ,  1  (0...16),  2  (+) ============================
; :XHXL		:XE XHXL 	  0,1 ,   0, =00 ( )
;     . = "1"  . XE (16- ).
H4_PZ	movlw D'16'	;   
		movwf XE
		bcf C		;       HH
cz3		btfsc XH,7
		return		; . = 1   
		rlf XL,F	;   . 
		rlf XH,F	;   .  (  )
		decfsz XE,F	; =-1,        
		goto cz3	; XE   0 - 
		return		; =0,     (   )
;===PZ_H4=====PZ   (2) ============================================================================
; :ZE ZHZL	:ZHZL		: FZE=1,  ZE=0 (PZ=0,xx)  ZE>16 (PZ=0,0x   2 ) 
;     .  2     (16-ZE) .
PZ_H4	bsf FZE		;   
		movf ZE,W	;   W,   Z
		btfsc Z
		return		; Z=1   :    
		sublw D'16'	; W=(16-ZE)    C, Z
		btfss C
		return		; C=0 ,   :    ,   2- 
		bcf FZE		;  ,   (FZE=0)
		btfsc Z
		return		; Z=1, ZE=16    ,  ZHZL  
		movwf ZE	; ZE=16-ZE    
cz4		bcf C		;   ZHZL
		rrf ZH,F	;   . 
		rrf ZL,F	;   .  (  )
		decfsz ZE,F	;    ZE=1,   16-1=15 ( ZHZL=1) 
		goto cz4	; ZE  =0,   
		return		;  ,  ZHZL  
;=====CalcQi===== HC-SR04     ZL=Qi%===========================================
; :ZL=Qi[%]  FZE=1 ERR=ERR+10,  ZH<>0  ZL>100 ERR=ERR+1  ZL=99%
;   Qw[%] = 100 - 17,00 x N(TMR1) / Ht (  )
CalcQi	bsf TRIG		;     HC-SR04
		clrf TMR1L		;   TMR1
		clrf TMR1H
		call WT_7		;  72 = 14
		call WT_7
		bcf TRIG		;     HC-SR04,  1 ..  ECHO
cq1		btfss ECHO		;    ECHO
		goto cq1
		bsf T1CON,0		;   TMR1
cq2		btfsc ECHO		;    ECHO
		goto cq2
		bcf T1CON,0		;   TMR1,  . = N(TMR1) []  RG TMR1H TMR1L
 		movlw H'05'	;   17,00   YE
		movwf YE
		movlw H'88'	; .  17,00   YH
		movwf YH
		movlw H'00'	; .  17,00   YL
		movwf YL
		movf HtL,W	; (Ht)  HtH,HtL -> XH,XL     
		movwf XL
		movf HtH,W
		movwf XH
		call H4_PZ	; Ht     XE XHXL
		call DIV_PZ	; 17,00 / Ht = ZE ZHZL
		movf ZE,W
		movwf YE
		movf ZH,W		
		movwf YH		
		movf ZL,W		
		movwf YL	;  ZE ZHZL = YE YHYL	(Ht)	
		movf TMR1L,W	; N(TMR1)  TMR1H,TMR1L -> XH,XL     
		movwf XL
		movf TMR1H,W
		movwf XH		
		call H4_PZ		; N(TMR1)     XE XHXL		
		call MUL_PZ		; 17,00 x N(TMR1) / Ht = ZE ZHZL
		call PZ_H4		; 17,00 x N(TMR1) / Ht = ZHZL
		movf ZH,W
		btfss Z
		goto mq1    ; ZH  =0,  ,  ERR=+1
		btfsc FZE
		goto mq2    ;   ,  ERR=+10
        movf ZL,W
        sublw D'100'       ; W = 100 - 17,00 x N(TMR1) / Ht
		movwf ZL       ; ZL = 100 - 17,00 x N(TMR1) / Ht
		btfsc C
		return		; C=1,  ,  ,  ZL   Qi
mq1     incf ERR,F    ; C=0, ,  >100%, ERR=+1
        goto mq3
mq2		movlw D'10'
        addwf ERR,F		;  , ERR=+10%
mq3     movlw D'99'
        movwf ZL		;   ZL=D'99'  
		return		;   , ZL=D'99'
;==========SetLimit   _2...4 === CTf, FSR-INDF========================================= 	
SetLimit	btfss F1		;   SB1 -  
			goto pp1		;  SB1   -  SB2
			incf CTf,F		;      SB1 +1    CTf
			movlw D'10'		;    Qwmin/max +10 (10%)
			btfsc F_Ht
			movlw D'25'		;   F_Ht   Ht +25 (25)
			btfss CTf,3		; ,    CTf=8 
			movlw D'1'		;   - ,  +1 (1%  1)
			addwf INDF,F	;  (FSR) = (FSR) + W
			btfss F_Ht
			return			;   Ht,  1  - 
			btfsc C
			incf HtH,F		; HtH=HtH+1    . (=1)
			return
pp1			btfss F2		;   SB2 -  
			goto pp2		;  SB2  
			incf CTf,F		;      SB2 +1    CTf
			movlw D'10'		;    Qwmin/max -10 (-10%)
			btfsc F_Ht
			movlw D'25'		;   F_Ht   Ht -25 (-25)
			btfss CTf,3		; ,    CTf=8 
			movlw D'1'		;   - ,  -1 (-1%  -1)
			subwf INDF,F	;  (FSR) = (FSR) - W
			btfss F_Ht
			return			;   Ht,  1  - 
			btfss C
			decf HtH,F		; HtH=HtH-1    . (=0)
			return
pp2			clrf CTf		;    -    CTf			
			return		
;/////////START///////////////////////////////////////////////////////////////////////////////////////////////
START	bcf MEM			; BANK0    
		clrf PORTC		;  ""   =0
		clrf T1CON		; TMR1=OFF,  1:1,  , pin3 T1G  
		movlw H'07'		;  OFF
		movwf CMCON
		movlw H'20'		;    TMR0 (GIE, E_SB /   )
		movwf INTCON
		clrf ADCON0		;  OFF
		bsf MEM			; BANK1    
		movlw H'05'		; pull up=ON, PORTA,2 ,   TMR0, 1:64
		movwf OPTION_REG
		clrf PIE1		;  EEPROM, , TMR1, 	=OFF	
;----------
		movlw H'2C'		; !!!   H'3FF',   !!!
		movwf OSCCAL	;     . 
;----------
		movlw H'3A'		; PORTA 0(pin13), 2(pin11) =0 ( ),  =1 ( ) B'00111010'
		movwf TRISA
		clrf TRISC		;   =0 (  ) B'00000000'
		clrf IOCA		;  PORTA 4(pin3-SB1-E_SB1), 5(pin2-SB2-E_SB2) /  
		movlw H'30'		; pull up  PORTA 4(pin3-SB1), 5(pin2-SB2) =1 B'00110000'
		movwf WPUA
		movlw H'10'		  ;    1:8 (  )
		movwf ADCON1
		clrf ANSEL		  ;    		
;----------    EEPROM
;  PiC16F676    RG  BANK1 A0...DF (/) .  BANK0 20..5F
		clrf EECON1		;  ,    eWR=1   (=1)
		clrf EEADR		;    ( HtL) 
		call EERD
		movwf HtL		;  EEPROM  HtL (.  )
		call EERD
		movwf HtH		;  EEPROM  HtH (.  )
		call EERD
		movwf Qmax		;  EEPROM  Qmax ( max    )
		call EERD
		movwf Qmin		;  EEPROM  Qmin   min    )
		bcf MEM			; BANK0 
;----------
		clrf Menu		;   
		bsf GIE			;    (  TMR0)
		call iSCR		;  ( ) 
		clrf Flag1		;  
		clrf Flag2		;  
;//////////WORK///////////////////////////////////////////////////////////////////////////////////
WORK	clrf Cycle		;    (1 .)
		bcf F_ERR		;    
		clrf ERR		;    
		call CalcQi
		movf ZL,W
		movwf Q1		;  1-   Q1
cw1		movlw D'20'
		xorwf Cycle,W	;  Cycle = 20  10  = 200
		btfss Z
		goto cw1		; , 		
		call CalcQi
		movf ZL,W
		movwf Q2		;  2-   Q2
cw2		movlw D'40'
		xorwf Cycle,W	;  Cycle = 40  10  = 400
		btfss Z
		goto cw2		; , 		
		call CalcQi
		movf ZL,W
		movwf Q3		;  3-   Q3
;----------    
		movf ERR,W
		btfsc Z
		goto cw3		;   ERR=0
		xorlw D'1'
		btfsc Z
		goto cw3		; ERR=1     ( )
		movf ERR,W
		xorlw D'10'
		btfsc Z
		goto cw3		; ERR=10     ( )
		bsf F_ERR		;     F_ERR=1 
;----------   Q1-Q2-Q3
cw3		movlw D'60'
		xorwf Cycle,W	;  Cycle = 60  10  = 600
		btfss Z
		goto cw3		; , 
		movf Q2,W
		subwf Q1,W		; W = Q1 - Q2
		movwf dQ12		; dQ12 = Q1 - Q2
		btfss Z
		goto mw1		; Q1   Q2
		movf Q1,W
		movwf Qw		; Q1 = Q2,  Qw = Q1
		goto cw4
mw1		btfsc C
		goto mw2		; C=1,   Q1>Q2  dQ12 > 0
		comf dQ12,F		; C=0,  dQ12 > 0 (  +1)
		incf dQ12,F
mw2		movf Q3,W
		subwf Q2,W		; W = Q2 - Q3
		movwf dQ23		; dQ23 = Q2 - Q3
		btfss Z
		goto mw3		; Q2   Q3
		movf Q2,W
		movwf Qw		; Q2 = Q3,  Qw = Q2
		goto cw4
mw3		btfsc C
		goto mw4		; C=1,   Q2>Q3  dQ23 > 0
		comf dQ23,F		; C=0,  dQ23 > 0 (  +1)
		incf dQ23,F		
mw4		movf Q3,W
		subwf Q1,W		; W = Q1 - Q3
		btfss Z
		goto mw5		; Q1   Q3
		movf Q3,W
		movwf Qw		; Q1 = Q3,  Qw = Q3
		goto cw4
;----------
mw5		movf dQ23,W
		subwf dQ12,W	; W = dQ12 - dQ23
		btfss Z
		goto mw6
		movf Q2,W
		movwf Qw		; dQ12 = dQ23,  Qw = Q2
		goto cw4
mw6		btfss C
		goto mw7
		movf Q3,W
		movwf Qw		; C=1,   dQ12 > dQ23,  Qw = Q3		
		goto cw4		
mw7		movf Q1,W
		movwf Qw		; C=0,  dQ12 < dQ23,  Qw = Q1		
;----------   F_Pump
cw4		movlw D'70'
		xorwf Cycle,W	;  Cycle = 70  10  = 700
		btfss Z
		goto cw4		; , 
		btfss F_Pump
		bcf Pump_ON
		btfsc F_Pump
		bsf Pump_ON
;----------  
cw5		movlw D'90'
		xorwf Cycle,W	;  Cycle = 90  10  = 900
		btfss Z
		goto cw5		; , 
		bcf E_SB		;     SB1, SB2
		btfss F1		;   SB1 ?
        goto mw8
		btfsc F2		;   SB2 ?
        bcf F_inME      ;  SB1+SB2 =    2...4
		bcf F_Ht		;      F_Ht
;==================      ----SB1= , SB2= ---------------------------
mw8		movlw H'E'		;  Displey control   ( )
		call CW_SCR
		btfsc F_inME	;    F_inME
		goto ME_X		; F_inME=1,   ,  Menu  
		movlw H'C'		; F_inME=0,  Displey control   (  )
		call CW_SCR
		btfsc F1		;   SB1 ?
		incf Menu,F		; ,   
		btfsc F2		;   SB2 ?
		bsf F_inME		; ,   F_inME=1 ( )
		bcf F1			;   F1-SB1 (      )
		bcf F2			;   F2-SB2 (      )		
ME_X 		movlw high Baz_ME  	; .   Baz_ME
			movwf PCLATH    		;   .  
			movlw low Baz_ME  	; .   Baz_ME
			addwf Menu,W		; W = . +  Menu
			btfsc C
			incf PCLATH,F		; =1, . =0,   .
			movwf PCL			;    .   
Baz_ME		goto ME_0
			goto ME_1
			goto ME_2
			goto ME_3
			goto ME_4
			goto ME_5
			clrf Menu
;========== Pump_ON/OFF. /   SB1.  - SB2 ---------------------------------------
ME_0	call A1_SCR		;  1-  
		clrw			;  W   "Pump_"
		call TABL_T		
		movlw D'6'		;    "OFF"
		btfsc F_Pump
		movlw D'10'		; F_Pump=1,   "ON_"
		call TABL_T
		call A2_SCR		;  2-  
		movlw D'42'		;   "__Qw="
		call TABL_T
		movf Qw,W
		movwf VL
		call H2_D2		;     Qw = ""
		call _p			;   "%"
;----------   
		btfss F_inME	;     		
		goto OutME		; F_inME=0,  ME_0  , 		
		btfss F1		;    SB1
		goto mm2		;  SB1  ,    
		btfss F_Pump
		goto mm1		;  F_Pump=0,  SB1   F_Pump=1
		bcf F_Pump		;  F_Pump=1,  SB1   F_Pump=0
		goto mm2
mm1		bsf F_Pump
mm2		btfsc F2		;    SB2
		bcf F_inME		;  SB2 ,      F_inME=0
		goto OutME		;   ME_0 
;==========     . /   .  - SB2 ----------------- 
ME_1	call A1_SCR		;  1-  
		movlw D'14'		;   "AutoQw_"
		call TABL_T
		btfsc F_Pump
		call jY			; F_Pump=1,  ,   "Y"
		btfss F_Pump
		call j_			; F_Pump=0,  ,    "_"
		call A2_SCR		;  2-  
		btfss F_ERR
		goto mm3
		movlw D'62'		;   "ERROR="
		call TABL_T
		movf ERR,W
		movwf VL
		call H2_D2		;    ERR = ""
		goto mm4
mm3		movlw D'42'		;   "__Qw="
		call TABL_T
		movf Qw,W
		movwf VL
		call H2_D2		;     Qw = ""
		call _p			;   "%"
;----------   
		btfss F_inME	;     		
		goto OutME		; F_inME=0,  ME_1  , 		
		movf Qw,W
		subwf Qmin,W	; W = Qmin - Qw
		btfsc C
		bsf F_Pump		; C=1,  , Qmin > Qw  (F_Pump=1) 
		movf Qw,W
		subwf Qmax,W	; W = Qmax - Qw
		btfss C
mm4		bcf F_Pump		; C=0, , Qmax < Qw  (   F_ERR=1)
		btfsc F2		;    SB2
		bcf F_inME		;  SB2 ,      F_inME=0
		goto OutME		;   ME_1 
;========== Qmin. =SB1, =SB2.   CTf.  - SB1+SB2 --------------------- 
ME_2	call A1_SCR		;  1-  
		movlw D'22'		;   "Set_"
		call TABL_T
		movlw D'27'		;   "min_"
		call TABL_T
		call A2_SCR		;  2-  
		movlw D'42'		;   "__Qw="
		call TABL_T
		movf Qmin,W
		movwf VL
		call H2_D2		;  min  Qmin = ""
		call _p			;   "%"
;----------   
		btfss F_inME	;     		
		goto OutME		; F_inME=0,  ME_2  , 
		movlw H'23'
		movwf FSR		;   RG Qmin
		call SetLimit	;      SB1  SB2
		btfsc F1
		btfss F2
		goto OutME		;   SB1+SB2  =  		
		bcf F_inME		;      F_inME=0
		goto OutME		;   ME_2
;========== Qmax. =SB1, =SB2.   CTf.  - SB1+SB2 -------------------------- 
ME_3	call A1_SCR		;  1-  
		movlw D'22'		;   "Set_"
		call TABL_T
		movlw D'32'		;   "max_"
		call TABL_T
		call A2_SCR		;  2-  
		movlw D'42'		;   "__Qw="
		call TABL_T
		movf Qmax,W
		movwf VL
		call H2_D2		;  max  Qmax = ""
		call _p			;   "%"
;----------   
		btfss F_inME	;     		
		goto OutME		; F_inME=0,  ME_3  , 
		movlw H'22'
		movwf FSR		;   RG Qmax
		call SetLimit	;      SB1  SB2
		goto OutME		;   ME_3
;========== HtH,HtL. =SB1, =SB2.   CTf.  - SB1+SB2 ------------------- 
ME_4	call A1_SCR		;  1-  
		movlw D'22'		;   "Set_"
		call TABL_T
		movlw D'37'		;   "Ht_="
		call TABL_T
		call A2_SCR		;  2-  
		movf HtH,W
		movwf VH
		movf HtL,W
		movwf VL		;  HtH HtL = VH VL 
		call H3_D4		;     Ht [mm]
		movlw D'48'		;   "mm__"
		call TABL_T
;----------   
		btfss F_inME	;     		
		goto OutME		; F_inME=0,  ME_4  , 
		bsf F_Ht		;      F_Ht
		movlw H'20'
		movwf FSR		;   RG HtL (HtH    SetLimit)
		call SetLimit	;      SB1  SB2
		goto OutME		;   ME_4
;==========c   EEPROM,    _5 =SB2.      =YYY ----------------		
ME_5	call A1_SCR		;  1-  
		movlw D'53'		;   "EEPROM__"
		call TABL_T
		call A2_SCR		;  2-  
		call j_			;  
		movlw D'22'		;   "Set "
		call TABL_T	
		movlw D'6'		;    "OFF"
		btfss F_inME	;     
		call TABL_T		; F_inME=0,  "OFF"
		btfss F_inME	;     
		goto OutME		; F_inME=0, _5   - 
		bcf GIE			;    
		bsf MEM			;  1 
		clrf EEADR		;  HtL 		
		movf HtL,W		;  HtL
		call EEWR
		movf HtH,W		;  HtH
		call EEWR
		movf Qmax,W		;  Qmax
		call EEWR	
		movf Qmin,W		;  Qmin
		call EEWR
		bcf MEM			;  0 
		bsf GIE			;  		
		call jY
		call jY
		call jY			;    "YYY"		
		bcf F_inME		;      F_inME=0
;=================      ------------------------------------------------------------
;---------    SB1, SB2,  
OutME	call A2_SCR     ;      
        btfsc SB1       ;  SB1  ,  F1  
		bcf F1          ;  SB1 ,   F1
        btfsc SB2       ;  SB2  ,  F1  
		bcf F2          ;  SB1 ,   F2
		bcf F_SB		;      F_SB
		bsf MEM			; BANK1  
		bsf E_SB1		;     SB1 
		bsf E_SB2		;     SB2 
		bcf MEM			; BANK0  
		bsf E_SB		;     SB1, SB2 
;---------   WORK
cw6		movlw D'100'
		xorwf Cycle,W	;    WORK Cycle = 100  10  = 1000
		btfss Z
		goto cw6		; , 	
		goto WORK
;---------
		end				;  



