/* 
* Исходный код приложения app.js
 * Remote Devices Control Project
 * Дистанционное управление электроприборами
* на платформе Facebook Messenger и основе
 * Starter Project for Messenger Platform Quick Start Tutorial
 * https://developers.facebook.com/docs/messenger-platform/getting-started/quick-start/
 *
* Webhook для IDE Glitch.com
*
 * Автор Панкратьев Д. И., 2018
 */

'use strict';

//Импорт требуемых модулей
const 
  request = require('request'),
  express = require('express'),
  body_parser = require('body-parser'),
  //создание http express сервера
  app = express().use(body_parser.json());

//Импорт токена верификации из переменных окружения
//Только для платформы glith.com!
const VERIFY_TOKEN = process.env.PAGE_ACCESS_TOKEN;
const DEV_LIST = process.env.DEV_LST;

var sender_psid, //идентификатор отправителя
    response, //json ответ на запрос
//Код текущей команды для контроллера в виде {"dev":"xy","set":"2/1/0"}
//Необрабатываемая комбинация Вкл.все
    cmd = {
      "dev":"0",
      "set":"1"
    },
//Счетчики запросов от контроллера для проверки связи
    nq = 0,
    nq_prev = 0; 
	
//Установка порта сервера
app.listen(process.env.PORT || 1337, () => console.log('webhook настроен'));

//Принятие POST запросов к /webhook
app.post('/webhook', (req, res) => {
  
  //Разбор POST запросов
  let body = req.body;

  //Проверка запроса от страницы подписки
  if (body.object === 'page') {
	  
    //Перебор входных элементов запроса, если он множественный
    body.entry.forEach(function(entry) {

      //Получение события webhook. 
	  //entry.messaging является массивом, 
      //необходим элемент с индексом 0
      let webhook_event = entry.messaging[0];
      console.log(webhook_event);
      
      //Получение идентификатора отправителя PSID
      sender_psid = webhook_event.sender.id;
      //console.log('Sender PSID: ' + sender_psid);

      //Проверка типа события (message / postback),
      //вызов обработчика
      if (webhook_event.message) {
        handleMessage(sender_psid, webhook_event.message);        
      } else if (webhook_event.postback) {
        handlePostback(sender_psid, webhook_event.postback);
      }      
    });
    
	//Отправка статуса '200 OK' на события
    res.status(200).send('EVENT_RECEIVED');
  } else {
    //Отправка статуса '404 Not Found', 
	//если запрос не от страницы подписки
    res.sendStatus(404);
  }
});

//Принятие GET запросов к /webhook
app.get('/webhook', (req, res) => {
  
  //Разбор параметров запроса верификации webhook
  let mode = req.query['hub.mode'];
  let token = req.query['hub.verify_token'];
  let challenge = req.query['hub.challenge'];
  
  let q = req.query['q']; //строка запроса команды от контроллера
  let d = req.query['d']; //номер исполнительного устройства от контроллера
  let st = req.query['st']; //статус выполнения команды от контроллера (0-выкл, 1-вкл, 2-отсутствует)
  let tk = req.query['tk']; //токен от контроллера
  
  let s = cmd.dev + ';' + cmd.set; //строка ответа в текстовом формате csv
  
  //Проверка режима подписки и токена  
  if (mode && token) {
    if (mode === 'subscribe' && token === VERIFY_TOKEN) {
	  //Отправка статуса 200 OK и параметра challenge
      console.log('WEBHOOK_VERIFIED');
      res.status(200).send(challenge);    
    } else { //несоответствие токена
      //Отправка статуса '403 Forbidden'
      res.sendStatus(403);      
    }
  }
    //запрос команды от контроллера и проверка токена
    if (q === '0' && tk === VERIFY_TOKEN) {
      res.status(200).send(s); //отправка команды контроллеру
      cmd = { //сброс команды
        "dev":"0",
        "set":"1"
      };
      //console.log(cmd.dev + '/' + cmd.set);
      nq += 1; //inc счетчика запросов от контроллера
      //console.log(nq);
  }
    //сообщение от контроллера о статусе выполнения команды
    if (q === '1' && tk === VERIFY_TOKEN) {
     let message_type = "UPDATE"; //свойство обязательно с 07.05.18!
       if (st === '0') {
             response = {"text":"Устройство " + d + " выключено"}
       }
       if (st === '1') {
             response = {"text":"Устройство " + d + " включено"}
       }
       if (st === '2') {
             response = {"text":"Команда не выполнена. Повторите"}
       }
       if (st === '3') {
             response = {"text":"Устройство " + d + " отсутствует"}
       }
     callSendAPI(sender_psid, response, message_type); 
  }
});

//Обработчик события messages
function handleMessage(sender_psid, received_message) {
  //Проверка на наличие текста в сообщении
  if (received_message.text) {
    //проверка связи по счетчику запросов
    if (nq != nq_prev) {
      //Формирование команды,
	  //создание текста сообщения
      response = checkCommand(received_message.text);
      
      nq_prev = nq;
      //Обнуление счетчиков (~1 мес-1)
      //во избежание переполнения
      if (nq > 5000000) {
        nq = 0;
      }
      /*
      //Пример шаблона с кнопками обратного вызова
	  response = {
        "attachment":{
          "type":"template",
          "payload":{
            "template_type":"button",
            "text":"Выберите действие",
            "buttons":[
              {
                "type":"postback",
                "title":"Вкл.устр.1",
                "payload":cmd
              },
              {
                "type":"postback",
                "title":"Вкл.устр.2",
                "payload":cmd
              },
              {
                "type":"postback",
                "title":"Выкл.все",
                "payload":cmd
              }
            ]
          }
        }
      }
      */
      } else {
      response = {
      "text": `Нет связи с контроллером!`
      }
    }
    console.log(response);
  //Отправка ответа на запрос
  let message_type = "RESPONSE"; //свойство обязательно с 07.05.18!
  callSendAPI(sender_psid, response, message_type);
  }
}

//Обработчик события messaging_postbacks
function handlePostback(sender_psid, received_postback) {

}

//Отправка сообщения через Send API
function callSendAPI(sender_psid, response, message_type) {
  //Формирование сообщения
  let request_body = {
	"messaging_type": message_type,
    "recipient": {
      "id": sender_psid
    },
    "message": response
  }

  //Отправка HTTP запроса мессенджеру
  request({
    "uri": "https://graph.facebook.com/v2.6/me/messages",
    "qs": { "access_token": VERIFY_TOKEN },
    "method": "POST",
    "json": request_body
  }, (err, res, body) => {
    if (!err) {
      console.log('Сообщение отправлено!')
    } else {
      console.error("Ошибка при отправке:" + err);
    }
  });
}

//Формирование команды,
//создание содержимого сообщения
function checkCommand(text) {
  let resp,
      char_exists;
  
  if (text === 'У') { //запрос списка устройств
      resp = {
      "text": DEV_LIST
      };
      cmd = { //сброс команды
      "dev":"0", 
      "set":"1"
      }
  }
  
  if (text === 'П') { //проверка связи
      if (nq !== nq_prev) {
			resp = {
				"text": `Связь с контроллером есть`
				};
		  } else {
			  resp = {
				"text": `Связи с контроллером нет`
				};
		}
  }
  
  if (text !== 'У' && text !== 'П') { //текст не равен У и П
  //проверка в Юникоде на нецифровые символы
  //(с кодами вне диапазона 48-57)
      for (var i = 0; i < text.length; i++) {
        if (48 <= text.charCodeAt(i) && text.charCodeAt(i) <= 57) {
            char_exists = 0
          } else {
            char_exists = 1;
            //console.log('Обнаружен символ');
            break;
            }
        //console.log(text.charCodeAt(i));
      }
    
      if (char_exists === 0) { //только цифры 
        resp = {
          "text": `Получена команда: ` + text
        };
        //Формирование команды для контроллера
		    //c проверкой на последний символ.
        //Если не 0 или 1, то 2 (0-выкл, 1-вкл, 2-статус)
        if (text.charCodeAt(text.length-1) == 48) {
          cmd = {
            "dev": text.substr(0, text.length-1),
            "set": "0"
          }
        };
        if (text.charCodeAt(text.length-1) == 49) {
          cmd = {
            "dev": text.substr(0, text.length-1),
            "set": "1"
          }
        };
        if (text.charCodeAt(text.length-1) > 49) {
          cmd = {
            "dev": text.substr(0, text.length-1),
            "set": "2"
          }
        };
        console.log(cmd.dev + '/' + cmd.set);
      } else { //обнаружен символ
          resp = {
            "text": `Команда должна содержать только цифры`
          };
          cmd = { //сброс команды
            "dev": "0",
            "set": "1"
          };
        }
  }
  //console.log(resp);
  return resp;
}
