/*
* Исходный код приложения app.js
 * Remote Devices Control Project
 * Дистанционное управление электроприборами
 * на платформе Facebook Messenger
*
 * Программа-бот для Orange PI, OS Armbian,
 * NodeJs
 *
 * Автор Панкратьев Д.И., 2018
 */

//Импорт требуемых модулей
const req = require('request'),
	  parser = require('csv-parse'),
	  gpio = require('orange-pi-gpio'),
	  //настройка Webhook
	  proto = 'https://';
      base_url = '<glitch_project_url>.glitch.me',
      path = '/webhook',
	  VERIFY_TOKEN = '<page_access_token>';

var s, //csv-строка команды
	dev = '0', //номер устройства
	cmd = '1'; //исполнительная команда

/*---------------------------
|	WiringPi|  BCM	|  Pin	|
-----------------------------
|	0		|	1	|	11 	|
|	1		|	110	|	12	|
|	2		|	0	|	13	|
|	3		|	3	|	15	|
|	4		|	68	|	16	|
|	5		|	71	|	18	|
|	6		|	2	|	22	|
---------------------------*/
	
//массив описания выходных пинов
//в соответствии с нумерацией WiringPi
let out_pins = [0,1,2],
//массив описания входных пинов
	in_pins = [3,4,5],
//массив описания пинов с "подтяжкой" к +
	pull_up_pins = [3,5],
//пин подачи питания на выходные каскады
	com_pwr_pin = 6,
//инициализация портов
//массив экземпляров GPIO
//io[0] не используется
	io = [];
//коллекции объектов для поиска
let store_out = {},
	store_in = {}; 

function set_pins () {
	console.log('Pin setup');
    //установка выходов
	for (var i=0; i < out_pins.length; i++) {
   	 io[i+1] = new gpio({pin:out_pins[i], mode:'out'});
   	 console.log('Out pin:' + out_pins[i]);
	 io[i+1].write(0); //уст. лог. 0
	}
    let j = 0,
		n = out_pins.length + in_pins.length;
	//установка входов
    for (var i=out_pins.length; i < n; i++) {
     io[i+1] = new gpio({pin:in_pins[j], mode:'in'});
     console.log('In pin:' + in_pins[j]);
	 j++;
    }	
	//"подтяжка" входов
    for (var i=0; i < n; i++) {
		for (j=0; j < pull_up_pins.length; j++) {    
			//console.log(io[i+1].pin);
			//console.log(pull_up_pins[j]);
			if (io[i+1].pin == pull_up_pins[j]) {
				io[i+1] = new gpio({pin:io[i+1].pin, mode:'up'});
     			console.log('Pullup:' + io[i+1].pin);
			}
		}
    }
	//выход подачи питания
	//режим по умолчанию out
	let pwr_pin = new gpio({pin:com_pwr_pin});
	pwr_pin.write(0); //уст. лог. 0
	console.log('Power pin:' + com_pwr_pin);
	
	//задержка подачи питания
	//на выходные буферные каскады
	var Timeout = setTimeout(function() {
    	pwr_pin.write(1); //уст. лог. 1
		console.log('Устройства готовы');
	}, 500); //время задержки, мс
}
set_pins();

//Функция запроса к Webhook по таймеру
var Timer = setInterval(function() {
   if (dev === '0' && cmd === '1') {
	//вызов функции запроса
	//qry(q,d,st,VERIFY_TOKEN)
	//q-тип запроса,d-номер устройства,st - статус
	//st = 0-ON,1-OFF,2-ошибка команды ALL OFF,3-устройство отсутствует
	qry(0, 0, 0, VERIFY_TOKEN); //запрос команды
  	if (s) {
		cmd_parse(s); //вызов функции парсинга
		console.log(dev + '/' + cmd);
		s = '';
  	}  
  }
  //обработка исполнительной команды
  if (dev !== '0' && cmd !== '2') {
	//проверка наличия в массиве описания выходов
	for (var i = 0; i < out_pins.length; i++) {
		var key = out_pins[i];
		if (!store_out[key]) {store_out[key] = true;} 
	}
	if (store_out[dev]) {
		io[dev].write(cmd);	//запись команды
		io[dev].read() //проверка статуса
    	.then((state)=>{
        	console.log('Dev=' + dev + ',State=' + state); //вывод статуса
			qry(1, dev, state, VERIFY_TOKEN); //отправка статуса
    	});
	} else {
			console.log('Dev=' + dev + 'is out of index');
			qry(1, dev, 3, VERIFY_TOKEN); //устройство отсутствует 
	}	
  };
  //обработка запроса статуса
  if (dev !== '0' && cmd === '2') {
	//проверка наличия в массивах описания выходов/входов
	for (var i = 0; i < out_pins.length; i++) {
		var key = out_pins[i];
		if (!store_out[key]) {store_out[key] = true;} 
	}
	for (var i = 0; i < in_pins.length; i++) {
		var key = in_pins[i];
		if (!store_in[key]) {store_in[key] = true;}
	}	
	if (store_out[dev] || store_in[dev]) {	
		io[dev].read() //проверка статуса
    	.then((state)=>{
        	console.log('Dev=' + dev + ',State=' + state); //вывод статуса
			qry(1, dev, state, VERIFY_TOKEN); //отправка статуса
    	});
	} else {
			console.log('Dev=' + dev + 'is out of index');
			qry(1, dev, 3, VERIFY_TOKEN); //устройство отсутствует 
	}
  };
  //обработка команды "Выключить все" (ALL OFF)
  if (dev === '0' && cmd === '0') {
	for (var i=0; i < out_pins.length; i++) {
	//элементы массива io[] от 1 до out_pins.length - выходы		
		io[i+1].write(0); //запись 0
		io[i+1].read() //проверка статуса
    	.then((state)=>{
        	console.log('Dev=' + dev + ',State=' + state); //вывод статуса
    	if (state == 1) {
			qry(1, 0, 2, VERIFY_TOKEN); //одно из устройств ВКЛ!			
			exit; //прервать цикл
		}
		});		 	
	}
  console.log('Устройства отключены');
	
  qry(1, 0, 0, VERIFY_TOKEN); //отправка статуса  
  }
}, 2000); //период отправки запросов, мс

//функция отправки запроса Webhook
function qry (q, d, st, tk) {	  
	req({
	"uri" : proto + base_url + path,
	"qs" : {
		"q" : q,
		"d" : d,
		"st" : st,
		"tk" : tk		
		},
	"method" : "GET"
	}, (err, res, body) => {
		if (!err) {
			console.log('Sent: q=' + q + ',d=' + d + ',st=' + st);
			//console.log(res.statusCode);			
			console.log(body);			
			s = body;
		} else {
			console.error(err)
		}
	});
	//сброс команды
	dev = '0';
	cmd = '1';
}

//функция парсинга csv
function cmd_parse (s) {
	let data = [];
	//data[0][0]-номер устройства, data[0][1]-команда
	parser(s, {delimiter:";"}, function(err, data) {
		if (!err) {
			dev = data[0][0];
			cmd = data[0][1];
			console.log(data);
		} else {
			console.log(err)
		}
	});
}
