/*
 ESP8266 --> ThingSpeak Channel via MKR1000 Wi-Fi
 
 This sketch sends the temperature & pressure (BMP280) to a ThingSpeak
 channel using the ThingSpeak API (https://www.mathworks.com/help/thingspeak).
 
 Requirements:
 
   * ESP8266 Wi-Fi Device
   * Arduino 1.6.9+ IDE
   * Additional Boards URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
   * Library: esp8266 by ESP8266 Community
   * Library: Adafruits BMP280 (https://github.com/adafruit/Adafruit_Sensor) & 
              (https://github.com/adafruit/Adafruit_BMP280_Library)
 
 ThingSpeak Setup:
 
   * Sign Up for New User Account - https://thingspeak.com/users/sign_up
   * Create a new Channel by selecting Channels, My Channels, and then New Channel
   * Enable two field
   * Note the Channel ID and Write API Key
    
 Setup Wi-Fi:
  * Enter SSID
  * Enter Password
  
*/
#define test_in   2   //анализируемый вход

#include <ESP8266WiFi.h>

// Wi-Fi Settings
const char* ssid = "ROSTELECOM_2A40"; // your wireless network name (SSID)
const char* password = "4KFJ7PHH"; // your Wi-Fi network password

WiFiClient client;
 
float pressure, temp_c;  // Values read from sensor

// ThingSpeak Settings
const int channelID = 490577;
String writeAPIKey = "C9CSOEPMSFZ155HZ"; // write API key for your ThingSpeak Channel
const char* server = "api.thingspeak.com";
const int postingInterval = 20 * 20; // post data every 20 seconds (отсчеты по 50 мс)
const int tContBounce = 50; //период опроса контакта (гашение влияния дребезга), мс

byte SwOld = 1;         //предыдущее состояние входа
long int tTekOld = 0;   //время предстоящего опроса входа, мс
long int tTek;          //текущий отсчет времени, мс
int tPer=0;             //отсчет периода для отправки сведений

void SendMesToThingSpeak() {   //отсылка сведений в сервис
    if (client.connect(server, 80)) {
    

    // Construct API request body
    String body = "field4=";
           body += String(SwOld);
    Serial.print("Switch: ");
    Serial.println(SwOld); 

    client.println("POST /update HTTP/1.1");
    client.println("Host: api.thingspeak.com");
    client.println("User-Agent: ESP8266 (nothans)/1.0");
    client.println("Connection: close");
    client.println("X-THINGSPEAKAPIKEY: " + writeAPIKey);
    client.println("Content-Type: application/x-www-form-urlencoded");
    client.println("Content-Length: " + String(body.length()));
    client.println("");
    client.print(body);

  }
  client.stop();
  
}

void setup() {
//  digitalWrite(_cs, HIGH);
  pinMode(test_in, INPUT);
  Serial.begin(115200);
  Serial.println(F("Switch test"));
  
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
}

void loop() {
  
  while (millis() < tTekOld) {   //пока не настало время опроса - ждем...
  }
  tTekOld += tContBounce;        //время следующего опроса 
  byte Sw = digitalRead(test_in);  //читаем вход контактного датчика

  if (Sw != SwOld) {            //состояние сменилось - отослать сведения
    SwOld = Sw;
    SendMesToThingSpeak();
    //можно добавить анализ и коррекцию tPer чтоб лишний раз не отсылать
    }

  tPer ++;
  if (tPer > postingInterval) {     //настало время отослать сведения даже
                                    //если состояние не менялось
    tPer = 0;
    SendMesToThingSpeak();
    }
  
}
