/*
 ESP8266 --> ThingSpeak Channel via MKR1000 Wi-Fi
 
 This sketch sends the temperature (DS18B20) to a ThingSpeak
 channel using the ThingSpeak API (https://www.mathworks.com/help/thingspeak).
 
 Requirements:
 
   * ESP8266 Wi-Fi Device
   * Arduino 1.6.9+ IDE
   * Additional Boards URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
   * Library: esp8266 by ESP8266 Community
   * Library: OneWire
 
 ThingSpeak Setup:
 
   * Sign Up for New User Account - https://thingspeak.com/users/sign_up
   * Create a new Channel by selecting Channels, My Channels, and then New Channel
   * Enable one field
   * Note the Channel ID and Write API Key
    
 Setup Wi-Fi:
  * Enter SSID
  * Enter Password
  
*/

//#include <DHT.h>
#include <ESP8266WiFi.h>
//#define DHTTYPE DHT11
//#define DHTPIN  2
#include <OneWire.h>  //для термометра DS18B20

// Wi-Fi Settings
const char* ssid = "ROSTELECOM_2A40"; // your wireless network name (SSID)
const char* password = "4KFJ7PHH"; // your Wi-Fi network password

WiFiClient client;
// Initialize DHT sensor 
// NOTE: For working with a faster than ATmega328p 16 MHz Arduino chip, like an ESP8266,
// you need to increase the threshold for cycle counts considered a 1 or 0.
// You can do this by passing a 3rd parameter for this threshold.  It's a bit
// of fiddling to find the right value, but in general the faster the CPU the
// higher the value.  The default for a 16mhz AVR is a value of 6.  For an
// Arduino Due that runs at 84mhz a value of 30 works.
// This is for the ESP8266 processor on ESP-01 
//DHT dht(DHTPIN, DHTTYPE, 11); // 11 works fine for ESP8266
 
float temp_f;  // Values read from sensor
OneWire  ds(2);  // on GPIO2 (a 4.7K resistor is necessary)

// ThingSpeak Settings
const int channelID = 490577;
String writeAPIKey = "C9CSOEPMSFZ155HZ"; // write API key for your ThingSpeak Channel
const char* server = "api.thingspeak.com";
const int postingInterval = 20 * 1000; // post data every 20 seconds

void Measure_Temperature_Start() {
//for 1-wire  (ds18b20)
  ds.reset();
  ds.write(0xCC);        //skip rom (не читать память с адресом)
  ds.write(0x44, 1);     // start conversion, with parasite power on at the end
//после запуска надо подождать, чтоб замер прошел – примерно секунду 
}

void Measure_Temperature_Read() {
//for 1-wire  (ds18b20)
  byte i;
  byte data[12];
  ds.reset();
  ds.write(0xCC);            //skip rom (не читать память с адресом)
  ds.write(0xBE);         // Read Scratchpad

  for ( i = 0; i < 9; i++) {           // we need 9 bytes
    data[i] = ds.read();
  }

  // Convert the data to actual temperature
  // because the result is a 16 bit signed integer, it should
  // be stored to an "int16_t" type, which is always 16 bits
  // even when compiled on a 32 bit processor.
  int16_t raw = (data[1] << 8) | data[0];
  temp_f = (float)raw / 16.0;
//  celsius = raw;   //все 16 бит без коррекции 
}

void gettemperature() {
    Measure_Temperature_Start();  //запустим измерение температуры
    delay(1000);
    Measure_Temperature_Read(); //считаем температуру с датчика 
}

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
}

void loop() {
  if (client.connect(server, 80)) {
    
// Reading temperature 
    gettemperature();       // read sensor

    // Construct API request body
    String body = "&field2=";
           body += String(temp_f);                          
    Serial.print("Temperature: ");
    Serial.println(temp_f); 

    client.println("POST /update HTTP/1.1");
    client.println("Host: api.thingspeak.com");
    client.println("User-Agent: ESP8266 (nothans)/1.0");
    client.println("Connection: close");
    client.println("X-THINGSPEAKAPIKEY: " + writeAPIKey);
    client.println("Content-Type: application/x-www-form-urlencoded");
    client.println("Content-Length: " + String(body.length()));
    client.println("");
    client.print(body);

  }
  client.stop();

  // wait and then post again
  delay(postingInterval);
}
