/*
 ESP8266 --> ThingSpeak Channel via MKR1000 Wi-Fi
 
 This sketch sends the temperature & pressure (BMP280) to a ThingSpeak
 channel using the ThingSpeak API (https://www.mathworks.com/help/thingspeak).
 
 Requirements:
 
   * ESP8266 Wi-Fi Device
   * Arduino 1.6.9+ IDE
   * Additional Boards URL: http://arduino.esp8266.com/stable/package_esp8266com_index.json
   * Library: esp8266 by ESP8266 Community
   * Library: Adafruits BMP280 (https://github.com/adafruit/Adafruit_Sensor) & 
              (https://github.com/adafruit/Adafruit_BMP280_Library)
 
 ThingSpeak Setup:
 
   * Sign Up for New User Account - https://thingspeak.com/users/sign_up
   * Create a new Channel by selecting Channels, My Channels, and then New Channel
   * Enable two field
   * Note the Channel ID and Write API Key
    
 Setup Wi-Fi:
  * Enter SSID
  * Enter Password
  
*/

#include <ESP8266WiFi.h>
#include <Wire.h>
#include <SPI.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BMP280.h>

// Wi-Fi Settings
const char* ssid = "ROSTELECOM_2A40"; // your wireless network name (SSID)
const char* password = "4KFJ7PHH"; // your Wi-Fi network password

WiFiClient client;
// Initialize pressure sensor 
Adafruit_BMP280 bme; // I2C
 
float pressure, temp_c;  // Values read from sensor

// ThingSpeak Settings
const int channelID = 490577;
String writeAPIKey = "C9CSOEPMSFZ155HZ"; // write API key for your ThingSpeak Channel
const char* server = "api.thingspeak.com";
const int postingInterval = 20 * 1000; // post data every 20 seconds


void setup() {
  Wire.begin(2,0);  //GPIO0=SCL I2C; GPIO2=SDA I2C  for ESP-01
  Serial.begin(115200);
  Serial.println(F("BMP280 test"));
  
  if (!bme.begin(0x76)) {             //адрес ВМР280 при SDO=GND   0x76
    Serial.println(F("Could not find a valid BMP280 sensor, check wiring!"));
    while (1);
  }
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }
}

void loop() {
  if (client.connect(server, 80)) {
    
    // Reading temperature & pressure BMP280
    pressure = bme.readPressure();
    temp_c = bme.readTemperature();

    // Construct API request body
    String body = "field3=";
           body += String(pressure);
           body += "&field2=";
           body += String(temp_c);                          
    Serial.print("Pressure: ");
    Serial.print(pressure); 
    Serial.print("     Temperature: ");
    Serial.println(temp_c); 

    client.println("POST /update HTTP/1.1");
    client.println("Host: api.thingspeak.com");
    client.println("User-Agent: ESP8266 (nothans)/1.0");
    client.println("Connection: close");
    client.println("X-THINGSPEAKAPIKEY: " + writeAPIKey);
    client.println("Content-Type: application/x-www-form-urlencoded");
    client.println("Content-Length: " + String(body.length()));
    client.println("");
    client.print(body);

  }
  client.stop();

  // wait and then post again
  delay(postingInterval);
}
