library verilog;
use verilog.vl_types.all;
entity UART_byte_tx is
    generic(
        GLOBAL_CLOCK    : integer := 50000000;
        UART_RATE_2400  : integer := 2400;
        UART_RATE_4800  : integer := 4800;
        UART_RATE_9600  : integer := 9600;
        UART_RATE_19200 : integer := 19200;
        UART_RATE_38400 : integer := 38400
    );
    port(
        clk             : in     vl_logic;
        nrst            : in     vl_logic;
        UART_tx_start   : in     vl_logic;
        UART_tx_data    : in     vl_logic_vector(7 downto 0);
        dip             : in     vl_logic_vector(3 downto 0);
        UART_tx         : out    vl_logic;
        UART_tx_final   : out    vl_logic;
        UART_tx_done    : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of GLOBAL_CLOCK : constant is 1;
    attribute mti_svvh_generic_type of UART_RATE_2400 : constant is 1;
    attribute mti_svvh_generic_type of UART_RATE_4800 : constant is 1;
    attribute mti_svvh_generic_type of UART_RATE_9600 : constant is 1;
    attribute mti_svvh_generic_type of UART_RATE_19200 : constant is 1;
    attribute mti_svvh_generic_type of UART_RATE_38400 : constant is 1;
end UART_byte_tx;
