library verilog;
use verilog.vl_types.all;
entity PCF8563_wr_rd is
    generic(
        GLOBAL_CLOCK    : integer := 50000000;
        PCF8563_RATE    : integer := 500000;
        T               : vl_notype;
        ADDR_SLAVE_PCF8563: vl_logic_vector(0 to 6) := (Hi1, Hi0, Hi1, Hi0, Hi0, Hi0, Hi1);
        WORD_ADDR_WRITE : vl_logic_vector(0 to 7) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi1, Hi0);
        WORD_ADDR_READ  : vl_logic_vector(0 to 7) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi1, Hi0);
        WRITE_BIT       : integer := 0;
        READ_BIT        : vl_logic := HiZ
    );
    port(
        clk             : in     vl_logic;
        nrst            : in     vl_logic;
        PCF8563_write_start: in     vl_logic;
        PCF8563_read_start: in     vl_logic;
        PCF8563_write_data_1: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_2: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_3: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_4: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_5: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_6: in     vl_logic_vector(7 downto 0);
        PCF8563_write_data_7: in     vl_logic_vector(7 downto 0);
        PCF8563_read_data_1: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_2: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_3: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_4: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_5: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_6: out    vl_logic_vector(7 downto 0);
        PCF8563_read_data_7: out    vl_logic_vector(7 downto 0);
        write_final_imp : out    vl_logic;
        read_final_imp  : out    vl_logic;
        PCF8563_SCL     : out    vl_logic;
        PCF8563_SDA     : inout  vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of GLOBAL_CLOCK : constant is 1;
    attribute mti_svvh_generic_type of PCF8563_RATE : constant is 1;
    attribute mti_svvh_generic_type of T : constant is 3;
    attribute mti_svvh_generic_type of ADDR_SLAVE_PCF8563 : constant is 1;
    attribute mti_svvh_generic_type of WORD_ADDR_WRITE : constant is 1;
    attribute mti_svvh_generic_type of WORD_ADDR_READ : constant is 1;
    attribute mti_svvh_generic_type of WRITE_BIT : constant is 1;
    attribute mti_svvh_generic_type of READ_BIT : constant is 1;
end PCF8563_wr_rd;
