//   Модуль формирования единичного импульса разрешения звука от нажатия кнопки.
// 
module  buzzer_butt(
        input clk,	
	     input en_buzzer_key,
	     output en_buzzer_button
	);

reg[8:0] counter; // счетчик для подсчета счетных импульсов

reg reg_en_buzzer_button = 0;	 // переменная состояния  импульса разрешения звука

wire en_buzzer_key_start; 

reg Q1 = 0;
reg Q2 = 0;

parameter   POROG_IMP = 100;       //  количество счетных импульсов, задающее длительность 
                                    // формируемого единичного импульса разрешения звука  


// формирователь импульса  длительностью один период clk по фронту en_buzzer_key   	  
always@(posedge (~clk)) 	  
  begin  
     Q1 <= en_buzzer_key;
	Q2 <= Q1; 
  end  
 
assign en_buzzer_key_start = Q1 & (~Q2);							 
							 
							 
							 
							 
// формирование  единичного  импульса  по нажатию кнопки  
always @(posedge clk or posedge en_buzzer_key_start)  
begin
       if (en_buzzer_key_start)
	        begin
		       counter <= 0;
		       reg_en_buzzer_button <= 1; // начать  импульс 
		     end
       else
           begin	
	          if (counter >= POROG_IMP) 
		          begin
			         reg_en_buzzer_button <= 0; // закончить  импульс
			       end
		       else
	             begin
		            counter <= counter + 1;
                end 		
           end 
end 

assign en_buzzer_button = reg_en_buzzer_button;  

endmodule