// Модуль  передачи байта через UART  
//
module  UART_byte_tx(
     input clk, 	
	input nrst,   
	input UART_tx_start, // сигнал  начала передачи через UART  
	input [7:0] UART_tx_data,  // передаваемые данные через UART  
   
	input  [3:0]dip,  // линии задания скорости UART
		
   output UART_tx, 
	output UART_tx_final,  // признак завершения передачи байта через UART
	output UART_tx_done    // признак длящейся передачи байта через UART    
	);
   

   
wire tx_start;  // импульс начала передачи через UART 
  
reg [31:0] counter_T_bit = 0; // счетчик отсчета интервала между  передаваемыми битами через UART       


reg  tx_done  = 0; // признак длящейся передачи байта через UART  
reg  tx_final = 0; // признак завершения передачи байта через UART   
reg  tx = 0;  // линия передачи

// выходы двухступенчатого триггера формирователя положительного импульса  длительностью 1 период clk 
reg Q1 = 0; //
reg Q2 = 0; //
reg R1 = 0; //
reg R2 = 0; //

parameter   GLOBAL_CLOCK  = 50_000_000;  // частота глобального синхросигнала, Гц 

parameter UART_RATE_2400 = 2400;  // скорость  передачи через UART 2400 бит/с
parameter UART_RATE_4800 = 4800;  // скорость  передачи через UART 4800 бит/с
parameter UART_RATE_9600 = 9600;  // скорость  передачи через UART 9600 бит/с
parameter UART_RATE_19200 = 19200;  // скорость  передачи через UART 19200 бит/с
parameter UART_RATE_38400 = 38400;  // скорость  передачи через UART 38400 бит/с 
 
reg [15:0] T = GLOBAL_CLOCK / UART_RATE_2400;  // интервал между  битами в байте 


// задание скорости передачи через UART 
always @(*)      
begin 
	case  (dip[3:0])  
		 4'b0111:  begin T <= GLOBAL_CLOCK / UART_RATE_4800;   end 
		 4'b1011:  begin T <= GLOBAL_CLOCK / UART_RATE_9600;   end		 
		 4'b1101:  begin T <= GLOBAL_CLOCK / UART_RATE_19200;  end		 
		 4'b1110:  begin T <= GLOBAL_CLOCK / UART_RATE_38400;  end		 
		 default:  begin T <= GLOBAL_CLOCK / UART_RATE_2400;   end 
	endcase	
end 

		
// формирователь импульса  старта  передачи через UART  
// tx_start  длительностью один период clk по фронту UART_tx_start   	  
always@(posedge (~clk)) 	  
  begin  
     Q1 <= UART_tx_start;
	Q2 <= Q1; 
  end  
 
assign tx_start = Q1 & (~Q2);
	
			

// Генерация состояния длящейся передачи через UART по обнаружению стартового импульса 
always @(posedge clk)      
begin 
 if (tx_start)  // если  обнаружен   стартовый импульс    
	 begin 
	   tx_done <= 1;	// установить признак длящейся передачи байта через UART
      end 
 else if (UART_tx_final)	 //  если   байт   передан
	 begin
      tx_done <= 0;   //  сбросить признак длящейся передачи байта через UART  
    end		
end
	 
// управление выходом UART_tx_done 
assign UART_tx_done = tx_done;
	
	
	
// Передача байта через UART     
always @(posedge clk)      
begin 
 if(!nrst) //  реакция системы на сброс 
    begin 	  	 
      counter_T_bit <= 0; 
	 tx_final <= 0;
      tx <= 1; // исходное состояние линии передачи - высокий уровень	 
    end 	
 else  if (tx_done)  //  если установлен признак длящейся передачи байта через UART  
    begin
       counter_T_bit <= counter_T_bit + 1;
		 case (counter_T_bit)  
		            1: begin tx <= 0;  end  // передача стартового бита   		
		            T: begin tx <= UART_tx_data[0]; end 
  	           (2*T): begin tx <= UART_tx_data[1]; end
		        (3*T): begin tx <= UART_tx_data[2]; end
		        (4*T): begin tx <= UART_tx_data[3]; end
		        (5*T): begin tx <= UART_tx_data[4]; end
		        (6*T): begin tx <= UART_tx_data[5]; end
		        (7*T): begin tx <= UART_tx_data[6]; end 
		        (8*T): begin tx <= UART_tx_data[7]; end
		        (9*T): begin tx <= 1; end  // передача стопового бита
			  
			    (10*T): begin 
					   // окончание передачи стопового бита    
					   tx_final <= 1;   
					end  
		 endcase
    end
 else
    begin
	   counter_T_bit <= 0;
	   tx_final <= 0; 	
	   tx <= 1; // исходное состояние линии передачи - высокий уровень	 
    end
end

// управление выходом UART_tx 
assign UART_tx = tx; 



// формирователь импульса  завершения пердачи данных   через UART  
// UART_tx_final  длительностью один период clk по фронту tx_final    	  
always@(posedge (~clk)) 	  
  begin  
   R1 <= tx_final;
   R2 <= R1; 
  end  
 
assign UART_tx_final = R1 & (~R2);





endmodule
