//----------------------------------------------------------------------------------------------------------------------------------------
// Электронные часы на базе модуля часов-календаря реального времени  PCF8563.
// Текущая время и дата  циклически (2 раза в секунду) читаются из PCF8563 и в режиме отображения отображаются на LCD1602.
// В режиме набора установка времени и даты осуществляется с клавиатуры 4 х 4 путем прямого набора. 
// При каждом новом нажатии на клавишу меняется следующее знакоместо на LCD1602  по кольцу.
// Для набора используются только цифровые клавиши. 
// Переход на начало набора (первое знакоместо LCD1602) - клавиша ESC.  
// Задание режима (отображение или набор) - клавиша GO. 
// Запись набранного с клавиатуры значения в PCF8563 - клавиша ENT.
// В момент записи режим принудительно  меняется с набора на отображение.  
// Включение/отключение блокировки клавиатуры - клавиша L.  
// При включенной блокировке клавиатура  на нажатия не реагирует, кроме клавиши L.  
// Каждое нажатие на любую клавишу  при отключенной блокировке озвучивается пачкой из 100 импульсов звуковой частоты.  
// Из устройства циклически (3-4 раза в секунду) через UART передаются  данные, прочитанные из PCF8563 и  преобразованные из упакованного  
// двоично-десятичного формата в неупакованный  двоичный ASCII. Формат передачи - 13 байт: байт заголовка (ASCII "$"), дес чисел, ед чисел, дес мес, 
// ед мес, дес лет, ед лет, дес час, ед час, дес мин, ед мин, дес сек, ед сек.
// UART работает только на передачу, прием данных не осуществляется. 
// Скорость передачи через UART задается DIP-переключателями и может быть равной: 2400, 4800, 9600, 19200, 38400 бит/с.  
//
//  Автор  - Редькин П.П.  2018 год       
//-----------------------------------------------------------------------------------------
// Входной глобальный синхросигнал  clk - 50 МГц
//
// Платоформа -  Cyclone-IVE     EP4CE22F17C6N (DE0-Nano)
//-----------------------------------------------------------------------------------------
//  clk          PIN_R8
// Вход подключения кнопки сброса 
// на этой линии должен быть  включен внутренний резистор подтяжки к плюсу питания 
//  nrst         PIN_F13   // Reset
//----------------------------------------
//   Выходы светодиодов штатных DE0-Nano
//  led[7]  PIN_L3
//  led[6]  PIN_B1
//  led[5]  PIN_F3
//  led[4]  PIN_D1
//  led[3]  PIN_A11
//  led[2]  PIN_B13
//  led[1]  PIN_A13
//  led[0]  PIN_A15
//-----------------------------------------
//    Входы штатных кнопок DE0-Nano
//  key[0]  PIN_J15  // имеется внешний резистор подтяжки к плюсу питания   
//  key[1]  PIN_E1   // имеется внешний резистор подтяжки к плюсу питания
//-----------------------------------------
//    Входы штатных DIP-переключателей DE0-Nano 
//  dip[3]  PIN_M15  // имеется внешний резистор подтяжки к плюсу питания
//  dip[2]  PIN_B9   // имеется внешний резистор подтяжки к плюсу питания
//  dip[1]  PIN_T8   // имеется внешний резистор подтяжки к плюсу питания
//  dip[0]  PIN_M1   // имеется внешний резистор подтяжки к плюсу питания
//-----------------------------------------
//   Звуковой выход 
//  buzzer  PIN_T13
//-----------------------------------------
//  Интерфейс LCD1602 
//  LCD_N   PIN_R10 
//  LCD_P   PIN_P9
//  dat[7]  PIN_N12 
//  dat[6]  PIN_N11
//  dat[5]  PIN_N9
//  dat[4]  PIN_K16
//  dat[3]  PIN_L16
//  dat[2]  PIN_L15 
//  dat[1]  PIN_R16
//  dat[0]  PIN_P16
//  en      PIN_P15
//  rsn     PIN_R14
//  rw      PIN_N16 
//-----------------------------------------
// Интерфейс клавиатуры 4 x 4: 
// горизонтальные линии (выходы ПЛИС - входы клавиатуры)
// KO_OUT_PLIZ    PIN_D12  
// K1_OUT_PLIZ    PIN_A12
// K2_OUT_PLIZ    PIN_C11
// K3_OUT_PLIZ    PIN_E11 
//
// вертикальные линии (выходы клавиатуры - входы ПЛИС)
// на этих линиях должны быть  включены внутренние резисторы подтяжки к плюсу питания  
// K4_IN_PLIZ     PIN_B12 
// K5_IN_PLIZ     PIN_D11
// K6_IN_PLIZ     PIN_B11
// K7_IN_PLIZ     PIN_E10 
//---------------------------------------
// сигналы обмена с ИМС PCF8563   по  шине I2C
// PCF8563_SCL    PIN_J13             
// PCF8563_SDA    PIN_J14             	
//---------------------------------------
//---------------------------------------
// сигналы обмена по шине UART
// UART_tx_output    PIN_M10   //  передача            
// UART_tx_input     PIN_L13   //  прием  (здесь не используется)      	
//---------------------------------------
// тестовый выход 
// TEST_OUT   PIN_D3   (здесь не используется)           
//--------------------------------------- 
//--------------------------------------------------------------------------
module CLOCK_PCF8563_VERILOG (
                     input nrst, 
							input clk, 
		
					      //---------------------------
							// линии обмена с клавиатурой 4х4:
							// входы ПЛИС - выходы клавиатуры
							input K4_IN_PLIZ,
							input K5_IN_PLIZ,
							input K6_IN_PLIZ,
							input K7_IN_PLIZ,
							
						   // выходы ПЛИС - входы клавиатуры
						   output K0_OUT_PLIZ,
						   output K1_OUT_PLIZ,
						   output K2_OUT_PLIZ,
						   output K3_OUT_PLIZ,	
						
			            //---------------------------  
                     output PCF8563_SCL, // синхросигнал PCF8563
                     inout PCF8563_SDA,   // двунаправленная линия данных для чтения/записи PCF8563
			            //--------------------------- 
			            			
							output [7:0] dat, 
							output e, 
							output rs, 
							output rw, 
							output LCD_N, 
							output LCD_P, 
							
							output [7:0] led, 
							
							output buzzer,
							
							//----------------------------------
							output UART_tx_output, // линия передачи UART 
							input  UART_rx_input,  // линия приема через UART 
							//----------------------------------

							// временно созданные выходы для моделирования нажатия на клавишу GO	
				         //output AKTIV_KLAV_G,
				         //output imp_KLAV_G_OUT,	
	
	                  input  [3:0] dip  // линии задания скорости UART
						  );
//--------------------------------------------------------------------------

// Константные параметры  
parameter   GLOBAL_CLOCK  = 50_000_000;  // частота глобального синхросигнала, Гц

parameter  MODE_SHOW = 0; // начальный режим устройства - режим отображения
parameter  MODE_SET = 1; //  режим набора  

parameter  LOCK_OFF = 0; // начальное состояние блокировки клавиатуры 4 х 4 -  клавиатура не блокирована
parameter  LOCK_ON = 1; // клавиатура  блокирована 

parameter  DEL_2kHz = 25_000;  // делитель  для получения частоты 2 кГц из 50_000_000 Гц

parameter  ZIKL_PCF8563_read = 400; // цикл чтения данных из PCF8563 в мс

parameter  START_SIMV_TX = "$"; // стартовый символ  при  выдаче пакета данных через UART 

parameter  UART_TEMP = 4; // частота передачи пакетов через UART в Гц

parameter  PERIOD = GLOBAL_CLOCK / UART_TEMP;   // период передачи пакетов через UART

//версия проекта ПЛИС
parameter  ver_H = "4";
parameter  ver_L = "0";


// константы задания временных интервалов управления LCD    
parameter   VALUE_1 = 50_000; // рабочее значение 
parameter   VALUE_2 = 2 * VALUE_1; //
parameter   VALUE_3 = 3 * VALUE_1; //
parameter   VALUE_4 = 4 * VALUE_1; //
parameter   VALUE_5 = 5 * VALUE_1; //
parameter   VALUE_6 = 6 * VALUE_1; //
parameter   VALUE_7 = 7 * VALUE_1; //
parameter   VALUE_8 = 8 * VALUE_1; //
parameter   VALUE_9 = 9 * VALUE_1; //
parameter   VALUE_10 = 10 * VALUE_1; //
parameter   VALUE_11 = 11 * VALUE_1; // 
parameter   VALUE_12 = 12 * VALUE_1; //
parameter   VALUE_13 = 13 * VALUE_1; //
parameter   VALUE_14 = 14 * VALUE_1; //
parameter   VALUE_15 = 15 * VALUE_1; // 
parameter   VALUE_16 = 16 * VALUE_1; //
parameter   VALUE_17 = 17 * VALUE_1; // 
parameter   VALUE_18 = 18 * VALUE_1; //
parameter   VALUE_19 = 19 * VALUE_1; // 
parameter   VALUE_20 = 20 * VALUE_1; // 
parameter   VALUE_21 = 21 * VALUE_1; //
parameter   VALUE_22 = 22 * VALUE_1; // 
parameter   VALUE_23 = 23 * VALUE_1; // 
parameter   VALUE_24 = 24 * VALUE_1; // 
parameter   VALUE_25 = 25 * VALUE_1; // 
parameter   VALUE_26 = 26 * VALUE_1; // 
parameter   VALUE_27 = 27 * VALUE_1; // 
parameter   VALUE_28 = 28 * VALUE_1; //
parameter   VALUE_29 = 29 * VALUE_1; //
parameter   VALUE_30 = 30 * VALUE_1; //
parameter   VALUE_31 = 31 * VALUE_1; //
parameter   VALUE_32 = 32 * VALUE_1; //
parameter   VALUE_33 = 33 * VALUE_1; //
parameter   VALUE_34 = 34 * VALUE_1; //
parameter   VALUE_35 = 35 * VALUE_1; //
parameter   VALUE_36 = 36 * VALUE_1; //
parameter   VALUE_37 = 37 * VALUE_1; //
parameter   VALUE_38 = 38 * VALUE_1; //
parameter   VALUE_39 = 39 * VALUE_1; //
parameter   VALUE_40 = 40 * VALUE_1; //
parameter   VALUE_41 = 41 * VALUE_1; //
parameter   VALUE_42 = 42 * VALUE_1; //
parameter   VALUE_43 = 43 * VALUE_1; //
parameter   VALUE_44 = 44 * VALUE_1; //
parameter   VALUE_45 = 45 * VALUE_1; //
parameter   VALUE_46 = 46 * VALUE_1; //
parameter   VALUE_47 = 47 * VALUE_1; //
parameter   VALUE_48 = 48 * VALUE_1; //
parameter   VALUE_49 = 49 * VALUE_1; //
parameter   VALUE_50 = 50 * VALUE_1; //
parameter   VALUE_51 = 51 * VALUE_1; //
parameter   VALUE_52 = 52 * VALUE_1; //
parameter   VALUE_53 = 53 * VALUE_1; //
parameter   VALUE_54 = 54 * VALUE_1; //
parameter   VALUE_55 = 55 * VALUE_1; //
parameter   VALUE_56 = 56 * VALUE_1; //
parameter   VALUE_57 = 57 * VALUE_1; //
parameter   VALUE_58 = 58 * VALUE_1; //
parameter   VALUE_59 = 59 * VALUE_1; //
parameter   VALUE_60 = 60 * VALUE_1; //
parameter   VALUE_61 = 61 * VALUE_1; //
parameter   VALUE_62 = 62 * VALUE_1; //
parameter   VALUE_63 = 63 * VALUE_1; //
parameter   VALUE_64 = 64 * VALUE_1; //
parameter   VALUE_65 = 65 * VALUE_1; //
parameter   VALUE_66 = 66 * VALUE_1; //
parameter   VALUE_67 = 67 * VALUE_1; //
parameter   VALUE_68 = 68 * VALUE_1; //
parameter   VALUE_69 = 69 * VALUE_1; //
parameter   VALUE_70 = 70 * VALUE_1; //
parameter   VALUE_71 = 71 * VALUE_1; //
parameter   VALUE_72 = 72 * VALUE_1; //
parameter   VALUE_73 = 73 * VALUE_1; //
parameter   VALUE_74 = 74 * VALUE_1; //
parameter   VALUE_75 = 75 * VALUE_1; //
parameter   VALUE_76 = 76 * VALUE_1; //
parameter   VALUE_77 = 77 * VALUE_1; //
parameter   VALUE_78 = 78 * VALUE_1; //
parameter   VALUE_79 = 79 * VALUE_1; //
parameter   VALUE_80 = 80 * VALUE_1; //
parameter   VALUE_81 = 81 * VALUE_1; //
parameter   VALUE_82 = 82 * VALUE_1; //
parameter   VALUE_83 = 83 * VALUE_1; //
parameter   VALUE_84 = 84 * VALUE_1; //
parameter   VALUE_85 = 85 * VALUE_1; //
parameter   VALUE_86 = 86 * VALUE_1; //
parameter   VALUE_87 = 87 * VALUE_1; //
parameter   VALUE_88 = 88 * VALUE_1; //
parameter   VALUE_89 = 89 * VALUE_1; //
parameter   VALUE_90 = 90 * VALUE_1; //
parameter   VALUE_91 = 91 * VALUE_1; //
parameter   VALUE_92 = 92 * VALUE_1; //
parameter   VALUE_93 = 93 * VALUE_1; //
parameter   VALUE_94 = 94 * VALUE_1; //
parameter   VALUE_95 = 95 * VALUE_1; //
parameter   VALUE_96 = 96 * VALUE_1; //
parameter   VALUE_97 = 97 * VALUE_1; //
parameter   VALUE_98 = 98 * VALUE_1; //
parameter   VALUE_99 = 99 * VALUE_1; //
parameter   VALUE_100 = 100 * VALUE_1; //
parameter   VALUE_101 = 101 * VALUE_1; //
parameter   VALUE_102 = 102 * VALUE_1; //

parameter   VALUE_300 = 300 * VALUE_1; //  
parameter   VALUE_1000 = 1000 * VALUE_1; // 
 
// константы начальной инициализации LCD  
parameter  Init_LCD_2s_8bit_5x7 = 8'b0011_1100; 
parameter  Init_LCD_d_ON_k_OFF  = 8'b0000_1100;
parameter  Init_LCD_d_NS_k_S    = 8'b0000_0110;
parameter  Init_LCD_d_start     = 8'b0000_0001;
parameter  Init_LCD_1_start     = 8'b0000_0010;
parameter  Init_LCD_2_start     = 8'b1100_0000;

// Регистры светодиодов																	 
reg[7:0] led_reg = 8'b0000_0000;  // регистр светодиодов 

// Регистры режима 
reg  mode = MODE_SHOW;  //  регистр режима 
reg  lock = LOCK_OFF;  // регистр блокировки клавиатуры 
 
// Регистры генерации вспомогательных синхросигналов 
reg clk_1kHz = 0;  // синхросигнал 1 кГц 
reg[15:0] counter_2kHz = 0; //  счетчик  для генерации частоты 2 кГц

// Регистры LCD 
reg [25:0] counter_s = 0;  // счетчик для синхронизации   индикации на LCD
reg en = 0;   // управление стробом  данных-команд LCD  
reg Init_LCD_start = 0; // флаг разрешения начальной инициализации LCD  
reg Funk_LCD_start = 0; // флаг разрешения текущего функционирования LCD
reg [7:0]  data = 0; // переменная слова данных LCD 
reg rsn = 0; // переменная признака  данные-команды LCD  

// Регистры клавиатуры 4 х 4 
reg K0_OUT_PLIZ_reg = 1; 
reg K1_OUT_PLIZ_reg = 1;
reg K2_OUT_PLIZ_reg = 1;
reg K3_OUT_PLIZ_reg = 1;

// Уровни на время удержания клавиш  клавиатуры  4 х 4
reg AKTIV_KLAV_1_reg = 0; 
reg AKTIV_KLAV_2_reg = 0;
reg AKTIV_KLAV_3_reg = 0;
reg AKTIV_KLAV_S_reg = 0;
reg AKTIV_KLAV_4_reg = 0;
reg AKTIV_KLAV_5_reg = 0;
reg AKTIV_KLAV_6_reg = 0;
reg AKTIV_KLAV_G_reg = 0;
reg AKTIV_KLAV_7_reg = 0;
reg AKTIV_KLAV_8_reg = 0;
reg AKTIV_KLAV_9_reg = 0;
reg AKTIV_KLAV_L_reg = 0;
reg AKTIV_KLAV_E_reg = 0;
reg AKTIV_KLAV_0_reg = 0;
reg AKTIV_KLAV_e_reg = 0;
reg AKTIV_KLAV_P_reg = 0;

// Импульсы стробирования звука от клавиш  клавиатуры  4 х 4
wire AKTIV_KLAV_1_wire; 
wire AKTIV_KLAV_2_wire;
wire AKTIV_KLAV_3_wire;
wire AKTIV_KLAV_S_wire;
wire AKTIV_KLAV_4_wire;
wire AKTIV_KLAV_5_wire;
wire AKTIV_KLAV_6_wire;
wire AKTIV_KLAV_G_wire;
wire AKTIV_KLAV_7_wire;
wire AKTIV_KLAV_8_wire;
wire AKTIV_KLAV_9_wire;
wire AKTIV_KLAV_L_wire;
wire AKTIV_KLAV_E_wire;
wire AKTIV_KLAV_0_wire;
wire AKTIV_KLAV_e_wire;
wire AKTIV_KLAV_P_wire;

// Импульсы  по фронту нажатия  на клавиши  клавиатуры  4 х 4  
wire imp_KLAV_1;
wire imp_KLAV_2;
wire imp_KLAV_3;
wire imp_KLAV_S;
wire imp_KLAV_4;
wire imp_KLAV_5;
wire imp_KLAV_6;
wire imp_KLAV_G;
wire imp_KLAV_7;
wire imp_KLAV_8;
wire imp_KLAV_9;
wire imp_KLAV_L;
wire imp_KLAV_E;
wire imp_KLAV_0;
wire imp_KLAV_e;
wire imp_KLAV_P; 

reg [15:0] counter_klav = 0; // счетчик задания временной диаграммы опроса клавиатуры 4 х 4   

reg [7:0] num_set_klav = 0; // регистр номера текущего знакоместа при наборе на клавиатуре 4 х 4 

// Регистры взаимодействия клавиатуры и PCF8563  
reg  KLAV_data_ready = 0; // сигнал загрузки данных в PCF8563 
wire KLAV_data_ready_imp; // импульс по фронту чигнала загрузки данных в PCF8563

// Регистры набора времени и даты  на клавиатуре 4 х 4 
reg  [7:0] ed_sek_data_klav = 0; // единицы секунд
reg  [7:0] des_sek_data_klav = 0;  // десятки секунд
reg  [7:0] ed_min_data_klav = 0; // единицы минут
reg  [7:0] des_min_data_klav = 0;  // десятки минут
reg  [7:0] ed_chas_data_klav = 0; // единицы часов
reg  [7:0] des_chas_data_klav = 0;  // десятки часов
reg  [7:0] ed_chis_data_klav = 0; // единицы чисел
reg  [7:0] des_chis_data_klav = 0;  // десятки чисел
reg  [7:0] ed_mes_data_klav = 0; // единицы месяцев
reg  [7:0] des_mes_data_klav = 0;  // десятки месяцев
reg  [7:0] ed_god_data_klav = 0; // единицы лет
reg  [7:0] des_god_data_klav = 0;  // десятки лет

// Регистры индикации времени и даты, прочитанных из PCF8563   
reg  [7:0] ed_sek_data = 0; // единицы секунд
reg  [7:0] des_sek_data = 0;  // десятки секунд
reg  [7:0] ed_min_data = 0; // единицы минут
reg  [7:0] des_min_data = 0;  // десятки минут
reg  [7:0] ed_chas_data = 0; // единицы часов
reg  [7:0] des_chas_data = 0;  // десятки часов
reg  [7:0] ed_chis_data = 0; // единицы чисел
reg  [7:0] des_chis_data = 0;  // десятки чисел
reg  [7:0] ed_mes_data = 0; // единицы месяцев
reg  [7:0] des_mes_data = 0;  // десятки месяцев
reg  [7:0] ed_god_data = 0; // единицы лет
reg  [7:0] des_god_data = 0;  // десятки лет

// Регистры  записи PCF8563 
reg PCF8563_write_start = 0;  // старт записи PCF8563
reg PCF8563_load_start = 0;  // старт загрузки (внешней) PCF8563

reg [7:0] write_PCF8563_data_1 = 0;  //--------------------------- 
reg [7:0] write_PCF8563_data_2 = 0;  //    
reg [7:0] write_PCF8563_data_3 = 0;  //   регистры  записи 
reg [7:0] write_PCF8563_data_4 = 0;  //     
reg [7:0] write_PCF8563_data_5 = 0;  // 	
reg [7:0] write_PCF8563_data_6 = 0;  //       PCF8563 
reg [7:0] write_PCF8563_data_7 = 0;  //--------------------------- 

wire PCF8563_write_final_imp;  // импульс финала записи PCF8563

// Регистры и цепи чтения PCF8563
reg PCF8563_read_start = 0;  // старт чтения PCF8563 

wire [7:0] read_PCF8563_data_1;  //------------------------------- 
wire [7:0] read_PCF8563_data_2;  //
wire [7:0] read_PCF8563_data_3;  //         цепи чтения 
wire [7:0] read_PCF8563_data_4;  //  
wire [7:0] read_PCF8563_data_5;  //           PCF8563
wire [7:0] read_PCF8563_data_6;  //
wire [7:0] read_PCF8563_data_7;  //-------------------------------

wire PCF8563_read_final_imp;   // импульс финала чтения PCF8563

reg [7:0] PCF8563_data_1 = 0;  //------------------------------- 
reg [7:0] PCF8563_data_2 = 0;  //   регистры текущего хранения
reg [7:0] PCF8563_data_3 = 0;  //    
reg [7:0] PCF8563_data_4 = 0;  //      данных, прочитанных из
reg [7:0] PCF8563_data_5 = 0;  //      
reg [7:0] PCF8563_data_6 = 0;  //            PCF8563
reg [7:0] PCF8563_data_7 = 0;  //-------------------------------             

reg [31:0] counter_read_PCF8563 = 0; // счетчик, задающий периодичность чтения PCF8563


// Регистры обслуживания передачи данных через UART 
reg tx_UART_start = 0;  // сигнал старта передачи байта через UART

reg tx_UART_start_burst = 0;  // сигнал старта передачи посылки через UART 
wire tx_UART_start_burst_imp;  // имульс сигнала старта передачи посылки через UART 

reg [31:0] counter_data_tx_UART = 0; // счетчик интервалов передачи пакетов через UART 

reg [7:0] counter_byte_tx_UART = 0; // счетчик байтов, переданных через UART

reg tx_UART_burst_done = 0;  // сигнал длящейся передачи посылки через UART 

wire  UART_tx_final;  // признак завершения передачи байта через UART 
wire  UART_tx_done;   // признак длящейся передачи байта через UART

reg [7:0] tx_UART_data = 0; // регистр передаваемых через UART данных 

reg [7:0] tx_UART_data_0 = 0; // регистр 0 передаваемых через UART данных 
reg [7:0] tx_UART_data_1 = 0; // регистр 1 передаваемых через UART данных 
reg [7:0] tx_UART_data_2 = 0; // регистр 2 передаваемых через UART данных 
reg [7:0] tx_UART_data_3 = 0; // регистр 3 передаваемых через UART данных 
reg [7:0] tx_UART_data_4 = 0; // регистр 4 передаваемых через UART данных 
reg [7:0] tx_UART_data_5 = 0; // регистр 5 передаваемых через UART данных 
reg [7:0] tx_UART_data_6 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_7 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_8 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_9 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_10 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_11 = 0; // регистр 6 передаваемых через UART данных
reg [7:0] tx_UART_data_12 = 0; // регистр 6 передаваемых через UART данных


//---------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------
//     Исполняемый код 
//---------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------

//опрос  клавиатуры 4 х 4    
always @(posedge clk_1kHz or negedge nrst)          
begin 
 if (!nrst)   
     begin
	   counter_klav <= 0;
	   
	   K0_OUT_PLIZ_reg <= 1;
      K1_OUT_PLIZ_reg <= 1;
	   K2_OUT_PLIZ_reg <= 1;
	   K3_OUT_PLIZ_reg <= 1; 	   
     end
 else 
     begin
	   counter_klav <= counter_klav + 1;	
        case(counter_klav) 
         0: begin  
	       K0_OUT_PLIZ_reg <= 0;
		    K1_OUT_PLIZ_reg <= 1;
		    K2_OUT_PLIZ_reg <= 1;
		    K3_OUT_PLIZ_reg <= 1; 
	       end 
	    1: begin  
	         if (K7_IN_PLIZ == 0)      begin AKTIV_KLAV_1_reg <= 1; end  
		    else if (K6_IN_PLIZ == 0) begin AKTIV_KLAV_2_reg <= 1; end  
		    else if (K5_IN_PLIZ == 0) begin AKTIV_KLAV_3_reg <= 1; end 
		    else if (K4_IN_PLIZ == 0) begin AKTIV_KLAV_S_reg <= 1; end 
		    else  begin AKTIV_KLAV_1_reg <= 0;  AKTIV_KLAV_2_reg <= 0; 
		                AKTIV_KLAV_3_reg <= 0;  AKTIV_KLAV_S_reg <= 0;
				end
	       end
         2: begin  
	       K0_OUT_PLIZ_reg <= 1;
		    K1_OUT_PLIZ_reg <= 0;
		    K2_OUT_PLIZ_reg <= 1;
		    K3_OUT_PLIZ_reg <= 1; 
	       end 		  
	    3: begin  
	         if (K7_IN_PLIZ == 0)      begin AKTIV_KLAV_4_reg <= 1; end 
		    else if (K6_IN_PLIZ == 0) begin AKTIV_KLAV_5_reg <= 1; end  
		    else if (K5_IN_PLIZ == 0) begin AKTIV_KLAV_6_reg <= 1; end 
		    else if (K4_IN_PLIZ == 0) begin AKTIV_KLAV_G_reg <= 1; end 
		    else begin  AKTIV_KLAV_4_reg <= 0; AKTIV_KLAV_5_reg <= 0; 
		                AKTIV_KLAV_6_reg <= 0; AKTIV_KLAV_G_reg <= 0;
		         end
	       end				
         4: begin  
	       K0_OUT_PLIZ_reg <= 1;
		    K1_OUT_PLIZ_reg <= 1;
		    K2_OUT_PLIZ_reg <= 0;
		    K3_OUT_PLIZ_reg <= 1; 
	       end 					
	    5: begin  
	         if (K7_IN_PLIZ == 0)      begin AKTIV_KLAV_7_reg <= 1; end
		    else if (K6_IN_PLIZ == 0) begin AKTIV_KLAV_8_reg <= 1; end
		    else if (K5_IN_PLIZ == 0) begin AKTIV_KLAV_9_reg <= 1; end
		    else if (K4_IN_PLIZ == 0) begin AKTIV_KLAV_L_reg <= 1; end 
		    else begin  AKTIV_KLAV_7_reg <= 0; AKTIV_KLAV_8_reg <= 0; 
		                AKTIV_KLAV_9_reg <= 0; AKTIV_KLAV_L_reg <= 0;
		         end		    
	       end				
         6: begin  
	       K0_OUT_PLIZ_reg <= 1;
		    K1_OUT_PLIZ_reg <= 1;
		    K2_OUT_PLIZ_reg <= 1;
		    K3_OUT_PLIZ_reg <= 0; 
	       end 			  
	    7: begin  
	         if (K7_IN_PLIZ == 0)      begin AKTIV_KLAV_E_reg <= 1; end
		    else if (K6_IN_PLIZ == 0) begin AKTIV_KLAV_0_reg <= 1; end
		    else if (K5_IN_PLIZ == 0) begin AKTIV_KLAV_e_reg <= 1; end
		    else if (K4_IN_PLIZ == 0) begin AKTIV_KLAV_P_reg <= 1; end
		    else begin  AKTIV_KLAV_E_reg <= 0; AKTIV_KLAV_0_reg <= 0; 
		                AKTIV_KLAV_e_reg <= 0; AKTIV_KLAV_P_reg <= 0;
		         end		    
		    end			  
         8: begin
	       K0_OUT_PLIZ_reg <= 0;
		    K1_OUT_PLIZ_reg <= 1;
		    K2_OUT_PLIZ_reg <= 1;
		    K3_OUT_PLIZ_reg <= 1;
	    
	         counter_klav <= 0; 
		  end    
       endcase
     end
end 	 
 

 
// Формирование сигналов клавиатуры 4 х 4  
//------------------------------------------------------------ 
assign K0_OUT_PLIZ = K0_OUT_PLIZ_reg;
assign K1_OUT_PLIZ = K1_OUT_PLIZ_reg;
assign K2_OUT_PLIZ = K2_OUT_PLIZ_reg;
assign K3_OUT_PLIZ = K3_OUT_PLIZ_reg;
//------------------------------------------------------------




// формирование сигналов на временно созданных выходах для моделирования нажатия на клавишу GO
//assign  AKTIV_KLAV_G = AKTIV_KLAV_G_reg;
//assign  imp_KLAV_G_OUT = imp_KLAV_G;



//набор  времени и даты  на клавиатуре 4 х 4     
always @(posedge clk_1kHz or negedge nrst)          
begin 
  if (!nrst)   // случайный момент прихода сигнала сброса 
     begin
	    num_set_klav <= 0;  
     end 
  else if ((mode == MODE_SET) & (lock == LOCK_OFF)) // набор  возможен только в режиме набора 
      	                             // и при отключенной блокировке клавиатуры    
   case (num_set_klav)
    0: begin  
         if (imp_KLAV_0)      begin  des_chis_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_chis_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_chis_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_chis_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_chis_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_chis_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_chis_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_chis_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_chis_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_chis_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end	
       end  
    1: begin  
         if (imp_KLAV_0)      begin  ed_chis_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_chis_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_chis_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_chis_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_chis_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_chis_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_chis_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_chis_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_chis_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_chis_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end	
	    else if (imp_KLAV_e) begin  num_set_klav <= 0; end    
       end     
    2: begin  
         if (imp_KLAV_0)      begin  des_mes_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_mes_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_mes_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_mes_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_mes_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_mes_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_mes_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_mes_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_mes_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_mes_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end        
    3: begin  
         if (imp_KLAV_0)      begin  ed_mes_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_mes_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_mes_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_mes_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_mes_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_mes_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_mes_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_mes_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_mes_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_mes_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end
    4: begin  
         if (imp_KLAV_0)      begin  des_god_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_god_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_god_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_god_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_god_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_god_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_god_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_god_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_god_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_god_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end       
    5: begin  
         if (imp_KLAV_0)      begin  ed_god_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_god_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_god_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_god_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_god_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_god_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_god_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_god_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_god_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_god_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 	  
    6: begin  
         if (imp_KLAV_0)      begin  des_chas_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_chas_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_chas_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_chas_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_chas_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_chas_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_chas_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_chas_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_chas_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_chas_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 	 	  
    7: begin  
         if (imp_KLAV_0)      begin  ed_chas_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_chas_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_chas_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_chas_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_chas_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_chas_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_chas_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_chas_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_chas_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_chas_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 	  
    8: begin  
         if (imp_KLAV_0)      begin  des_min_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_min_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_min_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_min_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_min_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_min_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_min_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_min_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_min_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_min_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 	      
    9: begin  
         if (imp_KLAV_0)      begin  ed_min_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_min_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_min_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_min_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_min_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_min_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_min_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_min_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_min_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_min_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 	  
   10: begin  
         if (imp_KLAV_0)      begin  des_sek_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  des_sek_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  des_sek_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  des_sek_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  des_sek_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  des_sek_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  des_sek_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  des_sek_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  des_sek_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  des_sek_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end	    
       end 		  
   11: begin  
         if (imp_KLAV_0)      begin  ed_sek_data_klav <= 0; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_1) begin  ed_sek_data_klav <= 1; num_set_klav <= num_set_klav + 1;  end 
	    else if (imp_KLAV_2) begin  ed_sek_data_klav <= 2; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_3) begin  ed_sek_data_klav <= 3; num_set_klav <= num_set_klav + 1;  end	    
	    else if (imp_KLAV_4) begin  ed_sek_data_klav <= 4; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_5) begin  ed_sek_data_klav <= 5; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_6) begin  ed_sek_data_klav <= 6; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_7) begin  ed_sek_data_klav <= 7; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_8) begin  ed_sek_data_klav <= 8; num_set_klav <= num_set_klav + 1;  end
	    else if (imp_KLAV_9) begin  ed_sek_data_klav <= 9; num_set_klav <= num_set_klav + 1;  end
         else if (imp_KLAV_e) begin  num_set_klav <= 0; end 	    
       end 		  
   12: begin 
         num_set_klav <= 0; 
       end 
   endcase
end 	



//обработка управляющих сигналов от клавиатуры 4 х 4     
always @(posedge clk_1kHz or negedge nrst)          
begin 
 if (!nrst)
     begin 
	   mode <= MODE_SHOW; // перевод устройства в исходный режим  - режим отображения 
	   lock <= LOCK_OFF; // перевод блокировки клавиатуры в исходный режим - блокировка не установлена  
	   led_reg[0] <= 0;  // светодиодная  индикация исходного режима устройства - режима отображения - светодиод погашен 
	   led_reg[1] <= 0;  // светодиодная  индикация исходного режима блокировки - не установленной блокировки - светодиод погашен
		KLAV_data_ready <= 0; // не загружать набранные на клавиатуре 4 х 4  данные в PCF8563
	  end 
	  
 else if ((imp_KLAV_G) & (lock == LOCK_OFF))  // задание режима устройства, если снята блокировка клавиатуры    
     begin  
        mode <= ~mode; 
		  led_reg[0] <= ~led_reg[0];  // светодиодная индикация режима устройства
     end
	  
 else if (imp_KLAV_L)  // установка-снятие блокировки клавиатуры 4 x 4 
     begin 
	  lock <= ~lock; 
	  led_reg[1] <= ~led_reg[1];  // светодиодная  индикация режима блокировки 
	end 

 else if ((imp_KLAV_E) & (lock == LOCK_OFF) & (mode == MODE_SET)) // загрузка набранных на клавиатуре 4 х 4  данных в PCF8563,
                      // если снята блокировка клавиатуры и если задан соответствующий режим набора  
     begin
       KLAV_data_ready <= 1; // загрузить набранные на клавиатуре 4 х 4  данные в PCF8563
		 mode <= MODE_SHOW;  // задать режим  отображения
	    led_reg[0] <= 0;  // светодиодная  индикация исходного режима устройства - режима отображения - светодиод погашен
     end
 else
 
     begin 
       KLAV_data_ready <= 0; // не загружать набранные на клавиатуре 4 х 4  данные в PCF8563
	  end 	 
end 	
		   


// Периодическое  чтение времени и даты из PCF8563
// При нажатии на клавишу ENT в случайный момент запись в PCF8563  начальных значений и включение его генератора
// Запись в PCF8563 никак не помешает чтению из нее, поскольку они разнесены по времени 		
always @(posedge clk_1kHz)          
begin 
 if (!nrst)   // реакция на сброс
     begin
       counter_read_PCF8563 <= 0; // обнулить счетчик задания периодичности чтения DS1302
	    PCF8563_write_start <= 0; //  не производить  запись в PCF8563
	    PCF8563_load_start <= 0; //  снять сигнал начала загрузки PCF8563	
     end
	  
  else if (KLAV_data_ready_imp)  // случайный момент прихода сигнала загрузки	 
	 begin
	  //-----------------------------------------------------------------------------------------------------------------
               	 //   В  набранных с клавиатуры 4 х 4 данных:
		           // des_chis_data_klav - десятки числа месяца ("0" - "3")
		           // ed_chis_data_klav - единицы числа месяца ("0" - "9")
		           // des_mes_data_klav - десятки месяцев ("0" - "1")	
		           // ed_mes_data_klav - единицы месяцев  ("0" - "9")	
		           // des_god_data_klav - десятки лет ("0" - "9")	
		           // ed_god_data_klav - единицы лет ("0" - "9") 				 
		           // des_chas_data_klav - десятки часов (24-часовой формат) ("0" - "2")
		           // ed_chas_data_klav - единицы часов (24-часовой формат) ("0" - "9")
		           // des_min_data_klav - десятки минут ("0" - "5")
		           // ed_min_data_klav - единицы минут ("0" - "9")
		           // des_sek_data_klav - десятки секунд ("0" - "5")
		           // ed_sek_data_klav - единицы секунд ("0" - "9")
                     // Номер дня недели в этих данных не содержится  	
	                // За корректность принятых данных несет ответственность клавиатура, при записи их корректность не проверяется  			 
	
                     // секунды для PCF8563				
             write_PCF8563_data_1[3:0] <= ed_sek_data_klav;
				 write_PCF8563_data_1[6:4] <= des_sek_data_klav; 
				 write_PCF8563_data_1[7] <= 1'b0;  // бит 7 - "0"          
				 
				 // минуты для PCF8563 
             write_PCF8563_data_2[3:0] <= ed_min_data_klav;
				 write_PCF8563_data_2[6:4] <= des_min_data_klav;     
             write_PCF8563_data_2[7] <= 1'b0;  // бит 7 - "0"         				 
											 
				 // часы для PCF8563
             write_PCF8563_data_3[3:0] <= ed_chas_data_klav;
				 write_PCF8563_data_3[5:4] <= des_chas_data_klav;  				 
			    write_PCF8563_data_3[7:6] <= 2'b00;  // биты 7,6 - "0" 	 
                     							
				 // числа месяца для PCF8563
             write_PCF8563_data_4[3:0] <= ed_chis_data_klav;
				 write_PCF8563_data_4[5:4] <= des_chis_data_klav; 				   
				 write_PCF8563_data_4[7:6] <= 2'b00;  // биты 7,6 - "0" 	 
							
				 // день недели для PCF8563  -  всегда такое значение  
             write_PCF8563_data_5 <= 8'b0000_0001;    				
				 
				 // месяц для PCF8563 
             write_PCF8563_data_6[3:0] <= ed_mes_data_klav;
				 write_PCF8563_data_6[4]   <= des_mes_data_klav;                      
				 write_PCF8563_data_6[7:5] <= 3'b000;  // биты 7,6,5 - "0" 	 
				                      											 
				 // год для PCF8563 
             write_PCF8563_data_7[3:0] <= ed_god_data_klav;
				 write_PCF8563_data_7[7:4] <= des_god_data_klav; 				  
				 				 				 
				 PCF8563_load_start <= 1; // начать загрузку PCF8563		
	  //-----------------------------------------------------------------------------------------------------------------	 
	 end 	 

  else 
      begin  // периодическое чтение даты и времени из PCF8563
	    counter_read_PCF8563 <= counter_read_PCF8563 + 1; 
	    
	    case (counter_read_PCF8563)
            //---------------------------------------------------------------------------------------------------------------	    
		 1: begin  
	            PCF8563_read_start <= 1; // начать чтение из PCF8563
		     end 	  
		 2: begin 	
			  PCF8563_read_start <= 0;   // не начинать  чтение из PCF8563
		    end 	  
	    10: begin   // предполагаем, что чтение завершено 
	            PCF8563_data_1 <= read_PCF8563_data_1; // сохранить результат чтения
	            PCF8563_data_2 <= read_PCF8563_data_2; // сохранить результат чтения
	            PCF8563_data_3 <= read_PCF8563_data_3; // сохранить результат чтения
	            PCF8563_data_4 <= read_PCF8563_data_4; // сохранить результат чтения
	            PCF8563_data_5 <= read_PCF8563_data_5; // сохранить результат чтения
	            PCF8563_data_6 <= read_PCF8563_data_6; // сохранить результат чтения
	            PCF8563_data_7 <= read_PCF8563_data_7; // сохранить результат чтения			  
	       end  
             //--------------------------------------------------------------------------------------------------------------- 
		// блок осуществления загрузки, если загрузка требуется  
	   30: begin    
	         if (PCF8563_load_start)  // проверяем, не требуется ли произвести загрузку
			      begin  
				      PCF8563_write_start <= 1; // начать запись в PCF8563
			         PCF8563_load_start <= 0; //  снять сигнал начала загрузки PCF8563
               end  
	         end
      31: begin 
                 PCF8563_write_start <= 0; //  не производить  запись в PCF8563
          end 
           //---------------------------------------------------------------------------------------------------------------

           // окончание цикла чтения 		 
	  ZIKL_PCF8563_read: begin   
	                      counter_read_PCF8563 <= 0; // обнулить счетчик задания периодичности чтения DS1302 
	                    end  
	  endcase   		
	 end
end 	  



//периодическое  обновление показаний ЖКИ информацией,  прочитанной из PCF8563 
always @(posedge clk_1kHz)
begin
 ed_sek_data <= PCF8563_data_1[3:0];
 des_sek_data <= PCF8563_data_1[6:4];
 
 ed_min_data <= PCF8563_data_2[3:0];
 des_min_data <= PCF8563_data_2[6:4]; 
 
 ed_chas_data <= PCF8563_data_3[3:0];
 des_chas_data <= PCF8563_data_3[5:4];  
 
 ed_chis_data <= PCF8563_data_4[3:0];
 des_chis_data <= PCF8563_data_4[5:4];
 
 ed_mes_data <= PCF8563_data_6[3:0];
 des_mes_data <= PCF8563_data_6[4];
 
 ed_god_data <= PCF8563_data_7[3:0];
 des_god_data <= PCF8563_data_7[7:4];
end 



// периодическая передача данных через UART 
always @(posedge clk)
begin
     if (!nrst)  // реакция на сброс 
	   begin 
		  counter_data_tx_UART <= 0; // сбросить счетчик интервалов передачи пакетов через UART
		  tx_UART_start_burst <= 0; // не начинать передачу блока данных через UART
	   end
	   
     else 
	   begin  
         counter_data_tx_UART <=  counter_data_tx_UART + 1;  
	    case (counter_data_tx_UART)
	     1: begin 
             //--------------------------------------------------------------------------------- 		   
               tx_UART_data_0 <= START_SIMV_TX; // стартовый символ  для  передачи пакета

               // подготовка данных для передачи в виде ASCII-символов   					
               tx_UART_data_1 <= des_chis_data + 48; // дес чисел  
		         tx_UART_data_2 <= ed_chis_data + 48; // ед чисел 
               tx_UART_data_3 <= des_mes_data + 48; // дес мес 		
	            tx_UART_data_4 <= ed_mes_data + 48; // ед мес 
	            tx_UART_data_5 <= des_god_data + 48; // дес лет  
	            tx_UART_data_6 <= ed_god_data + 48; // ед лет  
		   
	            tx_UART_data_7 <= des_chas_data + 48; // дес час  
	            tx_UART_data_8 <= ed_chas_data + 48; // ед час  
	            tx_UART_data_9 <= des_min_data + 48; // дес мин  
	            tx_UART_data_10 <= ed_min_data + 48; // ед мин  
	            tx_UART_data_11 <= des_sek_data + 48; // дес сек  
	            tx_UART_data_12 <= ed_sek_data + 48; // ед сек  					
					
	            tx_UART_start_burst <= 1; // начать непосредственно передачу блока данных через UART  
             //--------------------------------------------------------------------------------- 	
             end 
 	   10: begin 
		        tx_UART_start_burst <= 0; // не начинать передачу блока данных через UART  
		     end 
	 	   
     PERIOD: begin   // задание периода передачи пакетов через UART 
		         counter_data_tx_UART <= 0; // сбросить счетчик интервалов передачи пакетов через UART 
		       end 
	   endcase  	   
	 end   
end


  
// непосредственная передача многобайтовой посылки (блока)  данных через UART
always @(posedge  clk)  
begin 
   if (tx_UART_start_burst_imp)  // если обнаружен импульс старта  передачи посылки через UART
      begin
	    tx_UART_burst_done <= 1;  // установить сигнал длящейся передачи посылки через UART  
	    counter_byte_tx_UART <= 0; // обнулить счетчик переданных байтов  
	   end  
   else if (UART_tx_final) // если обнаружено окончание передачи очередного байта
      begin       
	    tx_UART_start <= 0;  // сбросить сигнал  начала передачи байта через UART  
      end 	 

   else if (tx_UART_burst_done & (~tx_UART_start))    // если установлен сигнал длящейся передачи посылки через UART 
      begin                                           // и сброшен сигнал начала передачи байта через UART 
	      case(counter_byte_tx_UART)  // последовательно передавать байты
 	          0:  begin tx_UART_data <= tx_UART_data_0; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end   
 	          1:  begin tx_UART_data <= tx_UART_data_1; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end	   
 	          2:  begin tx_UART_data <= tx_UART_data_2; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
 	          3:  begin tx_UART_data <= tx_UART_data_3; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end			
 	          4:  begin tx_UART_data <= tx_UART_data_4; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end			
 	          5:  begin tx_UART_data <= tx_UART_data_5; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				 6:  begin tx_UART_data <= tx_UART_data_6; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				 7:  begin tx_UART_data <= tx_UART_data_7; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				 8:  begin tx_UART_data <= tx_UART_data_8; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				 9:  begin tx_UART_data <= tx_UART_data_9; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				10:  begin tx_UART_data <= tx_UART_data_10; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				11:  begin tx_UART_data <= tx_UART_data_11; tx_UART_start <= 1; counter_byte_tx_UART <= counter_byte_tx_UART + 1; end
				12:  begin tx_UART_data <= tx_UART_data_12; tx_UART_start <= 1; 				 
				 //  передан последний байт		
		             tx_UART_burst_done <= 0; // сбросить сигнал длящейся передачи посылки через UART 
				       counter_byte_tx_UART <= 0; // обнулить счетчик переданных байтов
			        end		    
	      endcase 
     end 
end 

		

// получение  синхросигнала 1 кГц  из частоты 50_000_000 Гц
// для формирования звуковых пачек 
always @(posedge clk)
begin
   //------------------------------------
	if (counter_2kHz == DEL_2kHz)
	  begin
	     counter_2kHz <= 0;
        clk_1kHz <= ~clk_1kHz; // заполнение для формирования звуковых пачек 
	  end
   else
     begin
        counter_2kHz <= counter_2kHz + 1;  	 
	  end
	//------------------------------------- 	 
end 



/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//   Контроллер ЖКИ 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

// начальная  инициализация и  циклический вывод  данных на LCD
always @(posedge clk)      
begin 
   if (!nrst)   
       begin 	  	 
	     Init_LCD_start <= 1;  // разрешить начальную  инициализацию LCD 
		  Funk_LCD_start <= 0;  // запретить текущее функционирование LCD 
		  counter_s <= 0;     
  	     //  все светодиоды погасить 
        // led_reg[0] <= 0;		  
        // led_reg[1] <= 0;
        // led_reg[2] <= 0;
	     led_reg[3] <= 0;
	     led_reg[4] <= 0;
	     led_reg[5] <= 0;
	     led_reg[6] <= 0;
	     led_reg[7] <= 0;		  
       end
 
   else  if (Init_LCD_start == 1) // если  начальная инициализация LCD разрешена
     begin    
      counter_s <= counter_s + 1;
      //  начальная инициализация LCD 
      case(counter_s) 
        VALUE_1:  begin rsn <= 0; data <= Init_LCD_2s_8bit_5x7;  end  
        VALUE_2:  begin en <= 1;  end  // начало импульса en  
        VALUE_3:  begin en <= 0;  end  // конец импульса en

        VALUE_4:  begin rsn <= 0; data <= Init_LCD_d_ON_k_OFF;  end  
        VALUE_5:  begin en <= 1;  end  // начало импульса en
        VALUE_6:  begin en <= 0;  end  // конец импульса en 
 
        VALUE_7:  begin rsn <= 0; data <= Init_LCD_d_NS_k_S;  end  
        VALUE_8:  begin en <= 1;  end  // начало импульса en
        VALUE_9:  begin en <= 0;  end	// конец импульса en  
	  
        VALUE_10:  begin rsn <= 0; data <= Init_LCD_d_start;  end
        VALUE_11:  begin en <= 1;  end  // начало импульса en
        VALUE_12:  begin en <= 0;  end	  

		  // вывод начальной заставки  на LCD  
        VALUE_13:  begin rsn <= 1; data <= "V";   end  
        VALUE_14:  begin en <= 1;  end  // начало импульса en
        VALUE_15:  begin en <= 0;  end	 // конец импульса en 	  

        VALUE_16:  begin rsn <= 1; data <= "E";   end  
        VALUE_17:  begin en <= 1;  end  // начало импульса en
        VALUE_18:  begin en <= 0;  end	 // конец импульса en	  
	  
        VALUE_19:  begin rsn <= 1; data <= "R";   end  
        VALUE_20:  begin en <= 1;  end  // начало импульса en
        VALUE_21:  begin en <= 0;  end	 // конец импульса en
		  
        VALUE_22:  begin rsn <= 1; data <= "I";   end  
        VALUE_23:  begin en <= 1;  end  // начало импульса en
        VALUE_24:  begin en <= 0;  end	 // конец импульса en
			 
        VALUE_25:  begin rsn <= 1; data <= "L";   end  
        VALUE_26:  begin en <= 1;  end  // начало импульса en
        VALUE_27:  begin en <= 0;  end	 // конец импульса en
		  
        VALUE_28:  begin rsn <= 1; data <= "O";   end  
        VALUE_29:  begin en <= 1;  end  // начало импульса en
        VALUE_30:  begin en <= 0;  end	 // конец импульса en	
	
        VALUE_31:  begin rsn <= 1; data <= "G";   end  
        VALUE_32:  begin en <= 1;  end  // начало импульса en
        VALUE_33:  begin en <= 0;  end	 // конец импульса en	
		 
        VALUE_34:  begin rsn <= 1; data <= " ";   end  
        VALUE_35:  begin en <= 1;  end  // начало импульса en
        VALUE_36:  begin en <= 0;  end	 // конец импульса en	
	
        VALUE_37:  begin rsn <= 1; data <= "v";   end  
        VALUE_38:  begin en <= 1;  end  // начало импульса en
        VALUE_39:  begin en <= 0;  end	 // конец импульса en	
		  
        VALUE_40:  begin rsn <= 1; data <= ver_H;   end  
        VALUE_41:  begin en <= 1;  end  // начало импульса en
        VALUE_42:  begin en <= 0;  end	 // конец импульса en			  

        VALUE_43:  begin rsn <= 1; data <= ".";   end  
        VALUE_44:  begin en <= 1;  end  // начало импульса en
        VALUE_45:  begin en <= 0;  end	 // конец импульса en			  
						 
        VALUE_46:  begin rsn <= 1; data <= ver_L;   end  
        VALUE_47:  begin en <= 1;  end  // начало импульса en
        VALUE_48:  begin en <= 0;  end	 // конец импульса en								 
									 
        VALUE_1000:
          begin 
		 	  counter_s <= 0; 
			  Init_LCD_start <= 0;  // запретить начальную  инициализацию LCD
			  Funk_LCD_start <= 1;  // разрешить текущее функционирование LCD  
	       end 	  
       endcase
	    //--------------------------------------------
  end

  else if (Funk_LCD_start == 1) // если текущее функционирование LCD разрешено
     begin    
       counter_s <= counter_s + 1;
       //   текущее функционирование LCD - вывод  данных на индикацию 
       case(counter_s) 
		 // задание начального  положения курсора - начало первой строки 
       VALUE_1:  begin rsn <= 0; data <= Init_LCD_1_start;  end  
       VALUE_2:  begin en <= 1;  end  // начало импульса en
       VALUE_3:  begin en <= 0;  end	  
	  
       VALUE_4:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_chis_data + 48;
	                            else data <= des_chis_data_klav + 48;  
	            end 
       VALUE_5:  begin en <= 1;  end  // начало импульса en
       VALUE_6:  begin en <= 0;  end	 // конец импульса en 

       VALUE_7:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_chis_data + 48;   
	                            else data <= ed_chis_data_klav + 48;
			  end  
       VALUE_8:  begin en <= 1;  end  // начало импульса en
       VALUE_9:  begin en <= 0;  end	 // конец импульса en 		 
	  	  
       VALUE_10:  begin rsn <= 1; data <= "."; end  				 
       VALUE_11:  begin en <= 1;  end  // начало импульса en
       VALUE_12:  begin en <= 0;  end	 // конец импульса en 	  

       VALUE_13:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_mes_data + 48; 
	                             else data <= des_mes_data_klav + 48;  
			   end  			 
       VALUE_14:  begin en <= 1;  end  // начало импульса en
       VALUE_15:  begin en <= 0;  end	 // конец импульса en	  
	  
       VALUE_16:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_mes_data + 48; 
	                             else data <= ed_mes_data_klav + 48; 
			   end  			
       VALUE_17:  begin en <= 1;  end  // начало импульса en
       VALUE_18:  begin en <= 0;  end	 // конец импульса en	
		 
       VALUE_19:  begin rsn <= 1; data <= "."; end  		 
       VALUE_20:  begin en <= 1;  end  // начало импульса en
       VALUE_21:  begin en <= 0;  end	 // конец импульса en	
		 
       VALUE_22:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_god_data + 48; 
	                             else data <= des_god_data_klav + 48;
			   end  		 
       VALUE_23:  begin en <= 1;  end  // начало импульса en
       VALUE_24:  begin en <= 0;  end	 // конец импульса en	

       VALUE_25:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_god_data + 48; 
	                             else data <= ed_god_data_klav + 48;
			   end  
       VALUE_26:  begin en <= 1;  end  // начало импульса en
       VALUE_27:  begin en <= 0;  end	 // конец импульса en

       VALUE_28:  begin rsn <= 1; data <= "-"; end 
		 VALUE_29:  begin en <= 1;  end  // начало импульса en
       VALUE_30:  begin en <= 0;  end	 // конец импульса en		 
			
       VALUE_31:  begin rsn <= 1; data <= "-"; end 						
       VALUE_32:  begin en <= 1;  end  // начало импульса en
       VALUE_33:  begin en <= 0;  end	 // конец импульса en	

       VALUE_34:  begin rsn <= 1; data <= "D"; end 								
       VALUE_35:  begin en <= 1;  end  // начало импульса en
       VALUE_36:  begin en <= 0;  end	 // конец импульса en	

       VALUE_37:  begin rsn <= 1; data <= "A"; end  
       VALUE_38:  begin en <= 1;  end  // начало импульса en
       VALUE_39:  begin en <= 0;  end	 // конец импульса en	

       VALUE_40:  begin rsn <= 1; data <= "T"; end 						 
       VALUE_41:  begin en <= 1;  end  // начало импульса en
       VALUE_42:  begin en <= 0;  end	 // конец импульса en	

       VALUE_43:  begin rsn <= 1; data <= "E"; end 			 
       VALUE_44:  begin en <= 1;  end  // начало импульса en
       VALUE_45:  begin en <= 0;  end	 // конец импульса en		
				
       VALUE_46:  begin rsn <= 1; data <= "-"; end 						 
       VALUE_47:  begin en <= 1;  end  // начало импульса en
       VALUE_48:  begin en <= 0;  end	 // конец импульса en	

       VALUE_49:  begin rsn <= 1; if (mode  == MODE_SHOW) data <= "R";
	                             else data <= "S";  
	             end
       VALUE_50:  begin en <= 1;  end  // начало импульса en
       VALUE_51:  begin en <= 0;  end	 // конец импульса en						
						
		 // задание начального  положения курсора - начало второй строки 
       VALUE_52:  begin rsn <= 0; data <= Init_LCD_2_start;  end  
       VALUE_53:  begin en <= 1;  end  // начало импульса en
       VALUE_54:  begin en <= 0;  end	
		 
       VALUE_55:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_chas_data + 48;   
	                             else data <= des_chas_data_klav + 48; 
			   end  
       VALUE_56:  begin en <= 1;  end  // начало импульса en
       VALUE_57:  begin en <= 0;  end	 // конец импульса en 		 
		 
       VALUE_58:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_chas_data + 48;   
	                             else data <= ed_chas_data_klav + 48;
			   end  
       VALUE_59:  begin en <= 1;  end  // начало импульса en
       VALUE_60:  begin en <= 0;  end	 // конец импульса en 		 
	  	  
       VALUE_61:  begin rsn <= 1; data <= ":"; end  				 
       VALUE_62:  begin en <= 1;  end  // начало импульса en
       VALUE_63:  begin en <= 0;  end	 // конец импульса en 	  

       VALUE_64:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_min_data + 48; 
	                             else data <= des_min_data_klav + 48;
			   end  			 
       VALUE_65:  begin en <= 1;  end  // начало импульса en
       VALUE_66:  begin en <= 0;  end	 // конец импульса en	  
	  
       VALUE_67:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_min_data + 48; 
	                             else data <= ed_min_data_klav + 48;
			   end  			
       VALUE_68:  begin en <= 1;  end  // начало импульса en
       VALUE_69:  begin en <= 0;  end	 // конец импульса en	
		 
       VALUE_70:  begin rsn <= 1; data <= ":"; end  		 
       VALUE_71:  begin en <= 1;  end  // начало импульса en
       VALUE_72:  begin en <= 0;  end	 // конец импульса en	
		 
       VALUE_73:  begin rsn <= 1; if (mode == MODE_SHOW) data <= des_sek_data + 48; 
	                             else data <= des_sek_data_klav + 48;  
			   end  		 
       VALUE_74:  begin en <= 1;  end  // начало импульса en
       VALUE_75:  begin en <= 0;  end	 // конец импульса en	

       VALUE_76:  begin rsn <= 1; if (mode == MODE_SHOW) data <= ed_sek_data + 48; 
	                             else data <= ed_sek_data_klav + 48; 
	             end  
       VALUE_77:  begin en <= 1;  end  // начало импульса en
       VALUE_78:  begin en <= 0;  end	 // конец импульса en

       VALUE_79:  begin rsn <= 1; data <= "-"; end 
		 VALUE_80:  begin en <= 1;  end  // начало импульса en
       VALUE_81:  begin en <= 0;  end	 // конец импульса en		 
			
       VALUE_82:  begin rsn <= 1; data <= "-"; end 						
       VALUE_83:  begin en <= 1;  end  // начало импульса en
       VALUE_84:  begin en <= 0;  end	 // конец импульса en	

       VALUE_85:  begin rsn <= 1; data <= "T"; end 								
       VALUE_86:  begin en <= 1;  end  // начало импульса en
       VALUE_87:  begin en <= 0;  end	 // конец импульса en	

       VALUE_88:  begin rsn <= 1; data <= "I"; end  
       VALUE_89:  begin en <= 1;  end  // начало импульса en
       VALUE_90:  begin en <= 0;  end	 // конец импульса en	

       VALUE_91:  begin rsn <= 1; data <= "M"; end 						 
       VALUE_92:  begin en <= 1;  end  // начало импульса en
       VALUE_93:  begin en <= 0;  end	 // конец импульса en	

       VALUE_94:  begin rsn <= 1; data <= "E"; end 			 
       VALUE_95:  begin en <= 1;  end  // начало импульса en
       VALUE_96:  begin en <= 0;  end	 // конец импульса en	
	  
       VALUE_97:  begin rsn <= 1; data <= "-"; end 			 
       VALUE_98:  begin en <= 1;  end  // начало импульса en
       VALUE_99:  begin en <= 0;  end	 // конец импульса en	  
 
       VALUE_100:  begin rsn <= 1; if (lock == LOCK_ON) data <= "L";
	                              else data <= " ";  
	              end 			 
       VALUE_101:  begin en <= 1;  end  // начало импульса en
       VALUE_102:  begin en <= 0;  end	 // конец импульса en 
				
       VALUE_300: begin counter_s <= 0; end 	  
       endcase
	   //--------------------------------------------
  end
end 


// Формирование сигналов LCD  
//------------------------------------------------------------ 
assign LCD_N = 0;
assign LCD_P = 1;
  
assign dat = data; 
assign rs = rsn;  
 
assign e = en; 
assign rw = 0;
//-----------------------------------------------------------

// формирование сигналов управления светодиодами
assign led = led_reg; 


// назначение,  какие источники управляют выходом звука:
// цифровые клавиши озвучены только при снятой блокировке и только в режиме набора
assign buzzer = 
  ((clk_1kHz & AKTIV_KLAV_1_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_2_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_3_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |     
   //(clk_1kHz & AKTIV_KLAV_S_wire & (lock == LOCK_OFF)) 
   (clk_1kHz & AKTIV_KLAV_4_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_5_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_6_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_G_wire & (lock == LOCK_OFF)) |
   (clk_1kHz & AKTIV_KLAV_7_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_8_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) | 
   (clk_1kHz & AKTIV_KLAV_9_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) | 
   (clk_1kHz & AKTIV_KLAV_L_wire) |   // эта клавиша не блокируется никогда 
   (clk_1kHz & AKTIV_KLAV_E_wire & (lock == LOCK_OFF)) |
   (clk_1kHz & AKTIV_KLAV_0_wire & (lock == LOCK_OFF) & (mode == MODE_SET)) |
   (clk_1kHz & AKTIV_KLAV_e_wire & (lock == LOCK_OFF) & (mode == MODE_SET))    
   //(clk_1kHz & AKTIV_KLAV_P_wire & (lock == LOCK_OFF))    
   );  // сигнал разрешения звука от клавиши	 
	
 	 
	
//-----------------------------------------------------------------------------------	
// Модули  нижних уровней 
//-----------------------------------------------------------------------------------
	
// Модуль записи-чтения блока данных в ИМС часов-календаря  PCF8563 
PCF8563_wr_rd  PCF8563_wr_rd_0(

     //сигналы обмена с остальной конфигурацией ПЛИС 
     .clk(clk), 	
	.nrst(nrst),   
  	.PCF8563_write_start(PCF8563_write_start), // сигнал  старта  записи    
	.PCF8563_read_start(PCF8563_read_start), // сигнал  старта  чтения	

	.PCF8563_write_data_1(write_PCF8563_data_1),  //--------------------  
     .PCF8563_write_data_2(write_PCF8563_data_2),  //   
	.PCF8563_write_data_3(write_PCF8563_data_3),  //  данные записи
     .PCF8563_write_data_4(write_PCF8563_data_4),  //    
     .PCF8563_write_data_5(write_PCF8563_data_5),  // регистров RTC  PCF8563	
     .PCF8563_write_data_6(write_PCF8563_data_6),  //    
     .PCF8563_write_data_7(write_PCF8563_data_7),  //-------------------- 
	 	 
	.PCF8563_read_data_1(read_PCF8563_data_1),   //---------------------  
	.PCF8563_read_data_2(read_PCF8563_data_2),   //  
	.PCF8563_read_data_3(read_PCF8563_data_3),   //  цепи чтения регистров 
	.PCF8563_read_data_4(read_PCF8563_data_4),   //  
	.PCF8563_read_data_5(read_PCF8563_data_5),   //      RTC  PCF8563
	.PCF8563_read_data_6(read_PCF8563_data_6),   //  
	.PCF8563_read_data_7(read_PCF8563_data_7),   //---------------------  	
  
     .write_final_imp(DS1302_write_final_imp),  // импульс финала записи DS1302
	.read_final_imp(DS1302_read_final_imp),  // импульс финала чтения DS1302
 
	  // сигналы обмена с ИМС PCF8563 
     .PCF8563_SCL(PCF8563_SCL), // синхросигнал PCF8563 
 	
     .PCF8563_SDA(PCF8563_SDA)   // двунаправленная линия данных для чтения/записи PCF8563 
	); 
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_1(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_1_reg),
	.en_buzzer_button(AKTIV_KLAV_1_wire)
	);	
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_2(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_2_reg),
	.en_buzzer_button(AKTIV_KLAV_2_wire)
	);		

// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_3(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_3_reg),
	.en_buzzer_button(AKTIV_KLAV_3_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_S(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_S_reg),
	.en_buzzer_button(AKTIV_KLAV_S_wire)
	);	
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_4(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_4_reg),
	.en_buzzer_button(AKTIV_KLAV_4_wire)
	);	
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_5(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_5_reg),
	.en_buzzer_button(AKTIV_KLAV_5_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_6(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_6_reg),
	.en_buzzer_button(AKTIV_KLAV_6_wire)
	);	

// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_G(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_G_reg),
	.en_buzzer_button(AKTIV_KLAV_G_wire)
	);		

// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_7(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_7_reg),
	.en_buzzer_button(AKTIV_KLAV_7_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_8(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_8_reg),
	.en_buzzer_button(AKTIV_KLAV_8_wire)
	);		

// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_9(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_9_reg),
	.en_buzzer_button(AKTIV_KLAV_9_wire)
	);	
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_L(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_L_reg),
	.en_buzzer_button(AKTIV_KLAV_L_wire)
	);		

// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_E(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_E_reg),
	.en_buzzer_button(AKTIV_KLAV_E_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_0(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_0_reg),
	.en_buzzer_button(AKTIV_KLAV_0_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_e(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_e_reg),
	.en_buzzer_button(AKTIV_KLAV_e_wire)
	);		
	
// модуль формирования одного импульса (разрешения звука) по нажатию клавиши
buzzer_butt  butt_klav_P(
   .clk(clk_1kHz),	
	.en_buzzer_key(AKTIV_KLAV_P_reg),
	.en_buzzer_button(AKTIV_KLAV_P_wire)
	);		
	

// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_1( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_1_reg),
	    .imp(imp_KLAV_1)  
	    );		
	   
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_2( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_2_reg),
	    .imp(imp_KLAV_2)  
	    );		   
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_3( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_3_reg),
	    .imp(imp_KLAV_3)  
	    );		

// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_S( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_S_reg),
	    .imp(imp_KLAV_S)  
	    );		    
	    
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_4( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_4_reg),
	    .imp(imp_KLAV_4)  
	    );		    
	    
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_5( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_5_reg),
	    .imp(imp_KLAV_5)  
	    );		    
	    
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_6( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_6_reg),
	    .imp(imp_KLAV_6)  
	    );		    
	  	    
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_G( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_G_reg),
	    .imp(imp_KLAV_G)  
	    );		
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_7( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_7_reg),
	    .imp(imp_KLAV_7)  
	    );		
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_8( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_8_reg),
	    .imp(imp_KLAV_8)  
	    );		
	   
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_9( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_9_reg),
	    .imp(imp_KLAV_9)  
	    );		   
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_L( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_L_reg),
	    .imp(imp_KLAV_L)  
	    );		
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_E( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_E_reg),
	    .imp(imp_KLAV_E)  
	    );		
	   
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_0( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_0_reg),
	    .imp(imp_KLAV_0)  
	    );		   
	    
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_e( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_e_reg),
	    .imp(imp_KLAV_e)  
	    );		    
	   
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_klav_P( 
         .clk(~clk_1kHz), 
         .fx_in(AKTIV_KLAV_P_reg),
	    .imp(imp_KLAV_P)   
	    );		   
	
// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_data_ready( 
         .clk(~clk_1kHz), 
         .fx_in(KLAV_data_ready),
	    .imp(KLAV_data_ready_imp)   
	    );	
	

// модуль двухступенчатого триггера для формирования положительных импульсов  длительностью 1 период синхросигнала   	
// по фронту входного сигнала 
Trigger_2st_front Trigger_data_UART_burst( 
         .clk(~clk), 
         .fx_in(tx_UART_start_burst),
	    .imp(tx_UART_start_burst_imp)   
	    );		
	
	
// Модуль  передачи байта через UART  
UART_byte_tx  UART_byte_tx_0(
     .clk(clk), 	
	  .nrst(nrst),   
	  .UART_tx_start(tx_UART_start), // сигнал  начала передачи через UART  
	  .UART_tx_data(tx_UART_data),  // передаваемые данные через UART  
	  	  
	  .dip(dip),  // линии задания скорости UART
	  
     .UART_tx(UART_tx_output),  
	  .UART_tx_final(UART_tx_final),  // признак завершения передачи байта через UART
	  .UART_tx_done(UART_tx_done)    // признак длящейся передачи байта через UART    
	 );	
	
endmodule


