#define LED_PIN  13
#define SIGN_PIN  A0
#define POT_PIN  A1
#define BUZZER_PIN  12 
#define FIRST_SEGMENT_PIN   2
#define SEGMENT_COUNT       8
// комбинации элементов для каждой из цифр на индикаторе
byte numberSegments[21] = {
  0b00111111, 0b00001010, 0b01011101, 0b01011110, 0b01101010,
  0b01110110, 0b01110111, 0b00011010, 0b01111111, 0b01111110, 0b10000000,
  0b10001010, 0b11011101, 0b11011110, 0b11101010,
  0b11110110, 0b11110111, 0b10011010, 0b11111111, 0b11111110, 0b00000000,
};
int number = 0;
void setup()
{
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUZZER_PIN, OUTPUT);
  for (int i = 0; i < SEGMENT_COUNT; ++i)
  pinMode(i + FIRST_SEGMENT_PIN, OUTPUT);
}
void loop()
{   
  digitalWrite(BUZZER_PIN, LOW);   
  int sign = analogRead(SIGN_PIN); // считываем уровень сигнала
  int threshold = analogRead(POT_PIN); // считываем значение порога
  boolean Zero = (sign > threshold); // сравниваем уровень сигнала с порогом
    if (Zero) { // принимаем решение
    digitalWrite(LED_PIN, LOW);  // включаем зеленый светодиод - разрешение стрельбы
     }
  else {
    number = (number + 1) % 21; 
    digitalWrite(LED_PIN, HIGH); // включаем красный светодиод - запрет стрельбы
    tone(BUZZER_PIN, 1000, 300); // подаем звуковой сигнал попадания и считаем попадания 
    int mask = numberSegments[number]; // код для индикатора
    for (int i = 0; i < SEGMENT_COUNT; ++i) {
    boolean enableSegment = bitRead(mask, i);
    digitalWrite(i + FIRST_SEGMENT_PIN, enableSegment); // включаем элементы индикатора
    }
      // Пауза 5 с
      delay(5000);
      // прерывистый звуковой сигнал окончания паузы
      tone(BUZZER_PIN, 1000, 300);
      delay(400);
      tone(BUZZER_PIN, 1000, 300);
      delay(400);
      tone(BUZZER_PIN, 1000, 300);
      delay(400);
 }
   
 }
