
#ifndef	_HTC_H_
#warning Header file pic12f683.h included directly. Use #include <htc.h> instead.
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  12F683
 */


#ifndef __PIC12F683_H
#define __PIC12F683_H

//
// Configuration mask definitions
//


// Config Register: CONFIG
#define CONFIG               0x2007
// Oscillator Selection bits
// EXTRC oscillator: External RC on RA5/OSC1/CLKIN, CLKOUT function on RA4/OSC2/CLKOUT pin
#define FOSC_EXTRCCLK        0xFFFF
// EXTRCIO oscillator: External RC on RA5/OSC1/CLKIN, I/O function on RA4/OSC2/CLKOUT pin
#define FOSC_EXTRCIO         0xFFFE
// INTOSC oscillator: CLKOUT function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
#define FOSC_INTOSCCLK       0xFFFD
// INTOSCIO oscillator: I/O function on RA4/OSC2/CLKOUT pin, I/O function on RA5/OSC1/CLKIN
#define FOSC_INTOSCIO        0xFFFC
// EC: I/O function on RA4/OSC2/CLKOUT pin, CLKIN on RA5/OSC1/CLKIN
#define FOSC_EC              0xFFFB
// HS oscillator: High-speed crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
#define FOSC_HS              0xFFFA
// XT oscillator: Crystal/resonator on RA4/OSC2/CLKOUT and RA5/OSC1/CLKINT
#define FOSC_XT              0xFFF9
// LP oscillator: Low-power crystal on RA4/OSC2/CLKOUT and RA5/OSC1/CLKIN
#define FOSC_LP              0xFFF8
// Watchdog Timer Enable bit
// WDT enabled
#define WDTE_ON              0xFFFF
// WDT disabled
#define WDTE_OFF             0xFFF7
// Power-up Timer Enable bit
// PWRT disabled
#define PWRTE_OFF            0xFFFF
// PWRT enabled
#define PWRTE_ON             0xFFEF
// MCLR Pin Function Select bit
// MCLR pin function is MCLR
#define MCLRE_ON             0xFFFF
// MCLR pin function is digital input, MCLR internally tied to VDD
#define MCLRE_OFF            0xFFDF
// Code Protection bit
// Program memory code protection is disabled
#define CP_OFF               0xFFFF
// Program memory code protection is enabled
#define CP_ON                0xFFBF
// Data Code Protection bit
// Data memory code protection is disabled
#define CPD_OFF              0xFFFF
// Data memory code protection is enabled
#define CPD_ON               0xFF7F
// Brown Out Detect
// BOR enabled
#define BOREN_ON             0xFFFF
// BOR enabled during operation and disabled in Sleep
#define BOREN_NSLEEP         0xFEFF
// BOR controlled by SBOREN bit of the PCON register
#define BOREN_SBODEN         0xFDFF
// BOR disabled
#define BOREN_OFF            0xFCFF
// Internal External Switchover bit
// Internal External Switchover mode is enabled
#define IESO_ON              0xFFFF
// Internal External Switchover mode is disabled
#define IESO_OFF             0xFBFF
// Fail-Safe Clock Monitor Enabled bit
// Fail-Safe Clock Monitor is enabled
#define FCMEN_ON             0xFFFF
// Fail-Safe Clock Monitor is disabled
#define FCMEN_OFF            0xF7FF


//
// Special function register definitions
//


// Register: INDF
volatile unsigned char           INDF                @ 0x000;
// bit and bitfield definitions

// Register: TMR0
volatile unsigned char           TMR0                @ 0x001;
// bit and bitfield definitions

// Register: PCL
volatile unsigned char           PCL                 @ 0x002;
// bit and bitfield definitions

// Register: STATUS
volatile unsigned char           STATUS              @ 0x003;
// bit and bitfield definitions
volatile bit CARRY               @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit ZERO                @ ((unsigned)&STATUS*8)+2;
volatile bit nPD                 @ ((unsigned)&STATUS*8)+3;
volatile bit nTO                 @ ((unsigned)&STATUS*8)+4;
volatile bit IRP                 @ ((unsigned)&STATUS*8)+7;
volatile bit RP0                 @ ((unsigned)&STATUS*8)+5;
volatile bit RP1                 @ ((unsigned)&STATUS*8)+6;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	C                   : 1;
        unsigned	DC                  : 1;
        unsigned	Z                   : 1;
        unsigned	nPD                 : 1;
        unsigned	nTO                 : 1;
        unsigned	RP                  : 2;
        unsigned	IRP                 : 1;
    };
    struct {
        unsigned	                    : 5;
        unsigned	RP0                 : 1;
        unsigned	RP1                 : 1;
    };
} STATUSbits @ 0x003;
#endif

// Register: FSR
volatile unsigned char           FSR                 @ 0x004;
// bit and bitfield definitions

// Register: GPIO
volatile unsigned char           GPIO                @ 0x005;
// bit and bitfield definitions
volatile bit GP0                 @ ((unsigned)&GPIO*8)+0;
volatile bit GP1                 @ ((unsigned)&GPIO*8)+1;
volatile bit GP2                 @ ((unsigned)&GPIO*8)+2;
volatile bit GP3                 @ ((unsigned)&GPIO*8)+3;
volatile bit GP4                 @ ((unsigned)&GPIO*8)+4;
volatile bit GP5                 @ ((unsigned)&GPIO*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	GP0                 : 1;
        unsigned	GP1                 : 1;
        unsigned	GP2                 : 1;
        unsigned	GP3                 : 1;
        unsigned	GP4                 : 1;
        unsigned	GP5                 : 1;
    };
} GPIObits @ 0x005;
#endif

// Register: PCLATH
volatile unsigned char           PCLATH              @ 0x00A;
// bit and bitfield definitions
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	PCLATH              : 5;
    };
} PCLATHbits @ 0x00A;
#endif

// Register: INTCON
volatile unsigned char           INTCON              @ 0x00B;
// bit and bitfield definitions
volatile bit GPIF                @ ((unsigned)&INTCON*8)+0;
volatile bit INTF                @ ((unsigned)&INTCON*8)+1;
volatile bit T0IF                @ ((unsigned)&INTCON*8)+2;
volatile bit GPIE                @ ((unsigned)&INTCON*8)+3;
volatile bit INTE                @ ((unsigned)&INTCON*8)+4;
volatile bit T0IE                @ ((unsigned)&INTCON*8)+5;
volatile bit PEIE                @ ((unsigned)&INTCON*8)+6;
volatile bit GIE                 @ ((unsigned)&INTCON*8)+7;
volatile bit TMR0IF              @ ((unsigned)&INTCON*8)+2;
volatile bit TMR0IE              @ ((unsigned)&INTCON*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	GPIF                : 1;
        unsigned	INTF                : 1;
        unsigned	T0IF                : 1;
        unsigned	GPIE                : 1;
        unsigned	INTE                : 1;
        unsigned	T0IE                : 1;
        unsigned	PEIE                : 1;
        unsigned	GIE                 : 1;
    };
    struct {
        unsigned	                    : 2;
        unsigned	TMR0IF              : 1;
        unsigned	: 2;
        unsigned	TMR0IE              : 1;
    };
} INTCONbits @ 0x00B;
#endif

// Register: PIR1
volatile unsigned char           PIR1                @ 0x00C;
// bit and bitfield definitions
volatile bit TMR1IF              @ ((unsigned)&PIR1*8)+0;
volatile bit TMR2IF              @ ((unsigned)&PIR1*8)+1;
volatile bit OSFIF               @ ((unsigned)&PIR1*8)+2;
volatile bit CMIF                @ ((unsigned)&PIR1*8)+3;
volatile bit CCP1IF              @ ((unsigned)&PIR1*8)+5;
volatile bit ADIF                @ ((unsigned)&PIR1*8)+6;
volatile bit EEIF                @ ((unsigned)&PIR1*8)+7;
volatile bit T1IF                @ ((unsigned)&PIR1*8)+0;
volatile bit T2IF                @ ((unsigned)&PIR1*8)+1;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	TMR1IF              : 1;
        unsigned	TMR2IF              : 1;
        unsigned	OSFIF               : 1;
        unsigned	CMIF                : 1;
        unsigned	                    : 1;
        unsigned	CCP1IF              : 1;
        unsigned	ADIF                : 1;
        unsigned	EEIF                : 1;
    };
    struct {
        unsigned	T1IF                : 1;
        unsigned	T2IF                : 1;
    };
} PIR1bits @ 0x00C;
#endif
// bit and bitfield definitions

// Register: TMR1L
volatile unsigned char           TMR1L               @ 0x00E;
// bit and bitfield definitions

// Register: TMR1H
volatile unsigned char           TMR1H               @ 0x00F;
// bit and bitfield definitions

// Register: TMR1
volatile unsigned int            TMR1                @ 0x00E;

// Register: T1CON
volatile unsigned char           T1CON               @ 0x010;
// bit and bitfield definitions
volatile bit TMR1ON              @ ((unsigned)&T1CON*8)+0;
volatile bit TMR1CS              @ ((unsigned)&T1CON*8)+1;
volatile bit nT1SYNC             @ ((unsigned)&T1CON*8)+2;
volatile bit T1OSCEN             @ ((unsigned)&T1CON*8)+3;
volatile bit TMR1GE              @ ((unsigned)&T1CON*8)+6;
volatile bit T1GINV              @ ((unsigned)&T1CON*8)+7;
volatile bit T1CKPS0             @ ((unsigned)&T1CON*8)+4;
volatile bit T1CKPS1             @ ((unsigned)&T1CON*8)+5;
volatile bit T1GE                @ ((unsigned)&T1CON*8)+6;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	TMR1ON              : 1;
        unsigned	TMR1CS              : 1;
        unsigned	nT1SYNC             : 1;
        unsigned	T1OSCEN             : 1;
        unsigned	T1CKPS              : 2;
        unsigned	TMR1GE              : 1;
        unsigned	T1GINV              : 1;
    };
    struct {
        unsigned	                    : 4;
        unsigned	T1CKPS0             : 1;
        unsigned	T1CKPS1             : 1;
        unsigned	T1GE                : 1;
    };
} T1CONbits @ 0x010;
#endif

// Register: TMR2
volatile unsigned char           TMR2                @ 0x011;
// bit and bitfield definitions

// Register: T2CON
volatile unsigned char           T2CON               @ 0x012;
// bit and bitfield definitions
volatile bit TMR2ON              @ ((unsigned)&T2CON*8)+2;
volatile bit T2CKPS0             @ ((unsigned)&T2CON*8)+0;
volatile bit T2CKPS1             @ ((unsigned)&T2CON*8)+1;
volatile bit TOUTPS0             @ ((unsigned)&T2CON*8)+3;
volatile bit TOUTPS1             @ ((unsigned)&T2CON*8)+4;
volatile bit TOUTPS2             @ ((unsigned)&T2CON*8)+5;
volatile bit TOUTPS3             @ ((unsigned)&T2CON*8)+6;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	T2CKPS              : 2;
        unsigned	TMR2ON              : 1;
        unsigned	TOUTPS              : 4;
    };
    struct {
        unsigned	T2CKPS0             : 1;
        unsigned	T2CKPS1             : 1;
        unsigned	                    : 1;
        unsigned	TOUTPS0             : 1;
        unsigned	TOUTPS1             : 1;
        unsigned	TOUTPS2             : 1;
        unsigned	TOUTPS3             : 1;
    };
} T2CONbits @ 0x012;
#endif
// bit and bitfield definitions

// Register: CCPR1L
volatile unsigned char           CCPR1L              @ 0x013;
// bit and bitfield definitions

// Register: CCPR1H
volatile unsigned char           CCPR1H              @ 0x014;
// bit and bitfield definitions

// Register: CCPR1
volatile unsigned int            CCPR1               @ 0x013;

// Register: CCP1CON
volatile unsigned char           CCP1CON             @ 0x015;
// bit and bitfield definitions
volatile bit CCP1M0              @ ((unsigned)&CCP1CON*8)+0;
volatile bit CCP1M1              @ ((unsigned)&CCP1CON*8)+1;
volatile bit CCP1M2              @ ((unsigned)&CCP1CON*8)+2;
volatile bit CCP1M3              @ ((unsigned)&CCP1CON*8)+3;
volatile bit DC1B0               @ ((unsigned)&CCP1CON*8)+4;
volatile bit DC1B1               @ ((unsigned)&CCP1CON*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	CCP1M               : 4;
        unsigned	DC1B                : 2;
    };
    struct {
        unsigned	CCP1M0              : 1;
        unsigned	CCP1M1              : 1;
        unsigned	CCP1M2              : 1;
        unsigned	CCP1M3              : 1;
        unsigned	DC1B0               : 1;
        unsigned	DC1B1               : 1;
    };
} CCP1CONbits @ 0x015;
#endif

// Register: WDTCON
volatile unsigned char           WDTCON              @ 0x018;
// bit and bitfield definitions
volatile bit SWDTEN              @ ((unsigned)&WDTCON*8)+0;
volatile bit WDTPS0              @ ((unsigned)&WDTCON*8)+1;
volatile bit WDTPS1              @ ((unsigned)&WDTCON*8)+2;
volatile bit WDTPS2              @ ((unsigned)&WDTCON*8)+3;
volatile bit WDTPS3              @ ((unsigned)&WDTCON*8)+4;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	SWDTEN              : 1;
        unsigned	WDTPS               : 4;
    };
    struct {
        unsigned	                    : 1;
        unsigned	WDTPS0              : 1;
        unsigned	WDTPS1              : 1;
        unsigned	WDTPS2              : 1;
        unsigned	WDTPS3              : 1;
    };
} WDTCONbits @ 0x018;
#endif

// Register: CMCON0
volatile unsigned char           CMCON0              @ 0x019;
// bit and bitfield definitions
volatile bit CIS                 @ ((unsigned)&CMCON0*8)+3;
volatile bit CINV                @ ((unsigned)&CMCON0*8)+4;
volatile bit COUT                @ ((unsigned)&CMCON0*8)+6;
volatile bit CM0                 @ ((unsigned)&CMCON0*8)+0;
volatile bit CM1                 @ ((unsigned)&CMCON0*8)+1;
volatile bit CM2                 @ ((unsigned)&CMCON0*8)+2;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	CM                  : 3;
        unsigned	CIS                 : 1;
        unsigned	CINV                : 1;
        unsigned	                    : 1;
        unsigned	COUT                : 1;
    };
    struct {
        unsigned	CM0                 : 1;
        unsigned	CM1                 : 1;
        unsigned	CM2                 : 1;
    };
} CMCON0bits @ 0x019;
#endif

// Register: CMCON1
volatile unsigned char           CMCON1              @ 0x01A;
// bit and bitfield definitions
volatile bit CMSYNC              @ ((unsigned)&CMCON1*8)+0;
volatile bit T1GSS               @ ((unsigned)&CMCON1*8)+1;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	CMSYNC              : 1;
        unsigned	T1GSS               : 1;
    };
} CMCON1bits @ 0x01A;
#endif

// Register: ADRESH
volatile unsigned char           ADRESH              @ 0x01E;
// bit and bitfield definitions

// Register: ADCON0
volatile unsigned char           ADCON0              @ 0x01F;
// bit and bitfield definitions
volatile bit ADON                @ ((unsigned)&ADCON0*8)+0;
volatile bit GO_nDONE            @ ((unsigned)&ADCON0*8)+1;
volatile bit VCFG                @ ((unsigned)&ADCON0*8)+6;
volatile bit ADFM                @ ((unsigned)&ADCON0*8)+7;
volatile bit GO                  @ ((unsigned)&ADCON0*8)+1;
volatile bit CHS0                @ ((unsigned)&ADCON0*8)+2;
volatile bit CHS1                @ ((unsigned)&ADCON0*8)+3;
volatile bit CHS2                @ ((unsigned)&ADCON0*8)+4;
volatile bit nDONE               @ ((unsigned)&ADCON0*8)+1;
volatile bit GO_DONE             @ ((unsigned)&ADCON0*8)+1;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	ADON                : 1;
        unsigned	GO_nDONE            : 1;
        unsigned	CHS                 : 2;
        unsigned	                    : 2;
        unsigned	VCFG                : 1;
        unsigned	ADFM                : 1;
    };
    struct {
        unsigned	: 1;
        unsigned	: 1;
        unsigned	: 2;
        unsigned	: 2;
        unsigned	: 1;
        unsigned	: 1;
    };
    struct {
        unsigned	: 1;
        unsigned	GO                  : 1;
        unsigned	CHS0                : 1;
        unsigned	CHS1                : 1;
        unsigned	CHS2                : 1;
    };
    struct {
        unsigned	: 1;
        unsigned	nDONE               : 1;
    };
    struct {
        unsigned	: 1;
        unsigned	GO_DONE             : 1;
    };
} ADCON0bits @ 0x01F;
#endif

//
// Special function register definitions: Bank 1
//


// Register: OPTION_REG
volatile unsigned char           OPTION_REG          @ 0x081;
// bit and bitfield definitions
volatile bit PSA                 @ ((unsigned)&OPTION_REG*8)+3;
volatile bit T0SE                @ ((unsigned)&OPTION_REG*8)+4;
volatile bit T0CS                @ ((unsigned)&OPTION_REG*8)+5;
volatile bit INTEDG              @ ((unsigned)&OPTION_REG*8)+6;
volatile bit nGPPU               @ ((unsigned)&OPTION_REG*8)+7;
volatile bit PS0                 @ ((unsigned)&OPTION_REG*8)+0;
volatile bit PS1                 @ ((unsigned)&OPTION_REG*8)+1;
volatile bit PS2                 @ ((unsigned)&OPTION_REG*8)+2;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	PS                  : 3;
        unsigned	PSA                 : 1;
        unsigned	T0SE                : 1;
        unsigned	T0CS                : 1;
        unsigned	INTEDG              : 1;
        unsigned	nGPPU               : 1;
    };
    struct {
        unsigned	PS0                 : 1;
        unsigned	PS1                 : 1;
        unsigned	PS2                 : 1;
    };
} OPTION_REGbits @ 0x081;
#endif

// Register: TRISIO
volatile unsigned char           TRISIO              @ 0x085;
// bit and bitfield definitions
volatile bit TRISIO0             @ ((unsigned)&TRISIO*8)+0;
volatile bit TRISIO1             @ ((unsigned)&TRISIO*8)+1;
volatile bit TRISIO2             @ ((unsigned)&TRISIO*8)+2;
volatile bit TRISIO3             @ ((unsigned)&TRISIO*8)+3;
volatile bit TRISIO4             @ ((unsigned)&TRISIO*8)+4;
volatile bit TRISIO5             @ ((unsigned)&TRISIO*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	TRISIO0             : 1;
        unsigned	TRISIO1             : 1;
        unsigned	TRISIO2             : 1;
        unsigned	TRISIO3             : 1;
        unsigned	TRISIO4             : 1;
        unsigned	TRISIO5             : 1;
    };
} TRISIObits @ 0x085;
#endif

// Register: PIE1
volatile unsigned char           PIE1                @ 0x08C;
// bit and bitfield definitions
volatile bit TMR1IE              @ ((unsigned)&PIE1*8)+0;
volatile bit TMR2IE              @ ((unsigned)&PIE1*8)+1;
volatile bit OSFIE               @ ((unsigned)&PIE1*8)+2;
volatile bit CMIE                @ ((unsigned)&PIE1*8)+3;
volatile bit CCP1IE              @ ((unsigned)&PIE1*8)+5;
volatile bit ADIE                @ ((unsigned)&PIE1*8)+6;
volatile bit EEIE                @ ((unsigned)&PIE1*8)+7;
volatile bit T1IE                @ ((unsigned)&PIE1*8)+0;
volatile bit T2IE                @ ((unsigned)&PIE1*8)+1;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	TMR1IE              : 1;
        unsigned	TMR2IE              : 1;
        unsigned	OSFIE               : 1;
        unsigned	CMIE                : 1;
        unsigned	                    : 1;
        unsigned	CCP1IE              : 1;
        unsigned	ADIE                : 1;
        unsigned	EEIE                : 1;
    };
    struct {
        unsigned	T1IE                : 1;
        unsigned	T2IE                : 1;
    };
} PIE1bits @ 0x08C;
#endif

// Register: PCON
volatile unsigned char           PCON                @ 0x08E;
// bit and bitfield definitions
volatile bit nBOD                @ ((unsigned)&PCON*8)+0;
volatile bit nPOR                @ ((unsigned)&PCON*8)+1;
volatile bit SBODEN              @ ((unsigned)&PCON*8)+4;
volatile bit ULPWUE              @ ((unsigned)&PCON*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	nBOD                : 1;
        unsigned	nPOR                : 1;
        unsigned	                    : 2;
        unsigned	SBODEN              : 1;
        unsigned	ULPWUE              : 1;
    };
} PCONbits @ 0x08E;
#endif

// Register: OSCCON
volatile unsigned char           OSCCON              @ 0x08F;
// bit and bitfield definitions
volatile bit SCS                 @ ((unsigned)&OSCCON*8)+0;
volatile bit LTS                 @ ((unsigned)&OSCCON*8)+1;
volatile bit HTS                 @ ((unsigned)&OSCCON*8)+2;
volatile bit OSTS                @ ((unsigned)&OSCCON*8)+3;
volatile bit IRCF0               @ ((unsigned)&OSCCON*8)+4;
volatile bit IRCF1               @ ((unsigned)&OSCCON*8)+5;
volatile bit IRCF2               @ ((unsigned)&OSCCON*8)+6;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	SCS                 : 1;
        unsigned	LTS                 : 1;
        unsigned	HTS                 : 1;
        unsigned	OSTS                : 1;
        unsigned	IRCF                : 3;
    };
    struct {
        unsigned	                    : 4;
        unsigned	IRCF0               : 1;
        unsigned	IRCF1               : 1;
        unsigned	IRCF2               : 1;
    };
} OSCCONbits @ 0x08F;
#endif

// Register: OSCTUNE
volatile unsigned char           OSCTUNE             @ 0x090;
// bit and bitfield definitions
volatile bit TUN0                @ ((unsigned)&OSCTUNE*8)+0;
volatile bit TUN1                @ ((unsigned)&OSCTUNE*8)+1;
volatile bit TUN2                @ ((unsigned)&OSCTUNE*8)+2;
volatile bit TUN3                @ ((unsigned)&OSCTUNE*8)+3;
volatile bit TUN4                @ ((unsigned)&OSCTUNE*8)+4;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	TUN                 : 5;
    };
    struct {
        unsigned	TUN0                : 1;
        unsigned	TUN1                : 1;
        unsigned	TUN2                : 1;
        unsigned	TUN3                : 1;
        unsigned	TUN4                : 1;
    };
} OSCTUNEbits @ 0x090;
#endif

// Register: PR2
volatile unsigned char           PR2                 @ 0x092;
// bit and bitfield definitions

// Register: WPU
volatile unsigned char           WPU                 @ 0x095;
volatile unsigned char           WPUA                @ 0x095;
// bit and bitfield definitions
volatile bit WPU0                @ ((unsigned)&WPU*8)+0;
volatile bit WPU1                @ ((unsigned)&WPU*8)+1;
volatile bit WPU2                @ ((unsigned)&WPU*8)+2;
volatile bit WPU4                @ ((unsigned)&WPU*8)+4;
volatile bit WPU5                @ ((unsigned)&WPU*8)+5;
volatile bit WPUA0               @ ((unsigned)&WPU*8)+0;
volatile bit WPUA1               @ ((unsigned)&WPU*8)+1;
volatile bit WPUA2               @ ((unsigned)&WPU*8)+2;
volatile bit WPUA4               @ ((unsigned)&WPU*8)+4;
volatile bit WPUA5               @ ((unsigned)&WPU*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	WPU0                : 1;
        unsigned	WPU1                : 1;
        unsigned	WPU2                : 1;
        unsigned	                    : 1;
        unsigned	WPU4                : 1;
        unsigned	WPU5                : 1;
    };
    struct {
        unsigned	WPUA0               : 1;
        unsigned	WPUA1               : 1;
        unsigned	WPUA2               : 1;
        unsigned	: 1;
        unsigned	WPUA4               : 1;
        unsigned	WPUA5               : 1;
    };
} WPUbits @ 0x095;
#endif

// Register: IOC
volatile unsigned char           IOC                 @ 0x096;
volatile unsigned char           IOCA                @ 0x096;
// bit and bitfield definitions
volatile bit IOC0                @ ((unsigned)&IOC*8)+0;
volatile bit IOC1                @ ((unsigned)&IOC*8)+1;
volatile bit IOC2                @ ((unsigned)&IOC*8)+2;
volatile bit IOC3                @ ((unsigned)&IOC*8)+3;
volatile bit IOC4                @ ((unsigned)&IOC*8)+4;
volatile bit IOC5                @ ((unsigned)&IOC*8)+5;
volatile bit IOCA0               @ ((unsigned)&IOC*8)+0;
volatile bit IOCA1               @ ((unsigned)&IOC*8)+1;
volatile bit IOCA2               @ ((unsigned)&IOC*8)+2;
volatile bit IOCA3               @ ((unsigned)&IOC*8)+3;
volatile bit IOCA4               @ ((unsigned)&IOC*8)+4;
volatile bit IOCA5               @ ((unsigned)&IOC*8)+5;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	IOC0                : 1;
        unsigned	IOC1                : 1;
        unsigned	IOC2                : 1;
        unsigned	IOC3                : 1;
        unsigned	IOC4                : 1;
        unsigned	IOC5                : 1;
    };
    struct {
        unsigned	IOCA0               : 1;
        unsigned	IOCA1               : 1;
        unsigned	IOCA2               : 1;
        unsigned	IOCA3               : 1;
        unsigned	IOCA4               : 1;
        unsigned	IOCA5               : 1;
    };
} IOCbits @ 0x096;
#endif

// Register: VRCON
volatile unsigned char           VRCON               @ 0x099;
// bit and bitfield definitions
volatile bit VRR                 @ ((unsigned)&VRCON*8)+5;
volatile bit VREN                @ ((unsigned)&VRCON*8)+7;
volatile bit VR0                 @ ((unsigned)&VRCON*8)+0;
volatile bit VR1                 @ ((unsigned)&VRCON*8)+1;
volatile bit VR2                 @ ((unsigned)&VRCON*8)+2;
volatile bit VR3                 @ ((unsigned)&VRCON*8)+3;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	VR                  : 4;
        unsigned	                    : 1;
        unsigned	VRR                 : 1;
        unsigned	: 1;
        unsigned	VREN                : 1;
    };
    struct {
        unsigned	VR0                 : 1;
        unsigned	VR1                 : 1;
        unsigned	VR2                 : 1;
        unsigned	VR3                 : 1;
    };
} VRCONbits @ 0x099;
#endif

// Register: EEDAT
volatile unsigned char           EEDAT               @ 0x09A;
volatile unsigned char           EEDATA              @ 0x09A;
// bit and bitfield definitions

// Register: EEADR
volatile unsigned char           EEADR               @ 0x09B;
// bit and bitfield definitions

// Register: EECON1
volatile unsigned char           EECON1              @ 0x09C;
// bit and bitfield definitions
volatile bit RD                  @ ((unsigned)&EECON1*8)+0;
volatile bit WR                  @ ((unsigned)&EECON1*8)+1;
volatile bit WREN                @ ((unsigned)&EECON1*8)+2;
volatile bit WRERR               @ ((unsigned)&EECON1*8)+3;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	RD                  : 1;
        unsigned	WR                  : 1;
        unsigned	WREN                : 1;
        unsigned	WRERR               : 1;
    };
} EECON1bits @ 0x09C;
#endif

// Register: EECON2
volatile unsigned char           EECON2              @ 0x09D;
// bit and bitfield definitions

// Register: ADRESL
volatile unsigned char           ADRESL              @ 0x09E;
// bit and bitfield definitions

// Register: ANSEL
volatile unsigned char           ANSEL               @ 0x09F;
// bit and bitfield definitions
volatile bit ANS0                @ ((unsigned)&ANSEL*8)+0;
volatile bit ANS1                @ ((unsigned)&ANSEL*8)+1;
volatile bit ANS2                @ ((unsigned)&ANSEL*8)+2;
volatile bit ANS3                @ ((unsigned)&ANSEL*8)+3;
volatile bit ADCS0               @ ((unsigned)&ANSEL*8)+4;
volatile bit ADCS1               @ ((unsigned)&ANSEL*8)+5;
volatile bit ADCS2               @ ((unsigned)&ANSEL*8)+6;
#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	ANS                 : 4;
        unsigned	ADCS                : 3;
    };
    struct {
        unsigned	ANS0                : 1;
        unsigned	ANS1                : 1;
        unsigned	ANS2                : 1;
        unsigned	ANS3                : 1;
        unsigned	ADCS0               : 1;
        unsigned	ADCS1               : 1;
        unsigned	ADCS2               : 1;
    };
} ANSELbits @ 0x09F;
#endif

#endif
