/*============================  ZU_1.2f============================*/
//   Ni-Cd  NiMH    ATmega8L-8PU (ATmega8-16PU)
// : WinAVR-20060125
//Make: Name=ZU_2, MCU=ATmega8, Level=2, Debug=VMLab, Programmer=ponyser,Port=com1
/* : CKSEL0=CKSEL1=CKSEL3=0 ( RC- 8 ),
            BODEN=SUT1=SUT0=0 ( BOD Ures<2,7),
            WDTON=0 (  ),
            EESAVE=0 (  EEPROM )
            ("0"- )*/
// RC- 8 
//
# include <avr/io.h>           //  
# include <avr/eeprom.h>       //    EEPROM
# include <avr/wdt.h>          //    
# include <avr/pgmspace.h>     //  
# include <avr/interrupt.h>    //   
# define RED PB4               // PB4 -  
# define GREEN PB5             // PB5 -  
# define BLUE PB7              // PB7 -   ( )
# define A PC4                 // PC4 -    
# define B PC5                 // PC5 -  B  
# define ZAR1 PD7              // PD7 -    1- 
# define DOZAR1 PD6            // PD6 -    1- 
# define RAZR1 PD5             // PD5 -    1- 
# define ZAR2 PD4              // PD4 -    2- 
# define DOZAR2 PD3            // PD3 -    2- 
# define RAZR2 PC3             // PC3 -    2- 
# define ZAR3 PD2              // PD2 -    3- 
# define DOZAR3 PD1            // PD1 -    3- 
# define RAZR3 PD0             // PD0 -    3- 
# define Vref 2700             //       (2300...2560...2700)
                               //(   .21-20 )
# define Calibr 169            //   .RC=  8 
                               //(  Osc.Calibration Byte   0003
                               //     8)
# define ZAPR 60               //   _U  /2  
                               //         
                               //     _U
# define DOZAR 4               //       /2   
# define Nzam 10               //       
//
//  flash    *2      
static unsigned int __attribute__ ((progmem)) tymezar[]={
                                  396,   //"0" - 600 *
                                  494,   //"1" - 750 *
                                  658,   //"2" - 1000 *
                                  790,   //"3" - 1200 *
                                  856,   //"4" - 1300 *
                                  844,   //"5" - 1500 *
                                  902,   //"6" - 1600 *
                                 1014,   //"7" - 1800 *
                                 1126,   //"8" - 2000 *
                                 1184,   //"9" - 2100 *
                                 1240,   //"A" - 2200 *
                                 1296,   //"B" - 2300 *
                                 1352,   //"C" - 2400 *
                                 1408,   //"D" - 2500 *
                                 1522,   //"E" - 2700 *
                                 1578 }; //"F" - 2800 *
//  flash     *2      
static unsigned int __attribute__ ((progmem)) tymedzar[]={
                                  646,   //"0" - 600 *
                                  910,   //"1" - 750 *
                                 1208,   //"2" - 1000 *
                                 1456,   //"3" - 1200 *
                                 1574,   //"4" - 1300 *
                                 1676,   //"5" - 1500 *
                                 1786,   //"6" - 1600 *
                                 1998,   //"7" - 1800 *
                                 2228,   //"8" - 2000 *
                                 2348,   //"9" - 2100 *
                                 2456,   //"A" - 2200 *
                                 2564,   //"B" - 2300 *
                                 2682,   //"C" - 2400 *
                                 2790,   //"D" - 2500 *
                                 3020,   //"E" - 2700 *
                                 3128 }; //"F" - 2800 *
//
/*----  ----*/
volatile unsigned char effled[3];        //  
                                         //0-,1-./..,2-./..
unsigned char n_zam[3];                  //    (  )
volatile unsigned char pr=0;             //    
volatile unsigned char rezh[3];          //  1, 2  3- :
                                         //0- ,1-, 2-, 3-
                                         //4- , 5- ,6-..,
                                         //7 -   
volatile unsigned char rt[3];            //  : 0-, 1- , 2-
                                         //   
unsigned char sec[3];                    // 
volatile unsigned char taktLED=0;        //0,1,2 -     (.)
volatile unsigned int taym=0;            // 4,08   (0...65535)
volatile unsigned char takt_025=0;       // 0,25  
volatile unsigned char takt_05=0;        // 0,5  
volatile unsigned char taym_30[3];       //1 -     30 .
volatile unsigned char taym_1=0;         //1 -     1 .
unsigned char t_zapr[3];                 //1 -        
                                         //    _U   ZAPR  
                                         //2 -  _U 
volatile unsigned int taymer[3];         //      
unsigned int Uakk[3];                    //     
unsigned int Uakkmax[3];                 //      
//unsigned int Uakkxx[3];                  //        
unsigned int Uakkxx[3][Nzam];            //        
volatile unsigned char TMR[3];           //     0...F
volatile unsigned char TMR_1[3];         //    
//
/*----  ----*/
void apptest (void);                     //  
void indikat (void);                     //
void izmeren (void);                     //
void kommut (void);                      //   
void obrab(void);                        //  
void tayms (unsigned int t);             //  
void rdgleepr (void);                    //    EEPROM
void wrgleepr (unsigned char k);         //    EEPROM
//
/*----     .-.2----*/
ISR(TIMER2_OVF_vect)               //   .-.2 ( 4,096 )
{ register unsigned char m=0;      //   0...2
  wdt_reset();                     //  
  taym++;
  if (taym%61==0)                  //  0,25 
  { takt_025++;                    // 0,25 . 
  }
  if (taym%122==0)                 //  0,5 
  { takt_05++;                     // 0,5 . 
  }
  if (taym%244==0)                 //  1 
  { taym_1=1;                      //1 -     1 .
  }
  if (taym%7324==0)                //  30  (30/0.004096=7324.21875)
  { while (m<3)                    //  3- 
    { taym_30[m]=1;                //1 -     30 
      taymer[m]++;                 //    m- 
      if (taymer[m]%60==0)         //  ,  30 
      { eeprom_write_word(13+m*2, taymer[m]);//  EEPROM   m- .  13,14...17,18
      }
      m++;
    }
  }
  if (taym>58594)                  //  4 
  { taym=0;                        //   ( 4,096  )
  }
  indikat();                       // 
  taktLED++;                       // 
  if (taktLED>2) taktLED=0;        //   
  return;
}
//
/*================ ====================*/
int main(void)                     //  
{ DDRB=0b10110000;PORTB=0b11001111;//PB0...3,6-  .; PB4,5-  .0; PB7-  .1
  DDRC=0b00111000;PORTC=0b00110000;//PC0...2 -   ..; :PC3=0,PC4=PC5=1
  DDRD=0b11111111;PORTD=0b00000000;//PORTD -   .0
  OSCCAL=Calibr+10;                //   OSCALL    8  .RC-.
                                   //      (3.3  5)
  ACSR|=_BV(ACD);                  //ACSR(ACD)=1 -   
  rdgleepr();                      //    EEPROM
  TCCR2=0b00000101;                //F=Fclk/128,  ,  ..2
  TIFR|=_BV(TOV2);                 //TOV2=1 -      ..2
  TIMSK|=_BV(TOIE2);               //TOIE2=1 -     ..2 ( 4,096 )
  wdt_reset();                     //    
  wdt_enable(WDTO_1S);             //      1 .
  sei();                           //  
  t_zapr[0]=t_zapr[1]=t_zapr[2]=0; //      _U
  apptest();                       //  
  while(1)                         // 
  { if (pr>=3)                     //     3-  
    { pr=0;                        //     
      taym_1=0;                    //   1 
      izmeren();                   //
      obrab();                     //  
      kommut();                    // 
    }
  }
}
//
/*----  ----*/
void apptest (void)                 //  
{ unsigned char m=0;                //   (0...2)
  unsigned char rh[3];              //    
  unsigned char t=0;                //        
  tayms(200);                       //    
//  
  izmeren();                        //    
  while (m<3)                       //    
  { rt[m]=0;                        //  
    if ((Uakk[m]>200)&&(Uakk[m]<1600))// 0,2<U<1,6 ( )
    { rt[m]=1;                      //  
    }
    m++;
  }
//  
  m=0;
  while (m<3)                       //      
  { rh[m]=rezh[m];                  //  
    if (rt[m]==0)                   //     
    { rezh[m]=2;                    //       
    }
    else rezh[m]=0;                 // -       
    m++;
  }
  kommut();                         // 
  tayms(5);                         //   ,   
  izmeren();                        //   
  m=0;
  while (m<3)                       //    
  { if (rt[m]==0)                   //    
    { if (Uakk[m]<2540)             // U<2,54
      { rh[m]=7;                    //   
        rt[m]=1;                    //  
      }
      else rezh[m]=1;               // -       
    }
    m++;
  }
//  
  kommut();                         // 
  tayms(5);                         //   ,   
  izmeren();                        //   
  m=0;
  while (m<3)                       //    
  { if (rt[m]==0)                   //    
    { if (Uakk[m]>200)              // U>0,2 -   
      { rh[m]=7;                    //   
        rt[m]=1;                    //  
      }
      else rezh[m]=3;               // -    
    }
    m++;
  }
//  
  kommut();                         // 
  tayms(5);                         //   ,   
  izmeren();                        //   
  m=0;
  while (m<3)                       //    
  { if (rt[m]==0)                   //    
    { if (Uakk[m]<1650)             // U<1,65
      { rh[m]=7;                    //   
        rt[m]=1;                    //  
      }
      else rezh[m]=1;               // -       
    }
    m++;
  }
  kommut();                         // 
  tayms(5);                         //   ,   
  m=0;
// 
  while (m<3)                       //    ,   (   )
  { if (rt[m]==0)                   //     
    { rezh[m]=0;                    //   
      rt[m]=1;                      //    
      t=1;                          //  
    }
    m++;
  }
  kommut();                         // 
  m=0;
  while (m<3)                       //   
  { rezh[m]=rh[m];                  //        .
    m++;
  }
  if ((rezh[0]==7)||(rezh[1]==7)||(rezh[2]==7)||(t==1)) //     3- 
  { m=0;
    while (m<2)                     //    
    { PORTB&=~_BV(BLUE);            //BLUE=0;
      tayms(400);                   //
      PORTB|=_BV(BLUE);             //BLUE=1;
      tayms(400);                   //
      m++;
    }
  }
  return;
}
//
/*----------*/
void izmeren (void)                 //   
{ unsigned char m=0;                //   (0...2)
  unsigned char n=0;                //  
  unsigned char N=16;               // 
  unsigned int dADC=0;              //    
  unsigned long mVolt=0;            //      
  unsigned char r=0;                //    
  //   
  while (m<3)                       //  3   N  
  { ADMUX=(0b11000000|m);           //=2.56,  ,   
    dADC=0;                         //     
    if (rezh[m]==0)                 //  
    { Uakkmax[m]=0;                 //    
      n_zam[m]=0;                   //  
    }
    if ((taym_30[m]==1)&&((rezh[m]==3)||(rezh[m]==4)))//  30      
    { //     
      r=rezh[m];                    //  
      rezh[m]=0;                    //  
      kommut();                     // 
      tayms(20);                    // 20      
      while (n<N)                   //  N 
      { while (bit_is_set(ADCSR,ADSC));//  
        cli();                      // 
        ADCSR=0b11000110;           //  , F/64=125
        while (bit_is_set(ADCSR,ADSC));//  
        dADC+=ADCL;                 //   
        dADC+=(256*ADCH);           // 2-    
        sei();                      // 
        n++;
      }
      rezh[m]=r;                    //   
      kommut();                     // 
      dADC=dADC+N/2;                //  
      mVolt=dADC;                   //  unsigned int  unsigned long
      mVolt=((mVolt*Vref)/1024)/N;  //  
      if (n_zam[m]<Nzam)            //     (Nzam)
      { Uakkxx[m][n_zam[m]]=mVolt;  //       Uakkxx[m][Nzam]
        n_zam[m]++;                 //  
      }
      else                          //,    Nzam 
      { n=0;                        //    
        while (n<(Nzam-1))          //     Uakkxx[m][Nzam]   1
        { Uakkxx[m][n]=Uakkxx[m][n+1];//   
          n++;
        }
        Uakkxx[m][Nzam-1]=mVolt;    //       Uakkxx[m][Nzam-1]
      }
      if (rezh[m]==3)               //  
      { if (t_zapr[m]!=1)           //   _U
        { //   Nzam 
          n=0;                      //    
          Uakkmax[m]=0;             //  
          while (n<=(n_zam[m]-1))   //        
          { if (Uakkxx[m][n]>Uakkmax[m]) //   U  
            { Uakkmax[m]=Uakkxx[m][n];//  
            }
            n++;
          }
/*          if (Uakkxx[m]>Uakkmax[m]) //   U  
          { Uakkmax[m]=Uakkxx[m];   //    
          }
*/
        }
      }
      taym_30[m]=0;                 //  30       
    }
    else                            // -      
    { n=0;
      while (n<N)                   //  N 
      { while (bit_is_set(ADCSR,ADSC));//  
        cli();                      // 
        ADCSR=0b11000110;           //  , F/64=125
        while (bit_is_set(ADCSR,ADSC));//  
        dADC+=ADCL;                 //   
        dADC+=(256*ADCH);           // 2-    
        sei();                      // 
        n++;
      }
      dADC=dADC+N/2;                //  .
      mVolt=dADC;                   //  unsigned int  unsigned long
      mVolt=((mVolt*Vref)/1024)/N;  //  
      Uakk[m]=mVolt;                //    
    }
    n=0;                            //  
    m++;                            //  
  }
  return;                           //  t~
}
//
/*----   ----*/
void obrab (void)
{ unsigned char m=0;                //   (0..2)
  unsigned char k=0;                //   EEPROM
  //    
  while (m<3)                       //  3- 
  { if (TMR[m]!=TMR_1[m])           //    
    { if (rezh[m]!=7)               //   ..
      { effled[m]=2;                // ./. 
        takt_025=0;                 //  0,25.,     .
      }
    }
    if (rezh[m]==3)                 //  
    { if (taymer[m]>=ZAPR)          //  ZAPR    
      { if (t_zapr[m]==1)           //    _U    .. .
        { t_zapr[m]=2;              //     _U
        }
      }
      if (taymer[m]>pgm_read_word(tymezar+TMR[m]))//      
      { rezh[m]=4;                  //  
        Uakkmax[m]=0;               //    (   
                                    //.       U  
                                    // Uakkmax[m]
        n_zam[m]=0;                 //      
        wrgleepr(m+1);              //    EEPROM
      }
    }
    else
    { if (rezh[m]==4)               //   
      { if (taymer[m]>pgm_read_word(tymedzar+TMR[m]))//    
        { rezh[m]=5;                //  
          wrgleepr(m+1);            //    EEPROM
        }
        else
        { if (taymer[m]<pgm_read_word(tymezar+TMR[m]))//         
          { rezh[m]=3;              //  -    
            wrgleepr(m+1);          //    EEPROM
          }
        }
      }
    }
    //  
    if (rezh[m]<2)                  //  .,  
    { taymer[m]=0;                  //    
      if ((eeprom_read_word(m*2+13))>0)//  EEPROM       13,14...17,18
      { eeprom_write_word(13+m*2, 0);//  EEPROM    m- .   13,14...17,18
      }
    }
    m++;
  }
  //     
  m=0;
  while (m<3)                           //  3- 
  { switch (rezh[m])
    { case 0:                           //  
        Uakkmax[m]=0;                   //   
        t_zapr[m]=0;                    //    _U
        n_zam[m]=0;                     //  
        if (Uakk[m]<200)                // U<0,2 -  
        { rezh[m]=0;                    // 
        }
        else
        { if (Uakk[m]<1000)             //     U<1
          { rezh[m]=2;                  //-  
            taymer[m]=0;                //    
            k=m+1;                      //
          }
          else
          { rezh[m]=1;                  // -  (U>1)
            k=m+1;
          }
        }
        break;
      case 1:                           //  
        if (Uakk[m]<100)                //      
        { if (effled[m]==0)             //    .
          { sec[m]=0;                   //  
            takt_025=0;                 //  0,25.
            effled[m]=1;                // ./..
          }
          else if (effled[m]==1)        //  ./..
          { sec[m]++;
            if (sec[m]>2)               //  3 
            { rezh[m]=0;                //   
              effled[m]=0;              //  
              k=m+1;
            }
          }
        }
        else
        { if (Uakk[m]<600)              //    0,6
          { rezh[m]=2;                  //   
            taymer[m]=0;                //    
            n_zam[m]=0;                 //  
            t_zapr[m]=1;                //   _U    5 
            k=m+1;
          }
          else                          //,    >=0,6
          { if (effled[m]==1)           //   
            { rezh[m]=3;                //     
              n_zam[m]=0;               //  
              k=m+1;
              effled[m]=0;              //  
            }
          }
        }
        break;
      case 2:                           //   
        if (Uakk[m]>2200)               //    2,2
        { rezh[m]=0;                    //  
          k=m+1;
        }
        else
        { if ((Uakk[m]>1100)&&(taymer[m]>=DOZAR))//   1,1    DOZAR/2 
          { rezh[m]=3;                  //   
            n_zam[m]=0;                 //  
            t_zapr[m]=1;                //   _U    5 
            k=m+1;
          }
        }
        break;
      case 3:                           //  
        if (Uakk[m]>2000)               //    2 -  
        { rezh[m]=0;                    //   
          taymer[m]=0;                  //   
          n_zam[m]=0;                   //  
          k=m+1;
        }
        else
        { if (Uakk[m]>1950)             //    1,95
          { rezh[m]=6;                  // 
          }
          else
          if (n_zam[m]>0)               //      Uxx
          { if ((Uakkxx[m][n_zam[m]-1]+1)<Uakkmax[m]) //  U    2 
            { if (Uakkmax[m]>1350)      // . Umax>1,35 (  
                                        // U    .    0)
              { if ((t_zapr[m]==2)&&(taymer[m]<((pgm_read_word(tymezar+TMR[m]))/2)))//  
//    t<0.5T     .  . .-. .
                { rezh[m]=3;            //   "" 
                }
                else rezh[m]=5;         // -    " "
                t_zapr[m]=0;            //      ""
                Uakkmax[m]=0;           //   
                n_zam[m]=0;             //  
                k=m+1;
              }
            }
          }
        }
        break;
      case 4:                           //   
        if (Uakk[m]>2200)               //    2,2
        { rezh[m]=0;                    //  
          taymer[m]=0;                  //   
          n_zam[m]=0;                   //  
          k=m+1;
        }
        else
        { if (Uakk[m]>1800)             //    1,8
          { rezh[m]=6;                  // 
          }
          else
          { if (Uakkmax[m]>1600)        //    1,6
            { rezh[m]=5;                //    
              Uakkmax[m]=0;             //   
              n_zam[m]=0;               //  
              k=m+1;
            }
          }
        }
        break;
      case 5:                           //  
        if (Uakk[m]<200)                // U<0,2
        { rezh[m]=0;                    // 
          k=m+1;
        }
        break;
      case 6:                           //  
        if (Uakk[m]<200)                // U<0,2
        { rezh[m]=0;                    // 
          k=m+1;
        }
        break;
    }
    wrgleepr(k);                        //    EEPROM
    m++;
  }
  return;
}
//
/*----         ----*/
void indikat (void)
{ register unsigned char m=0;       //  
  m=taktLED;                        //    
  //  
  PORTC|=_BV(A);                    //A=1
  PORTC|=_BV(B);                    //B=1
  //
  if (rt[m]<2)                      //       - 
  { PORTB&=~_BV(RED);               //RED=0
    PORTB&=~_BV(GREEN);             //GREEN=0
  }
  else
  { if (effled[m]==1)               //  ./.. (   .. ..)
    { if (takt_025%2==0)            //   -  
      { PORTB|=_BV(RED);            //RED=1
        PORTB&=~_BV(GREEN);         //GREEN=0
      }
      else                          //,    -  
      { PORTB&=~_BV(RED);           //RED=0
        PORTB|=_BV(GREEN);          //GREEN=1
      }
    }
    else
    { if (effled[m]==2)             //  ./. . (   )
      { if (takt_025<5)             //    2- 
        { if (takt_025%2==0)        //   - += 
          { PORTB|=_BV(RED);        //RED=1
            PORTB|=_BV(GREEN);      //GREEN=1
          }
          else                      //,    -  
          { PORTB&=~_BV(RED);       //RED=0
            PORTB|=_BV(GREEN);      //GREEN=1
          }
        }
        else effled[m]=0;           //,   2  -   
      }
      else                          //,   
      { switch (rezh[m])
        { case 0:                   //   -  
            PORTB&=~_BV(RED);       //RED=0
            PORTB&=~_BV(GREEN);     //GREEN=0
            break;
          case 1:                   //   -  
            PORTB&=~_BV(RED);       //RED=0
            PORTB|=_BV(GREEN);      //GREEN=1
            break;
          case 2:                   //    -   
            if (takt_05%2==0)       //    
            { PORTB|=_BV(RED);      //RED=1
              PORTB|=_BV(GREEN);    //GREEN=1
            }
            else                    //,     
            { PORTB&=~_BV(RED);     //RED=0
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
            break;
          case 3:                   //   -  
            PORTB|=_BV(RED);        //RED=1
            PORTB&=~_BV(GREEN);     //GREEN=0
            break;
          case 4:                   //    -  
            PORTB|=_BV(RED);        //RED=1
            PORTB|=_BV(GREEN);      //GREEN=1
            break;
          case 5:                   //   -   
            if (takt_05%3==0)       //     3
            { PORTB&=~_BV(RED);     //RED=0
              PORTB|=_BV(GREEN);    //GREEN=1
            }
            else                    //,        3
            { PORTB&=~_BV(RED);     //RED=0
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
            break;
          case 6:                   //   -   
            if (takt_05%2==0)       //    
            { PORTB|=_BV(RED);      //RED=1
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
            else                    //,     
            { PORTB&=~_BV(RED);     //RED=0
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
            break;
          case 7:                   //    -    
            if (takt_05%3==0)       //     3
            { PORTB|=_BV(RED);      //RED=1
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
            else                    //,        3
            { PORTB&=~_BV(RED);     //RED=0
              PORTB&=~_BV(GREEN);   //GREEN=0
            }
        }
      }
    }
  }
  //         
  if (m==0)                         //   
  { PORTC&=~_BV(A);                 //A=0
    PORTC&=~_BV(B);                 //B=0
  }
  else
  { if (m==1)                       //   
    { PORTC|=_BV(A);                //A=1
      PORTC&=~_BV(B);               //B=0
    }
    else
    { if (m==2)                     //   
      { PORTC&=~_BV(A);             //A=0
        PORTC|=_BV(B);              //B=1
      }
    }
  }
  //     
  if ((taym_1==1)&&(pr<3))          //  1       . 3- .
  { tayms(1);                       // 1    
    TMR_1[m]=TMR[m];                //  
    TMR[m]=15-(PINB&0b00001111);    //    
    if (rt[m]==1)                   //    
    { TMR_1[m]=TMR[m];              //        
      rt[m]=2;                      //  
    }
    pr++;
  }
  return;
}
//
/*----    - ----*/
void kommut (void)
{ //1- :
  if ((rezh[0]==0)||(rezh[0]==5)||(rezh[0]==6)) // ,  , ..,  :
  { PORTD&=~_BV(ZAR1);              //ZAR1=0; DOZAR1=0, RAZR1=0;
    PORTD&=~_BV(DOZAR1);
    PORTD&=~_BV(RAZR1);
  }
  else
  { if (rezh[0]==1)                 //:
    { PORTD&=~_BV(ZAR1);            //ZAR1=0; DOZAR1=0, RAZR1=1;
      PORTD&=~_BV(DOZAR1);
      PORTD|=_BV(RAZR1);
    }
    else
    { if ((rezh[0]==2)||(rezh[0]==4))// ,  :
      { PORTD&=~_BV(ZAR1);          //ZAR1=0; DOZAR1=1, RAZR1=0;
        PORTD|=_BV(DOZAR1);
        PORTD&=~_BV(RAZR1);
      }
      else
      if (rezh[0]==3)               //:
      { PORTD|=_BV(ZAR1);           //ZAR1=1; DOZAR1=0  1, RAZR1=0;
        if (TMR[0]>4) PORTD|=_BV(DOZAR1);   //   310 ( 5...F)
        else PORTD&=~_BV(DOZAR1);   //   265
        PORTD&=~_BV(RAZR1);
      }
    }
  }
  //2- :
  if ((rezh[1]==0)||(rezh[1]==5)||(rezh[1]==6)) // ,  , ..,  :
  { PORTD&=~_BV(ZAR2);              //ZAR2=0; DOZAR2=0, RAZR2=0;
    PORTD&=~_BV(DOZAR2);
    PORTC&=~_BV(RAZR2);
  }
  else
  { if (rezh[1]==1)                 //:
    { PORTD&=~_BV(ZAR2);            //ZAR2=0; DOZAR2=0, RAZR2=1;
      PORTD&=~_BV(DOZAR2);
      PORTC|=_BV(RAZR2);
    }
    else
    { if ((rezh[1]==2)||(rezh[1]==4))// ,  :
      { PORTD&=~_BV(ZAR2);          //ZAR2=0; DOZAR2=1, RAZR2=0;
        PORTD|=_BV(DOZAR2);
        PORTC&=~_BV(RAZR2);
      }
      else
      if (rezh[1]==3)               //:
      { PORTD|=_BV(ZAR2);           //ZAR2=1; DOZAR2=0  1, RAZR2=0;
        if (TMR[1]>4) PORTD|=_BV(DOZAR2);   //   310 ( 5...F)
        else PORTD&=~_BV(DOZAR2);   //   265
        PORTC&=~_BV(RAZR2);
      }
    }
  }
  //3- :
  if ((rezh[2]==0)||(rezh[2]==5)||(rezh[2]==6)) // ,  , ..,  :
  { PORTD&=~_BV(ZAR3);              //ZAR3=0; DOZAR3=0, RAZR3=0;
    PORTD&=~_BV(DOZAR3);
    PORTD&=~_BV(RAZR3);
  }
  else
  { if (rezh[2]==1)                 //:
    { PORTD&=~_BV(ZAR3);            //ZAR3=0; DOZAR3=0, RAZR3=1;
      PORTD&=~_BV(DOZAR3);
      PORTD|=_BV(RAZR3);
    }
    else
    { if ((rezh[2]==2)||(rezh[2]==4))// ,  :
      { PORTD&=~_BV(ZAR3);          //ZAR3=0; DOZAR3=1, RAZR3=0;
        PORTD|=_BV(DOZAR3);
        PORTD&=~_BV(RAZR3);
      }
      else
      if (rezh[2]==3)               //:
      { PORTD|=_BV(ZAR3);           //ZAR3=1; DOZAR3=0  1, RAZR3=0;
        if (TMR[2]>4) PORTD|=_BV(DOZAR3);   //   310 ( 5...F)
        else PORTD&=~_BV(DOZAR3);   //   265
        PORTD&=~_BV(RAZR3);
      }
    }
  }
  return;
}
//
/*----- ms-----*/
void tayms (unsigned int t)
{ unsigned int t1;
  while (t!=0)
  { t1=7759;
    while (--t1!=0);
    t--;
  }
  return;
}
//
/*----     EEPROM----*/
void wrgleepr (unsigned char k)
{ if (k==0) return;
  cli();                               // 
  eeprom_write_byte(9+k, rezh[k-1]);   //   EEPROM rezh  .10...12;
  sei();                               // 
  k=0;                                 // 
  return;
}
//
/*----     EEPROM----*/
void rdgleepr (void)
{ unsigned char k=0;
  while (k<3)
  { rezh[k]=eeprom_read_byte(k+10);    //  EEPROM     10...12
    if (rezh[k]>5) rezh[k]=0;          //  
    taymer[k]=eeprom_read_word(k*2+13);//  EEPROM     13,14...17,18
    if (taymer[k]>60000) taymer[k]=0;  //  
    k++;
  }
  return;
}
//
/*
---------------------------------------------------------------------------------
=====================   ========================
---------------------------------------------------------------------------------
            -
 .    1    -
  ~45.    1     ~100
   0,6.           -
 3- .    -   ,  -
 .
       0,6   
  ~45.  2 .     1,1 
    265 (310,  C>=1500*).  30 
   20 ,     . 
     2   1,35  -  .
         
,  1,4.       35...45, 
        
(   ).     
,      , 
   0,2.     
 -   _U  _U  
5       ()   .
        .  -
   0,1        -
  2       . 
  1,95 (   )   -
.
     16     
        .  
         .
         rezh[m]   EEPROM.
         
.
        taymer[m] ,  30,
 taymer[m]   EEPROM.      
       .
---------------------------------------------------------------------------------
---------------------------------------------------------------------------------
  rezh[]:
0 -   ( )
1 - 
2 -  
3 - 
4 -  
5 -  
6 -  
7 -   
---------------------------------------------------------------------------------

---------------------------------------------------------------------------------
========      ==========
----------------------------------------------------------------------------------------
    | |        |              |         |
  .     |.|  , |      1,4 [     |      45  (0,2)    |
|  *  |         |    U]   |      [  ]     |
----------------------------------------------------------------------------------------
     "0"     |   600  |    265    | 3 10 (190)[198]| 2 00 (120)[125]|
     "1"     |   750  |    265    | 3 58 (238)[247]| 3 20 (200)[208]|
     "2"     |  1000  |    265    | 5 17 (317)[329]| 4 25 (265)[275]|
     "3"     |  1200  |    265    | 6 20 (380)[395]| 5 20 (320)[333]|
     "4"     |  1300  |    265    | 6 52 (412)[428]| 5 45 (345)[359]|
     "5"     |  1500  | 265+45=310| 6 46 (406)[422]| 6 40 (400)[416]|
     "6"     |  1600  | 265+45=310| 7 14 (434)[451]| 7 05 (425)[442]|
     "7"     |  1800  | 265+45=310| 8 08 (488)[507]| 8 00 (480)[492]|
     "8"     |  2000  | 265+45=310| 9 02 (542)[563]| 8 50 (530)[551]|
     "9"     |  2100  | 265+45=310| 9 29 (569)[592]| 9 20 (560)[582]|
     "A"     |  2200  | 265+45=310| 9 56 (596)[620]| 9 45 (585)[608]|
     "B"     |  2300  | 265+45=310|10 23 (623)[648]|10 10 (610)[634]|
     "C"     |  2400  | 265+45=310|10 50 (650)[676]|10 40 (640)[665]|
     "D"     |  2500  | 265+45=310|11 17 (677)[704]|11 05 (665)[691]|
     "E"     |  2700  | 265+45=310|12 12 (732)[761]|12 00 (720)[749]|
     "F"     |  2800  | 265+45=310|12 39 (759)[789]|12 25 (745)[775]|
-----------------------------------------------------------------------------------------

-------------------------------------------------------------------------------
===================   ======================
-------------------------------------------------------------------------------
1  -  
2  - 
3   (101010) -  
4 /    3-  -   
       (   )
5  - 
6  -  
7    (100100) -   
8   (101010) -  
9 /  (2 ) -   
    (  )
10    (100100) -   
-------------------------------------------------------------------------------
*/
//
/* :
1.0  
1.1    3      16
    .
1.2       .
1.2a   :
     -   Vref         
          (   .21-20 );
     -  Uakk[3], Uakkmax[3]  Uakkxx[3]   ;
     -       
        U,       5 .   -
           (  t_zapr[m]
         _U   ZAPR);
     -   U       -
        U>1,35;
     -    U    (  
               ),
            U>1,6;
     -      RC- 8  
              OSCCAL (
        Osc.Calibration Byte   0003   
         8 ),       (3,3
        5)   +5%.
1.2b   :
     -       
             ;
     -    _U    5   
           .
1.2c   :
     -            
       t<0.5T  ,         
       ""  "" (     
          );
     -       0,8   0,6 ;
     -     _U  5   30    
               
       ;
     -          U
         5   10      ;
     -         10   ;
1.2d   :
     -        _U
                U
         10   20      ;
     -     _U  60   30 .
         ATABA AT-508   1 ,    105 .
        MAX712/713       21...168 ,   
       5 . MAX712   ,     
       ,    ,  MAX713 -   
            2.5   .    
       MAX712  MAX713;
     -         20   30 ;
     -     4  16     ;
1.2e   :
     -         _U
                +21  +60. 
         UT71A,   2,699    .
              -
            , ..    , 
            ,  
       .         
          ,    N=10 , ..   5 .
             Uakk[3]   
       Uakkxx[3][N],      n_zam[3], 
         Uakkmax[m]     (n_zam[3]-1)
       ;
1.2f   :
     -         
            2   45,  
             1  1,1     
          1,7   1,95 .     
          (   );
*/
//
//
/*
Program:    4074 bytes (49.7% Full) ( 8192 bytes)
(.text + .data + .bootloader)

Data:        112 bytes (10.0% Full)
(.data + .bss + .noinit)
*/
