I/O REGISTER DEFINITIONS *****************************************
; NOTE:
; DEFINITIONS MARKED "MEMORY MAPPED"ARE EXTENDED I/O PORTS
; AND CANNOT BE USED WITH IN/OUT INSTRUCTIONS
.EQU	SREG	= 0X3F
.EQU	SPL	= 0X3D
.EQU	SPH	= 0X3E
.EQU	OCR0	= 0X3C
.EQU	GICR	= 0X3B
.EQU	GIFR	= 0X3A
.EQU	TIMSK	= 0X39
.EQU	TIFR	= 0X38
.EQU	SPMCSR	= 0X37
.EQU	TWCR	= 0X36
.EQU	MCUCR	= 0X35
.EQU	MCUCSR	= 0X34
.EQU	TCCR0	= 0X33
.EQU	TCNT0	= 0X32
.EQU	OSCCAL	= 0X31
.EQU	OCDR	= 0X31
.EQU	SFIOR	= 0X30
.EQU	TCCR1A	= 0X2F
.EQU	TCCR1B	= 0X2E
.EQU	TCNT1L	= 0X2C
.EQU	TCNT1H	= 0X2D
.EQU	OCR1AL	= 0X2A
.EQU	OCR1AH	= 0X2B
.EQU	OCR1BL	= 0X28
.EQU	OCR1BH	= 0X29
.EQU	ICR1L	= 0X26
.EQU	ICR1H	= 0X27
.EQU	TCCR2	= 0X25
.EQU	TCNT2	= 0X24
.EQU	OCR2	= 0X23
.EQU	ASSR	= 0X22
.EQU	WDTCR	= 0X21
.EQU	UBRRH	= 0X20
.EQU	UCSRC	= 0X20
.EQU	EEARL	= 0X1E
.EQU	EEARH	= 0X1F
.EQU	EEDR	= 0X1D
.EQU	EECR	= 0X1C
.EQU	PORTA	= 0X1B
.EQU	DDRA	= 0X1A
.EQU	PINA	= 0X19
.EQU	PORTB	= 0X18
.EQU	DDRB	= 0X17
.EQU	PINB	= 0X16
.EQU	PORTC	= 0X15
.EQU	DDRC	= 0X14
.EQU	PINC	= 0X13
.EQU	PORTD	= 0X12
.EQU	DDRD	= 0X11
.EQU	PIND	= 0X10
.EQU	SPDR	= 0X0F
.EQU	SPSR	= 0X0E
.EQU	SPCR	= 0X0D
.EQU	UDR	= 0X0C
.EQU	UCSRA	= 0X0B
.EQU	UCSRB	= 0X0A
.EQU	UBRRL	= 0X09
.EQU	ACSR	= 0X08
.EQU	ADMUX	= 0X07
.EQU	ADCSRA	= 0X06
.EQU	ADCH	= 0X05
.EQU	ADCL	= 0X04
.EQU	TWDR	= 0X03
.EQU	TWAR	= 0X02
.EQU	TWSR	= 0X01
.EQU	TWBR	= 0X00


; ***** BIT DEFINITIONS **************************************************

; ***** TIMER_COUNTER_0 **************
; TCCR0 - TIMER/COUNTER CONTROL REGISTER
.EQU	CS00	= 0	; CLOCK SELECT 1
.EQU	CS01	= 1	; CLOCK SELECT 1
.EQU	CS02	= 2	; CLOCK SELECT 2
.EQU	WGM01	= 3	; WAVEFORM GENERATION MODE 1
.EQU	CTC0	= WGM01	; FOR COMPATIBILITY
.EQU	COM00	= 4	; COMPARE MATCH OUTPUT MODE 0
.EQU	COM01	= 5	; COMPARE MATCH OUTPUT MODE 1
.EQU	WGM00	= 6	; WAVEFORM GENERATION MODE 0
.EQU	PWM0	= WGM00	; FOR COMPATIBILITY
.EQU	FOC0	= 7	; FORCE OUTPUT COMPARE

; TCNT0 - TIMER/COUNTER REGISTER
.EQU	TCNT0_0	= 0	;
.EQU	TCNT0_1	= 1	;
.EQU	TCNT0_2	= 2	;
.EQU	TCNT0_3	= 3	;
.EQU	TCNT0_4	= 4	;
.EQU	TCNT0_5	= 5	;
.EQU	TCNT0_6	= 6	;
.EQU	TCNT0_7	= 7	;

; OCR0 - OUTPUT COMPARE REGISTER
.EQU	OCR0_0	= 0	;
.EQU	OCR0_1	= 1	;
.EQU	OCR0_2	= 2	;
.EQU	OCR0_3	= 3	;
.EQU	OCR0_4	= 4	;
.EQU	OCR0_5	= 5	;
.EQU	OCR0_6	= 6	;
.EQU	OCR0_7	= 7	;

; TIMSK - TIMER/COUNTER INTERRUPT MASK REGISTER
.EQU	TOIE0	= 0	; TIMER/COUNTER0 OVERFLOW INTERRUPT ENABLE
.EQU	OCIE0	= 1	; TIMER/COUNTER0 OUTPUT COMPARE MATCH INTERRUPT REGISTER

; TIFR - TIMER/COUNTER INTERRUPT FLAG REGISTER
.EQU	TOV0	= 0	; TIMER/COUNTER0 OVERFLOW FLAG
.EQU	OCF0	= 1	; OUTPUT COMPARE FLAG 0

; SFIOR - SPECIAL FUNCTION IO REGISTER
.EQU	PSR10	= 0	; PRESCALER RESET TIMER/COUNTER1 AND TIMER/COUNTER0


; ***** TIMER_COUNTER_1 **************
; TIMSK - TIMER/COUNTER INTERRUPT MASK REGISTER
.EQU	TOIE1	= 2	; TIMER/COUNTER1 OVERFLOW INTERRUPT ENABLE
.EQU	OCIE1B	= 3	; TIMER/COUNTER1 OUTPUT COMPAREB MATCH INTERRUPT ENABLE
.EQU	OCIE1A	= 4	; TIMER/COUNTER1 OUTPUT COMPAREA MATCH INTERRUPT ENABLE
.EQU	TICIE1	= 5	; TIMER/COUNTER1 INPUT CAPTURE INTERRUPT ENABLE

; TIFR - TIMER/COUNTER INTERRUPT FLAG REGISTER
.EQU	TOV1	= 2	; TIMER/COUNTER1 OVERFLOW FLAG
.EQU	OCF1B	= 3	; OUTPUT COMPARE FLAG 1B
.EQU	OCF1A	= 4	; OUTPUT COMPARE FLAG 1A
.EQU	ICF1	= 5	; INPUT CAPTURE FLAG 1

; TCCR1A - TIMER/COUNTER1 CONTROL REGISTER A
.EQU	WGM10	= 0	; WAVEFORM GENERATION MODE
.EQU	PWM10	= WGM10	; FOR COMPATIBILITY
.EQU	WGM11	= 1	; WAVEFORM GENERATION MODE
.EQU	PWM11	= WGM11	; FOR COMPATIBILITY
.EQU	FOC1B	= 2	; FORCE OUTPUT COMPARE 1B
.EQU	FOC1A	= 3	; FORCE OUTPUT COMPARE 1A
.EQU	COM1B0	= 4	; COMPARE OUTPUT MODE 1B, BIT 0
.EQU	COM1B1	= 5	; COMPARE OUTPUT MODE 1B, BIT 1
.EQU	COM1A0	= 6	; COMPARE OUPUT MODE 1A, BIT 0
.EQU	COM1A1	= 7	; COMPARE OUTPUT MODE 1A, BIT 1

; TCCR1B - TIMER/COUNTER1 CONTROL REGISTER B
.EQU	CS10	= 0	; PRESCALER SOURCE OF TIMER/COUNTER 1
.EQU	CS11	= 1	; PRESCALER SOURCE OF TIMER/COUNTER 1
.EQU	CS12	= 2	; PRESCALER SOURCE OF TIMER/COUNTER 1
.EQU	WGM12	= 3	; WAVEFORM GENERATION MODE
.EQU	CTC10	= WGM12	; FOR COMPATIBILITY
.EQU	CTC1	= WGM12	; FOR COMPATIBILITY
.EQU	WGM13	= 4	; WAVEFORM GENERATION MODE
.EQU	CTC11	= WGM13	; FOR COMPATIBILITY
.EQU	ICES1	= 6	; INPUT CAPTURE 1 EDGE SELECT
.EQU	ICNC1	= 7	; INPUT CAPTURE 1 NOISE CANCELER


; ***** EXTERNAL_INTERRUPT ***********
; GICR - GENERAL INTERRUPT CONTROL REGISTER
.EQU	GIMSK	= GICR	; FOR COMPATIBILITY
.EQU	IVCE	= 0	; INTERRUPT VECTOR CHANGE ENABLE
.EQU	IVSEL	= 1	; INTERRUPT VECTOR SELECT
.EQU	INT2	= 5	; EXTERNAL INTERRUPT REQUEST 2 ENABLE
.EQU	INT0	= 6	; EXTERNAL INTERRUPT REQUEST 0 ENABLE
.EQU	INT1	= 7	; EXTERNAL INTERRUPT REQUEST 1 ENABLE

; GIFR - GENERAL INTERRUPT FLAG REGISTER
.EQU	INTF2	= 5	; EXTERNAL INTERRUPT FLAG 2
.EQU	INTF0	= 6	; EXTERNAL INTERRUPT FLAG 0
.EQU	INTF1	= 7	; EXTERNAL INTERRUPT FLAG 1

; MCUCR - GENERAL INTERRUPT CONTROL REGISTER
.EQU	ISC00	= 0	; INTERRUPT SENSE CONTROL 0 BIT 0
.EQU	ISC01	= 1	; INTERRUPT SENSE CONTROL 0 BIT 1
.EQU	ISC10	= 2	; INTERRUPT SENSE CONTROL 1 BIT 0
.EQU	ISC11	= 3	; INTERRUPT SENSE CONTROL 1 BIT 1

; MCUCSR - MCU CONTROL AND STATUS REGISTER
.EQU	ISC2	= 6	; INTERRUPT SENSE CONTROL 2


; ***** EEPROM ***********************
; EEDR - EEPROM DATA REGISTER
.EQU	EEDR0	= 0	; EEPROM DATA REGISTER BIT 0
.EQU	EEDR1	= 1	; EEPROM DATA REGISTER BIT 1
.EQU	EEDR2	= 2	; EEPROM DATA REGISTER BIT 2
.EQU	EEDR3	= 3	; EEPROM DATA REGISTER BIT 3
.EQU	EEDR4	= 4	; EEPROM DATA REGISTER BIT 4
.EQU	EEDR5	= 5	; EEPROM DATA REGISTER BIT 5
.EQU	EEDR6	= 6	; EEPROM DATA REGISTER BIT 6
.EQU	EEDR7	= 7	; EEPROM DATA REGISTER BIT 7

; EECR - EEPROM CONTROL REGISTER
.EQU	EERE	= 0	; EEPROM READ ENABLE
.EQU	EEWE	= 1	; EEPROM WRITE ENABLE
.EQU	EEMWE	= 2	; EEPROM MASTER WRITE ENABLE
.EQU	EEWEE	= EEMWE	; FOR COMPATIBILITY
.EQU	EERIE	= 3	; EEPROM READY INTERRUPT ENABLE


; ***** CPU **************************
; SREG - STATUS REGISTER
.EQU	SREG_C	= 0	; CARRY FLAG
.EQU	SREG_Z	= 1	; ZERO FLAG
.EQU	SREG_N	= 2	; NEGATIVE FLAG
.EQU	SREG_V	= 3	; TWO'S COMPLEMENT OVERFLOW FLAG
.EQU	SREG_S	= 4	; SIGN BIT
.EQU	SREG_H	= 5	; HALF CARRY FLAG
.EQU	SREG_T	= 6	; BIT COPY STORAGE
.EQU	SREG_I	= 7	; GLOBAL INTERRUPT ENABLE

; MCUCR - MCU CONTROL REGISTER
;.EQU	ISC00	= 0	; INTERRUPT SENSE CONTROL 0 BIT 0
;.EQU	ISC01	= 1	; INTERRUPT SENSE CONTROL 0 BIT 1
;.EQU	ISC10	= 2	; INTERRUPT SENSE CONTROL 1 BIT 0
;.EQU	ISC11	= 3	; INTERRUPT SENSE CONTROL 1 BIT 1
.EQU	SM0	= 4	; SLEEP MODE SELECT
.EQU	SM1	= 5	; SLEEP MODE SELECT
.EQU	SE	= 6	; SLEEP ENABLE
.EQU	SM2	= 7	; SLEEP MODE SELECT

; MCUCSR - MCU CONTROL AND STATUS REGISTER
.EQU	MCUSR	= MCUCSR	; FOR COMPATIBILITY
.EQU	PORF	= 0	; POWER-ON RESET FLAG
.EQU	EXTRF	= 1	; EXTERNAL RESET FLAG
.EQU	EXTREF	= EXTRF	; FOR COMPATIBILITY
.EQU	BORF	= 2	; BROWN-OUT RESET FLAG
.EQU	WDRF	= 3	; WATCHDOG RESET FLAG
.EQU	JTRF	= 4	; JTAG RESET FLAG
.EQU	JTD	= 7	; JTAG INTERFACE DISABLE

; OSCCAL - OSCILLATOR CALIBRATION VALUE
.EQU	CAL0	= 0	; OSCILLATOR CALIBRATION VALUE BIT0
.EQU	CAL1	= 1	; OSCILLATOR CALIBRATION VALUE BIT1
.EQU	CAL2	= 2	; OSCILLATOR CALIBRATION VALUE BIT2
.EQU	CAL3	= 3	; OSCILLATOR CALIBRATION VALUE BIT3
.EQU	CAL4	= 4	; OSCILLATOR CALIBRATION VALUE BIT4
.EQU	CAL5	= 5	; OSCILLATOR CALIBRATION VALUE BIT5
.EQU	CAL6	= 6	; OSCILLATOR CALIBRATION VALUE BIT6
.EQU	CAL7	= 7	; OSCILLATOR CALIBRATION VALUE BIT7

; SFIOR - SPECIAL FUNCTION I/O REGISTER
;.EQU	PSR10	= 0	; PRESCALER RESET
.EQU	PSR2	= 1	; PRESCALER RESET
.EQU	PUD	= 2	; PULL-UP DISABLE


; ***** TIMER_COUNTER_2 **************
; TIMSK - TIMER/COUNTER INTERRUPT MASK REGISTER
.EQU	TOIE2	= 6	; TIMER/COUNTER2 OVERFLOW INTERRUPT ENABLE
.EQU	OCIE2	= 7	; TIMER/COUNTER2 OUTPUT COMPARE MATCH INTERRUPT ENABLE

; TIFR - TIMER/COUNTER INTERRUPT FLAG REGISTER
.EQU	TOV2	= 6	; TIMER/COUNTER2 OVERFLOW FLAG
.EQU	OCF2	= 7	; OUTPUT COMPARE FLAG 2

; TCCR2 - TIMER/COUNTER2 CONTROL REGISTER
.EQU	CS20	= 0	; CLOCK SELECT BIT 0
.EQU	CS21	= 1	; CLOCK SELECT BIT 1
.EQU	CS22	= 2	; CLOCK SELECT BIT 2
.EQU	WGM21	= 3	; WAVEFORM GENERATION MODE
.EQU	CTC2	= WGM21	; FOR COMPATIBILITY
.EQU	COM20	= 4	; COMPARE OUTPUT MODE BIT 0
.EQU	COM21	= 5	; COMPARE OUTPUT MODE BIT 1
.EQU	WGM20	= 6	; WAVEFORM GENRATION MODE
.EQU	PWM2	= WGM20	; FOR COMPATIBILITY
.EQU	FOC2	= 7	; FORCE OUTPUT COMPARE

; TCNT2 - TIMER/COUNTER2
.EQU	TCNT2_0	= 0	; TIMER/COUNTER 2 BIT 0
.EQU	TCNT2_1	= 1	; TIMER/COUNTER 2 BIT 1
.EQU	TCNT2_2	= 2	; TIMER/COUNTER 2 BIT 2
.EQU	TCNT2_3	= 3	; TIMER/COUNTER 2 BIT 3
.EQU	TCNT2_4	= 4	; TIMER/COUNTER 2 BIT 4
.EQU	TCNT2_5	= 5	; TIMER/COUNTER 2 BIT 5
.EQU	TCNT2_6	= 6	; TIMER/COUNTER 2 BIT 6
.EQU	TCNT2_7	= 7	; TIMER/COUNTER 2 BIT 7

; OCR2 - TIMER/COUNTER2 OUTPUT COMPARE REGISTER
.EQU	OCR2_0	= 0	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 0
.EQU	OCR2_1	= 1	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 1
.EQU	OCR2_2	= 2	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 2
.EQU	OCR2_3	= 3	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 3
.EQU	OCR2_4	= 4	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 4
.EQU	OCR2_5	= 5	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 5
.EQU	OCR2_6	= 6	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 6
.EQU	OCR2_7	= 7	; TIMER/COUNTER2 OUTPUT COMPARE REGISTER BIT 7

; ASSR - ASYNCHRONOUS STATUS REGISTER
.EQU	TCR2UB	= 0	; TIMER/COUNTER CONTROL REGISTER2 UPDATE BUSY
.EQU	OCR2UB	= 1	; OUTPUT COMPARE REGISTER2 UPDATE BUSY
.EQU	TCN2UB	= 2	; TIMER/COUNTER2 UPDATE BUSY
.EQU	AS2	= 3	; ASYNCHRONOUS TIMER/COUNTER2

; SFIOR - SPECIAL FUNCTION IO REGISTER
;.EQU	PSR2	= 1	; PRESCALER RESET TIMER/COUNTER2


; ***** SPI **************************
; SPDR - SPI DATA REGISTER
.EQU	SPDR0	= 0	; SPI DATA REGISTER BIT 0
.EQU	SPDR1	= 1	; SPI DATA REGISTER BIT 1
.EQU	SPDR2	= 2	; SPI DATA REGISTER BIT 2
.EQU	SPDR3	= 3	; SPI DATA REGISTER BIT 3
.EQU	SPDR4	= 4	; SPI DATA REGISTER BIT 4
.EQU	SPDR5	= 5	; SPI DATA REGISTER BIT 5
.EQU	SPDR6	= 6	; SPI DATA REGISTER BIT 6
.EQU	SPDR7	= 7	; SPI DATA REGISTER BIT 7

; SPSR - SPI STATUS REGISTER
.EQU	SPI2X	= 0	; DOUBLE SPI SPEED BIT
.EQU	WCOL	= 6	; WRITE COLLISION FLAG
.EQU	SPIF	= 7	; SPI INTERRUPT FLAG

; SPCR - SPI CONTROL REGISTER
.EQU	SPR0	= 0	; SPI CLOCK RATE SELECT 0
.EQU	SPR1	= 1	; SPI CLOCK RATE SELECT 1
.EQU	CPHA	= 2	; CLOCK PHASE
.EQU	CPOL	= 3	; CLOCK POLARITY
.EQU	MSTR	= 4	; MASTER/SLAVE SELECT
.EQU	DORD	= 5	; DATA ORDER
.EQU	SPE	= 6	; SPI ENABLE
.EQU	SPIE	= 7	; SPI INTERRUPT ENABLE


; ***** USART ************************
; UDR - USART I/O DATA REGISTER
.EQU	UDR0	= 0	; USART I/O DATA REGISTER BIT 0
.EQU	UDR1	= 1	; USART I/O DATA REGISTER BIT 1
.EQU	UDR2	= 2	; USART I/O DATA REGISTER BIT 2
.EQU	UDR3	= 3	; USART I/O DATA REGISTER BIT 3
.EQU	UDR4	= 4	; USART I/O DATA REGISTER BIT 4
.EQU	UDR5	= 5	; USART I/O DATA REGISTER BIT 5
.EQU	UDR6	= 6	; USART I/O DATA REGISTER BIT 6
.EQU	UDR7	= 7	; USART I/O DATA REGISTER BIT 7

; UCSRA - USART CONTROL AND STATUS REGISTER A
.EQU	USR	= UCSRA	; FOR COMPATIBILITY
.EQU	MPCM	= 0	; MULTI-PROCESSOR COMMUNICATION MODE
.EQU	U2X	= 1	; DOUBLE THE USART TRANSMISSION SPEED
.EQU	UPE	= 2	; PARITY ERROR
.EQU	PE	= UPE	; FOR COMPATIBILITY
.EQU	DOR	= 3	; DATA OVERRUN
.EQU	FE	= 4	; FRAMING ERROR
.EQU	UDRE	= 5	; USART DATA REGISTER EMPTY
.EQU	TXC	= 6	; USART TRANSMITT COMPLETE
.EQU	RXC	= 7	; USART RECEIVE COMPLETE

; UCSRB - USART CONTROL AND STATUS REGISTER B
.EQU	UCR	= UCSRB	; FOR COMPATIBILITY
.EQU	TXB8	= 0	; TRANSMIT DATA BIT 8
.EQU	RXB8	= 1	; RECEIVE DATA BIT 8
.EQU	UCSZ2	= 2	; CHARACTER SIZE
.EQU	CHR9	= UCSZ2	; FOR COMPATIBILITY
.EQU	TXEN	= 3	; TRANSMITTER ENABLE
.EQU	RXEN	= 4	; RECEIVER ENABLE
.EQU	UDRIE	= 5	; USART DATA REGISTER EMPTY INTERRUPT ENABLE
.EQU	TXCIE	= 6	; TX COMPLETE INTERRUPT ENABLE
.EQU	RXCIE	= 7	; RX COMPLETE INTERRUPT ENABLE

; UCSRC - USART CONTROL AND STATUS REGISTER C
.EQU	UCPOL	= 0	; CLOCK POLARITY
.EQU	UCSZ0	= 1	; CHARACTER SIZE
.EQU	UCSZ1	= 2	; CHARACTER SIZE
.EQU	USBS	= 3	; STOP BIT SELECT
.EQU	UPM0	= 4	; PARITY MODE BIT 0
.EQU	UPM1	= 5	; PARITY MODE BIT 1
.EQU	UMSEL	= 6	; USART MODE SELECT
.EQU	URSEL	= 7	; REGISTER SELECT

.EQU	UBRRHI	= UBRRH	; FOR COMPATIBILITY

; ***** TWI **************************
; TWBR - TWI BIT RATE REGISTER
.EQU	I2BR	= TWBR	; FOR COMPATIBILITY
.EQU	TWBR0	= 0	;
.EQU	TWBR1	= 1	;
.EQU	TWBR2	= 2	;
.EQU	TWBR3	= 3	;
.EQU	TWBR4	= 4	;
.EQU	TWBR5	= 5	;
.EQU	TWBR6	= 6	;
.EQU	TWBR7	= 7	;

; TWCR - TWI CONTROL REGISTER
.EQU	I2CR	= TWCR	; FOR COMPATIBILITY
.EQU	TWIE	= 0	; TWI INTERRUPT ENABLE
.EQU	I2IE	= TWIE	; FOR COMPATIBILITY
.EQU	TWEN	= 2	; TWI ENABLE BIT
.EQU	I2EN	= TWEN	; FOR COMPATIBILITY
.EQU	ENI2C	= TWEN	; FOR COMPATIBILITY
.EQU	TWWC	= 3	; TWI WRITE COLLITION FLAG
.EQU	I2WC	= TWWC	; FOR COMPATIBILITY
.EQU	TWSTO	= 4	; TWI STOP CONDITION BIT
.EQU	I2STO	= TWSTO	; FOR COMPATIBILITY
.EQU	TWSTA	= 5	; TWI START CONDITION BIT
.EQU	I2STA	= TWSTA	; FOR COMPATIBILITY
.EQU	TWEA	= 6	; TWI ENABLE ACKNOWLEDGE BIT
.EQU	I2EA	= TWEA	; FOR COMPATIBILITY
.EQU	TWINT	= 7	; TWI INTERRUPT FLAG
.EQU	I2INT	= TWINT	; FOR COMPATIBILITY

; TWSR - TWI STATUS REGISTER
.EQU	I2SR	= TWSR	; FOR COMPATIBILITY
.EQU	TWPS0	= 0	; TWI PRESCALER
.EQU	TWS0	= TWPS0	; FOR COMPATIBILITY
.EQU	I2GCE	= TWPS0	; FOR COMPATIBILITY
.EQU	TWPS1	= 1	; TWI PRESCALER
.EQU	TWS1	= TWPS1	; FOR COMPATIBILITY
.EQU	TWS3	= 3	; TWI STATUS
.EQU	I2S3	= TWS3	; FOR COMPATIBILITY
.EQU	TWS4	= 4	; TWI STATUS
.EQU	I2S4	= TWS4	; FOR COMPATIBILITY
.EQU	TWS5	= 5	; TWI STATUS
.EQU	I2S5	= TWS5	; FOR COMPATIBILITY
.EQU	TWS6	= 6	; TWI STATUS
.EQU	I2S6	= TWS6	; FOR COMPATIBILITY
.EQU	TWS7	= 7	; TWI STATUS
.EQU	I2S7	= TWS7	; FOR COMPATIBILITY

; TWDR - TWI DATA REGISTER
.EQU	I2DR	= TWDR	; FOR COMPATIBILITY
.EQU	TWD0	= 0	; TWI DATA REGISTER BIT 0
.EQU	TWD1	= 1	; TWI DATA REGISTER BIT 1
.EQU	TWD2	= 2	; TWI DATA REGISTER BIT 2
.EQU	TWD3	= 3	; TWI DATA REGISTER BIT 3
.EQU	TWD4	= 4	; TWI DATA REGISTER BIT 4
.EQU	TWD5	= 5	; TWI DATA REGISTER BIT 5
.EQU	TWD6	= 6	; TWI DATA REGISTER BIT 6
.EQU	TWD7	= 7	; TWI DATA REGISTER BIT 7

; TWAR - TWI (SLAVE) ADDRESS REGISTER
.EQU	I2AR	= TWAR	; FOR COMPATIBILITY
.EQU	TWGCE	= 0	; TWI GENERAL CALL RECOGNITION ENABLE BIT
.EQU	TWA0	= 1	; TWI (SLAVE) ADDRESS REGISTER BIT 0
.EQU	TWA1	= 2	; TWI (SLAVE) ADDRESS REGISTER BIT 1
.EQU	TWA2	= 3	; TWI (SLAVE) ADDRESS REGISTER BIT 2
.EQU	TWA3	= 4	; TWI (SLAVE) ADDRESS REGISTER BIT 3
.EQU	TWA4	= 5	; TWI (SLAVE) ADDRESS REGISTER BIT 4
.EQU	TWA5	= 6	; TWI (SLAVE) ADDRESS REGISTER BIT 5
.EQU	TWA6	= 7	; TWI (SLAVE) ADDRESS REGISTER BIT 6


; ***** ANALOG_COMPARATOR ************
; SFIOR - SPECIAL FUNCTION IO REGISTER
.EQU	ACME	= 3	; ANALOG COMPARATOR MULTIPLEXER ENABLE

; ACSR - ANALOG COMPARATOR CONTROL AND STATUS REGISTER
.EQU	ACIS0	= 0	; ANALOG COMPARATOR INTERRUPT MODE SELECT BIT 0
.EQU	ACIS1	= 1	; ANALOG COMPARATOR INTERRUPT MODE SELECT BIT 1
.EQU	ACIC	= 2	; ANALOG COMPARATOR INPUT CAPTURE ENABLE
.EQU	ACIE	= 3	; ANALOG COMPARATOR INTERRUPT ENABLE
.EQU	ACI	= 4	; ANALOG COMPARATOR INTERRUPT FLAG
.EQU	ACO	= 5	; ANALOG COMPARE OUTPUT
.EQU	ACBG	= 6	; ANALOG COMPARATOR BANDGAP SELECT
.EQU	ACD	= 7	; ANALOG COMPARATOR DISABLE


; ***** AD_CONVERTER *****************
; ADMUX - THE ADC MULTIPLEXER SELECTION REGISTER
.EQU	MUX0	= 0	; ANALOG CHANNEL AND GAIN SELECTION BITS
.EQU	MUX1	= 1	; ANALOG CHANNEL AND GAIN SELECTION BITS
.EQU	MUX2	= 2	; ANALOG CHANNEL AND GAIN SELECTION BITS
.EQU	MUX3	= 3	; ANALOG CHANNEL AND GAIN SELECTION BITS
.EQU	MUX4	= 4	; ANALOG CHANNEL AND GAIN SELECTION BITS
.EQU	ADLAR	= 5	; LEFT ADJUST RESULT
.EQU	REFS0	= 6	; REFERENCE SELECTION BIT 0
.EQU	REFS1	= 7	; REFERENCE SELECTION BIT 1

; ADCSRA - THE ADC CONTROL AND STATUS REGISTER
.EQU	ADCSR	= ADCSRA	; FOR COMPATIBILITY
.EQU	ADPS0	= 0	; ADC  PRESCALER SELECT BITS
.EQU	ADPS1	= 1	; ADC  PRESCALER SELECT BITS
.EQU	ADPS2	= 2	; ADC  PRESCALER SELECT BITS
.EQU	ADIE	= 3	; ADC INTERRUPT ENABLE
.EQU	ADIF	= 4	; ADC INTERRUPT FLAG
.EQU	ADATE	= 5	; WHEN THIS BIT IS WRITTEN TO ONE,THE TIMER/COUNTER2 PRESCALER WILL BE RESET.THE BIT WILL BE CLEARED BY HARDWARE AFTER THE OPERATION IS PERFORMED.WRITING A ZERO TO THIS BIT WILL HAVE NO EFFECT.THIS BIT WILL ALWAYS BE READ AS ZERO IF TIMER/C                 OUNTER2 IS CLOCKED BY THE INTERNAL CPU CLOCK.IF THIS BIT IS WRITTEN WHEN TIMER/COUNTER2 IS OPERATING IN ASYNCHRONOUS MODE,THE BIT WILL REMAIN ONE UNTIL THE PRESCALER HAS BEEN RESET.
.EQU	ADFR	= ADATE	; FOR COMPATIBILITY
.EQU	ADSC	= 6	; ADC START CONVERSION
.EQU	ADEN	= 7	; ADC ENABLE

; ADCH - ADC DATA REGISTER HIGH BYTE
.EQU	ADCH0	= 0	; ADC DATA REGISTER HIGH BYTE BIT 0
.EQU	ADCH1	= 1	; ADC DATA REGISTER HIGH BYTE BIT 1
.EQU	ADCH2	= 2	; ADC DATA REGISTER HIGH BYTE BIT 2
.EQU	ADCH3	= 3	; ADC DATA REGISTER HIGH BYTE BIT 3
.EQU	ADCH4	= 4	; ADC DATA REGISTER HIGH BYTE BIT 4
.EQU	ADCH5	= 5	; ADC DATA REGISTER HIGH BYTE BIT 5
.EQU	ADCH6	= 6	; ADC DATA REGISTER HIGH BYTE BIT 6
.EQU	ADCH7	= 7	; ADC DATA REGISTER HIGH BYTE BIT 7

; ADCL - ADC DATA REGISTER LOW BYTE
.EQU	ADCL0	= 0	; ADC DATA REGISTER LOW BYTE BIT 0
.EQU	ADCL1	= 1	; ADC DATA REGISTER LOW BYTE BIT 1
.EQU	ADCL2	= 2	; ADC DATA REGISTER LOW BYTE BIT 2
.EQU	ADCL3	= 3	; ADC DATA REGISTER LOW BYTE BIT 3
.EQU	ADCL4	= 4	; ADC DATA REGISTER LOW BYTE BIT 4
.EQU	ADCL5	= 5	; ADC DATA REGISTER LOW BYTE BIT 5
.EQU	ADCL6	= 6	; ADC DATA REGISTER LOW BYTE BIT 6
.EQU	ADCL7	= 7	; ADC DATA REGISTER LOW BYTE BIT 7

; SFIOR - SPECIAL FUNCTION IO REGISTER
.EQU	ADTS0	= 5	; ADC AUTO TRIGGER SOURCE 0
.EQU	ADTS1	= 6	; ADC AUTO TRIGGER SOURCE 1
.EQU	ADTS2	= 7	; ADC AUTO TRIGGER SOURCE 2


; ***** JTAG *************************
; OCDR - ON-CHIP DEBUG RELATED REGISTER IN I/O MEMORY
.EQU	OCDR0	= 0	; ON-CHIP DEBUG REGISTER BIT 0
.EQU	OCDR1	= 1	; ON-CHIP DEBUG REGISTER BIT 1
.EQU	OCDR2	= 2	; ON-CHIP DEBUG REGISTER BIT 2
.EQU	OCDR3	= 3	; ON-CHIP DEBUG REGISTER BIT 3
.EQU	OCDR4	= 4	; ON-CHIP DEBUG REGISTER BIT 4
.EQU	OCDR5	= 5	; ON-CHIP DEBUG REGISTER BIT 5
.EQU	OCDR6	= 6	; ON-CHIP DEBUG REGISTER BIT 6
.EQU	OCDR7	= 7	; ON-CHIP DEBUG REGISTER BIT 7
.EQU	IDRD	= OCDR7	; FOR COMPATIBILITY

; MCUCSR - MCU CONTROL AND STATUS REGISTER
;.EQU	JTRF	= 4	; JTAG RESET FLAG
;.EQU	JTD	= 7	; JTAG INTERFACE DISABLE


; ***** BOOT_LOAD ********************
; SPMCSR - STORE PROGRAM MEMORY CONTROL REGISTER
.EQU	SPMCR	= SPMCSR	; FOR COMPATIBILITY
.EQU	SPMEN	= 0	; STORE PROGRAM MEMORY ENABLE
.EQU	PGERS	= 1	; PAGE ERASE
.EQU	PGWRT	= 2	; PAGE WRITE
.EQU	BLBSET	= 3	; BOOT LOCK BIT SET
.EQU	RWWSRE	= 4	; READ WHILE WRITE SECTION READ ENABLE
.EQU	ASRE	= RWWSRE	; FOR COMPATIBILITY
.EQU	RWWSB	= 6	; READ WHILE WRITE SECTION BUSY
.EQU	ASB	= RWWSB	; FOR COMPATIBILITY
.EQU	SPMIE	= 7	; SPM INTERRUPT ENABLE


; ***** PORTA ************************
; PORTA - PORT A DATA REGISTER
.EQU	PORTA0	= 0	; PORT A DATA REGISTER BIT 0
.EQU	PA0	= 0	; FOR COMPATIBILITY
.EQU	PORTA1	= 1	; PORT A DATA REGISTER BIT 1
.EQU	PA1	= 1	; FOR COMPATIBILITY
.EQU	PORTA2	= 2	; PORT A DATA REGISTER BIT 2
.EQU	PA2	= 2	; FOR COMPATIBILITY
.EQU	PORTA3	= 3	; PORT A DATA REGISTER BIT 3
.EQU	PA3	= 3	; FOR COMPATIBILITY
.EQU	PORTA4	= 4	; PORT A DATA REGISTER BIT 4
.EQU	PA4	= 4	; FOR COMPATIBILITY
.EQU	PORTA5	= 5	; PORT A DATA REGISTER BIT 5
.EQU	PA5	= 5	; FOR COMPATIBILITY
.EQU	PORTA6	= 6	; PORT A DATA REGISTER BIT 6
.EQU	PA6	= 6	; FOR COMPATIBILITY
.EQU	PORTA7	= 7	; PORT A DATA REGISTER BIT 7
.EQU	PA7	= 7	; FOR COMPATIBILITY

; DDRA - PORT A DATA DIRECTION REGISTER
.EQU	DDA0	= 0	; DATA DIRECTION REGISTER, PORT A, BIT 0
.EQU	DDA1	= 1	; DATA DIRECTION REGISTER, PORT A, BIT 1
.EQU	DDA2	= 2	; DATA DIRECTION REGISTER, PORT A, BIT 2
.EQU	DDA3	= 3	; DATA DIRECTION REGISTER, PORT A, BIT 3
.EQU	DDA4	= 4	; DATA DIRECTION REGISTER, PORT A, BIT 4
.EQU	DDA5	= 5	; DATA DIRECTION REGISTER, PORT A, BIT 5
.EQU	DDA6	= 6	; DATA DIRECTION REGISTER, PORT A, BIT 6
.EQU	DDA7	= 7	; DATA DIRECTION REGISTER, PORT A, BIT 7

; PINA - PORT A INPUT PINS
.EQU	PINA0	= 0	; INPUT PINS, PORT A BIT 0
.EQU	PINA1	= 1	; INPUT PINS, PORT A BIT 1
.EQU	PINA2	= 2	; INPUT PINS, PORT A BIT 2
.EQU	PINA3	= 3	; INPUT PINS, PORT A BIT 3
.EQU	PINA4	= 4	; INPUT PINS, PORT A BIT 4
.EQU	PINA5	= 5	; INPUT PINS, PORT A BIT 5
.EQU	PINA6	= 6	; INPUT PINS, PORT A BIT 6
.EQU	PINA7	= 7	; INPUT PINS, PORT A BIT 7


; ***** PORTB ************************
; PORTB - PORT B DATA REGISTER
.EQU	PORTB0	= 0	; PORT B DATA REGISTER BIT 0
.EQU	PB0	= 0	; FOR COMPATIBILITY
.EQU	PORTB1	= 1	; PORT B DATA REGISTER BIT 1
.EQU	PB1	= 1	; FOR COMPATIBILITY
.EQU	PORTB2	= 2	; PORT B DATA REGISTER BIT 2
.EQU	PB2	= 2	; FOR COMPATIBILITY
.EQU	PORTB3	= 3	; PORT B DATA REGISTER BIT 3
.EQU	PB3	= 3	; FOR COMPATIBILITY
.EQU	PORTB4	= 4	; PORT B DATA REGISTER BIT 4
.EQU	PB4	= 4	; FOR COMPATIBILITY
.EQU	PORTB5	= 5	; PORT B DATA REGISTER BIT 5
.EQU	PB5	= 5	; FOR COMPATIBILITY
.EQU	PORTB6	= 6	; PORT B DATA REGISTER BIT 6
.EQU	PB6	= 6	; FOR COMPATIBILITY
.EQU	PORTB7	= 7	; PORT B DATA REGISTER BIT 7
.EQU	PB7	= 7	; FOR COMPATIBILITY

; DDRB - PORT B DATA DIRECTION REGISTER
.EQU	DDB0	= 0	; PORT B DATA DIRECTION REGISTER BIT 0
.EQU	DDB1	= 1	; PORT B DATA DIRECTION REGISTER BIT 1
.EQU	DDB2	= 2	; PORT B DATA DIRECTION REGISTER BIT 2
.EQU	DDB3	= 3	; PORT B DATA DIRECTION REGISTER BIT 3
.EQU	DDB4	= 4	; PORT B DATA DIRECTION REGISTER BIT 4
.EQU	DDB5	= 5	; PORT B DATA DIRECTION REGISTER BIT 5
.EQU	DDB6	= 6	; PORT B DATA DIRECTION REGISTER BIT 6
.EQU	DDB7	= 7	; PORT B DATA DIRECTION REGISTER BIT 7

; PINB - PORT B INPUT PINS
.EQU	PINB0	= 0	; PORT B INPUT PINS BIT 0
.EQU	PINB1	= 1	; PORT B INPUT PINS BIT 1
.EQU	PINB2	= 2	; PORT B INPUT PINS BIT 2
.EQU	PINB3	= 3	; PORT B INPUT PINS BIT 3
.EQU	PINB4	= 4	; PORT B INPUT PINS BIT 4
.EQU	PINB5	= 5	; PORT B INPUT PINS BIT 5
.EQU	PINB6	= 6	; PORT B INPUT PINS BIT 6
.EQU	PINB7	= 7	; PORT B INPUT PINS BIT 7


; ***** PORTC ************************
; PORTC - PORT C DATA REGISTER
.EQU	PORTC0	= 0	; PORT C DATA REGISTER BIT 0
.EQU	PC0	= 0	; FOR COMPATIBILITY
.EQU	PORTC1	= 1	; PORT C DATA REGISTER BIT 1
.EQU	PC1	= 1	; FOR COMPATIBILITY
.EQU	PORTC2	= 2	; PORT C DATA REGISTER BIT 2
.EQU	PC2	= 2	; FOR COMPATIBILITY
.EQU	PORTC3	= 3	; PORT C DATA REGISTER BIT 3
.EQU	PC3	= 3	; FOR COMPATIBILITY
.EQU	PORTC4	= 4	; PORT C DATA REGISTER BIT 4
.EQU	PC4	= 4	; FOR COMPATIBILITY
.EQU	PORTC5	= 5	; PORT C DATA REGISTER BIT 5
.EQU	PC5	= 5	; FOR COMPATIBILITY
.EQU	PORTC6	= 6	; PORT C DATA REGISTER BIT 6
.EQU	PC6	= 6	; FOR COMPATIBILITY
.EQU	PORTC7	= 7	; PORT C DATA REGISTER BIT 7
.EQU	PC7	= 7	; FOR COMPATIBILITY

; DDRC - PORT C DATA DIRECTION REGISTER
.EQU	DDC0	= 0	; PORT C DATA DIRECTION REGISTER BIT 0
.EQU	DDC1	= 1	; PORT C DATA DIRECTION REGISTER BIT 1
.EQU	DDC2	= 2	; PORT C DATA DIRECTION REGISTER BIT 2
.EQU	DDC3	= 3	; PORT C DATA DIRECTION REGISTER BIT 3
.EQU	DDC4	= 4	; PORT C DATA DIRECTION REGISTER BIT 4
.EQU	DDC5	= 5	; PORT C DATA DIRECTION REGISTER BIT 5
.EQU	DDC6	= 6	; PORT C DATA DIRECTION REGISTER BIT 6
.EQU	DDC7	= 7	; PORT C DATA DIRECTION REGISTER BIT 7

; PINC - PORT C INPUT PINS
.EQU	PINC0	= 0	; PORT C INPUT PINS BIT 0
.EQU	PINC1	= 1	; PORT C INPUT PINS BIT 1
.EQU	PINC2	= 2	; PORT C INPUT PINS BIT 2
.EQU	PINC3	= 3	; PORT C INPUT PINS BIT 3
.EQU	PINC4	= 4	; PORT C INPUT PINS BIT 4
.EQU	PINC5	= 5	; PORT C INPUT PINS BIT 5
.EQU	PINC6	= 6	; PORT C INPUT PINS BIT 6
.EQU	PINC7	= 7	; PORT C INPUT PINS BIT 7


; ***** PORTD ************************
; PORTD - PORT D DATA REGISTER
.EQU	PORTD0	= 0	; PORT D DATA REGISTER BIT 0
.EQU	PD0	= 0	; FOR COMPATIBILITY
.EQU	PORTD1	= 1	; PORT D DATA REGISTER BIT 1
.EQU	PD1	= 1	; FOR COMPATIBILITY
.EQU	PORTD2	= 2	; PORT D DATA REGISTER BIT 2
.EQU	PD2	= 2	; FOR COMPATIBILITY
.EQU	PORTD3	= 3	; PORT D DATA REGISTER BIT 3
.EQU	PD3	= 3	; FOR COMPATIBILITY
.EQU	PORTD4	= 4	; PORT D DATA REGISTER BIT 4
.EQU	PD4	= 4	; FOR COMPATIBILITY
.EQU	PORTD5	= 5	; PORT D DATA REGISTER BIT 5
.EQU	PD5	= 5	; FOR COMPATIBILITY
.EQU	PORTD6	= 6	; PORT D DATA REGISTER BIT 6
.EQU	PD6	= 6	; FOR COMPATIBILITY
.EQU	PORTD7	= 7	; PORT D DATA REGISTER BIT 7
.EQU	PD7	= 7	; FOR COMPATIBILITY

; DDRD - PORT D DATA DIRECTION REGISTER
.EQU	DDD0	= 0	; PORT D DATA DIRECTION REGISTER BIT 0
.EQU	DDD1	= 1	; PORT D DATA DIRECTION REGISTER BIT 1
.EQU	DDD2	= 2	; PORT D DATA DIRECTION REGISTER BIT 2
.EQU	DDD3	= 3	; PORT D DATA DIRECTION REGISTER BIT 3
.EQU	DDD4	= 4	; PORT D DATA DIRECTION REGISTER BIT 4
.EQU	DDD5	= 5	; PORT D DATA DIRECTION REGISTER BIT 5
.EQU	DDD6	= 6	; PORT D DATA DIRECTION REGISTER BIT 6
.EQU	DDD7	= 7	; PORT D DATA DIRECTION REGISTER BIT 7

; PIND - PORT D INPUT PINS
.EQU	PIND0	= 0	; PORT D INPUT PINS BIT 0
.EQU	PIND1	= 1	; PORT D INPUT PINS BIT 1
.EQU	PIND2	= 2	; PORT D INPUT PINS BIT 2
.EQU	PIND3	= 3	; PORT D INPUT PINS BIT 3
.EQU	PIND4	= 4	; PORT D INPUT PINS BIT 4
.EQU	PIND5	= 5	; PORT D INPUT PINS BIT 5
.EQU	PIND6	= 6	; PORT D INPUT PINS BIT 6
.EQU	PIND7	= 7	; PORT D INPUT PINS BIT 7


; ***** WATCHDOG *********************
; WDTCR - WATCHDOG TIMER CONTROL REGISTER
.EQU	WDP0	= 0	; WATCH DOG TIMER PRESCALER BIT 0
.EQU	WDP1	= 1	; WATCH DOG TIMER PRESCALER BIT 1
.EQU	WDP2	= 2	; WATCH DOG TIMER PRESCALER BIT 2
.EQU	WDE	= 3	; WATCH DOG ENABLE
.EQU	WDTOE	= 4	; RW
.EQU	WDDE	= WDTOE	; FOR COMPATIBILITY



; ***** LOCKSBITS ********************************************************
.EQU	LB1	= 0	; LOCK BIT
.EQU	LB2	= 1	; LOCK BIT
.EQU	BLB01	= 2	; BOOT LOCK BIT
.EQU	BLB02	= 3	; BOOT LOCK BIT
.EQU	BLB11	= 4	; BOOT LOCK BIT
.EQU	BLB12	= 5	; BOOT LOCK BIT


; ***** FUSES ************************************************************
; LOW FUSE BITS
.EQU	CKSEL0	= 0	; SELECT CLOCK SOURCE
.EQU	CKSEL1	= 1	; SELECT CLOCK SOURCE
.EQU	CKSEL2	= 2	; SELECT CLOCK SOURCE
.EQU	CKSEL3	= 3	; SELECT CLOCK SOURCE
.EQU	SUT0	= 4	; SELECT START-UP TIME
.EQU	SUT1	= 5	; SELECT START-UP TIME
.EQU	BODEN	= 6	; BROWN OUT DETECTOR ENABLE
.EQU	BODLEVEL	= 7	; BROWN OUT DETECTOR TRIGGER LEVEL

; HIGH FUSE BITS
.EQU	BOOTRST	= 0	; SELECT RESET VECTOR
.EQU	BOOTSZ0	= 1	; SELECT BOOT SIZE
.EQU	BOOTSZ1	= 2	; SELECT BOOT SIZE
.EQU	EESAVE	= 3	; EEPROM MEMORY IS PRESERVED THROUGH CHIP ERASE
.EQU	CKOPT	= 4	; OSCILLATOR OPTIONS
.EQU	SPIEN	= 5	; ENABLE SERIAL PROGRAMMING AND DATA DOWNLOADING
.EQU	JTAGEN	= 6	; ENABLE JTAG
.EQU	OCDEN	= 7	; ENABLE OCD



; ***** CPU REGISTER DEFINITIONS *****************************************
.DEF	XH	= R27
.DEF	XL	= R26
.DEF	YH	= R29
.DEF	YL	= R28
.DEF	ZH	= R31
.DEF	ZL	= R30



; ***** DATA MEMORY DECLARATIONS *****************************************
.EQU	FLASHEND	= 0X1FFF	; NOTE: WORD ADDRESS
.EQU	IOEND	= 0X003F
.EQU	SRAM_START	= 0X0060
.EQU	SRAM_SIZE	= 1024
.EQU	RAMEND	= 0X045F
.EQU	XRAMEND	= 0X0000
.EQU	E2END	= 0X01FF
.EQU	EEPROMEND	= 0X01FF
.EQU	EEADRBITS	= 9
#PRAGMA AVRPART MEMORY PROG_FLASH 16384
#PRAGMA AVRPART MEMORY EEPROM 512
#PRAGMA AVRPART MEMORY INT_SRAM SIZE 1024
#PRAGMA AVRPART MEMORY INT_SRAM START_ADDR 0X60



; *****
