#include <avr/io.h>


//------------------------    READ   WRITE ( Cnt    Cmd) ---------------------------------
/*
    Cmd: 0 - 
	     1 -     RAM
		 2 -  
		 4 - 

      :
	       - 100 ..
		   - 69 ..
		 - 143 ..

		  :

		   - 100 ..
		   - 69 ..
		 - 123 ..


*/ 

/*
    :
	    0 -  
		1 - 
		2 - 
		3 - 
*/

//   
#define FClk 14300//,    : 16934,14300,10000,7373,12000,18000,17734,20000,3686,
                  //  3579, 3600 4000   

//  3          
#define PORT _SFR_IO_ADDR(PORTB)
#define DDR  _SFR_IO_ADDR(DDRB)
#define PIN  _SFR_IO_ADDR(PINB)

//    ,   
#define BitNum 0

   
//   
#define  WaitCount r26 //    
#define  BitCount  r27 //  
#define  Res0      r28 //     
#define  Cmd       r29 //   
#define  ByteCnt   r16 //   
#define  KS        r17 //  




.global Dbg

//-------------------   - .      ------------------------------------

Dbg:   
    cbi PORT, BitNum

	push WaitCount
    sbi DDR, BitNum //    (7 ..)
	
	ldi WaitCount, (65 * FClk - 140000) / 60000 + 1
	in   WaitCount, _SFR_IO_ADDR(SREG)
    push WaitCount

	clr  WaitCount

WaitSendItr: 
    dec WaitCount
	brne WaitSendItr
    push BitCount

    cbi DDR, BitNum //    (    )

    
	push Res0
	push Cmd     
	push ByteCnt
    push KS
	push r30
	push r31

Cikl: //       -   .    
	clt // 
    cli 
	rcall ReadWrite
    mov   Cmd, Res0

	rcall ReadWrite
    mov r30, Res0

	rcall ReadWrite
    mov r31, Res0

	rcall ReadWrite
	
	cpi   Cmd, 1
	brcs  CmdContinue //   0

	breq  CmdWrite //   1	

M1: ldi   ByteCnt, 8
    set // 
    ldi  KS, 0xAA
ReadCikl:
    ld   Res0, Z+ 
	add   KS, Res0
    rcall ReadWrite
	dec   ByteCnt
	brne  ReadCikl

	mov   Res0, KS
	rcall ReadWrite

    rjmp Cikl

CmdWrite:
    st Z, Res0
    rjmp Cikl

CmdContinue:
    set // 
	ldi Res0, 0x55
	rcall ReadWrite

Exit: wdr //  WatchDog
    pop r31
	pop r30 
    pop  KS
	pop  ByteCnt
	pop  Cmd
	pop  Res0
	pop  BitCount
	pop  WaitCount
	out  _SFR_IO_ADDR(SREG), WaitCount
	pop  WaitCount
	ret
	

//-------------------------       -   --------------------

ReadWrite:
/*
    :  T = 0
	          
*/    
    ldi  BitCount, 8
    

//-------------------------        --------------------------------------------
Wait0:
    sbic PIN, BitNum
	rjmp Wait0

    

//-------------------------         -----------------------------------------------

    
Wait1: 
    
    sbis PIN, BitNum
	rjmp Wait1
	
    
	
//----------------------------------     -  ----------------
    lsr Res0  
	brtc Reading

    brcs BitCikl   //  ,       

    sbi  DDR, BitNum   //   0


//-------------------------------------    65  96 ..  20   ----------------------


     ldi WaitCount, (65 * FClk - 140000) / 60000 + 1
SignalWait:
     dec WaitCount
     brne SignalWait
	
	cbi  DDR, BitNum   //  1 
    
	rjmp BitCikl

//-------------------------         ------------------------------------------
Reading:
    
	ldi WaitCount, (79 * FClk - 120000) / 60000 + 1// 73  105

EndReadingWait:
	dec WaitCount
    brne EndReadingWait 

	sbic PIN, BitNum
    ori  Res0, 0x80

//-------------------------              ----------------------------
BitCikl:
    dec BitCount
    brne Wait0

//-------------------------    -    1  -------------------------

    
m0:
	sbis PIN, BitNum
	rjmp m0
    
	ret 



