
#define SDIDebugUnit
//------------------------    READ   WRITE ( Cnt    Cmd) ---------------------------------
/*
    Cmd: 0 - 
	     1 -     RAM
		 2 -  
		 4 - 

      :
	       - 100 ..
		   - 69 ..
		 - 143 ..

		  :

		   - 100 ..
		   - 69 ..
		 - 123 ..


*/ 

/*
    :
	    0 -  
		1 - 
		2 - 
		3 - 
*/

//   
#define FClk 14300//,    : 16934,14300,10000,7373,12000,18000,17734,20000,3686,
                  //  3579, 3600 4000   

//  3          
#define PORT PORTB
#define DDR  DDRB
#define PIN  PINB

//    ,   
#define BitNum 0

   
//   
#define  WaitCount r26 //    
#define  BitCount  r27 //  
#define  Res0      r28 //     
#define  Cmd       r29 //   
#define  ByteCnt   r16 //   
#define  KS        r17 //  






//-------------------   - .      ------------------------------------

Dbg:   
    cbi PORT, BitNum

	push WaitCount
    sbi DDR, BitNum //    (7 ..)
	
	ldi WaitCount, (65 * FClk - 140000) / 60000 + 1
	in   WaitCount, SREG
    push WaitCount

	clr  WaitCount

__WaitSendItr: 
    dec WaitCount
	brne __WaitSendItr
    push BitCount

    cbi DDR, BitNum //    (    )

    
	push Res0
	push Cmd     
	push ByteCnt
    push KS
	push r30
	push r31

__Cikl: //       -   .    
	clt // 
    cli 
	rcall __ReadWrite
    mov   Cmd, Res0

	rcall __ReadWrite
    mov r30, Res0

	rcall __ReadWrite
    mov r31, Res0

	rcall __ReadWrite
	
	cpi   Cmd, 1
	brcs  __CmdContinue //   0

	breq  __CmdWrite //   1	

__M1: ldi   ByteCnt, 8
    set // 
    ldi  KS, 0xAA
__ReadCikl:
    ld   Res0, Z+ 
	add   KS, Res0
    rcall __ReadWrite
	dec   ByteCnt
	brne  __ReadCikl

	mov   Res0, KS
	rcall __ReadWrite

    rjmp __Cikl

__CmdWrite:
    st Z, Res0
    rjmp __Cikl

__CmdContinue:
    set // 
	ldi Res0, 0x55
	rcall __ReadWrite

__Exit: wdr //  WatchDog
    pop r31
	pop r30 
    pop  KS
	pop  ByteCnt
	pop  Cmd
	pop  Res0
	pop  BitCount
	pop  WaitCount
	out  SREG, WaitCount
	pop  WaitCount
	ret
	

//-------------------------       -   --------------------

__ReadWrite:
/*
    :  T = 0
	          
*/    
    ldi  BitCount, 8
    

//-------------------------        --------------------------------------------
__Wait0:
    sbic PIN, BitNum
	rjmp __Wait0

    

//-------------------------         -----------------------------------------------

    
__Wait1: 
    
    sbis PIN, BitNum
	rjmp __Wait1
	
    
	
//----------------------------------     -  ----------------
    lsr Res0  
	brtc __Reading

    brcs __BitCikl   //  ,       

    sbi  DDR, BitNum   //   0


//-------------------------------------    65  96 ..  20   ----------------------


     ldi WaitCount, (65 * FClk - 140000) / 60000 + 1
__SignalWait:
     dec WaitCount
     brne __SignalWait
	
	cbi  DDR, BitNum   //  1 
    
	rjmp __BitCikl

//-------------------------         ------------------------------------------
__Reading:
    
	ldi WaitCount, (79 * FClk - 120000) / 60000 + 1// 73  105

__EndReadingWait:
	dec WaitCount
    brne __EndReadingWait 

	sbic PIN, BitNum
    ori  Res0, 0x80

//-------------------------              ----------------------------
__BitCikl:
    dec BitCount
    brne __Wait0

//-------------------------    -    1  -------------------------

    
__m0:
	sbis PIN, BitNum
	rjmp __m0
    
	ret 

#undef SDIDebugUnit
