$PAGEWIDTH=120
;*********************************************************************
;         
;    V 1.11  			                           26-06-2009
;---------------------------------------------------------------------

;  1     1,   
;      ,     
;      (Alf),  
;     
;        
;        3  ( )
;*********************************************************************
;
        DefSeg  All,Absolute
        Seg     All
;
;=========================================================
;                
;=========================================================
Reg0	equ	0	;R0
Reg1	equ	1	;R1
Reg4	equ	4	;R4
Steck   equ     7       ; 

Alf0	equ	21h	; (2 ) bin . / -  (3)
tmpLo	equ	23h	;2      (Low)
tmpHi	equ	24h	;High
Alf1	equ	25h	; (2 ) bin . / -   (3)
NStep	equ	27h	;2      
			; (NStep+1).7=1 (. <0) -   , 

mT50	equ	29h	;  50
mSP1	equ	2Ah	; 1 (  )
mSout	equ	2Bh	;   50

PTA	equ	2Ch	;
PTB	equ	2Dh	;
iBufRs	equ  	2Eh	;   ..
oBufRs	equ	2Fh	; .  .

			;  - .  #1
N0	equ	Alf0	;3      (ASCII)
N1	equ	Alf1	;3      (ASCII)

BufRs	equ	30h	;  (  )
BufRsLng    equ	  78	; 

N1bin	equ	7Fh	;    (bin)

;=========================================================
;                
;=========================================================
bStep	equ	20h.0	;    
			;0-  (  4)/1- (  8)
bDirect	equ	20h.1	;    
			;1- R7(  )/0- R7( ..)
bTxRdy	equ	20h.2	;   
bWay	equ	20h.3	;    ( )
			;1 -   /; 0 -  ../ 
bDirTmp	equ	20h.4	;     
			;1- R7(  )/0- R7( ..)
LtEn	equ	20h.5	;      
			;1-/0-  (.   5-6 )

;=========================================================

;R0 -    
;R1 -      .
;R2 -  (    )
;R3 -  50
;R4 -  50
;R5 -    
;R6 -       
;R7 -    

;=========================================================
;              / 
;=========================================================

Kontr0	equ	P0.2	; (1-)

; 1 -     (4..7)

;               P3.0    ;RxD - in    60
;               P3.1    ;TxD - out   60

Switch	equ	P3.2	;  (=1 / =0)
Kontr	equ	P3.3	; (1-)

Direct	equ	P3.4	;  (1-/0- R7)
Step	equ	P3.5	;0-  (  4)/1- (  8)
Right	equ	P3.6	; "/+" (  )
Left	equ	P3.7	; "/-" (  )

;=========================================================
;                      
;=========================================================

        ORG     0
        LJMP    Begin
;
;	ORG	3		;   INT0
;	
        db      ' std111 '	; 
;
        ORG     0BH             ;Timer counter TF0 Interrapt
        LJMP    TimInt
;
        ORG     13H             ;pp  INT1 
        reti
;
        ORG     1BH             ;Timer counter TF1 Interrapt
        ljmp	Time50

        ORG     23H             ;  . 
        ljmp	Serial
;
;
StepTable8:			;  ( )
	db	10001111b
	db	11001111b
	db	01001111b
	db	01101111b
	db	00101111b
	db	00111111b
	db	00011111b
	db	10011111b
StepTable:			;  
	db	10001111b
	db	01001111b
	db	00101111b
	db	00011111b
	db	10001111b
	db	01001111b
	db	00101111b
	db	00011111b

sCPBR1:	db	'AT+CPBR=1',0Dh,0    ;   1 . ( )
sCPBR2:	db	'AT+CPBR=2',0Dh,0    ;   2 . (  )
sCPBRX:	db	'AT+CPBR=',0         ;   c   
sATZ:	db	'ATZ',0Dh,0	     ; ATZ
sCCLK:	db	'AT+CCLK?',0Dh,0     ;     
sATE0:	db	'ATE0',0Dh,0	     ; -
sATCM:	db	'AT+CMEC=2',0Dh,0    ;  
sATCK:	db	'AT+CKPD=',0	     ;   
;AT+CKPD=0,20	;"+"   
;AT+CKPD=#	;"#"   (  )

AdrOK:	db	'OK',0		;   
AdrErr:	db	'ERROR',0	;   ERROR ()
AdrN1:	db	':1,"',0	;      1
				;(  "  ) ( )
AdrN:	db	',"',0		;      (  )
AdrDat:	db	'K:"',0		;  .   
				;(  "  ,) ( )

;**********************************************
;       T/C1 (50 )
;**********************************************
Time50:	push	ACC
	push	PSW

	dec	mT50		; 

	mov	A,mSout		; ""
	jz	t_end		; -   
	add	A,#5
	jnc	t_On		; 250 -  
	mov	A,mSout
	inc	A
	jz	t_Q10		;=FF -   
	mov	A,P1		; 250  254 -  (Q=2)
	xrl	A,mSP1		;  
	mov	P1,A
	inc	mSout		;  
	ajmp	t_end
t_On:	mov	P1,mSP1		; 
	inc	mSout		;  
	ajmp	t_end
t_Q10:	mov	A,mT50		; 
	anl	A,#00000011b	;  (1:4)
	mov	P1,#0		;
	jnz	t_end
	mov	P1,mSP1		;

t_end:	pop	PSW
	pop	ACC
	reti

;  36  ( 0,8 ) -  30

;  25         mSP1
;     "" MSout=1
;     ,  mSout=0
;  "":
;mSout		 
;0		 
;1..250		
;251..254 	   
;255		1/4 - , 3/4 - 	

;**********************************************
;       T/C0 (25 )
;**********************************************
TimInt: push    ACC
        push    PSW
	push	DPH
	push	DPL

        MOV     TH0,#8BH        ;  T/C0 = 25
        MOV     TL0,#7AH        ;25 ms  (8B7Ah)  14,31818
                                ;    
	mov	A,PTA		; 
	jz	ti01		; - 
	dec	PTA		; -1  25
ti01:
	dec	PTB		; (50,100,200,400,800,1.6c,3.2c,6.4c)
	mov	A,PTB
	anl	A,#01111111b	;  6.4 
	jnz	ti14
	setb	LtEn		;"   "
ti14:	mov	A,PTB
;  
	mov	C,ACC.3		;
	jnb	Switch,ti04
	mov	C,ACC.5		;
ti04:
	mov	Kontr,C
	cpl	C
	mov	Kontr0,C

	jnb	Switch,ti02
				;    9 (  360)
	anl	A,#11b		;  4    4 ()
	jnb	bStep,ti12	;Step=0 - , =1 - 
	anl	A,#1b		;  2    8 ()
ti12:	jnz	ti03
	djnz	R5,ti03
	mov	R5,#90		; = 90 (904=360)

ti02:	jnb	bDirect,ti13	;
	inc	R7		;   (1...8)   
	cjne	R7,#9,ti05
	mov	R7,#1
	ajmp	ti05
ti13:				;   ( ) 8...1
	djnz	R7,ti05		;    
	mov	R7,#8		;  

ti05:	mov	A,R7
	dec	A

	mov	DPTR,#StepTable	;  ( -  4)
	jnb	bStep,ti06	;Step=0 - , =1 - 
	mov	DPTR,#StepTable8 ;  ( -  8)
ti06:
	movc	A,@A+DPTR	;     
;	mov	P1,A
	mov	mSP1,A		; 
	mov	mSout,#1	;  

	mov	A,NStep+1	; NStep<0, 
	jb	ACC.7,ti03	;   
	mov	A,NStep		; 1 (2)  
	jnb	bStep,ti07	;Step=0 -  (-2), =1 -  (-1)
	add	A,#(-1)
	ajmp	ti08
ti07:	add	A,#(-2)
ti08:	mov	NStep,A		; 
	mov	A,NStep+1	; 
	addc	A,#(-1)
	mov	NStep+1,A
ti03:
;
	pop	DPL
	pop	DPH
	pop     PSW
        pop     ACC
        RETI

;***************************************************
;      
;***************************************************
Serial: push    ACC
        push    PSW

        jnb     RI,ser0         ; 
        clr     RI              ; 

        mov     A,SBUF          ; 

;--      -  "" 
	cjne	A,#' ',ser1	;""
        ajmp    ser2
ser1:	cjne	A,#0Dh,ser3	;<CR>
        ajmp    ser2
ser3:	cjne	A,#0Ah,ser4	;<LF>
        ajmp    ser2
;--  "  "
	
ser4:	lcall	SetBufRs	;  
        ajmp    ser2

ser0:   clr     TI              ; 
	clr	bTxRdy		; 

ser2:   pop     PSW
        pop     ACC
        reti


;******************************************************
;                    
;******************************************************

;------------------------------------------------------
;    
;  =0 -   , ACC<>0 - - 
;------------------------------------------------------
Key: 	mov	A,P3
	anl	A,#11000000b	;  Right,Left
	xrl	A,#11000000b	; 
	ret

;------------------------------------------------------
; 50  ( )
;------------------------------------------------------
Pause50: mov	PTA,#2
	ajmp	pa01
;------------------------------------------------------
; 3  ( )
;------------------------------------------------------
Pause3: mov	PTA,#120
	ajmp	pa01
;------------------------------------------------------
; 1  ( )
;------------------------------------------------------
Pause:	mov	PTA,#40
pa01:	mov	A,PTA
	jnz	pa01
	ret

;------------------------------------------------------
; 3        
;( )
;: C=1 -   -   
;       =0 -  
;------------------------------------------------------
Pause3OK: 
	mov	PTA,#120
pa32:	mov	DPTR,#AdrOK	;   ('OK')
	lcall	CompStr		; 
	jc	pa31		;- ,    - 
	jz	pa33		;  - 
pa31:	mov	A,PTA		; 
	jnz	pa32		;  -  
	setb	C		; 
pa33:	ret

;------------------------------------------------------
; 50  (  ) T=0,8
;------------------------------------------------------
Nop50:  mov	R3,#58		;58  -  50
np01:	mov	R4,#0
np02:	nop			;4  256 
	nop			; 858 
	djnz	R4,np02
	djnz	R3,np01
	ret

;------------------------------------------------------
;    ()     
;------------------------------------------------------
SetBufRs:
	mov	R1,iBufRs	; 
	mov	@R1,A		;  ( )
	inc	iBufRs
	mov	R1,iBufRs
	cjne	R1,#(BufRs+BufRsLng),sb1
;   -    ( )
	mov	R1,#(BufRs+1)
sb2:	mov	A,@R1
	dec	R1
	mov	@R1,A
	inc	R1
	inc	R1
	cjne	R1,#(BufRs+BufRsLng+1),sb2
	mov	iBufRs,#(BufRs+BufRsLng-1)	;  

	dec	oBufRs		;  
	mov	R1,oBufRs
	cjne	R1,#(BufRs-1),sb1
	inc	oBufRs	
sb1:	
	ret

;------------------------------------------------------
;        ( )
;  =0,     
;------------------------------------------------------
GetBufRs:
	push	Reg0
	clr	ES		;  .
	mov	R0,oBufRs	; 
	mov	A,@R0
	jz	gb1		;  - 
	inc	oBufRs		; -  
gb1:	setb	ES		; 
	pop	Reg0
	ret

;------------------------------------------------------
;    (  
;   ( 0))
;------------------------------------------------------
ResBufRs:
	push	Reg0
	clr	ES		;  .
	mov	iBufRs,#BufRs	;   
	mov	oBufRs,#BufRs	;   
	mov	R0,iBufRs	; 
rb1:	mov	@R0,#0		;0   ( )
	inc	R0
	cjne	R0,#(BufRs+BufRsLng+1),rb1
	setb	ES
	pop	Reg0
	ret

;------------------------------------------------------
;      DPTR   0
;------------------------------------------------------
StrTX:	clr	A
	movc	A,@A+DPTR	;   
	jz	st03		;
	lcall	ByteTX		; 
	inc	DPTR
	ajmp	StrTX		;  - 
st03:	;lcall	ClrBuf		;  	
	ret

;------------------------------------------------------
;  ( )   
;------------------------------------------------------
ByteTX:	jb	bTxRdy,ByteTX	;  
	;       (5 )
	mov	SBUF,A		; 
	setb	bTxRdy		; 
	ret

;------------------------------------------------------
;  ( ,   )
;:  DPTR -      (0-)
;: C=1      - - ,   
;	=0,=0  -   (R0 . .)
;	=0,<>0 -   (  )
;------------------------------------------------------
CompStr: 
	mov	R0,#BufRs	; 
CompStrR0:			;     R0
	mov	R3,#0		;    
cs01:	mov	A,@R0		;   
	jz	cs02		;  (0) - 
	mov	A,R3
	movc	A,@A+DPTR	;   
	xrl	A,@R0		;   
	jnz	cs03		; 
	inc	R3		; -  
	mov	A,R3
	movc	A,@A+DPTR	;    ( 0 - )
	clr	C		; 
	jz	cs04		; - 
	inc	R0		;   
	ajmp	cs01		;
cs03:	inc	R0		;   
	mov	R3,#0		;     
	ajmp	cs01		;
cs02:	mov	A,R0		;,    
	add	A,#(-BufRs-1)	;   (R0>BufSR)
cs04:	ret

;----------------------------------------------------------------
;      (R0)->(R6)
;  -  '"'  '+'  '#' ( )
;  = 0 -  :  R6=7Fh
;----------------------------------------------------------------
Str2tmp:
	mov	A,@R0
	cjne	A,#('"'),qt1
	ret			;  (<>0)

qt1:	cjne	A,#('+'),qt2
	ret			;  (<>0)

qt2:	cjne	A,#('#'),qt3
	ret			;  (<>0)

qt3:	lcall	movAtoR6	;    mov @R6,A
;	xch	A,R0		;    mov @R6,A
;	xch	A,R6
;	xch	A,R0
;	mov	@R0,A
;	mov	A,R0
;	xch	A,R6
;	mov	R0,A

	inc	R6
	inc	R0
	cjne	R6,#7Fh,Str2tmp
	clr	A		; 
	ret

;----------------------------------------------------------------
;-  mov @R6,A ( )
;----------------------------------------------------------------
movAtoR6:
	xch	A,R0		;    mov @R6,A
	xch	A,R6
	xch	A,R0
	mov	@R0,A
	mov	A,R0
	xch	A,R6
	mov	R0,A
	ret

;----------------------------------------------------------------
;-  mov A,@R6 ( )
;----------------------------------------------------------------
movR6toA:
	mov	A,R0		;    mov A,@R6
	xch	A,R6
	xch	A,R0
	mov	A,@R0
	xch	A,R0
	xch	A,R6
	xch	A,R0
	ret

;----------------------------------------------------------------
;   ASCII @R0     
;  R0+2 (  2)
;----------------------------------------------------------------
Asc2bin:
	mov	A,@R0		;  ASCII ()
	anl	A,#00001111b	; 
	rl	A		;  2
	mov	R2,A		; 
	rl	A
	rl	A		;  8
	add	A,R2		;     10
	mov	R2,A		; 
	inc	R0		;  ()
	mov	A,@R0		;  ASCII ()
	anl	A,#00001111b	; 
	add	A,R2		;  
	inc	R0		;  
	ret

;----------------------------------------------------------------
; 2   tmp  ,   tmp
;----------------------------------------------------------------
MulAtmp:
	mov	R2,A		;  
	mov	B,A		;   
	mov	A,tmpLo		; 
	mul	AB		;
	mov	tmpLo,A		;  
	mov	A,B		;
	xch	A,tmpHi		; - ()    
	xch	A,R2
	mov	B,A
	mov	A,R2
	mul	AB		;
	add	A,tmpHi		; 
	mov	tmpHi,A		;   
	ret
	
;----------------------------------------------------------------
;  " "     4.5 
; @R6,@R6+1 = bin(@R0,@R0+1)*800 + bin(@R0+2,@R0+3)*13 + bin(@R0+2,@R0+3)/3 +
;             + bin(@R0+4,@R0+5)*2/9
;----------------------------------------------------------------
Str2bin:
	lcall	Asc2bin		;  ()   ASCII  Bin
	mov	tmpLo,#Low(800)
	mov	tmpHi,#High(800)
	lcall	MulAtmp		;""   800

	mov	A,tmpLo		;  @R6 (Low,High)
	lcall	movAtoR6
	inc	R6
	mov	A,tmpHi
	lcall	movAtoR6
	dec	R6

	lcall	Asc2bin		;  ()   ASCII  Bin
	push	ACC		; 
	mov	tmpLo,#Low(13)
	mov	tmpHi,#High(13)
	lcall	MulAtmp		;""   13

	lcall	movR6toA	; Low  
	add	A,tmpLo		; 
	lcall	movAtoR6
	inc	R6	
	lcall	movR6toA	; Low  
	addc	A,tmpHi		;  + 
	lcall	movAtoR6
	dec	R6

	pop	ACC		;  ()
	mov	B,#3		;  3
	div	AB		;     
	mov	tmpLo,A		;(  -   4")
	
	lcall	Asc2bin		;  ()   ASCII  Bin
	rl	A		;  2
	mov	B,#9		;  9
	div	AB		;     
				;(  -   4")
	add	A,tmpLo		; 
	mov	R2,A
	lcall	movR6toA	; Low  
	add	A,R2		; 
	lcall	movAtoR6
	inc	R6	
	lcall	movR6toA	; Low  
	addc	A,#0		;  + 
	lcall	movAtoR6
	dec	R6

	ret

;----------------------------------------------------------------
; ""  tmp (2  )
;----------------------------------------------------------------
Minustmp:
	mov	A,tmpLo		;  
	cpl	A
	add	A,#1
	mov	tmpLo,A

	mov	A,tmpHi		;  
	cpl	A
	addc	A,#0
	mov	tmpHi,A
	ret
	
;----------------------------------------------------------------
;  @R0(Lo),@R0+1(Hi)  tmp,   tmp
;----------------------------------------------------------------
SubDW:
	lcall	Minustmp	;-tmp
	mov	A,tmpLo		;  
	add	A,@R0
	mov	tmpLo,A
	inc	R0
	mov	A,tmpHi		;  
	addc	A,@R0
	mov	tmpHi,A
	ret
	
;----------------------------------------------------------------
; 2  tmp  R2 ( )
;----------------------------------------------------------------
DivDW:
	mov	A,R2		;  R2 "-R2"
	cpl	A
	inc	A
	mov	R2,A

	mov	R0,#0		;   

dd1:	mov	A,tmpLo		;  
	add	A,R2
	mov	tmpLo,A
	mov	A,tmpHi		;  
	addc	A,#0FFh
	mov	tmpHi,A
	jb	ACC.7,dd2	; (<0) - 
	inc	R0
	ajmp	dd1
dd2:
	mov	A,R0
	ret
	
;******************************************************
;                  
;******************************************************
Begin:  mov     SP,#Steck       ; 
	mov	P1,#0		; 
;------      ------
	mov	C,Step		; 
	jb	Right,bg11	; "  "
	cpl	C		;  -  
bg11:	mov	bStep,C		; " "

	mov	C,Direct	; 
	jb	Left,bg12	; "  "
	cpl	C		;  -  
bg12:	mov	bDirect,C	; ""
	mov	bDirTmp,C

bg13:	lcall	Key		;  
	jnz	bg13
	lcall	Nop50		;" "
	lcall	Key		;    
	jnz	bg13		; 

;-------------   -------------
        mov     SCON,#01110000b ;    1
;-------------  ------------
        MOV     TMOD,#00100001b ;  :
        ;T/C0:      TR0
        ;      16  /
        ;T/C1:      TR1
        ;      8   /
	;         . 1200
	;           52 
        mov     TH1,#194        ;  52 
        mov     TL1,#194	;14.3
	mov	PCON,#10000000b	;SMOD=1
        MOV     TH0,#8BH        ;  T/C0 = 25
        MOV     TL0,#7AH        ;25 ms  (8B7Ah)  14,31818
	mov	R6,#1		;   90 (   )
	mov	PTB,#1		;  -    
        SETB    TR1             ; T/C1
        SETB    TR0             ; T/C0
        SETB    PT1             ; T/C1
        MOV     IE,#00011010b   ;   T/C0  /1  .

	mov	NStep+1,#0FFh	;<0 -   (  )
	mov	R7,#8		;    / (8 )
	mov	DPTR,#StepTable	;  ( -  4)
	jnb	bStep,bg01	;Step=0 - , =1 - 
	mov	DPTR,#StepTable8 ;  ( -  8)
bg01:	mov	mSP1,#0		; 
	mov	mSout,#0	; 
	clr	bTxRdy		;  ()
	lcall	ResBufRs	;  
        SETB    EA              ; 
;
;==============================================================
;     ATZ      
	mov	DPTR,#sATZ	; ATZ (     )
	lcall	StrTX		;   ATZ
	lcall	ResBufRs	;  
	lcall	Pause3		;  3 
	
;==============================================================
;  -  :    ATZ      
	mov	DPTR,#sATZ	; ATZ (     )
	lcall	StrTX		;   ATZ
	lcall	ResBufRs	;  
	lcall	Pause3OK	;  OK  3 
	jc	bg03		; ,   -  
	lcall	Pause50		; 50    
	
;==============================================================
;   ATE0   -
	mov	DPTR,#sATE0	; ATE0 
	lcall	StrTX		;   AT...
	lcall	ResBufRs	;  
	lcall	Pause3OK	;  OK  3 
	lcall	Pause50		; 50    
				;   	
;==============================================================
;   AT+CMEC=2	;  
	mov	DPTR,#sATCM	; AT+CMEC=2 
	lcall	StrTX		;   AT...
	lcall	ResBufRs	;  
	lcall	Pause3OK	;  OK  3 
	lcall	Pause50		; 50    
				;   	
;==============================================================
;   AT+CKPD=C	;      1
	mov	DPTR,#sATCK	; AT+CKPD= 
	lcall	StrTX		;   AT...
	mov	A,#'C'
	lcall	ByteTX
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  
	lcall	Pause3		;  3 
;==============================================================
;   AT+CKPD=C	;      2
	mov	DPTR,#sATCK	; AT+CKPD= 
	lcall	StrTX		;   AT...
	mov	A,#'C'
	lcall	ByteTX
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  
	lcall	Pause3OK	;  OK  3 
	lcall	Pause50		; 50    
				;   	
	ajmp	bg02
bg03:	ljmp	Cyrcle
bg02:
;!!!      ,       
;!!!     -    (  )

;  #1  SIM,       
;!!!      3!    "+"  "#"	
;==========   AT+CPBR (   1) ============
	mov	DPTR,#sCPBR1	;    
	lcall	StrTX		;   +CPBR=1
	lcall	ResBufRs	;  

	lcall	Pause3OK	;  3  (    )
	lcall	Pause50		; 50    
	mov	DPTR,#AdrN1	;   (': 1,"')
	lcall	CompStr		; 
	jc	bg03		;- ,   
	jnz	bg03		; 
;   -   ( "  +)  .   
	inc	R0		;    
	mov	R6,#N0		;   (    )
	lcall	Str2tmp
	jz	bg03		;   - ,  	
	inc	R0		;    
	mov	R6,#N1	 	;   (    )
	lcall	Str2tmp
	jz	bg03		;   - ,  	

;  N0  SIM,    
	mov	DPTR,#sCPBRX	;    
	lcall	StrTX		;   +CPBR=
	mov	A,N0		;   
	lcall	ByteTX
	mov	A,N0+1
	lcall	ByteTX
	mov	A,N0+2
	lcall	ByteTX
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  

	lcall	Pause3OK	;  3  (  .  )
	lcall	Pause50		; 50    
	mov	DPTR,#AdrN	;   (',"')
	lcall	CompStr		; 
bg031:	jc	bg03		;- ,   
bg032:	jnz	bg03		; 
;   -  6     
	inc	R0		;    
	mov	R6,#Alf0	;   (  Alf0)
	lcall	Str2bin		;   BIN  ( )

;  N1  SIM,  Alf1  
;     bin  -    
	mov	A,N1		;
	anl	A,#00001111b	;  
	mov	B,#100
	mul	AB		;  100
	mov	R2,A		;
	mov	A,N1+1		;
	anl	A,#00001111b	;  
	mov	B,#10
	mul	AB		;  10
	add	A,R2		;  
	mov	R2,A		;
	mov	A,N1+2		;
	anl	A,#00001111b	;  
	add	A,R2		;    
	mov	N1bin,A		;, , 	
;    N1
	mov	DPTR,#sCPBRX	;     
	lcall	StrTX		;   +CPBR=
	mov	A,N1		;   
	lcall	ByteTX
	mov	A,N1+1
	lcall	ByteTX
	mov	A,N1+2
	lcall	ByteTX
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  

	lcall	Pause3OK	;  3  (  .  )
	lcall	Pause50		; 50    
	mov	DPTR,#AdrN	;   (',"')
	lcall	CompStr		; 
	jc	bg031		;- ,   
	jnz	bg032		; 
;   -  6     
	inc	R0		;    
	mov	R6,#Alf1	;   (  Alf1)
	lcall	Str2bin		;   BIN  ( )

;    ,       
;              
	mov	DPTR,#sATCK	; AT+CKPD= 
	lcall	StrTX		;   AT...
	mov	A,#'V'		;  (   -   )
	lcall	ByteTX		;  
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  
	lcall	Pause3		; 3  (   -   )
;  -    <.>
	mov	DPTR,#sATCK	; AT+CKPD= 
	lcall	StrTX		;   AT...
	mov	A,#'V'		; 
	lcall	ByteTX		;  
	mov	A,#'V'		; 
	lcall	ByteTX		;  
;  -    <> -       - 
	mov	R2,N1bin	;   
zn1:	mov	A,#'V'		; 
	lcall	ByteTX		;  
	djnz	R2,zn1		;    
	mov	A,#'['		; ".." - ""
	lcall	ByteTX		; 
	mov	A,#0Dh
	lcall	ByteTX
	lcall	ResBufRs	;  
	lcall	Pause3OK	;  3   
	lcall	Pause50		; 50    

;   6   AT+CKPD=:	; 

;    (   ) D=Alf0-Alf1
;1. delta = Alf0 - Alf1  -   ()
	mov	A,Alf1		; tmp  
	mov	tmpLo,A
	mov	A,Alf1+1
	mov	tmpHi,A
	mov	R0,#Alf0	; 
	lcall	SubDW		;:  D=delta  tmp 
;2. delta.D15 = 0 -  , ..      ( bWay = bDirect)
;   delta.D15 = 1 -  , ..   ( bWay = not bDirect, delta = not delta + 1) \-delta\
;      bWay   , delta -     
	mov	A,tmpHi		; 7 -  
	mov	C,bDirect
	mov	bWay,C
	jnb	ACC.7,dl01	;  -    ( )
	cpl	C		;  -   
	mov	bWay,C
	lcall	MinusTmp	;delta  
dl01:
;3.       ,      
;   Max = 19200 (24*60*60/4.5) -     (24 )
;   sign = Max/2 - delta :     
	mov	A,tmpLo		;Alf1   ,   delta
	mov	Alf1,A 
	mov	A,tmpHi	
	mov	Alf1+1,A 
	mov	Alf0,#Low(19200/2)
	mov	Alf0+1,#High(19200/2)
	mov	R0,#Alf0
	lcall	SubDW		;:  sign  tmp 
;   sign.D15 = 0 -  , ..        -    
;   sign.D15 = 1 -  , ..     : bWay = not bWay; delta = Max - delta
	mov	A,tmpHi		; 7 -  
	mov	C,ACC.7
	mov	A,Alf1		;delta  Alf1   tmp 
	mov	tmpLo,A 
	mov	A,Alf1+1	
	mov	tmpHi,A 
	jnc	dl02		;  -     
	mov	C,bWay
	cpl	C		;  -    
	mov	bWay,C
	mov	Alf0,#Low(19200)
	mov	Alf0+1,#High(19200)
	mov	R0,#Alf0
	lcall	SubDW		;:   delta  tmp 
dl02:
;-    bWay   , delta -     
;(        ) 

;      (  ):
;1.         , ..    
;2. ..   () = NStep * T0
;3.          (N) =  / 
;..    : NStep + N
;NStep1 = NStep + K * NStep * T0 / T, 
;NStep1 -       ( ,   )
;NStep -    (  ), ..    
;K - ,      ("+1"-" ", "-1"-" ")
;	   bWay (bWay=0 -> "-1"; bWay=1 -> "+1")
;T0 -    ()   () ,   Switch=0 (25  
;          ) 
;T -    ()   (4.5  bStep=1,  9  bStep=0)
;----------
;       25, ..: 0=1; =180  =360
	mov	A,tmpLo		;    Alf0
	mov	Alf0,A
	mov	A,tmpHi
	mov	Alf0+1,A

	mov	A,tmpHi		;    2  delta  
	clr	C		;..      90,   180
	rrc	A		;    1 
	mov	tmpHi,A
	mov	A,tmpLo
	rrc	A
	mov	tmpLo,A

	mov	R2,#90		;    (4.5  9 )
	jb	bStep,dl10
	mov	R2,#180
dl10:
	lcall	DivDW		; tmp  R2,   
	jb	bWay,dl11	;  " ",   
				;" " - 
	cpl	A		;"" 
	inc	A
	add	A,Alf0		;  
	mov	tmpLo,A
	mov	A,Alf0+1	;  
	addc	A,#0FFh
	mov	tmpHi,A
	ajmp	dl12

dl11:				; ""    
	add	A,Alf0		;  
	mov	tmpLo,A
	mov	A,Alf0+1	;  
	addc	A,#0
	mov	tmpHi,A
dl12:
;  tmp         

;        
	mov	C,bDirect	; ""  
	mov	bDirTmp,C
	mov	C,bWay		; ""  
	mov	bDirect,C
	mov	A,tmpLo		;   
	mov	NStep,A
	mov	A,tmpHi
	mov	NStep+1,A
	clr	Switch		;"" 
;
;==============    =============
cyrcle:	
;           6 
; AT+CKPD=:	; 
	jnb	LtEn,cr21	;    
	clr	LtEn		;
	mov	DPTR,#sATCK	; AT+CKPD= 
	lcall	StrTX		;   AT...
	mov	A,#':'
	lcall	ByteTX
	mov	A,#0Dh
	lcall	ByteTX

cr21:	mov	A,NStep+1	;     
	jnb	ACC.7,cr20	;  - 

				;  -  " "
	mov	C,bDirTmp	; ""  
	mov	bDirect,C
	setb	Switch		;""   - 
cr20:		

	lcall	Key		;   
	jz	cyrcle		; 
	lcall	Pause50		; 50
	lcall	Key		;    
	jz	cyrcle		; 
; -  -       
cr04:	clr	EA		; 
	mov	P1,#0		; 
cr01:
	lcall	Key		;   
	jnz	cr01		; 
	lcall	Nop50		; 50
	lcall	Key		;    
	jnz	cr01		; 
;  -     
cr02:
	lcall	Key		;   
	jz	cr02		;   
	jb	ACC.7,cr_Le	; .7,  Left (.6) -  
	lcall	Nop50		; 50
	jb	Right,cr02	; 
;	mov	C,bDirect	;  
;	mov	bDirTmp,C
	setb	bDirect		;  " "
	ajmp	cr10

cr_Le:	lcall	Nop50		; 50
	jb	Left,cr02	; 
;	mov	C,bDirect	;  
;	mov	bDirTmp,C
	clr	bDirect		;  " "

;  -    
cr10:	clr	Switch		;"" 
	setb	EA		; 
cr03:
	lcall	Key		;   
	jnz	cr03		;  -  
	lcall	Pause50		; 50
	lcall	Key		;    
	jnz	cr03		;  -  

	ajmp	cr04		; - 

        END
;
