$PAGEWIDTH=120
;*********************************************************************
;         
;    V 0.07  			                           22-05-2009
;---------------------------------------------------------------------

;
;*********************************************************************
;
        DefSeg  All,Absolute
        Seg     All
;
;=========================================================
;                
;=========================================================
Reg0	equ	0	;R0
Reg1	equ	1	;R1
Reg4	equ	4	;R4
Steck   equ     7       ; 


mT50	equ	30h	;  50
mSP1	equ	31h	; 1 (  )
mSout	equ	32h	;   50

PTA	equ	33h	;
PTB	equ	34h	;

;=========================================================
;                
;=========================================================
bStep	equ	20h.0	;    
			;0-  (  4)/1- (  8)
bDirect	equ	20h.1	;    
			;1- R7(  )/0- R7( ..)
bDirTmp	equ	20h.0	;     
			;1- R7(  )/0- R7( ..)


;=========================================================

;R0 - 
;R1 - 
;R2 -  
;R3 -  50
;R4 -  50
;R5 - 
;R6 -    
;R7 -    

;=========================================================
;              / 
;=========================================================

Kontr0	equ	P0.2	; (1-)

; 1 -     (4..7)

;               P3.0    ;RxD - in    60
;               P3.1    ;TxD - out   60

Switch	equ	P3.2	;  (=1 / =0)
Kontr	equ	P3.3	; (1-)

Direct	equ	P3.4	;  (1-/0- R7)
Step	equ	P3.5	;0-  (  4)/1- (  8)
Right	equ	P3.6	; "/+" (  )
Left	equ	P3.7	; "/-" (  )

;=========================================================
;                      
;=========================================================

        ORG     0
        LJMP    Begin
;
;	ORG	3		;   INT0
;	
        db      ' std007 '	; 
;
        ORG     0BH             ;Timer counter TF0 Interrapt
        LJMP    TimInt
;
        ORG     13H             ;pp  INT1 
        reti
;
        ORG     1BH             ;Timer counter TF1 Interrapt
        ljmp	Time50

        ORG     23H             ;  . 
        reti
;
;
StepTable8:			;  ( )
	db	10001111b
	db	11001111b
	db	01001111b
	db	01101111b
	db	00101111b
	db	00111111b
	db	00011111b
	db	10011111b
StepTable:			;  
	db	10001111b
	db	01001111b
	db	00101111b
	db	00011111b
	db	10001111b
	db	01001111b
	db	00101111b
	db	00011111b


;**********************************************
;       T/C1 (50 )
;**********************************************
Time50:	push	ACC
	push	PSW

	dec	mT50		; 

	mov	A,mSout		; ""
	jz	t_end		; -   
	add	A,#5
	jnc	t_On		; 250 -  
	mov	A,mSout
	inc	A
	jz	t_Q10		;=FF -   
	mov	A,P1		; 250  254 -  (Q=2)
	xrl	A,mSP1		;  
	mov	P1,A
	inc	mSout		;  
	ajmp	t_end
t_On:	mov	P1,mSP1		; 
	inc	mSout		;  
	ajmp	t_end
t_Q10:	mov	A,mT50		; 
	anl	A,#00000011b	;  (1:4)
	mov	P1,#0		;
	jnz	t_end
	mov	P1,mSP1		;

t_end:	pop	PSW
	pop	ACC
	reti

;  36  ( 0,8 ) -  30

;  25         mSP1
;     "" MSout=1
;     ,  mSout=0
;  "":
;mSout		 
;0		 
;1..250		
;251..254 	   
;255		1/4 - , 3/4 - 	

;**********************************************
;       T/C0 (25 )
;**********************************************
TimInt: push    ACC
        push    PSW

        MOV     TH0,#8BH        ;  T/C0 = 25
        MOV     TL0,#7AH        ;25 ms  (8B7Ah)  14,31818
                                ;    
	mov	A,PTA		; 
	jz	ti01		; - 
	dec	PTA		; -1  25
ti01:
	dec	PTB		; (50,100,200,400,800,1.6c,3.2c,6.4c)
	mov	A,PTB
;  
	mov	C,ACC.3		;
	jnb	Switch,ti04
	mov	C,ACC.5		;
ti04:
	mov	Kontr,C
	cpl	C
	mov	Kontr0,C

	jnb	Switch,ti02
				;    9 (  360)
	anl	A,#11b		;  4    4 ()
	jnb	bStep,ti12	;Step=0 - , =1 - 
	anl	A,#1b		;  2    8 ()
ti12:	jnz	ti03
	djnz	R6,ti03
	mov	R6,#90		; = 90 (904=360)

ti02:	jnb	bDirect,ti13	;
	inc	R7		;   (1...8)   
	cjne	R7,#9,ti05
	mov	R7,#1
	ajmp	ti05
ti13:				;   ( ) 8...1
	djnz	R7,ti05		;    
	mov	R7,#8		;  

ti05:	mov	A,R7
	dec	A
	movc	A,@A+DPTR	;     
;	mov	P1,A
	mov	mSP1,A		; 
	mov	mSout,#1	;  
ti03:
;
	pop     PSW
        pop     ACC
        RETI


;******************************************************
;                    
;******************************************************

;------------------------------------------------------
;    
;  =0 -   , ACC<>0 - - 
;------------------------------------------------------
Key: 	mov	A,P3
	anl	A,#11000000b	;  Right,Left
	xrl	A,#11000000b	; 
	ret

;------------------------------------------------------
; 50  ( )
;------------------------------------------------------
Pause50: mov	PTA,#2
	ajmp	pa01
;------------------------------------------------------
; 1  ( )
;------------------------------------------------------
Pause:	mov	PTA,#100
pa01:	mov	A,PTA
	jnz	pa01
	ret

;------------------------------------------------------
; 50  (  ) T=0,8
;------------------------------------------------------
Nop50:  mov	R3,#58		;58  -  50
np01:	mov	R4,#0
np02:	nop			;4  256 
	nop			; 858 
	djnz	R4,np02
	djnz	R3,np01
	ret


;******************************************************
;                  
;******************************************************
Begin:  mov     SP,#Steck       ; 
	mov	P1,#0		; 
;------      ------
	mov	C,Step		; 
	jb	Right,bg11	; "  "
	cpl	C		;  -  
bg11:	mov	bStep,C		; " "

	mov	C,Direct	; 
	jb	Left,bg12	; "  "
	cpl	C		;  -  
bg12:	mov	bDirect,C	; ""

bg13:	lcall	Key		;  
	jnz	bg13
	lcall	Nop50		;" "
	lcall	Key		;    
	jnz	bg13		; 

;-------------   -------------
        mov     SCON,#01110000b ;    1
;-------------  ------------
        MOV     TMOD,#00100001b ;  :
        ;T/C0:      TR0
        ;      16  /
        ;T/C1:      TR1
        ;      8   /
	;          50 
        mov     TH1,#196        ;  50 
        mov     TL1,#196	;14.3
	mov	PCON,#10000000b	;SMOD=1
        MOV     TH0,#8BH        ;  T/C0 = 25
        MOV     TL0,#7AH        ;25 ms  (8B7Ah)  14,31818
	mov	R6,#1		;   90 (   )
	mov	PTB,#1		;  -    
        SETB    TR1             ; T/C1
        SETB    TR0             ; T/C0
        SETB    PT1             ; T/C1
        MOV     IE,#00001010b   ;   T/C0  /1

	mov	R7,#8		;    / (8 )
	mov	DPTR,#StepTable	;  ( -  4)
	jnb	bStep,bg01	;Step=0 - , =1 - 
	mov	DPTR,#StepTable8 ;  ( -  8)
bg01:	mov	mSP1,#0		; 
	mov	mSout,#0	; 
        SETB    EA              ; 
;
cyrcle:	lcall	Key		;   
	jz	cyrcle		; 
	lcall	Pause50		; 50
	lcall	Key		;    
	jz	cyrcle		; 
; -  -       
cr04:	clr	EA		; 
	mov	P1,#0		; 
cr01:
	lcall	Key		;   
	jnz	cr01		; 
	lcall	Nop50		; 50
	lcall	Key		;    
	jnz	cr01		; 
;  -     
cr02:
	lcall	Key		;   
	jz	cr02		;   
	jb	ACC.7,cr_Le	; .7,  Left (.6) -  
	lcall	Nop50		; 50
	jb	Right,cr02	; 
;	mov	C,bDirect	;  
;	mov	bDirTmp,C
	setb	bDirect		;  " "
	ajmp	cr10

cr_Le:	lcall	Nop50		; 50
	jb	Left,cr02	; 
;	mov	C,bDirect	;  
;	mov	bDirTmp,C
	clr	bDirect		;  " "

;  -    
cr10:	clr	Switch		;"" 
	setb	EA		; 
cr03:
	lcall	Key		;   
	jnz	cr03		;  -  
	lcall	Pause50		; 50
	lcall	Key		;    
	jnz	cr03		;  -  

	ajmp	cr04		; - 

        END
;
