                                             
                                     ;  
                                  
  processor 12f675  
  include <p12F675.inc>

  Org    h'0000'
  goto   MAIN
  Org    h'0004'
  goto   INTERRUPT 
       
   __CONFIG 3184H
   errorlevel-302
 CBLOCK  20H
minuta
ADC_H5
ADC_L5 
ADC_H       
ADC_L     
ADC_HM   
ADC_LM  
_2             
CHECK0
CHECK1   
RT 
LOOP1    
LOOP2 
sec_60 
TEMP
W_TEMP        
S_TEMP
FLAG                 ; 0-  ""
                          ; 1-  
		              ; 2-  Ubk
		              ; 3- 
                          ; 4-  
                          ; 5- 
                          ; 6- 
 ENDC

         ; 
OUT            EQU  4
RED            EQU  2
KEY            EQU  3

; 
MAIN
        bsf         STATUS, RP0  	 ;   1- 
        CALL     h'3FF'
        ;movlw   h'6c'                     ;    
        movwf   OSCCAL               ;   RC 
        movlw   b'10001111'    	 ;    
        movwf   VRCON          	 ;   = 3,6
        movlw   b'11001011'    	 ;  0,1,3   ,
        movwf   TRISIO         		 ;     
        clrf       OPTION_REG        ;   
        bsf         WPU, 1
        movlw   b'00110010'   	 ;  RC 
        movwf   ANSEL          	 ;  6-.,  
        clrf        PIE1
        bsf        PIE1, TMR1IE        ;   TMR1        
        bcf	   STATUS, RP0       ;   0- 
        clrf        GPIO
        clrf        FLAG
        movlw  b'00011110'           ;    ( 
        movwf   CMCON               ;   COUT), .
        movlw  .250
        movwf   TEMP 
        movwf   CHECK0 
        movwf   CHECK1
        clrf        minuta
        movlw   h'03'
        movwf   ADC_H5
        movlw   h'9A'
        movwf   ADC_L5
        movlw   .60
        movwf   sec_60                    ;    60  
        goto      mm
                                          ;   
 ;==============================================================                   
    
DELAY_250:
        MOVLW 	.250     		 ;  250 
DELAY_N_MS:
        MOVWF 	LOOP1
OUTTER:
        MOVLW   .110     		 ;  1 
        MOVWF   LOOP2
INNER:
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        DECFSZ  LOOP2, F
        GOTO 	INNER
        DECFSZ  LOOP1, F
        GOTO 	OUTTER
        RETURN

  ;   -   EEPROM
;-------------------------------------------------------------------
WRITE_MIN:
        movf     minuta, W
        bsf        STATUS, RP0      	        ;  1
        movwf  EEDATA
        clrw             			  ;   h'00'
        movwf  EEADR
        CALL    M_WR
                          ;   
WR_WAIT_MIN:
        bcf        STATUS, RP0     		 ;   0
        btfss      PIR1, EEIF    			 ;    
        goto      WR_WAIT_MIN    		 ;   
        bcf         PIR1, EEIF            	 ;  
        RETURN
;-----------------------------------------------------------------------------------------------
M_WR:
        
        bsf        EECON1, WREN        ;    EEPROM
        bcf        INTCON, GIE
                  ;   
        movlw  55h
        movwf  EECON2
        movlw  h'AA'
        movwf  EECON2
        bsf        EECON1, WR           ;    
        bsf        INTCON, GIE
        return

                      ;     EEPROM
;-------------------------------------------------------------------
WRITE_L:
        
        movf     ADC_L, W
        bsf        STATUS, RP0      	        ;  1
        movwf  EEDATA
        movlw  .2             			  ;   h'02'
        movwf  EEADR
        CALL    M_WR
                          ;   
WR_WAIT_L:
        bcf        STATUS, RP0     		 ;   0
        btfss      PIR1, EEIF    			 ;    
        goto      WR_WAIT_L    		 ;   
        bcf       PIR1, EEIF            	 ;  
        RETURN
;---------------------------------------------------------------------------------------------------
WRITE_H:
        movf     ADC_H, W
        bsf        STATUS, RP0            ;  1
        movwf  EEDATA
        movlw  .1             	            ;   h'01'
        movwf  EEADR
        CALL    M_WR
                          ;   
WR_WAIT_H:
        bcf       STATUS, RP0     	      ;   0
        btfss     PIR1, EEIF   		      ;    
        goto     WR_WAIT_H      	      ;   
         bcf      PIR1, EEIF                  ;  
        RETURN

;---------------------------------------------------------------------------------------------------
READ_M:
        bsf        STATUS, RP0          ;   1
        movwf  EEADR
        bsf        EECON1, RD            ; 
        movf     EEDATA, W             ;     W
        bcf        STATUS, RP0          ;   0 
        return

    ;    TMR1
;-------------------------------------------------------------------------
INTERRUPT
        movwf   W_TEMP          ;  
        swapf   STATUS, W       ; W, STATUS
        movwf   S_TEMP          ; 

        bcf     PIR1, TMR1IF     ;    TMR1
        
        decfsz  RT, F
        goto    m3
        movlw   .5                      ;  
        movwf   RT
        movfw   minuta             ;   1 ?
        xorlw   .1
        bnz     m2                    ; ,   
        movfw   sec_60            ;  sec_60
        xorlw   .20                   ;   20  
        bnz     m2                    ; ,,   
       
        bsf     FLAG, 5             ; ,   
m2
        decfsz  sec_60, F        ;  60 
        goto    m3
        movlw   .60
        movwf   sec_60           ;    60 
        DECF    minuta, F       ;  
                 
m3
        CALL    CONST              
        
        swapf   S_TEMP, W       ;  
        movwf   STATUS          ; W, STATUS 
        swapf   W_TEMP, F       ;
        swapf   W_TEMP, W 

        retfie
         
                      ;      TMR1
;----------------------------------------------------------------------------------------------------------------------
CONST
        movlw   .60             ;      
        movwf   TMR1H       ;    TMR1
        movlw   .108           
        movwf   TMR1L
        return
       
;---------------------------------------------------------------------------------------------------
INC_MIN
        bsf          GPIO, RED           ;    
        CALL      DELAY_250
        CALL      DELAY_250        ;  0,5  
        bcf         GPIO, RED            ;    
        CALL      DELAY_250
        CALL      DELAY_250        ;  0,5  
        incf         minuta, F
        movfw    minuta
        xorlw      .61                     ;   1 ? 
        bnz         $+3
        movlw    .1
        movwf    minuta
        return
       
;----------------------------------------------------------------------------------------------
WR_MIN
        bcf        FLAG, 0
        bcf        GPIO, OUT 
        CALL    WRITE_MIN        ;     
        CALL    DELAY_250
        CALL    DELAY_250
        CALL    DELAY_250         ;  3  
        CALL    DELAY_250      
        CALL    DELAY_250
        CALL    DELAY_250      
        bsf        GPIO, RED           ;   
        CALL    DELAY_250
        CALL    DELAY_250          ;  0,5  
        bcf        GPIO, RED            ;      
        return  
;-------------------------------------------------------------------------------------------
START_ADC
        movlw     b'10000101'     	    ;   ,  AN0,
        movwf     ADCON0         	    ; - ,  ,
        goto        $+1                        ;     
        goto        $+1                        ;  C_ hold 
        goto        $+1 
              
        bsf          ADCON0,1   		    ;  
        btfsc        ADCON0, 1  	    ;  ?
        goto        $-1           		    ; , 
        movfw    ADRESH      		    ;  , 
        movwf    ADC_H        		    ;   
        bsf          STATUS, RP0 	    ;   1- 
        movfw    ADRESL
        bcf	    STATUS, RP0  	    ;   0- 
        movwf    ADC_L  
        return

;-----------------------------------------------------------------------------------------
S1
                    ;      4,5  
                    ;     ADC_H,ADC_L     ADC_H5, ADC_L5, 
                    ;     
        bsf       FLAG, 0
        movf    ADC_H5, W     	  ;   
        subwf   ADC_H, W      	  ;  
        movwf   _2           		  ;    
                
        movf    ADC_L5, W    	        ;     
        subwf   ADC_L, W      	  ;  
        btfss   STATUS, C     		  ;   
        decf    _2, F          		  ;  
        iorwf   _2, W        			  ;   0
        btfsc   STATUS, Z    		  ;  ,  
        goto    EqLes        		  ;  , 
        btfsc   _2, 7                		  ;   , 
                                         		  ;  
        goto    EqLes    		        ;    
        bsf       FLAG, 1                  ;     
        CALL    INC_MIN
        return
EqLes  
        bsf     FLAG, 2                   ;      Ubk
        return      

                           
;=========================================================        
mm                                                  
                  ;  TMR1
;--------------------------------------------------------------------
	  CALL    CONST
        movlw   b'00100000'      ;   TMR1   
        movwf   T1CON            ;    1:4
        movlw   .5               
        movwf   RT
        movlw   b'11000000'     ;    
        movwf   INTCON          ;      

MAIN1                 ;    -   EEPROM
       bcf        FLAG, 0
;--------------------------------------------------------------------
       clrw             			       ;   h'00'
       CALL    READ_M 
       movwf  minuta                  ;    MINUTA
       xorlw   h'ff'
       bnz       $+3
       movlw  .1
       movwf  minuta
       
      

                 ;      EEPROM
;--------------------------------------------------------------------
       movlw  .1               			 ;   h'01'
       CALL    READ_M 
       movwf  ADC_HM                      ;    AD_HM
       
       movlw  .2                                 ;   h'02'
       CALL   READ_M
       movwf  ADC_LM           	 	 ;    AD_LM
       
       
CYCLE                      ;  
                         ;     
 ;---------------------------------------------------------------------------
       CALL      START_ADC
 
                     ;     ""
;----------------------------------------------------------------------
        btfsc         GPIO, KEY       ;  ?
        goto         m0
        movlw     .30 
        CALL       DELAY_N_MS 
        btfsc        GPIO, KEY       ;  ?
        goto        m0
        btfss        FLAG, 0
        clrf         minuta  
        CALL      S1
        goto        CYCLE 
m0
        btfss     FLAG, 2                 ;   Ubk
        goto     m1
                                   ;   Ubk
;-------------------------------------------------------------------------------------------------------
        CALL    WRITE_L
        CALL    WRITE_H
        bcf       FLAG, 2
        bsf       GPIO, RED         ; red
        CALL    DELAY_250
        CALL    DELAY_250       ;  0,5  
        bcf       GPIO, RED        ; red
        goto     MAIN1
m1
        btfss     FLAG, 1
        goto     m4
        bcf        FLAG, 1
        CALL      WR_MIN                    ;    
        goto       MAIN1

                    ;      EEPROM 
                    ;     ADC_H,ADC_L     ADC_HM, ADC_LM 
                    ;( ) ,    GP5   
m4     
        movf    ADC_HM, W     	  ;   
        subwf   ADC_H, W      	  ;  
        movwf   _2           		  ;    
                
        movf    ADC_LM, W    	  ;     
        subwf   ADC_L, W      	  ;  
        btfss   STATUS, C     		  ;   
        decf    _2, F          		  ;  
        iorwf   _2, W        			  ;   0
        btfsc   STATUS, Z    		  ;  ,  
        goto    EqualLess      		  ;  , 
        btfsc   _2, 7                		  ;   , 
                                         		  ;  
        goto    EqualLess      		  ;    
        movlw   .250
        movwf   CHECK1
        movlw    .6
        CALL       DELAY_N_MS   
        decfsz  CHECK0, F         		  ;    
        goto    m5
        movlw   .250
        movwf  CHECK0
        bcf      GPIO, 5 
        bcf     GPIO,OUT    		; green
        goto   m5
        
        
EqualLess 
        movlw   .250
        movwf  CHECK0  
        movlw   .6 
        CALL       DELAY_N_MS 
        decfsz  CHECK1, F          		 ;     
        goto    m5
        movlw   .250
        movwf   CHECK1
        bsf      GPIO, 5 
        ;bsf     GPIO,OUT             ; green

m5
        btfss      FLAG, 5             ;   ? 
        goto      m6
             
        bcf        GPIO, 5              ;  20   
        CALL    DELAY_250       
        CALL    DELAY_250         ; 
        bsf        GPIO, 5
        CALL    DELAY_250       
        CALL    DELAY_250
         
        movf     minuta, F
        bnz       m6
        bcf        FLAG, 5            ;  
        bcf        FLAG, 4            ;     
m6
        movfw   minuta             ;     
        xorlw     h'ff'                  ;   
        bnz       $+4                   ; , 
        clrw             			   ;    h'00' 
        CALL    READ_M 
        movwf  minuta             ;   EEPROM                               
        
     
                        ;    
;------------------------------------------------------------------------------------------------------------------------------------------------
        btfsc     GPIO, OUT               ;   
        goto     m8
m9
        btfss     CMCON, COUT         ;     
        goto     m7
        movlw   .1                            ;   
        CALL    DELAY_N_MS          ; 
        decfsz   TEMP, F  
        goto      m6
        movlw  .250
        movwf   TEMP
        btfss     GPIO, 5                 
        goto     m7
        bcf       FLAG, 5                    ;   
        movlw   .60
        movwf   sec_60                    ;    60   
        bsf       GPIO, OUT               ;   ,   
        bsf      T1CON, TMR1ON       ;   TMR1
        bsf       FLAG, 4                    ;     
        goto      CYCLE  
m7
        movlw  .250
        movwf   TEMP
        btfsc     FLAG, 4                    ;   
        goto     CYCLE
        bcf       GPIO, OUT
        bcf       T1CON, TMR1ON
        goto     MAIN1   
m8
        btfss     FLAG, 5                  ;  
        goto     m7
        goto     m9 
   
        END
