                                 
                                  ; - 
                                  ;   4 , TMR1 
                                  ;    
                                  ;   DS18S20

 processor 16f628A  
 include <p16F628A.inc>

          Org    h'0000'
          goto   MAIN
          Org    h'0004'
          goto   INTERRUPT 
       
   __CONFIG  3F03H
   errorlevel-302
   CBLOCK  20H
; 
                ;   
dig_EMB		;    
dig_DMB		;    
dig_EHB		;    
dig_DHB		;    

dig_Zt          ;   
dig_Et          ;    
dig_Dt          ;   
dig_o           ;   

dig_EM		;   
dig_DM		;   
dig_EH		;   
dig_DH		;   


           ;    ( )
ind_EM		;   
ind_DM		;   
ind_EH		;   
ind_DH		;   
anodNo          ;    4 2 1 0
MEM
count1		;     
count2
sec_60
T_C             ;    
_N              ;    
O_BYTE          ;    
I_BYTE          ;     
LOOP1		;              
LOOP2           ;
sec_3
LSB             ;  
MSB             ;
TEMP
RT
W_TEMP
S_TEMP
F_TEMP
FLAG		;    
                                ; 0-  
                                ; 1-   count1
                                ; 2- "" 
                                ; 3-  
                                ; 4-  
                                ; 5- 
                                ; 6- ""
                                ; 7-  

 ENDC
      ; 
SB_H EQU  3
SB_M EQU  1
SB_K EQU  2                     ; 
SB_B EQU  0
SB_R EQU  5
DATA_PIN   EQU  4
temp EQU  3

MAIN
                                    
	bsf     STATUS, RP0     ; "" ""    
        bcf     STATUS, RP1     ; 1- .
        bsf     PIE1, TMR1IE    ;  TMR1
        clrf    VRCON           ;    
        movlw   b'10100000'
	movwf   TRISA           ;  5  7  A  ,      
        movlw   b'00000001'
	movwf   TRISB           ;  0  B  ,   
        movlw   b'01000011'	; TMR0      16, 
	movwf	OPTION_REG      ;   ,
        bcf	STATUS, RP0     ;   
        movlw   b'11000000'     ;    
        movwf   INTCON          ;    
        movlw   .07             ;  .
        movwf   CMCON           ; --------"--------
        clrf    RCSTA           ;  USART.
        clrf    T2CON           ; ----"----  TMR2.
        clrf    CCP1CON         ; ----"----  CCP.
	clrf	PORTA
	clrf	PORTB
	clrf	TMR0
        movlw   h'fe'
        movwf   anodNo
        movlw   b'00001111'
        movwf   ind_EM		;   
        movwf   ind_DM		;   
        movwf   ind_EH		;   
        movwf   ind_DH          ;   
        movlw   b'0000001'
        movwf   FLAG
        clrf 	dig_DMB	        ;  
        clrf 	dig_EMB
        movlw   .7
        movwf   dig_EHB
        clrf 	dig_DHB	
        clrf 	dig_DH	        ; 
       	clrf 	dig_EH	        ; 
        clrf 	dig_DM	        ;  
        clrf 	dig_EM
	movlw   .125            ; 
	movwf	count1	        ;    
        movwf   count2          ; (125x2    = 4)
        movlw   .60
        movwf   sec_60  
        movlw   .3
        movwf   sec_3 
        clrf    dig_Zt
        clrf    dig_Et           
        clrf    dig_Dt
        movlw   .10
        movwf    dig_o 
        clrf    LSB
        clrf    MSB
        bcf     PORTA, 6 
                            ;  TMR1
;--------------------------------------------------------------------

        movlw   b'00100001'      ;   TMR1   
        movwf   T1CON            ;    1:4
        CALL    CONST
        movlw   .5               
        movwf   RT
                            ; 
;-----------------------------------------------------------------
KEY     macro   x,SB_x,x
        bcf     FLAG, x         ;   x
        btfss   PORTB, SB_x     ;  "x" ?
        bsf     FLAG, x         ; ,   x
        endm
;----------------------------------------------------------------
IND     macro   dig_EM,dig_DM,dig_EH
        movfw	dig_EM         
	call	MASKA          
        movwf   ind_EM         
          
        movfw	dig_DM 
	call	MASKA          
        movwf   ind_DM

        movfw	dig_EH
       	call	MASKA          
        movwf   ind_EH
        endm
;------------------------------------------------------------------------
BUD     macro   dig_EMB,dig_EM
        movfw   dig_EMB
        subwf   dig_EM, W
        bnz     m23
        endm
;-----------------------------------------------------------------------
BANK_1  macro   k
        bsf     STATUS, RP0
        movlw   k
        movwf   TRISB           
        bcf	STATUS, RP0 
        endm  
                                       ;   
;----------------------------------------------------------------------------------------------
        
minuta_1
        bcf     FLAG, temp        
        CALL    CYCLE
              
                             ;     
;-------------------------------------------------------------------------------------------------
        
        BANK_1   h'0F'          ;  RB0, RB1, RB2, RB3  

        KEY      4, SB_K,4      ;  "" 
        KEY      2, SB_H, 2     ;  ""
        KEY      6, SB_M, 6     ;  ""

        BANK_1   h'01'          ;  RB1, RB2, RB3  
      
        KEY     5, SB_B, 5      ;  ""

        btfsc   FLAG, 5
        goto    m10
       
        btfsc   FLAG, 6         ;   ?
        goto	m5              ; ,   
        btfsc   FLAG, 2         ;   ?
        goto    m6              ; ,   

        btfsc   FLAG, 4         ;    ?
        goto    m2              ; ,   

        decfsz  sec_3, F        
        goto    $+6
        movlw   .3
        movwf   sec_3 

        btfss   PORTA, SB_R 
        goto    $+2             ; ,   
        goto    TERMO

       
;--------------------------------------------------------------------------------------------------
m4	           
        bcf     PORTA, 6 
        IND     dig_EM,dig_DM,dig_EH  ;     W
                                      ;   W   
	                              ;     
                                      ;    
                                      ;    
        movfw	dig_DH 
     	call	MASKA          ;     
        movwf   ind_DH
p1      
        goto    minuta_1
       
 
            ;           
;-----------------------------------------------------------------------------------------------
MASKA:
                     	
;   W                     
;      7- 
                addwf	PCL,f
;   7  6  5  4  3  2  1  0
;  13 12 11 10  9  8  7  
;    2  4  8  1        G

                        ; 2481 
                retlw	b'00001111'       ;  0 
	        retlw	b'00011111'       ;  1 
	        retlw	b'10001111'       ;  2 
	        retlw	b'10011111'       ;  3 
	        retlw	b'01001111'       ;  4 
	        retlw	b'01011111'       ;  5 
	        retlw	b'11001111'       ;  6 
	        retlw	b'11011111'       ;  7 
	        retlw	b'00101111'       ;  8 
	        retlw	b'00111111'       ;  9 
		retlw	b'01100111'       ;  u  -10   1010
                retlw	b'11111101'       ;  G  -11
                retlw	b'11111111'       ;  . -12
              
                                ;      
;----------------------------------------------------------------------------------------------
m5
        
        incf	dig_EM,f
        movfw   dig_EM
        xorlw   .10
        bnz     m4
        clrf    dig_EM
        incf	dig_DM,f
        movfw   dig_DM
        xorlw   .6
        btfsc   STATUS, Z
        clrf    dig_DM 
        goto    m4     
m6
        
        incf	dig_EH,f
        movfw   dig_EH
        xorlw   .4
        bnz     k_h
        movfw   dig_DH		
	xorlw   .2
        bnz     m4
        clrf    dig_DH	
        clrf    dig_EH
k_h
        movfw   dig_EH
        xorlw   .10
        bnz     m4
        clrf    dig_EH
        incf    dig_DH,F
        movfw   dig_DH		
	xorlw   .3
        btfsc   STATUS, Z
        clrf    dig_DH
        goto    m4
m2
        clrf    dig_EM
        clrf    dig_DM
        bsf     FLAG, 0        ;   
        movlw   .60
        movwf   sec_60          ;    
        goto    m4

                                 ;   
;--------------------------------------------------------------------------------------------
m10
        btfsc   FLAG, 6          ;   ?
        goto	m11              ; ,   
        btfsc   FLAG, 2          ;   ?
        goto    m12              ; ,   
        btfsc   FLAG, 4          ;    ?
        goto    m22              ; ,   
        goto    m4b      

;-------------------------------------------------------------------------------------------------
m11        
        
        incf	dig_EMB,f
        movfw   dig_EMB
        xorlw   .10
        bnz     m4b
        clrf    dig_EMB
        incf	dig_DMB,f
        movfw   dig_DMB
        xorlw   .6
        btfsc   STATUS, Z
        clrf    dig_DMB 
        goto    m4b     
m12
        
        incf	dig_EHB,f
        movfw   dig_EHB
        xorlw   .4
        bnz     k_hb
        movfw   dig_DHB		
	xorlw   .2
        bnz     m4b
        clrf    dig_DHB
        clrf    dig_EHB
k_hb
        movfw   dig_EHB
        xorlw   .10
        bnz     m4b
        clrf    dig_EHB
        incf    dig_DHB,F
        movfw   dig_DHB		
	xorlw   .3
        btfsc   STATUS, Z
        clrf    dig_DHB
        goto    m4b                                         
m22
        clrf    dig_EMB
        clrf    dig_DMB
        
            
;--------------------------------------------------------------------------------------------------
m4b	           
        
        IND     dig_EMB,dig_DMB,dig_EHB      ;     W
                                             ;   W   
	                                     ;     
                                             ;    
                                             ;    
        

        movfw   dig_DHB
        call	MASKA          ;     
        movwf   ind_DH

        goto    minuta_1 
        
               
                              
                           ;   
;************************************************************************************************
TERMO
                
        bsf     FLAG, temp
                            ;      
;-------------------------------------------------------------------------------------------------
        
        CALL    START_DS    ;   
        CALL    READ_T      ;                                 
                           
        btfss   MSB, 0      ;  ? 
        goto    $+4                                
        comf    LSB, F      ;      
        incf    LSB, F
        bsf     FLAG, 7     ;    

                            ;        1  
;---------------------------------------------------------------------------------------------
    
        rrf     LSB, F     ;    
        btfss   LSB, 7      ; 0,5  ?
        goto    $+3
        bcf     LSB, 7 
        incf    LSB, F      ; ,    

                                        ;     - 
;--------------------------------------------------------------------------------------------------------

        clrf    dig_Zt
        clrf    dig_Et           
        clrf    dig_Dt
CON_100
        movlw   .100
        subwf   LSB, W     ;  100   
        btfss   STATUS, C         
        goto    CON_10
        incf    dig_Zt, F
        movwf   LSB
        goto    CON_100
CON_10
        movlw   .10
        subwf   LSB, W
        btfss   STATUS, C
        goto    end_con
        incf    dig_Dt, F 
        movwf   LSB
        goto    CON_10
end_con
        movf    LSB, W
        movwf   dig_Et 
tmp
;--------------------------------------------------------------------------------------------
        
      
        IND     dig_o,dig_Et,dig_Dt   ;     W
                                      ;   W   
	                              ;     
                                      ;     
                                      ;     
        

        btfsc	FLAG, 7       ;    ?
        goto    mz
        movf    dig_Zt, f      ;     
        bnz     $+3            ;   ""
        movlw   .12
        movwf   dig_Zt
        movfw	dig_Zt         ;     W
	call	MASKA          ;   W   
        movwf   ind_DH         ;     
        goto    $+5
mz
        bcf     FLAG, 7        ;      
        movlw   .11            ;     ""
        movwf   dig_Zt
        goto    $-7            ;   
        CALL    CYCLE

        decfsz  sec_3, F
        goto    tmp
        movlw   .3
        movwf   sec_3 

        btfss   PORTA, SB_R    ;    ?
        goto    TERMO          ; ,   

        bcf     PORTA, 6 
        goto    m4



                                        ; 
;***************************************************************************************************        
CYCLE                                  ;  
                          ;       
secunda
       
                                    ;  
;---------------------------------------------------------------------------------------------------

        BUD     dig_EMB,dig_EM
        BUD     dig_DMB,dig_DM      ;    
        BUD     dig_EHB,dig_EH
        
        movfw   dig_DHB
        subwf   dig_DH, W
        btfsc   STATUS, Z
        bcf     PORTB, 2          ;  ,  
        
m23         
        movlw   .6                ;  4    1:16 
        movwf	TMR0	          ;  1   16x(255-6)
	bcf	INTCON,T0IF       ;     TMR0

ms_4
        btfss	FLAG, 0           ;  ?
        goto	no_min
        bcf	FLAG, 0 	  ;   
no_min        
        btfss	INTCON,T0IF	  ;   ,
	goto	ms_4              ;  TMR0   250 

                  ;   4 ,    
;------------------------------------------------------------------------------------------------
;              
;       2     1      18     17
;  RA   3     2      1      0

        bsf     STATUS,C
        rrf     anodNo,f        ;  AnodNo  3 -> 2 -> 1 -> 0
        BC      Nextanod        ;     ,   
        bcf     anodNo,3        ;    ,  AnodNo=3,   
        movlw   anodNo          ; ,     , 
        movwf   FSR             ;    
Nextanod
        movlw   b'11111111'
        movwf   PORTA           ;  
        decf    FSR,f           ;     e
        movfw   INDF            ;         
        movwf   PORTB           ;      
        movfw   anodNo
        movwf   PORTA           ;    
        btfsc   FLAG, 1         ;    count1 ? 
        GOTO    m1              ; ,   ,   count2
	decfsz	count1,f	; ,  4      250 , 
	goto	secunda		;     1,0 
        movlw   .125            ; 
	movwf	count1
        bsf     FLAG, 1         ;     count1
        btfsc   FLAG, temp
        goto    m1
        bcf     PORTB, 0 
        BANK_1   h'08'          ;  RB0  ,   
m1
        decfsz	count2,f        ;   125  
        goto	secunda         ;    
        movlw   .125            ; 
	movwf	count2
        bcf     FLAG, 1         ;     count1
        return
;-------------------------------------------------------------------------------------------
TIME
      
        incf	dig_EM,f
        movfw   dig_EM
        xorlw   .10
        bnz     m3_1
        clrf    dig_EM         ;     
        incf	dig_DM,f
        movfw   dig_DM
        xorlw   .6
        bnz     m3_1		
	clrf    dig_DM
   
        incf	dig_EH,f
        movfw   dig_EH
        xorlw   .4
        bnz      m_h
        movfw   dig_DH		
	xorlw   .2
        bnz     m3_1
        clrf    dig_DH	
        clrf    dig_EH
m_h
        movfw   dig_EH
        xorlw   .10
        bnz     m3_1 
        clrf    dig_EH
        incf    dig_DH,F
        movfw   dig_DH		
	xorlw   .3
        btfsc   STATUS, Z
        clrf    dig_DH
m3_1
        return
                  ;        
;-------------------------------------------------------------------------------
READ_T	        
        CALL	INIT
	MOVLW	0xCC		;   
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	MOVLW	0xBE		;    
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	                	    ;  
	CALL 	IN_BYTE
	MOVWF	LSB     	;    
	CALL 	IN_BYTE
	MOVWF	MSB     	;    
	CALL    PIN_LO          ;    
        return
               

                     ;      
;--------------------------------------------------------------------------------------- 
START_DS
	CALL	INIT
	MOVLW	0xCC		;   
	MOVWF	O_BYTE
        CALL	OUT_BYTE
	MOVLW	0x44		;   
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	RETLW	0xFF

;-------------------------------------------------------------------------------
                     ;     1-Wire
;-----------------------------------------------------------------------------------
INIT:
        CALL    PIN_HI
        CALL    PIN_LO
        MOVLW   .50              ;  500  
        CALL 	DELAY_10USEC
        CALL    PIN_HI
        MOVLW   .50              ;  500 
        CALL 	DELAY_10USEC
        RETURN

;------------------------------------------------------------------------------
IN_BYTE:              		;    W 
        MOVLW   .8
        MOVWF    _N
        CLRF    I_BYTE
IN_BYTE_1:
        CALL 	PIN_LO
        NOP
        CALL 	PIN_HI
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        MOVF    PORTA, W        
        MOVWF   TEMP
        BTFSS   TEMP, DATA_PIN
        BCF 	STATUS, C       
        BTFSC   TEMP, DATA_PIN
        BSF 	STATUS, C       
        RRF     I_BYTE, F
        MOVLW 	.6              
        CALL    DELAY_10USEC
        DECFSZ  _N, F
        GOTO    IN_BYTE_1
        MOVFW   I_BYTE          ;    W
        RETURN


;------------------------------------------
OUT_BYTE:
        MOVLW   .8
        MOVWF   _N
OUT_BYTE_1:
        RRF     O_BYTE, F
        BTFSS   STATUS, C
        GOTO    OUT_0
        GOTO    OUT_1
OUT_BYTE_2:
        DECFSZ  _N, F
        GOTO    OUT_BYTE_1
        RETURN

;-------------------------------------------
OUT_0:
        CALL    PIN_LO          
        MOVLW   .6              
        CALL    DELAY_10USEC
        CALL    PIN_HI
        GOTO    OUT_BYTE_2
OUT_1:
        CALL    PIN_LO          
        CALL    PIN_HI
        MOVLW 	.6
        CALL 	DELAY_10USEC
        GOTO    OUT_BYTE_2

;-----------------------------------------

PIN_HI:
        BSF     STATUS, RP0
        BSF     TRISA, DATA_PIN             ;   
        BCF     STATUS, RP0
        RETURN
;---------------------------------------
PIN_LO:
        BCF     PORTA, DATA_PIN
        BSF     STATUS, RP0
        BCF     TRISA, DATA_PIN              ;   
        BCF     STATUS, RP0
        RETURN

;---------------------------------------

DELAY_10USEC:   	;   W * 10 
        MOVWF 	LOOP1
DELAY_10USEC_1:
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        DECFSZ 	LOOP1, F
        GOTO 	DELAY_10USEC_1
        RETURN
                     ;    TMR1
;-----------------------------------------------------------------------
INTERRUPT
        
        movwf   W_TEMP          ;
        swapf   STATUS, W       ;
        clrf    STATUS          ;  
        movwf   S_TEMP          ; W, STATUS  FSR
        movfw   FSR             ;
        movwf   F_TEMP          ; 
 
        bcf     PIR1, TMR1IF    ;    TMR1
        decfsz  RT, F
        goto    $+9
        movlw   .5            
        movwf   RT
        decfsz  sec_60, F       ;  60 
        goto    $+5
        CALL    TIME 
        bsf     FLAG, 0         ;   
        movlw   .60
        movwf   sec_60          ;    
        CALL    CONST

        movfw   F_TEMP          ;
        movwf   FSR             ;
        swapf   S_TEMP, W       ;  
        movwf   STATUS          ; W, STATUS  FSR
        swapf   W_TEMP, F       ;
        swapf   W_TEMP, W 
        retfie
;----------------------------------------------------------------
CONST
        ;nop
        nop
        movlw   .60            ;      
        movwf   TMR1H          ;    TMR1
        movlw   .182           ; 
        movwf   TMR1L
        return

        end               
       
        

