// , 2007, "       USB"
//=============================================================================
// SEGA Mega Drive-II,  "in_sega.c",  
//=============================================================================
//  
#include "common.h" //  
//=============================================================================
// 
t_SegaController sega_data[2];
//=============================================================================
// 
void inDecoderInit(void)
{
  PORTB=0xFF; DDRB=0x10; //PB4 ,    
  PORTC=0xFF; DDRC=0x00; //   
  PORTD |= 0xFA; DDRD |= 0x18; //PD3, PD4 ,  
		TCCR2 = 0x0F; //-2,  CTC,  1024
		OCR2 = 0x6A; // ,   9    12 
		TIFR |= _BV(OCF2); //    		
}
//-----------------------------------------------------------------------------
//       
void inDecoderPoll(void)
{ 
  uchar aa1,bb1,cc1,st1,up1,dn1,lf1,rg1,xx1,yy1,zz1,md1; //-1 ()
  uchar aa2,bb2,cc2,st2,up2,dn2,lf2,rg2,xx2,yy2,zz2,md2; //-2 ()  
  uchar xxx1,xxx2,yyy1,yyy2,bbb1,bbb2; //  
  uchar out1[8], out2[8]; //    
  uchar k; // 
		unsigned int pause; //  		
  static uchar h=0; //    HL1

  if (bit_is_set(TIFR,OCF2)) //,    9 
		{
		  TIFR |= _BV(OCF2); //     
		  if (++h > 30) //  30*9=270 
    {
      h=0; // 
						PORTD ^= _BV(HL1); //   HL1  270 
				}
				for (k=0; k<8; k++) out1[k]=out2[k]=0; // 
		  for (k=0; k<8; k++) //4    SYN
    { 
				  if (k%2 == 0) PORTD |= _BV(SYN); //SYN=1
				  else PORTD &= ~_BV(SYN); //SYN=0	
			  	for (pause=1350; pause > 0; pause--); //   SYN 20 
				  out1[k]=((PINC & 0x02) >> 1) | ((PINC & 0x20) >> 4) | ((PINC & 0x01) << 2) |
              ((PINC & 0x1C) << 1); //   -1
				  out2[k]=(PINB & 0x01) | ((PIND & 0x20) >> 4) | ((PINB & 0x06) << 1) |
              ((PIND & 0x80) >> 3) | ((PIND & 0x40) >> 1); //   -2
    }
    PORTD |= _BV(SYN); //SYN=1  

//    -1
    aa1=(out1[3] & 0x01) ? 0:1;
    bb1=(out1[4] & 0x01) ? 0:1;
    cc1=(out1[4] & 0x02) ? 0:1;
    st1=(out1[3] & 0x02) ? 0:1;
    up1=(out1[2] & 0x04) ? 0:1;
    dn1=(out1[2] & 0x08) ? 0:1;
    lf1=(out1[2] & 0x10) ? 0:1;
    rg1=(out1[2] & 0x20) ? 0:1;
    xx1=(out1[6] & 0x10) ? 0:1;
    yy1=(out1[6] & 0x08) ? 0:1;
    zz1=(out1[6] & 0x04) ? 0:1;
    md1=(out1[6] & 0x20) ? 0:1;

//    -2
    aa2=(out2[3] & 0x01) ? 0:1;
    bb2=(out2[4] & 0x01) ? 0:1;
    cc2=(out2[4] & 0x02) ? 0:1;
    st2=(out2[3] & 0x02) ? 0:1;
    up2=(out2[2] & 0x04) ? 0:1;
    dn2=(out2[2] & 0x08) ? 0:1;
    lf2=(out2[2] & 0x10) ? 0:1;
    rg2=(out2[2] & 0x20) ? 0:1;
    xx2=(out2[6] & 0x10) ? 0:1;
    yy2=(out2[6] & 0x08) ? 0:1;
    zz2=(out2[6] & 0x04) ? 0:1;
    md2=(out2[6] & 0x20) ? 0:1;

// UP-DOWN -1
    if ((up1 == 0)&&(dn1 == 0)) yyy1=1;
    else
	  	{ 
				  if ((up1 == 0)&&(dn1 != 0)) yyy1=2;
		    else
			  	{ 
						  if ((up1 != 0)&&(dn1 == 0)) yyy1=0;
				    else yyy1=1;
			  	}
	  	}
// UP-DOWN -2    
    if ((up2 == 0)&&(dn2 == 0)) yyy2=1;
    else
	  	{ 
      if ((up2 == 0)&&(dn2 != 0)) yyy2=2;
		    else
			  	{ 
						  if ((up2 != 0)&&(dn2 == 0)) yyy2=0;
				    else yyy2=1;
			  	}
	  	}
// LEFT-RIGHT	-1	
    if ((lf1 == 0)&&(rg1 == 0)) xxx1=1;
    else
	  	{ 
				  if ((lf1 == 0)&&(rg1 != 0)) xxx1=2;
		    else
		  		{ 
						  if ((lf1 != 0)&&(rg1 == 0)) xxx1=0;
			  	  else xxx1=1;
				  }
	  	}
// LEFT-RIGHT	-2	
    if ((lf2 == 0)&&(rg2 == 0)) xxx2=1;
    else
	  	{ 
				  if ((lf2 == 0)&&(rg2 != 0)) xxx2=2;
		    else
			  	{ 
						  if ((lf2 != 0)&&(rg2 == 0)) xxx2=0;
				    else xxx2=1;
				  }
	  	}
//   
    bbb1=(md1 << 7) | (zz1 << 6) | (yy1 << 5) | (xx1 << 4) |
         (st1 << 3) | (cc1 << 2) | (bb1 << 1) | aa1;
    bbb2=(md2 << 7) | (zz2 << 6) | (yy2 << 5) | (xx2 << 4) |
         (st2 << 3) | (cc2 << 2) | (bb2 << 1) | aa2;
//   
    sega_data[0].x = xxx1;
    sega_data[1].x = xxx2; 
    sega_data[0].y = yyy1;
    sega_data[1].y = yyy2; 
    sega_data[0].u.buttons = bbb1;
    sega_data[1].u.buttons = bbb2; 
		}
}
