// , 2007, "       USB"
//=============================================================================
// SEGA Mega Drive-II,  "common.h"
//=============================================================================
// 
#define F_CPU   12000000UL // 
#include <avr/io.h> // -
#include <avr/interrupt.h> // 
#include <avr/pgmspace.h> // 
//=============================================================================
//  
#include "usbdrv.h" // USB
//=============================================================================
//   
typedef struct
{
  uchar x; // 0,   (0, 1, 2)
  uchar y; // 1,  Y (0, 1, 2)
  union {
    uchar buttons; // 2,  
    struct
    {
      uchar btn1: 1; //0, 1
      uchar btn2: 1; //0, 1
      uchar btn3: 1; //0, 1
      uchar btn4: 1; //0, 1
      uchar btn5: 1; //0, 1
      uchar btn6: 1; //0, 1
      uchar btn7: 1; //0, 1
      uchar btn8: 1; //0, 1
    } b;
  } u;
} t_SegaController;
//=============================================================================
// 
extern t_SegaController sega_data[2];
//=============================================================================
// 
extern void inDecoderInit(void); //
extern void inDecoderPoll(void); // 
extern void outSendData(void); // 
//=============================================================================
//   ATmega8
#define HL1 PD4 //   HL1
#define SYN PD3 //  SYN -1  -2

#define AB1 PC1 // A/B -1
#define SC1 PC5 // START/C -1
#define UZ1 PC0 // UP/Z -1
#define DY1 PC2 // RIGHT/MODE -1
#define LX1 PC3 // LEFT/X -1
#define RM1 PC4 // RIGHT/MODE -1

#define AB2 PB0 // A/B -2
#define SC2 PD5 // START/C -2
#define UZ2 PB1 // UP/Z -2
#define DY2 PB2 // RIGHT/MODE -2
#define LX2 PD7 // LEFT/X -2
#define RM2 PD6 // RIGHT/MODE -2
