// , 2007, "       USB"
//=============================================================================
// PlayStation (PSX),  "in_psx.c",  
//=============================================================================
//  
#include "common.h" //  
//=============================================================================
// 
t_PsxController psx_data[2];
//=============================================================================
// 
void inDecoderInit(void)
{
  PORTB=0xFF; DDRB=0x14; //PB2,PB4 ,    
  PORTC=0xFF; DDRC=0x3B; //PC0,PC1,PC3-PC5 ,    
  PORTD |= 0xFA; DDRD |= 0x10; //PD4 ,  
		TCCR2 = 0x0F; //-2,  CTC,  1024
		OCR2 = 0x6A; // ,   9    12 
		TIFR |= _BV(OCF2); //    		
}
//-----------------------------------------------------------------------------
//       
void inDecoderPoll(void)
{ 
  uchar sl1,jl1,jr1,st1,l21,r21,l11,r11,aa1,oo1,xx1,dd1,up1,dn1,lf1,rg1; //-1 ()
  uchar sl2,jl2,jr2,st2,l22,r22,l12,r12,aa2,oo2,xx2,dd2,up2,dn2,lf2,rg2; //-2 ()
		uchar fxx1,fyy1,rxx1=0,ryy1=0,bbb1,ccc1; //   -1
		uchar fxx2,fyy2,rxx2=0,ryy2=0,bbb2,ccc2; //   -2
  uchar out1[16]; //   -1
  uchar out2[16]; //   -2 
  uchar k; // 
		uchar analog1; //=1   -1
		uchar analog2; //=1   -2		
		unsigned int pause; //  		
  static uchar h=0; //    HL1

  if (bit_is_set(TIFR,OCF2)) //,    9 
		{
		  TIFR |= _BV(OCF2); //     
		  if (++h > 30) //  30*9=270 
    {
      h=0; // 
						PORTD ^= _BV(HL1); //   HL1  270 
				}
				for (k=0; k<16; k++) out1[k]=out2[k]=0; //  
				analog1=analog2=0; // -1, -2
				PORTB |= _BV(CMD1); //CMD=1
				PORTC |= _BV(CMD2); //CMD=1
				PORTC |= _BV(CLK1); //CLK=1
				PORTC |= _BV(CLK2); //CLK=1
				PORTC &= ~_BV(SEL1); //SEL=0
				PORTC &= ~_BV(SEL2); //SEL=0
    //----------------------------------------------------------------------
				for (k=0; k<8; k++) //-1
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
      if (k==1)
      { PORTB &= ~_BV(CMD1); //CMD=0
						  PORTC &= ~_BV(CMD2); //CMD=0
						}
      for (pause=1400; pause > 0; pause--); //  CLK (0)
      PORTC |= _BV(CLK1); //CLK=1
						PORTC |= _BV(CLK2); //CLK=1
      for (pause=1400; pause > 0; pause--); //  CLK (1)
    }
    PORTB |= _BV(CMD1); //CMD=1
				PORTC |= _BV(CMD2); //CMD=1
    for (pause=3000; pause > 0; pause--); // 				
    //----------------------------------------------------------------------  
				for (k=0; k<8; k++) //-2
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
				  for (pause=1400; pause > 0; pause--); //  CLK (0)
      if (k==1)
      { PORTB |= _BV(CMD1); //CMD=1
						  PORTC |= _BV(CMD2); //CMD=1
						  if(bit_is_set(PINB,DAT1)) analog1++; // -1
								if(bit_is_set(PINC,DAT2)) analog2++; // -2
						}
      else
      { if (k==6)
        { PORTB |= _BV(CMD1); //CMD=1
          PORTC |= _BV(CMD2); //CMD=1
        }	
        else
        { PORTB &= ~_BV(CMD1); //CMD=0
								  PORTC &= ~_BV(CMD2); //CMD=0
								}
      }
		    if(k==3)
						{ if(bit_is_set(PINB,DAT1)) analog1=0xFF; // -1
						  if(bit_is_set(PINC,DAT2)) analog2=0xFF; // -2						
						}        
      PORTC |= _BV(CLK1); //CLK=1
						PORTC |= _BV(CLK2); //CLK=1
      for (pause=1400; pause > 0; pause--); //  CLK (1)
    }
    PORTB |= _BV(CMD1); //CMD=1
				PORTC |= _BV(CMD2); //CMD=1
    for (pause=3000; pause > 0; pause--); // 
    //PORTB &= ~_BV(CMD1); //CMD=0
				//PORTC &= ~_BV(CMD2); //CMD=0
    //-----------------------------------------------------------------------  
				for (k=0; k<8; k++) //-3
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
				  for (pause=1400; pause > 0; pause--); //  CLK (0)
      PORTC |= _BV(CLK1); //CLK=1
						PORTC |= _BV(CLK2); //CLK=1
      for (pause=1400; pause > 0; pause--); //  CLK (1)
    }
    for (pause=3000; pause > 0; pause--); // 
				//------------------------------------------------------------------------		
    for (k=0; k<16; k++) //-4, -5
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
      for (pause=1400; pause > 0; pause--); //  CLK (0)
      if (k==15) // 
      { if(bit_is_clear(PINB,DAT1)) out1[k]++;
						  if(bit_is_clear(PINC,DAT2)) out2[k]++;
        PORTC |= _BV(CLK1); //CLK=1
								PORTC |= _BV(CLK2); //CLK=1
      }
      else
      { PORTC |= _BV(CLK1); //CLK=1
						  PORTC |= _BV(CLK2); //CLK=1
	       for (pause=100; pause > 0; pause--); //
        if(bit_is_clear(PINB,DAT1)) out1[k]++;
								if(bit_is_clear(PINC,DAT2)) out2[k]++;
      }
      if (k==7) for (pause=3000; pause > 0; pause--); // 
						for (pause=1400; pause > 0; pause--); //  CLK (1)
    }      
    for (pause=2000; pause > 0; pause--); //
//    -1
				sl1=out1[0];
    jl1=out1[1];
    jr1=out1[2];
    st1=out1[3];
    up1=out1[4];
    rg1=out1[5];
    dn1=out1[6];
    lf1=out1[7];
				l21=out1[8];
    r21=out1[9];
    l11=out1[10];
    r11=out1[11];
    aa1=out1[12];
    oo1=out1[13];
    xx1=out1[14];
    dd1=out1[15];
				
	//    -2
				sl2=out2[0];
    jl2=out2[1];
    jr2=out2[2];
    st2=out2[3];
    up2=out2[4];
    rg2=out2[5];
    dn2=out2[6];
    lf2=out2[7];
				l22=out2[8];
    r22=out2[9];
    l12=out2[10];
    r12=out2[11];
    aa2=out2[12];
    oo2=out2[13];
    xx2=out2[14];
    dd2=out2[15];
// LEFT-RIGHT	 -1	
    if ((lf1 == 0)&&(rg1 != 0)) fxx1=255;
		  else
		  { 
				  if ((lf1 != 0)&&(rg1 == 0)) fxx1=0;
			   else fxx1=127;				
	  	}
// UP-DOWN  -1
    if ((up1 == 0)&&(dn1 != 0)) fyy1=255;
		  else
			 { 
				  if ((up1 != 0)&&(dn1 == 0)) fyy1=0;
				  else fyy1=127;			 
	  	}
// LEFT-RIGHT	-2
    if ((lf2 == 0)&&(rg2 != 0)) fxx2=255;
		  else
		  { 
				  if ((lf2 != 0)&&(rg2 == 0)) fxx2=0;
			   else fxx2=127;
	  	}	
// UP-DOWN -2
    if ((up2 == 0)&&(dn2 != 0)) fyy2=255;
		  else
			 { 
				  if ((up2 != 0)&&(dn2 == 0)) fyy2=0;
				  else fyy2=127;
			 }
    //------------------------------------------------------------------------		
    for (k=0; k<16; k++) //-6, -7
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
      for (pause=1400; pause > 0; pause--); //  CLK (0)
      if (k==15) // 
      { if(bit_is_clear(PINB,DAT1)) out1[k]=1;
						  else out1[k]=0;
								if(bit_is_clear(PINC,DAT2)) out2[k]=1;
						  else out2[k]=0;
        PORTC |= _BV(CLK1); //CLK=1
								PORTC |= _BV(CLK2); //CLK=1
      }
      else
      { PORTC |= _BV(CLK1); //CLK=1
						  PORTC |= _BV(CLK2); //CLK=1
	       for (pause=100; pause > 0; pause--); //
        if(bit_is_clear(PINB,DAT1)) out1[k]=1;
						  else out1[k]=0;										
								if(bit_is_clear(PINC,DAT2)) out2[k]=1;
						  else out2[k]=0;										
      }
      if (k==7) for (pause=3000; pause > 0; pause--); // 
				  for (pause=1400; pause > 0; pause--); //  CLK (1)
    }      
    for (pause=3000; pause > 0; pause--); // 
				//   -1
    rxx1= ~((out1[7] <<7) | (out1[6] <<6) | (out1[5] <<5) | (out1[4] <<4) |
            (out1[3] <<3) | (out1[2] <<2) | (out1[1] <<1) | out1[0]);
				ryy1= ~((out1[15] <<7) | (out1[14] <<6) | (out1[13] <<5) | (out1[12] <<4) |
            (out1[11] <<3) | (out1[10] <<2) | (out1[9] <<1) | out1[8]);
    
				//   -2
    rxx2= ~((out2[7] <<7) | (out2[6] <<6) | (out2[5] <<5) | (out2[4] <<4) |
            (out2[3] <<3) | (out2[2] <<2) | (out2[1] <<1) | out2[0]);
				ryy2= ~((out2[15] <<7) | (out2[14] <<6) | (out2[13] <<5) | (out2[12] <<4) |
            (out2[11] <<3) | (out2[10] <<2) | (out2[9] <<1) | out2[8]);    
				//------------------------------------------------------------------------		
    for (k=0; k<16; k++) //-8, -9
    { PORTC &= ~_BV(CLK1); //CLK=0
				  PORTC &= ~_BV(CLK2); //CLK=0
      for (pause=1400; pause > 0; pause--); //  CLK (0)
      if (k==15) // 
      { if(bit_is_clear(PINB,DAT1)) out1[k]=1;
						  else out1[k]=0;
								if(bit_is_clear(PINC,DAT2)) out2[k]=1;
						  else out2[k]=0;
        PORTC |= _BV(CLK1); //CLK=1
								PORTC |= _BV(CLK2); //CLK=1
      }
      else
      { PORTC |= _BV(CLK1); //CLK=1
						  PORTC |= _BV(CLK2); //CLK=1
	       for (pause=100; pause > 0; pause--); //
        if(bit_is_clear(PINB,DAT1)) out1[k]=1;
						  else out1[k]=0;
								if(bit_is_clear(PINC,DAT2)) out2[k]=1;
						  else out2[k]=0;
      }
      if (k==7) for (pause=3000; pause > 0; pause--); // 
				  for (pause=1400; pause > 0; pause--); //  CLK (1)
				}						
    //------------------------------------------------------------------------------
				if (analog1 !=0) //   -1
				{
				  if ((fxx1==127)&&(fyy1==127)) //      -1
      { //   -1
						  fxx1= ~((out1[7] <<7) | (out1[6] <<6) | (out1[5] <<5) | (out1[4] <<4) |
                (out1[3] <<3) | (out1[2] <<2) | (out1[1] <<1) | out1[0]);
						  fyy1= ~((out1[15] <<7) | (out1[14] <<6) | (out1[13] <<5) | (out1[12] <<4) |
                (out1[11] <<3) | (out1[10] <<2) | (out1[9] <<1) | out1[8]);
						}
				}
				if (analog2 !=0) //   -2
				{
				  if ((fxx2==127)&&(fyy2==127)) //      -2
      { //  	-2
						  fxx2= ~((out2[7] <<7) | (out2[6] <<6) | (out2[5] <<5) | (out2[4] <<4) |
                (out2[3] <<3) | (out2[2] <<2) | (out2[1] <<1) | out2[0]);
						  fyy2= ~((out2[15] <<7) | (out2[14] <<6) | (out2[13] <<5) | (out2[12] <<4) |
                (out2[11] <<3) | (out2[10] <<2) | (out2[9] <<1) | out2[8]);
						}
				}
//----------------------------------------------------------------------------    
				if (analog1==0) rxx1=ryy1=127; //      -1
				if (analog2==0) rxx2=ryy2=127; //      -2
				
    PORTC |= _BV(SEL1); //SEL=1
				PORTC |= _BV(SEL2); //SEL=1
    PORTB |= _BV(CMD1); //  CMD=1
				PORTC |= _BV(CMD2); //  CMD=1

//    -1
				bbb1=(l21 << 7) | (l11 << 6) | (xx1 << 5) | (oo1 << 4) |
         (aa1 << 3) | (dd1 << 2) | (st1 << 1) | sl1;
				ccc1=(jr1 << 3) | (jl1 << 2) | (r21 << 1) | r11;
//    -2
				bbb2=(l22 << 7) | (l12 << 6) | (xx2 << 5) | (oo2 << 4) |
         (aa2 << 3) | (dd2 << 2) | (st2 << 1) | sl2;
				ccc2=(jr2 << 3) | (jl2 << 2) | (r22 << 1) | r12;
//    
				if (analog1==0xFF) // -1
    { rxx1=ryy1=fxx1=fyy1=127; //  -1, -2   
				  bbb1=ccc1=0; //  
				}
				if (analog2==0xFF) // -2
    { rxx2=ryy2=fxx2=fyy2=127; //  -1, -2   
				  bbb2=ccc2=0; //  
				}
//    -1
    psx_data[0].x = fxx1; //  
    psx_data[0].y = fyy1;	 // Y 
				psx_data[0].z = rxx1; //-1
				psx_data[0].p = ryy1; //-2    			   
    psx_data[0].u.buttons = bbb1; //8 
    psx_data[0].w.but = ccc1; //4    
//    -2
				psx_data[1].x = fxx2; //  
    psx_data[1].y = fyy2;	 // Y 
				psx_data[1].z = rxx2; //-1
				psx_data[1].p = ryy2; //-2    			   
    psx_data[1].u.buttons = bbb2; //8 
    psx_data[1].w.but = ccc2; //4 				
		}
}
