// , 2007, "       USB"
//=============================================================================
// Dendy,  "out_dendy.c",  
//=============================================================================
//  
#include "common.h" //  
//=============================================================================
//USB  
static uchar usbReport[1+sizeof(t_DendyController)]; //  ReportID
//=============================================================================
//HID  
PROGMEM const char usbHidReportDescriptor[USB_CFG_HID_REPORT_DESCRIPTOR_LENGTH] =
{
  //-1
  0x05, 0x01, // USAGE_PAGE (Generic Desktop)
  0x09, 0x04, // USAGE (Joystick)
  0xa1, 0x01, // COLLECTION (Application)
  0x09, 0x01, //   USAGE (Pointer)
  0xa1, 0x00, //   COLLECTION (Physical)
  0x85, 0x01, //     REPORT_ID (1)
  0x09, 0x30, //     USAGE (X)
  0x09, 0x31, //     USAGE (Y)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x02, //     LOGICAL_MAXIMUM (2)
  0x75, 0x08, //     REPORT_SIZE (8)
  0x95, 0x02, //     REPORT_COUNT (2)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x01, //     LOGICAL_MAXIMUM (1)
  0x95, 0x04, //     REPORT_COUNT (4)
  0x75, 0x01, //     REPORT_SIZE (1)
  0x05, 0x09, //     USAGE_PAGE (Button)
  0x19, 0x01, //     USAGE_MINIMUM (Button 1)
  0x29, 0x04, //     USAGE_MAXIMUM (Button 4)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
		0x95, 0x04, //     REPORT_COUNT (4)
		0x75, 0x01, //     REPORT_SIZE (1)
  0x81, 0x01, //     INPUT (Constant) - 4 bit padding   
  0xc0,       //   END_COLLECTION
  0xc0,       // END_COLLECTION
		
		//-2  
  0x05, 0x01, // USAGE_PAGE (Generic Desktop)
  0x09, 0x04, // USAGE (Joystick)
  0xa1, 0x01, // COLLECTION (Application)
  0x09, 0x01, //   USAGE (Pointer)
  0xa1, 0x00, //   COLLECTION (Physical)
  0x85, 0x02, //     REPORT_ID (2)
  0x09, 0x30, //     USAGE (X)
  0x09, 0x31, //     USAGE (Y)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x02, //     LOGICAL_MAXIMUM (2)
  0x75, 0x08, //     REPORT_SIZE (8)
  0x95, 0x02, //     REPORT_COUNT (2)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x01, //     LOGICAL_MAXIMUM (1)
  0x95, 0x04, //     REPORT_COUNT (4)
  0x75, 0x01, //     REPORT_SIZE (1)
  0x05, 0x09, //     USAGE_PAGE (Button)
  0x19, 0x01, //     USAGE_MINIMUM (Button 1)
  0x29, 0x04, //     USAGE_MAXIMUM (Button 4)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
		0x95, 0x04, //     REPORT_COUNT (4)
		0x75, 0x01, //     REPORT_SIZE (1)
  0x81, 0x01, //     INPUT (Constant) - 4 bit padding   
  0xc0,       //   END_COLLECTION
  0xc0,       // END_COLLECTION
		
		//-3
  0x05, 0x01, // USAGE_PAGE (Generic Desktop)
  0x09, 0x04, // USAGE (Joystick)
  0xa1, 0x01, // COLLECTION (Application)
  0x09, 0x01, //   USAGE (Pointer)
  0xa1, 0x00, //   COLLECTION (Physical)
  0x85, 0x03, //     REPORT_ID (3)
  0x09, 0x30, //     USAGE (X)
  0x09, 0x31, //     USAGE (Y)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x02, //     LOGICAL_MAXIMUM (2)
  0x75, 0x08, //     REPORT_SIZE (8)
  0x95, 0x02, //     REPORT_COUNT (2)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x01, //     LOGICAL_MAXIMUM (1)
  0x95, 0x04, //     REPORT_COUNT (4)
  0x75, 0x01, //     REPORT_SIZE (1)
  0x05, 0x09, //     USAGE_PAGE (Button)
  0x19, 0x01, //     USAGE_MINIMUM (Button 1)
  0x29, 0x04, //     USAGE_MAXIMUM (Button 4)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
		0x95, 0x04, //     REPORT_COUNT (4)
		0x75, 0x01, //     REPORT_SIZE (1)
  0x81, 0x01, //     INPUT (Constant) - 4 bit padding   
  0xc0,       //   END_COLLECTION
  0xc0,       // END_COLLECTION
		
		//-4  
  0x05, 0x01, // USAGE_PAGE (Generic Desktop)
  0x09, 0x04, // USAGE (Joystick)
  0xa1, 0x01, // COLLECTION (Application)
  0x09, 0x01, //   USAGE (Pointer)
  0xa1, 0x00, //   COLLECTION (Physical)
  0x85, 0x04, //     REPORT_ID (4)
  0x09, 0x30, //     USAGE (X)
  0x09, 0x31, //     USAGE (Y)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x02, //     LOGICAL_MAXIMUM (2)
  0x75, 0x08, //     REPORT_SIZE (8)
  0x95, 0x02, //     REPORT_COUNT (2)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
  0x15, 0x00, //     LOGICAL_MINIMUM (0)
  0x25, 0x01, //     LOGICAL_MAXIMUM (1)
  0x95, 0x04, //     REPORT_COUNT (4)
  0x75, 0x01, //     REPORT_SIZE (1)
  0x05, 0x09, //     USAGE_PAGE (Button)
  0x19, 0x01, //     USAGE_MINIMUM (Button 1)
  0x29, 0x04, //     USAGE_MAXIMUM (Button 4)
  0x81, 0x02, //     INPUT (Data,Var,Abs)
		0x95, 0x04, //     REPORT_COUNT (4)
		0x75, 0x01, //     REPORT_SIZE (1)
  0x81, 0x01, //     INPUT (Constant) - 4 bit padding   
  0xc0,       //   END_COLLECTION
  0xc0,       // END_COLLECTION
};
//-----------------------------------------------------------------------------
//    ReportID   
static uchar *usbBuildReport(uchar id)
{
  static uchar lastReport = 0; // ReportID
		
  if (id) lastReport = id; //  ReportID
  else lastReport = (lastReport %4) + 1; //   ReportID

  //   
  uchar *dp = (void *) &dendy_data[lastReport-1];
  uchar *rp = usbReport;

  // ReportID
   *rp++ = lastReport;
  for (uchar i = 0; i < sizeof(t_DendyController); i++) *rp++ = *dp++;

  //   
  return usbReport;
}
//-----------------------------------------------------------------------------
//    USB (  HidKeys)
uchar usbFunctionSetup(uchar data[8])
{
  usbRequest_t *rq = (void *)data;

  if ((rq->bmRequestType & USBRQ_TYPE_MASK) == USBRQ_TYPE_CLASS)
  {
    // Return the report if host requests it without USB interrupt
    if (rq->bRequest == USBRQ_HID_GET_REPORT)
    {
      // wValue: ReportType (highbyte), ReportID (lowbyte)
      // build report requested
      usbMsgPtr = usbBuildReport(rq->wValue.bytes[0]);
      return sizeof(usbReport);
    }
  }
  return 0;
}
//-----------------------------------------------------------------------------
// Check if the USB Interrupt In point buffer is empty and return
// the data buffer for the following host request via USB interrupt
void outSendData(void)
{
  if (usbInterruptIsReady())
  {
    // fill in the report buffer and return the
    // data pointer (Report ID is selected automatically)
    usbSetInterrupt(usbBuildReport(0), sizeof(usbReport));
  }
}
