// , 2007, "       USB"
//=============================================================================
// Dendy,  "in_dendy.c",  
//=============================================================================
//  
#include "common.h" //  
//=============================================================================
// 
t_DendyController dendy_data[4];
//=============================================================================
// 
void inDecoderInit(void)
{
  PORTB=0xFF; DDRB=0x10; //PB4 ,    
  PORTC=0xDE; DDRC=0x21; //PC0, PC5   .0,    
  PORTD |= 0xFA; DDRD |= 0x10; //PD4 ,  
		TCCR2 = 0x0F; //-2,  CTC,  1024
		OCR2 = 0x6A; // ,   9    12 
		TIFR |= _BV(OCF2); //    		
}
//-----------------------------------------------------------------------------
//       
void inDecoderPoll(void)
{ 
  uchar aa1,bb1,sl1,st1,up1,dn1,lf1,rg1; //-1 ()
		uchar aa2,bb2,sl2,st2,up2,dn2,lf2,rg2; //-2 ()
		uchar aa3,bb3,sl3,st3,up3,dn3,lf3,rg3; //-3 ()
		uchar aa4,bb4,sl4,st4,up4,dn4,lf4,rg4; //-4 ()
  uchar xxx1,yyy1,bbb1; //   -1
		uchar xxx2,yyy2,bbb2; //   -2
		uchar xxx3,yyy3,bbb3; //   -3
		uchar xxx4,yyy4,bbb4; //   -4
  uchar out1[8]; //   -1
  uchar out2[8]; //   -2
		uchar out3[8]; //   -3
  uchar out4[8]; //   -4
  uchar k; // 
		unsigned int pause; //  		
  static uchar h=0; //    HL1

  if (bit_is_set(TIFR,OCF2)) //,    9 
		{
		  TIFR |= _BV(OCF2); //     
		  if (++h > 30) //  30*9=270 
    {
      h=0; // 
						PORTD ^= _BV(HL1); //   HL1  270 
				}
				for (k=0; k<8; k++) out1[k]=out2[k]=out3[k]=out4[k]=0; //   
				PORTC |= _BV(PEX); //PE=1
    for (pause=500; pause > 0; pause--); //  PE
    PORTC &= ~_BV(PEX); //PE=0
    for (k=0; k<8; k++) //8   SYN
				{ PORTC &= ~_BV(SYN); //SYN=0
		    for (pause=300; pause > 0; pause--); //  SYN (0)
      if (bit_is_clear(PINC,OU1)) out1[k]++; // OUT -1
						if (bit_is_clear(PINC,OU2)) out2[k]++; // OUT -2
						if (bit_is_clear(PINC,OU3)) out3[k]++; // OUT -3
						if (bit_is_clear(PINC,OU4)) out4[k]++; // OUT -4
						for (pause=10; pause > 0; pause--); //
						PORTC |= _BV(SYN); //SYN=1
						for (pause=300; pause > 0; pause--); //  SYN (1)
    }
    PORTC &= ~_BV(SYN); //SYN=0
//    -1
				aa1=out1[0];
    bb1=out1[1];
    sl1=out1[2];
    st1=out1[3];
    up1=out1[4];
    dn1=out1[5];
    lf1=out1[6];
    rg1=out1[7];
//    -2
				aa2=out2[0];
    bb2=out2[1];
    sl2=out2[2];
    st2=out2[3];
    up2=out2[4];
    dn2=out2[5];
    lf2=out2[6];
    rg2=out2[7];
//    -3
				aa3=out3[0];
    bb3=out3[1];
    sl3=out3[2];
    st3=out3[3];
    up3=out3[4];
    dn3=out3[5];
    lf3=out3[6];
    rg3=out3[7];
//    -4
				aa4=out4[0];
    bb4=out4[1];
    sl4=out4[2];
    st4=out4[3];
    up4=out4[4];
    dn4=out4[5];
    lf4=out4[6];
    rg4=out4[7];

// UP-DOWN -1
    if ((up1 == 0)&&(dn1 == 0)) yyy1=1;
    else
	  	{ 
				  if ((up1 == 0)&&(dn1 != 0)) yyy1=2;
		    else
			  	{ 
						  if ((up1 != 0)&&(dn1 == 0)) yyy1=0;
				    else yyy1=1;
			  	}
	  	}
// UP-DOWN -2
    if ((up2 == 0)&&(dn2 == 0)) yyy2=1;
    else
	  	{ 
				  if ((up2 == 0)&&(dn2 != 0)) yyy2=2;
		    else
			  	{ 
						  if ((up2 != 0)&&(dn2 == 0)) yyy2=0;
				    else yyy2=1;
			  	}
	  	}
// UP-DOWN -3
    if ((up3 == 0)&&(dn3 == 0)) yyy3=1;
    else
	  	{ 
				  if ((up3 == 0)&&(dn3 != 0)) yyy3=2;
		    else
			  	{ 
						  if ((up3 != 0)&&(dn3 == 0)) yyy3=0;
				    else yyy3=1;
			  	}
	  	}
// UP-DOWN -4
    if ((up4 == 0)&&(dn4 == 0)) yyy4=1;
    else
	  	{ 
				  if ((up4 == 0)&&(dn4 != 0)) yyy4=2;
		    else
			  	{ 
						  if ((up4 != 0)&&(dn4 == 0)) yyy4=0;
				    else yyy4=1;
			  	}
	  	}

// LEFT-RIGHT	-1	
    if ((lf1 == 0)&&(rg1 == 0)) xxx1=1;
    else
	  	{ 
				  if ((lf1 == 0)&&(rg1 != 0)) xxx1=2;
		    else
		  		{ 
						  if ((lf1 != 0)&&(rg1 == 0)) xxx1=0;
			  	  else xxx1=1;
				  }
	  	}
// LEFT-RIGHT	-2
    if ((lf2 == 0)&&(rg2 == 0)) xxx2=1;
    else
	  	{ 
				  if ((lf2 == 0)&&(rg2 != 0)) xxx2=2;
		    else
		  		{ 
						  if ((lf2 != 0)&&(rg2 == 0)) xxx2=0;
			  	  else xxx2=1;
				  }
	  	}
// LEFT-RIGHT	-3
    if ((lf3 == 0)&&(rg3 == 0)) xxx3=1;
    else
	  	{ 
				  if ((lf3 == 0)&&(rg3 != 0)) xxx3=2;
		    else
		  		{ 
						  if ((lf3 != 0)&&(rg3 == 0)) xxx3=0;
			  	  else xxx3=1;
				  }
	  	}
// LEFT-RIGHT	-4
    if ((lf4 == 0)&&(rg4 == 0)) xxx4=1;
    else
	  	{ 
				  if ((lf4 == 0)&&(rg4 != 0)) xxx4=2;
		    else
		  		{ 
						  if ((lf4 != 0)&&(rg4 == 0)) xxx4=0;
			  	  else xxx4=1;
				  }
	  	}

//   
				bbb1=(aa1 << 3) | (bb1 << 2) | (st1 << 1) | sl1; //-1
				bbb2=(aa2 << 3) | (bb2 << 2) | (st2 << 1) | sl2; //-2
				bbb3=(aa3 << 3) | (bb3 << 2) | (st3 << 1) | sl3; //-3
				bbb4=(aa4 << 3) | (bb4 << 2) | (st4 << 1) | sl4; //-4
//   
    dendy_data[0].x = xxx1;    
    dendy_data[0].y = yyy1;    
    dendy_data[0].u.buttons = bbb1;
				dendy_data[1].x = xxx2;
    dendy_data[1].y = yyy2;    
    dendy_data[1].u.buttons = bbb2;
				dendy_data[2].x = xxx3;
    dendy_data[2].y = yyy3;    
    dendy_data[2].u.buttons = bbb3;
				dendy_data[3].x = xxx4;
    dendy_data[3].y = yyy4;    
    dendy_data[3].u.buttons = bbb4;
		}
}
