unit WrToFile;
interface

uses Sysutils;

type TWrAlign = (twrNone,twrLeft,twrCenter,twrRigth);

type TWrCol = record
                LeftSym : char;
                RigthSym: char;
                Size    : byte;
                Align   : TWrAlign;
              end;
      PTWrCol = ^TWrCol;

      TWrLine = array of TWrCol;
      PTWrLine = ^TWrLine;

type TWrToFile = class(TObject)

        private

        WrFile  : integer;
        pLine   : PTWrLine;
        CountCol: integer;

        function FrmColumn(pWrCol:PTWrCol; Inf: string): string;
        procedure FrmLine(pWrLine:PTWrLine);

        public

        NameFile: string;
        Header  : string;

        procedure WrHeader;
        procedure WriteLine(sLine: string);
     end;

implementation

procedure TWrToFile.WrHeader;
begin
  WrFile:=FileCreate(NameFile);
  WriteLine(FormatDateTime('dd.mm.yyyy',date)
           +StringOfChar(' ',10)
           +Header);
end;

function TWrToFile.FrmColumn(pWrCol:PTWrCol; Inf: string): string;
  var SS: string;
      lS,rS: string;

      lInf,lCol
     ,lLs,lRs
     ,lLf,lRt
     ,rSI     : integer;
begin
  with pWrCol^ do
  begin

    lS:='';
    lLs:=0;
    if LeftSym <> #0  then
    begin
      lS:=LeftSym;
      lLs:=1;
    end;

    rS:='';
    lRs:=0;
    if RigthSym <> #0  then
    begin
      rS:=RigthSym;
      lRs:=1;
    end;

    lInf:=Length(Inf);
    lCol:=lInf+lLs+lRs;

    if Size=lCol
    then SS:=Inf
    else
    begin
      if Size<lCol
      then SS:=Copy(Inf,1,Size-lLs-lRs)
      else
      begin

        rSI:=Size-lCol;

        case Align of
          twrNone
         ,twrLeft:  SS:=Inf+StringOfChar(' ',rSI);

          twrRigth: SS:=StringOfChar(' ',rSI)+Inf;

          twrCenter:
                   begin
                     lLf:=rSI div 2;
                     lRt:=rSI-lLf;
                     SS:=StringOfChar(' ',lLf)+Inf+StringOfChar(' ',lRt);
                   end;
        end;

      end;
    end;

    Result:=rS+SS+lS;
  end;
end;

procedure TWrToFile.FrmLine(pWrLine:PTWrLine);
begin
end;

procedure TWrToFile.WriteLine(sLine: string);
  var Buff  :  array[0..255] of char;
      bLen  : integer;
begin
  StrPCopy(Buff,sLine);
  bLen  :=StrLen(Buff);
  Buff[bLen  ]:=#13;
  Buff[bLen+1]:=#10;
  Buff[bLen+2]:=#0;
end;

end.

