unit Voice;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MPlayer, StdCtrls, ExtCtrls, ComCtrls, Mask, Grids
 ,Frmwav,TypeVoic, FileCtrl, Menus, Outline, DirOutln, Buttons;

type TDirChan = array [0..255] of char;
     TDirChannals = array [0..7] of TDirChan;

const InitDirChan: TDirChannals = ('c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  ,'c:\'#0
                                  );


type TDirectory   = class(TObject)
                      sDirectory: string;
                    end;
     PTDirectory  = ^TDirectory;

type TSortStr = class(TStringList)
                  procedure Sort; override;
                end;

type
  TFrmVoice = class(TForm)
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    GroupBox2: TGroupBox;
    Panel2: TPanel;
    GroupBox3: TGroupBox;
    MediaPlayer1: TMediaPlayer;
    GrBxChannals: TGroupBox;
    BtnCaseAll: TButton;
    BtnCleareAll: TButton;
    ChBx1: TCheckBox;
    ChBx2: TCheckBox;
    ChBx3: TCheckBox;
    ChBx4: TCheckBox;
    ChBx5: TCheckBox;
    ChBx6: TCheckBox;
    ChBx7: TCheckBox;
    ChBx8: TCheckBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    DTPicker0: TDateTimePicker;
    Label1: TLabel;
    MEDTime0: TMaskEdit;
    UdIncTime0: TUpDown;
    Label2: TLabel;
    GroupBox6: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    DTPicker1: TDateTimePicker;
    MEDTime1: TMaskEdit;
    UdIncTime1: TUpDown;
    BtnOnOff0: TButton;
    BtnOnOff1: TButton;
    Panel4: TPanel;
    Timer1: TTimer;
    BtnFormList: TButton;
    BtnClearList: TButton;
    Panel3: TPanel;
    LBListFiles: TListBox;
    GroupBox7: TGroupBox;
    Panel5: TPanel;
    RgDirChan: TRadioGroup;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    BitBtn1: TBitBtn;
    TrackBar1: TTrackBar;
    RGSort: TRadioGroup;
    StFileName: TStaticText;
    BitBtnStart: TBitBtn;
    Panel6: TPanel;
    ChBxAutoStart: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure BtnCaseAllClick(Sender: TObject);
    procedure BtnCleareAllClick(Sender: TObject);
    procedure UdIncTime0Click(Sender: TObject; Button: TUDBtnType);
    procedure BtnOnOff0Click(Sender: TObject);
    procedure BtnOnOff1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BtnFormListClick(Sender: TObject);
    procedure BtnClearListClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure N0_ExitClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure RgDirChanClick(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure UdIncTime1Click(Sender: TObject; Button: TUDBtnType);
    procedure TrackBar1Change(Sender: TObject);
    procedure MediaPlayer1Notify(Sender: TObject);
    procedure BitBtnStartClick(Sender: TObject);
    procedure LBListFilesClick(Sender: TObject);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure MediaPlayer1PostClick(Sender: TObject; Button: TMPBtnType);
    procedure LBListFilesDblClick(Sender: TObject);
  private
    { Private declarations }
{    ListFiles : TList;}
    FInit     : file;
    CurrentDir: string;
    DirChan   : TDirChannals;

    FTPChange : boolean;
    TimerTPChange: word;

    SortStr: TSortStr;

    ListOfDir        : TList;

    FWHandle
   ,FRHandle: integer;
    NSoundLine: integer;

    fStartSound: boolean;
    fOpen: boolean;

    procedure CheckUncheck(ChU: boolean);
    procedure IncTEdit(Button      : TUDBtnType;
                       var MED_Time: TMaskEdit;
                       var UD_Time : TUpDown);
    procedure SwitchTime(var MED_Time : TMaskEdit;
                         var UdIncTime: TUpDown;
                         var BtnOnOff : TButton);
    procedure FormWavFile(IndLB: integer);
    function  FileNameToDateTime(Name:string):TDateTime;
    function  DirNameToDateTime(Name:string):TDateTime;
    procedure PilicPilic;
    procedure FileHandleClose(var FHandle: integer);
  public
    { Public declarations }
  end;

var  vModes: TMPModes;
var
  FrmVoice: TFrmVoice;

implementation

{$R *.DFM}
function sDateTime(sDT: string;BegInd: integer): string;
begin
  sDateTime:=Copy(sDT,BegInd+6,2)
            +Copy(sDT,BegInd+3,2)
            +Copy(sDT,BegInd  ,2)
            +Copy(sDT,BegInd+9,8);
end;
{-------------------------------------------------------------------------------
}
function CompareDateBeg(List: TStringList; Index1, Index2: Integer): Integer; // stdcall;
  var sDateTime1,sDateTime2: string;
begin
  with List do
  begin
    if (Index1>(Count-1))
      or
       (Index2>(Count-1))
      or
       (Index1<0)
      or
       (Index2<0)
    then
    begin
      Result:=0;
      Exit;
    end;

    sDateTime1:=sDateTime(Strings[Index1],4);
    sDateTime2:=sDateTime(Strings[Index2],4);

    Result:=CompareText(sDateTime1,sDateTime2);
  end;
end;
{-------------------------------------------------------------------------------
}
function CompareDateEnd(List: TStringList; Index1, Index2: Integer): Integer; // stdcall;
  var sDateTime1,sDateTime2: string;
begin
  with List do
  begin
    if (Index1>(Count-1))
      or
       (Index2>(Count-1))
      or
       (Index1<0)
      or
       (Index2<0)
    then
    begin
      Result:=0;
      Exit;
    end;

    sDateTime1:=sDateTime(Strings[Index1],23)
               +sDateTime(Strings[Index1],4);
    sDateTime2:=sDateTime(Strings[Index2],23)
               +sDateTime(Strings[Index2],4);

    Result:=CompareText(sDateTime1,sDateTime2);
  end;
end;
{-------------------------------------------------------------------------------
}
function CompareChanDate(List: TStringList; Index1, Index2: Integer): Integer; // stdcall;
  var sDateTime1,sDateTime2: string;
begin
  with List do
  begin
    if (Index1>(Count-1))
      or
       (Index2>(Count-1))
      or
       (Index1<0)
      or
       (Index2<0)
    then
    begin
      Result:=0;
      Exit;
    end;

    sDateTime1:=Copy(Strings[Index1],1,1)
               +sDateTime(Strings[Index1],4);
    sDateTime2:=Copy(Strings[Index2],1,1)
               +sDateTime(Strings[Index2],4);

    Result:=CompareText(sDateTime1,sDateTime2);
  end;
end;
{-------------------------------------------------------------------------------
}
function CompareSize(List: TStringList; Index1, Index2: Integer): Integer; // stdcall;
  var sSize1,sSize2: string;
      rSize1,rSize2: extended;
{  procedure AppSpace(var s1: string; LenS2: integer);
  begin
    s1:=StringOfChar(' ',LenS2+Length(s1))+s1;
  end;}
begin
  with List do
  begin
    if (Index1>(Count-1))
      or
       (Index2>(Count-1))
      or
       (Index1<0)
      or
       (Index2<0)
    then
    begin
      Result:=0;
      Exit;
    end;

    sSize1:=TrimLeft(Trimright(Copy(Strings[Index1],41,15)));
    sSize2:=TrimLeft(Trimright(Copy(Strings[Index2],41,15)));

    rSize1:=StrToInt(sSize1);
    rSize2:=StrToInt(sSize2);

{    if Length(sSize1)<>Length(sSize2) then
    begin
      if Length(sSize1)>Length(sSize2)
      then AppSpace(sSize2,Length(sSize1))
      else AppSpace(sSize1,Length(sSize2));
    end;

    Result:=CompareText(sSize2,sSize1);
}
    if rSize1=rSize2 then Result:=0
    else
    begin
      if rSize1<rSize2
      then Result:=1
      else Result:=-1;
    end;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TSortStr.Sort;
begin
  case FrmVoice.RGSort.ItemIndex of
    0: CustomSort(@CompareDateBeg);
    1: CustomSort(@CompareDateEnd);
    2: CustomSort(@CompareChanDate);
    3: CustomSort(@CompareSize);
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.FormCreate(Sender: TObject);
begin
  fStartSound:=False;

  CheckUncheck(False);
  DTPicker0.Date:=Date;
  DTPicker1.Date:=Date;
  MEDTime0.Text:='00:00:00';
  MEDTime1.Text:='00:00:00';
  CurrentDir:=GetCurrentDir;
  AssignFile(FInit,'BegDir.Ini');
{$I-}
  Reset(FInit,1);
{$I+}
  if IoResult<>0 then
  begin
    DirChan:=InitDirChan;
{$I-}
    Rewrite(FInit,1);
{$I+}
    if IoResult=0  then
    begin
      BlockWrite(FInit,DirChan,SizeOf(DirChan));
      CloseFile(FInit);
    end;
  end
  else
  begin
    if FileSize(FInit)=SizeOf(DirChan) then
    begin
      BlockRead(FInit,DirChan,SizeOf(DirChan));
      CloseFile(FInit);
    end
    else
    begin
      CloseFile(FInit);
      DirChan:=InitDirChan;
{$I-}
      Rewrite(FInit,1);
{$I+}
      if IoResult=0  then
      begin
        BlockWrite(FInit,DirChan,SizeOf(DirChan));
        CloseFile(FInit);
      end;
    end;
  end;

  FTPChange :=False;
  TimerTPChange:=0;
  fOpen:=False;
  MediaPlayer1.Notify:=True;
  MediaPlayer1.Close;

  SortStr:=TSortStr.Create;

  LBListFiles.Items:=SortStr;
  ListOfDir   := TList.Create;

  FWHandle:=0;
  FRHandle:=0;

end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action:=caFree;

  fOpen:=False;
  MediaPlayer1.Close;
  MediaPlayer1.Notify:=False;

  if FWHandle>0 then FileHandleClose(FWHandle);
  if FRHandle>0 then FileHandleClose(FRHandle);

  SetCurrentDir(CurrentDir);
  if FileExists('$$$.Wav')
  then DeleteFile('$$$.Wav');
  ListOfDir.Clear;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.CheckUncheck(ChU: boolean);
  var i: integer;
begin
  with GrBxChannals do
    for i:=0 to ControlCount-1 do
      if Controls[i] is TCheckBox
      then (Controls[i] as TCheckBox).Checked:=ChU;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnCaseAllClick(Sender: TObject);
begin
  CheckUncheck(True);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnCleareAllClick(Sender: TObject);
begin
  CheckUncheck(False);
end;
{------------------------------------------------------------------------------
}
procedure TFrmVoice.IncTEdit(Button      : TUDBtnType;
                            var MED_Time: TMaskEdit;
                            var UD_Time : TUpDown);
  var iHour
     ,iMin
     ,iSec : byte;
      Cd   : integer;
      SHour
     ,SMin
     ,SSec : string;
      sText: string;
      sPos : integer;
  {----------------------------------------------------------------------------}
  function GetTm(N0: integer;
                 MaxD : integer ): byte;
    var sDig: string;
  begin
    Val(Copy(sText,N0,2),Result,Cd);
    if (CD<>0) or (Result>MaxD) then Result:=0;
    if (MED_Time.SelStart>=N0-1) and (MED_Time.SelStart<N0+2) then
    begin

      if Button = btPrev   then
      begin
        if Result>0 then Dec(Result,UD_Time.Increment);
      end
      else Inc(Result,UD_Time.Increment);

      if (Result>MaxD) then Result:=0;
      sDig:=Char(byte('0')+(Result div 10))+Char(byte('0')+(Result mod 10));
      Delete(sText,N0,2);
      Insert(sDig,sText,N0);
    end;
  end;
  {----------------------------------------------------------------------------}
begin
  sPos :=MED_Time.SelStart;
  sText:=MED_Time.Text;

  iHour:=GetTm(1,23);
  iMin:=GetTm(4,59);
  iSec:=GetTm(7,59);

  MED_Time.Text:=sText;
  MED_Time.SelStart:=sPos;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.UdIncTime0Click(Sender: TObject; Button: TUDBtnType);
begin
  IncTEdit(Button
          ,MEDTime0
          ,UdIncTime0);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.SwitchTime(var MED_Time : TMaskEdit;
                               var UdIncTime: TUpDown;
                               var BtnOnOff : TButton);
begin
  MED_Time.Enabled := not MED_Time.Enabled;
  UdIncTime.Enabled:= not UdIncTime.Enabled;

  if MED_Time.Enabled then
  begin
    MED_Time.Color:=clWhite;
    BtnOnOff.Caption:='.';
  end
  else
  begin
    MED_Time.Color:=clBtnFace;
    BtnOnOff.Caption:='.';
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnOnOff0Click(Sender: TObject);
begin
  SwitchTime(MEDTime0,UdIncTime0,BtnOnOff0);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnOnOff1Click(Sender: TObject);
begin
  SwitchTime(MEDTime1,UdIncTime1,BtnOnOff1);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.Timer1Timer(Sender: TObject);
  var DoDefault: boolean;
    vMessage: TWMLButtonDown;
  {----------------------------------------------------------------------------}
  procedure PosPP(Pos:longint;Len:longint);
  begin
    if Len<>0 then
    with TrackBar1 do
    begin
      Position:=Min+Pos*(Max-Min) div Len;
    end;
  end;
  {----------------------------------------------------------------------------}
begin

  if not fOpen then Exit;
  with MediaPlayer1 do
  begin
    if not MCIOpened then Exit;
//    if not Notify then Exit;

    if fStartSound then
    begin
      vMessage.Msg:=WM_LButtonDown;
      vMessage.Keys:=1;
      vMessage.XPos:=7;
      vMessage.YPos:=7;
      vMessage.Result:=0;
//        DoMouseDown(14,14);
{      PostMessage(Handle,WM_LButtonDown,1,$70007);
      PostMessage(Handle,WM_LButtonUp,1,$70007);}
      WMLButtonDown(vMessage);
      vMessage.Msg:=WM_LButtonUp;
      WMLButtonUp(vMessage);
//        MediaPlayer1Click(TObject(MediaPlayer1),btPlay,DoDefault);
//      OnPostClick(TObject(MediaPlayer1),btPlay);
//      Play;
      Notify:=True;
      fStartSound:=False;
    end;

    vModes:=Mode;
    if not (vModes in [mpNotReady, mpStopped
                  , mpPlaying, mpRecording
                  , mpSeeking, mpPaused, mpOpen])
    then Exit;
    case vModes of
      mpPlaying:
        begin
          PosPP(Position,Length);
        end;

//      mpNotReady
      mpOpen    :
        PosPP(Position,Length);
      mpStopped : ;


    end;
  end;
end;
{-------------------------------------------------------------------------------
}
function  TFrmVoice.DirNameToDateTime(Name:string):TDateTime;
  const sChar: string= '0123456789ABCDEF'
                      +'GHJIKLMNOPQRSTUVWXYZ_$';
  var vYear
     ,vMonth
     ,vDay
     ,vHour
     ,vMin
     ,vSec   : integer;
      sStr   : string;

      Code   : integer;
      ePos: integer;
begin
  vHour :=0;
  vMin  :=0;
  vSec  :=0;

  Name:=UpperCase(ExtractFileName(Name));

  if (Length(Name)<3) then
  begin
    vYear :=1900;
    vMonth:=1;
    vDay  :=1;
  end
  else
  begin
    vYear:=Pos(Name[1],sChar)-1;
    if vYear<0
    then vYear :=1999
    else vYear :=2000+vYear;

    vMonth:=Pos(Name[2],sChar)-1;
    if (vMonth=0) or (vMonth>12)
    then vMonth:=1;

    vDay:=Pos(Name[3],sChar)-1;
    if (vDay=0) or (vDay>31)
    then vDay:=1;
  end;

  Result:=EncodeDate(vYear, vMonth, vDay)
         +EncodeTime(vHour, vMin, vSec,0);
end;
{-------------------------------------------------------------------------------
}
function  TFrmVoice.FileNameToDateTime(Name:string):TDateTime;
  const sChar: string= '0123456789ABCDEF'
                      +'GHJIKLMNOPQRSTUVWXYZ_$';
  var vYear
     ,vMonth
     ,vDay
     ,vHour
     ,vMin
     ,vSec   : integer;
      sStr   : string;

      Code   : integer;
      ePos   : integer;

begin
  Name:=UpperCase(ExtractFileName(Name));
  ePos:=Pos('.',Name);
  if ePos=9
  then Name:=Copy(Name,1,ePos-1);

  if (Length(Name)<>8) or (ePos<>9) then
  begin
    vYear :=1900;
    vMonth:=1;
    vDay  :=1;
    vHour :=0;
    vMin  :=0;
    vSec  :=0;
  end
  else
  begin
    vYear:=Pos(Name[1],sChar)-1;
    if vYear<0
    then vYear :=1999
    else vYear :=2000+vYear;

    vMonth:=Pos(Name[2],sChar)-1;
    if (vMonth=0) or (vMonth>12)
    then vMonth:=1;

    vDay:=Pos(Name[3],sChar)-1;
    if (vDay=0) or (vDay>31)
    then vDay:=1;

    vHour:=Pos(Name[4],sChar)-1;
    if (vHour=0) or (vHour>23)
    then vHour:=0;

    sStr:=Copy(Name,5,2);
    Val(sStr,vMin,Code);
    if (vMin=0) or (vMin>59)
    then vMin:=0;

    sStr:=Copy(Name,7,2);
    Val(sStr,vSec,Code);
    if (vSec=0) or (vSec>59)
    then vSec:=0;
  end;

  Result:=EncodeDate(vYear, vMonth, vDay)
         +EncodeTime(vHour, vMin, vSec,0);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnFormListClick(Sender: TObject);
  var FChan: boolean;
      i: integer;
      sr
     ,Dr : TSearchRec;
      FileAttrs
     ,DirAttrs  : Integer;
      FDateTime : TDateTime;
      sDt,sTm   : string;
      FFind     : boolean;
      NumChan   : integer;

      ii        : integer;
  {----------------------------------------------------------------------------}
  function FrmLine(sStr: string):string;
  begin
    Result:=sStr;
    if Length(sStr)<80
    then Result:=sStr+StringOfChar(' ',80-Length(sStr));
  end;
  {----------------------------------------------------------------------------}
  procedure AddToDirList;
    var PDir: PTDirectory;
  begin
     if (Dr.Attr and DirAttrs) <> Dr.Attr then Exit;

    if (Dr.Name='..')
//      or
//       (Dr.Name='.')
      or
       (Dr.Name='')   then Exit;

    New(PDir);
    PDir^:=TDirectory.Create;
    PDir^.sDirectory:=ExpandFileName(Dr.Name);
    ListOfDir.Add(PDir);
  end;
  //---------------------------------------------------------------------
begin
  fOpen:=False;
  MediaPlayer1.Close;
//  MediaPlayer1.Notify:=False;
  MediaPlayer1.FileName:='';

  SortStr.Clear;
  LBListFiles.Clear;

  FChan:=False;

  with GrBxChannals do
    for i:=0 to ControlCount-1 do
      if Controls[i] is TCheckBox  then
        if (Controls[i] as TCheckBox).Checked then FChan:=True;

  if not FChan then
  begin
    Application.MessageBox('      .'
                          ,' '
                          ,Mb_Ok or Mb_IconStop);
    Exit;
  end;


  DirAttrs := faDirectory;
  FileAttrs:= faHidden+ faSysFile + faVolumeID
             + faArchive + faAnyFile;
  NumChan:=0;

  with GrBxChannals do
    for i:=0 to ControlCount-1 do
    begin
      ListOfDir.Clear;

      if Controls[i] is TCheckBox  then
      begin
        Inc(NumChan);
        if (Controls[i] as TCheckBox).Checked then
        begin
          SetCurrentDir(DirChan[NumChan-1]);

          if FindFirst('*.',DirAttrs,Dr)=0 then
          begin
            AddToDirList;
            while FindNext(Dr)=0 do AddToDirList;
          end;

          FindClose(Dr);

          SortStr.Sorted:=False;

          for ii:=0 to ListOfDir.Count-1 do
          begin
            FDateTime:=DirNameToDateTime(PTDirectory(ListOfDir.Items[ii])^.sDirectory);
            sDt:=FormatDateTime('yyyymmdd',FDateTime);

            if( (sDt>=FormatDateTime('yyyymmdd',DTPicker0.Date))
               and
                (sDt<=FormatDateTime('yyyymmdd',DTPicker1.Date)) )
               or
                ( Length(PTDirectory(ListOfDir.Items[ii])^.sDirectory)=4)   then
            begin
              SetCurrentDir(PTDirectory(ListOfDir.Items[ii])^.sDirectory);

              if FindFirst('*.'+IntToStr(NumChan), FileAttrs, sr) = 0 then
              begin
//                with {LBListFiles.Items}SortStr do
//                begin
//                  Sorted:=False;
                repeat
//                  FDateTime:=FileDateToDateTime(sr.Time);
                  FDateTime:=FileNameToDateTime(sr.Name);
                  sDt:=FormatDateTime('yyyymmdd',FDateTime);
                  sTm:=FormatDateTime('hh:nn:ss',FDateTime);

                  FFind:=True;

                  if (sDt<FormatDateTime('yyyymmdd',DTPicker0.Date))
                      or
                     (sDt>FormatDateTime('yyyymmdd',DTPicker1.Date))
                  then FFind:=False;

                  if MEDTime0.Enabled then
                    if (sTm<MEDTime0.Text)
                    then FFind:=False;

                  if MEDTime1.Enabled then
                    if (sTm>MEDTime1.Text)
                    then FFind:=False;

                  if FFind  then
                  begin
                    SortStr.Add(
                       FrmLine(IntToStr(NumChan)
                               +'  '
                               +FormatDateTime('dd.mm.yy hh:nn:ss',FDateTime)
                               +'  '
                               +FormatDateTime('dd.mm.yy hh:nn:ss'
                                              , FileDateToDateTime(sr.Time))
                               +'  '
                               +IntToStr(sr.Size)
                               )
                       +ExpandFileName(sr.Name));
                  end;
                until FindNext(sr) <> 0;
                FindClose(sr);

//                    Sorted:=True;
    //              CustomSort(@CompareDate);
//                  end;
              end;
            end;
          end;

          SortStr.Sorted:=True;
          LBListFiles.Items:=SortStr;
          ListOfDir.Clear;

        end;
      end;

    end;

  SetCurrentDir(CurrentDir);

end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BtnClearListClick(Sender: TObject);
begin
  SortStr.Clear;
  LBListFiles.Clear;
  fOpen:=False;
  MediaPlayer1.Close;
//  MediaPlayer1.Notify:=False;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.FormWavFile(IndLB: integer);
  const SBuffR = 4096;
        SBuffW = 4096;
  var sFName,sFName1: string;
      FRLength: longint;
      BuffR  : array [0..SBuffR-1] of byte;
      BuffW  : array [0..SBuffW-1] of byte;
      iBytesRead: integer;
      i,j,n     : integer;
      Bw,Bw1    : word;
begin
//  StFileName.Caption:='';
//  StFileName.Repaint;

  fOpen:=False;
  MediaPlayer1.Close;
//  MediaPlayer1.Notify:=False;

  sFName1:=LBListFiles.Items.Strings[IndLB];
  sFName:=TrimLeft(Copy(sFName1,81,length(sFName1)-80));

  if FRHandle>0 then FileHandleClose(FRHandle);
  FRHandle:=FileOpen(sFName,fmOpenRead);
  if FRHandle<0 then
  begin
    FileHandleClose(FRHandle);
    FRHandle:=FileOpen(sFName,fmOpenRead);
  end;

  if FWHandle>0 then FileHandleClose(FWHandle);
  FWHandle:=FileCreate(CurrentDir+'\$$$.Wav');
  if FWHandle<0 then
  begin
    FileHandleClose(FWHandle);
    FWHandle:=FileCreate(CurrentDir+'\$$$.Wav');
  end;

  if (FRHandle>0) and (FWHandle>0) then
  begin

    TypeFile:=TestHeader(FRHandle);
    case TypeFile of
      tDirBit: FormHeader(FRHandle,FWHandle);
      tWave  : FileSeek(FRHandle,0,0);
      tRevBit:
               begin
                 FormHeader(FRHandle,FWHandle);
                 FileSeek(FRHandle,16,1);
               end;
      tPack801
     ,tPack8
     ,tPack8D:
               begin
                 FormHeader(FRHandle,FWHandle);
                 FileSeek(FRHandle,16,1);
               end;
    end;

    j:=0;
    repeat
      iBytesRead := FileRead(FRHandle, BuffR, SBuffR);

      if iBytesRead>0  then
      case TypeFile of
        tRevBit:
          begin
            for i:=0 to iBytesRead-1 do
            begin
              Bw:=not byte(BuffR[i]);
              BuffW[i]:= lo(Bw div $8)+lo(Bw * $20);
            end;

            FileWrite(FWHandle,BuffW,iBytesRead);
          end;

        tWave,tDirBit:
          begin
            FileWrite(FWHandle,BuffR,iBytesRead);
          end;

        tPack801:
          begin
            i:=0;
            while i<iBytesRead do
            begin
              Bw:=not byte(BuffR[i]);
              Bw:=lo(Bw div $8)+lo((Bw and 7) * $20);
              BuffW[j]:=lo(Bw);
              Inc(j);
              Inc(i);


              if j=SBuffW then
              begin
                FileWrite(FWHandle,BuffW,j);
                j:=0;
              end;

              if i>=iBytesRead then Break;

              if (lo(Bw) and $01) <> 0 then
              begin
                Bw1:=not byte(BuffR[i]);
                Bw1:=lo(Bw1 div $4)+lo((Bw1 and 3) * $40);
                for n:=1 to Bw1-1 do
                begin
                  BuffW[j]:=Bw;
                  Inc(j);
                  if j=SBuffW then
                  begin
                    FileWrite(FWHandle,BuffW,j);
                    j:=0;
                  end;
                end;
                Inc(i);
              end;
            end;

          end;
        tPack8:
          begin
            i:=0;
            while i<iBytesRead do
            begin
              Bw:=byte(BuffR[i]);
              Bw:=(lo((Bw and $F0) div $10)+lo((Bw* $10) and $F0));
              Bw:=not byte(lo(Bw));
              Inc(i);

              if i>=iBytesRead then Break;

              if (lo(Bw) and $01) <> 0 then
              begin
                for n:=1 to Bw div 2 do
                begin
                  Bw1:=byte(BuffR[i]);
                  Bw1:=lo((Bw1 and $F0) div $10)+lo((Bw1 * $10) and $F0);
                  Bw1:=not byte(lo(Bw1));
                  BuffW[j]:=lo(Bw1);
//                  BuffW[j]:=byte(BuffR[i]);
                  Inc(j);
                  if j=SBuffW then
                  begin
                    FileWrite(FWHandle,BuffW,j);
                    j:=0;
                  end;
                end;
                Inc(i);
              end
              else
              begin
                BuffW[j]:=lo(BW);
                Inc(j);
                if j=SBuffW then
                begin
                  FileWrite(FWHandle,BuffW,j);
                  j:=0;
                end;
              end;
            end;
          end;

        tPack8D:
          begin
            i:=0;
            while i<iBytesRead do
            begin
              Bw:=byte(BuffR[i]);
              Inc(i);

              if i>=iBytesRead then Break;

              if (lo(Bw) and $01) <> 0 then
              begin
                for n:=1 to Bw div 2 do
                begin
                  Bw1:=byte(BuffR[i]);
                  BuffW[j]:=lo(Bw1);
                  Inc(j);
                  if j=SBuffW then
                  begin
                    FileWrite(FWHandle,BuffW,j);
                    j:=0;
                  end;
                end;
                Inc(i);
              end
              else
              begin
                BuffW[j]:=lo(Bw);
                Inc(j);
                if j=SBuffW then
                begin
                  FileWrite(FWHandle,BuffW,j);
                  j:=0;
                end;
              end;
            end;
          end;
      end;

    until iBytesRead<4096;

    case TypeFile of
      tPack801
     ,tPack8
     ,tPack8D :
        begin
          FileWrite(FWHandle,BuffW,j);
          FormHeader(FWHandle,FWHandle);
        end;
    end;

    FileHandleClose(FWHandle);
    FileHandleClose(FRHandle);

    try
//      MediaPlayer1.FileName:='';
      MediaPlayer1.FileName:=CurrentDir+'\$$$.Wav';

{      MediaPlayer1.Wait:=False;
      MediaPlayer1.Notify:=True;}
      MediaPlayer1.Open;
      fOpen:=True;
    except
      FileHandleClose(FWHandle);
      FileHandleClose(FRHandle);
    end;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.N0_ExitClick(Sender: TObject);
begin
  Close;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.DirectoryListBox1Change(Sender: TObject);
begin
  DriveComboBox1.Drive := DirectoryListBox1.Drive;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.RgDirChanClick(Sender: TObject);
begin
  if RgDirChan.ItemIndex > -1 then
  begin
    DirectoryListBox1.Directory:=StrPas(DirChan[RgDirChan.ItemIndex]);
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BitBtn1Click(Sender: TObject);
begin
  if RgDirChan.ItemIndex > -1 then
  begin
    StrPCopy(DirChan[RgDirChan.ItemIndex],DirectoryListBox1.Directory);
    AssignFile(FInit,CurrentDir+'\BegDir.Ini');
{$I-}
    Rewrite(FInit,1);
{$I+}
    if IoResult=0  then
    begin
      BlockWrite(FInit,DirChan,SizeOf(DirChan));
      CloseFile(FInit);
    end;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.UdIncTime1Click(Sender: TObject; Button: TUDBtnType);
begin
  IncTEdit(Button
          ,MEDTime1
          ,UdIncTime1);
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.TrackBar1Change(Sender: TObject);
begin
  with MediaPlayer1 do
  begin
    case Mode of
      mpStopped  :
        begin
          FTPChange :=True;
//          TimerTPChange:=0;
          if Position=Length  then
          begin
            Position:=0;
            TrackBar1.Position:=0;
          end
          else
          begin
            if Length<>0
            then Position:=TrackBar1.Position*Length
                     div (TrackBar1.Max-TrackBar1.Min)
            else Position:=0;
          end;
        end;

      mpSeeking
     ,mpPaused
     ,mpOpen     :
        begin
          FTPChange :=True;
          TimerTPChange:=0;
          if Length<>0
          then Position:=TrackBar1.Position*Length
                     div (TrackBar1.Max-TrackBar1.Min)
          else Position:=0;
        end;
    end;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.MediaPlayer1Notify(Sender: TObject);
{const
  ModeStr: array[TMPModes] of string =
           ('Not ready', 'Stopped', 'Playing'
           , 'Recording', 'Seeking', 'Paused', 'Open');}
  var fFind: boolean;
      i    : integer;
      ResNot: boolean;

begin
  ResNot:=True;

  with Sender as TMediaPlayer do
  begin
//    Label5.Caption:=ModeStr[Mode];
    case Mode of
      mpStopped:
      if (not fStartSound) and fOpen then
      begin
//        ResNot:=False;

//        beep;
{        AutoEnable := False;
        EnabledButtons := [];
}
        if (Position=Length)
          or
           (Position=0) then
        begin
//          AutoEnable := True;
          Position:=0;
          TrackBar1.Position:=0;

          begin
            fFind:=False;

            begin

              if (NSoundLine>=0)
                and
                 (NSoundLine<LBListFiles.Items.Count)  then
              with LBListFiles do
              begin
                StFileName.Caption:='';
                StFileName.Repaint;

        //          Selected[NSoundLine]:=False;
                for i:=NSoundLine+1 to Items.Count-1 do
                begin
                  if Selected[i] then
                  begin
                    fFind:=True;
                    NSoundLine:=i;
                    StFileName.Caption:=Copy(Items.Strings[i],1,52);
                    StFileName.Repaint;

                    FormWavFile(NSoundLine);

                    Break;
                  end;
                end;

                if fFind  then
                begin
                  if ChBxAutoStart.Checked then
                  begin
                    ResNot:=True;
                    fStartSound:=True;
//                    Play;
                  end
                  else
                  begin
//                    AutoEnable := True;
                    fStartSound:=False;
                    fOpen:=False;
                  end;
                end
                else
                begin
{                  AutoEnable := False;
                  EnabledButtons := [];
}
                  fOpen:=False;
                  Close;
                end;

              end;
            end;
          end;
        end;
      end;

      mpPlaying:
      begin
{        AutoEnable := False;
        EnabledButtons := [btPause,btStop];}
      end;

      mpNotReady:
      begin
{        AutoEnable := False;
        EnabledButtons := [];}
      end;

//      else AutoEnable := True;
    end;

    FTPChange :=False;

    { Note we must reset the Notify property to True }
    { so that we are notified the next time the }
    { mode changes }
    Notify := True;
//    Notify := ResNot;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.PilicPilic;
  var i: integer;
      FFind: boolean;
begin
  NSoundLine:=-1;
  fStartSound:=False;

  with LBListFiles do
  begin
    FFind:=False;
    for i:=0 to Items.Count-1 do
    begin
      if Selected[i] then
      begin
        FFind:=True;
        NSoundLine:=i;
        Break;
      end;
    end;

    if not FFind
    then Application.MessageBox('    .'
                               ,''
                               ,Mb_Ok or Mb_IconWarning)
    else
    begin
      StFileName.Caption:=Copy(Items.Strings[NSoundLine],1,52);
      StFileName.Repaint;

      FormWavFile(NSoundLine);

      fStartSound:=True;
//      MediaPlayer1.Play;

//      MediaPlayer1.AutoEnable := False;
//     MediaPlayer1.EnabledButtons := [btPause,btStop];


//      fStartSound:=True;
    end;
  end;
end;
{-------------------------------------------------------------------------------
}
procedure TFrmVoice.BitBtnStartClick(Sender: TObject);
begin
  PilicPilic;
end;

procedure TFrmVoice.LBListFilesClick(Sender: TObject);
begin
  fOpen:=False;
  MediaPlayer1.Close;
//  MediaPlayer1.Notify:=False;
end;

procedure TFrmVoice.MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  DoDefault:=True;
//  MediaPlayer1.OnClick(Sender,Button,DoDefault);

  with MediaPlayer1 do
  begin
    if not MCIOpened then Exit;
    if Mode <> mpStopped then Exit;

    case Button  of
      btPlay:
        begin
{          AutoEnable := False;
          EnabledButtons := [btPause,btStop];
          Play;                        }
          fOpen:=True;
        end;
{      btPause:
        begin
//          AutoEnable := True;
          AutoEnable := False;
          EnabledButtons:=[btPlay];//+byte(btNext)+byte(btPrev];
          fOpen:=False;
        end;
      btStop:
        begin
          AutoEnable := True;
          EnabledButtons := [btPlay];
          fOpen:=False;
        end;}
    end;
  end;
end;

procedure TFrmVoice.MediaPlayer1PostClick(Sender: TObject;
  Button: TMPBtnType);
  var i: integer;
begin
end;

procedure TFrmVoice.LBListFilesDblClick(Sender: TObject);
begin
  PilicPilic;
end;

procedure TFrmVoice.FileHandleClose(var FHandle: integer);
begin
  if FHandle>0 then
  begin
    FileClose(FHandle);
    FHandle:=-1;
  end;
end;

end.
