unit FrmWav;
interface
uses Sysutils,TypeVoic,Windows;

type THeaderWav1= record
                   hRiff: array[0..3] of char;
                   hSizeFileM8: dword;
                   hWave: array[0..3] of char;
                   hFmt : array[0..3] of char;
                   hSizeBlockHeader: dword;
                   hTypeFormatData : word;
                   hCountChann     : word;
                   hFreqDiscr      : dword;
                   hSpeedDataSend  : dword;
                   hCountDataCalc  : word;
                   hSizeBit        : word;
                   hIdData         : array[0..3] of char;
                   hLenSoundData   : dword;
                 end;
const HeaderWav1: THeaderWav1  = (
                   hRiff           : 'RIFF';
                   hSizeFileM8     : 0;
                   hWave           : 'WAVE';
                   hFmt            : 'fmt ';
                   hSizeBlockHeader: 0;
                   hTypeFormatData : 0;
                   hCountChann     : 0;
                   hFreqDiscr      : 0;
                   hSpeedDataSend  : 0;
                   hCountDataCalc  : 0;
                   hSizeBit        : 0;
                   hIdData         : 'data';
                   hLenSoundData   : 0
                                );

function TestHeader(var FRHandle: integer): TTypeFile;
procedure FormHeader(var FRHandle,FWHandle: integer);

implementation
{-------------------------------------------------------------------------------
}
procedure FormHeader(var FRHandle,FWHandle: integer);
  var
      vHeaderWav1: THeaderWav1;
      FRLength   : longint;
      fRW        : boolean;
begin
  fRW:=(FRHandle=FWHandle);
  FRLength := FileSeek(FRHandle,0,2);
  FileSeek(FRHandle,0,0);
  vHeaderWav1:=HeaderWav1;

  with vHeaderWav1 do
  begin
    if not fRW
    then hSizeFileM8     := FRLength+SizeOf(HeaderWav1)-$08
    else hSizeFileM8     := FRLength-$08;
    hSizeBlockHeader:=$000010;
    hTypeFormatData :=$0001;
    hCountChann     :=$01;
    hFreqDiscr      :=7860;
    hSizeBit        := 8;
    hSpeedDataSend  :=hFreqDiscr*hCountChann*(hSizeBit div 8);
    hCountDataCalc  :=1;
    if not fRW
    then hLenSoundData   :=FRLength
    else hLenSoundData   :=FRLength-SizeOf(HeaderWav1);
  end;

  FileSeek(FWHandle,0,0);
  FileWrite(FWHandle,vHeaderWav1,SizeOf(vHeaderWav1));
end;

function TestHeader(var FRHandle: integer): TTypeFile;
  var vHeaderWav1: THeaderWav1;
      IdQualificator : array [0..15] of byte;
begin
  Result:=tNon;

  FileSeek(FRHandle,0,0);
  FileRead(FRHandle,vHeaderWav1,SizeOf(vHeaderWav1));

  if (vHeaderWav1.hRiff=HeaderWav1.hRiff)
    and
     (vHeaderWav1.hWave=HeaderWav1.hWave)
    and
     (vHeaderWav1.hFmt=HeaderWav1.hFmt)
    and
     (vHeaderWav1.hIdData=HeaderWav1.hIdData)  then
  begin
    Result:=tWave;
    Exit;
  end;

  Fillchar(IdQualificator,SizeOf(IdQualificator),0);
  FileSeek(FRHandle,0,0);
  FileRead(FRHandle,IdQualificator,SizeOf(IdQualificator));

  if (IdQualificator[ 0]=$73)
    and
     (IdQualificator[ 1]=$45)
    and
     (IdQualificator[ 2]=$41)
    and
     (IdQualificator[ 3]=$29)
    and
     (IdQualificator[ 4]=$38)
    and
     (IdQualificator[ 5]=$46)
    and
     (IdQualificator[ 6]=$88)
    and
     (IdQualificator[ 7]=$61)
    and
     (IdQualificator[ 8]=$34)
    and
     (IdQualificator[ 9]=$02)
    and
     (IdQualificator[10]=$70)
    and
     (IdQualificator[11]=$73)
    and
     (IdQualificator[12]=$66)
    and
     (IdQualificator[13]=$E0)
    and
     (IdQualificator[14]=$23)
    and
     (IdQualificator[15]=$25)
  then
  begin
    Result:=tRevBit;
    Exit;
  end;

  if (IdQualificator[ 0]=$61)
    and
     (IdQualificator[ 1]=$54)
    and
     (IdQualificator[ 2]=$35)
    and
     (IdQualificator[ 3]=$26)
    and
     (IdQualificator[ 4]=$11)
    and
     (IdQualificator[ 5]=$17)
    and
     (IdQualificator[ 6]=$33)
    and
     (IdQualificator[ 7]=$48)
    and
     (IdQualificator[ 8]=$45)
    and
     (IdQualificator[ 9]=$42)
    and
     (IdQualificator[10]=$89)
    and
     (IdQualificator[11]=$A2)
    and
     (IdQualificator[12]=$C0)
    and
     (IdQualificator[13]=$70)
    and
     (IdQualificator[14]=$6A)
    and
     (IdQualificator[15]=$8D)
  then
  begin
    Result:=tPack801;
    Exit;
  end;
  if (IdQualificator[ 0]=$61)
    and
     (IdQualificator[ 1]=$54)
    and
     (IdQualificator[ 2]=$35)
    and
     (IdQualificator[ 3]=$26)
    and
     (IdQualificator[ 4]=$11)
    and
     (IdQualificator[ 5]=$17)
    and
     (IdQualificator[ 6]=$33)
    and
     (IdQualificator[ 7]=$48)
    and
     (IdQualificator[ 8]=$45)
    and
     (IdQualificator[ 9]=$42)
    and
     (IdQualificator[10]=$89)
    and
     (IdQualificator[11]=$A2)
    and
     (IdQualificator[12]=$C8)
    and
     (IdQualificator[13]=$78)
    and
     (IdQualificator[14]=$6A)
    and
     (IdQualificator[15]=$8D)
  then
  begin
    Result:=tPack8;
    Exit;
  end;

  if (IdQualificator[ 0]=$61)
    and
     (IdQualificator[ 1]=$54)
    and
     (IdQualificator[ 2]=$35)
    and
     (IdQualificator[ 3]=$26)
    and
     (IdQualificator[ 4]=$11)
    and
     (IdQualificator[ 5]=$17)
    and
     (IdQualificator[ 6]=$33)
    and
     (IdQualificator[ 7]=$48)
    and
     (IdQualificator[ 8]=$45)
    and
     (IdQualificator[ 9]=$42)
    and
     (IdQualificator[10]=$89)
    and
     (IdQualificator[11]=$A2)
    and
     (IdQualificator[12]=$CA)
    and
     (IdQualificator[13]=$7A)
    and
     (IdQualificator[14]=$6A)
    and
     (IdQualificator[15]=$8D)
  then
  begin
    Result:=tPack8D;
    Exit;
  end;

  if (IdQualificator[ 0]=$E1)
    and
     (IdQualificator[ 1]=$C8)
    and
     (IdQualificator[ 2]=$A6)
    and
     (IdQualificator[ 3]=$44)
    and
     (IdQualificator[ 4]=$7E)
    and
     (IdQualificator[ 5]=$8D)
    and
     (IdQualificator[ 6]=$E3)
    and
     (IdQualificator[ 7]=$76)
    and
     (IdQualificator[ 8]=$85)
    and
     (IdQualificator[ 9]=$45)
    and
     (IdQualificator[10]=$32)
    and
     (IdQualificator[11]=$53)
    and
     (IdQualificator[12]=$D2)
    and
     (IdQualificator[13]=$2F)
    and
     (IdQualificator[14]=$77)
    and
     (IdQualificator[15]=$F0)
  then
  begin
    Result:=tPackDlt01;
    Exit;
  end;

  Result:=tDirBit;

end;

end.