;       
;    2.1   PIC16F84, -
;   10 (   PIC16C84).   
;         :
;  - HS, Watchdog timer - ON, Power-up timer - ON.

LIST P=16F84 
;    
RTCC	EQU	0x01
PCL	EQU	0x02
PCLATH	EQU	0x0A
TRISA	EQU	0x85
TRISB	EQU	0x86
OPTIONS	EQU	0x81
STATUS  EQU     3 
RP0     EQU     5 
PORTA	EQU	0x05
PORTB	EQU	0x06
EEDATA	EQU	0x08
EEADR	EQU	0x09
EECON1	EQU	0x88
EECON2	EQU	0x89
WREN	equ	2
WR	equ	1
RD	equ	0
FSR	EQU	4
F0	EQU	0
INTCON	EQU	0x0B
C	equ	0
Z	equ	2
RBIF	equ	0
RTIF	equ	2
GIE	equ	7
RBIE	equ	3

;  ,     
R_ST	equ	3
C_ST	equ	4
NumL	EQU	0x0C			
NumH	EQU	0x0D			
REZIM	EQU	0x0E		
Thou	EQU	0x0F			
Hund	EQU	0x10			
Tens	EQU	0x11			
Ones	EQU	0x12			
TEMP1	EQU	0x13
I	EQU	0x14
J	EQU	0x15
;  ,     
;  
;*   : 
;*  0-  3.3,    TimeL
;*  1-       
;*  2-  K_ZAP = 0%
;*  3-  K_ZAP = 100%
;*  4-  0.5,   ""   
;*  5-,       EEROM
;*         1 
;*  7-,     
FLAGS	EQU	0x16
BACKUPW	EQU	0x17
K_ZAP	EQU	0x18
Ti12	EQU	0x19
Ti3	EQU	0x1A
T_KEY1	EQU	0x1B
N_STEP	EQU	0x1C
TIMEA	EQU	0x1D
TIMEL	EQU	0x1E
TIME_IMPA	EQU	0x1F
TIME_IMPL	EQU	0x20
N_IMPULS	EQU	0x21
F2L	EQU	0x22
F2H	EQU	0x23
FR_DOGT	EQU	0x24
KF_ZAD	EQU	0x25
F_REAL	EQU	0x26
TIMER1	EQU	0x27
TIMER2	EQU	0x28
BACKUPS	EQU	0x29
WTIMEL	EQU	0x2A
WTIMEH	EQU	0x2B
WI	EQU	0x2C

;******	     *******
	BSF     STATUS, RP0	;   1 
        CLRF    TRISA		;       
        MOVLW 	B'10000111'	
	GOTO	BEGIN_PROG	
	
;*****       .*************
 	BCF	INTCON,	GIE	; 
	MOVWF	BACKUPW		;   
	MOVF	STATUS, 0	;  STATUS
	MOVWF	BACKUPS
	BTFSS	INTCON, RTIF	;  
	GOTO	L17		;      		
	CLRWDT			;  
;******               *******
;******      *******
	; 1
	MOVLW	.1		
	SUBWF	N_STEP, 0		
	BTFSS	STATUS, Z
	GOTO	L28			;   1
	MOVF	Ti12, 0			;     
	MOVWF	RTCC
	CALL	GET_TIME		;   
	INCF	N_STEP
	MOVLW	.26			;    ,K_ZAP > 50%  K_ZAP < 50%
	SUBWF	K_ZAP, 0		
	BTFSC	STATUS, C	
	GOTO	L30			;K_ZAP > 50%
	; < 0.5
	BTFSS	FLAGS, 2		; K_ZAP = 0%,   
	BSF	PORTB, 4		; V2
	GOTO	L27
	; > 0.5
L30	BTFSS	FLAGS, 3		; K_ZAP = 100%,   
	BCF	PORTB, 5		; V4
	GOTO	L27
	; 2
L28	MOVLW	.2		
	SUBWF	N_STEP, 0
	BTFSS	STATUS, Z
	GOTO	L29
	MOVF	Ti12, 0			;     
	MOVWF	RTCC
	CALL	GET_TIME		;   
	INCF	N_STEP
	MOVLW	.26			;    ,K_ZAP > 50%  K_ZAP < 50%
	SUBWF	K_ZAP, 0		
	BTFSC	STATUS, C	
	GOTO	L65			;K_ZAP > 50%
	; < 0.5
	BTFSS	FLAGS, 3		; K_ZAP = 100%,   
	BCF	PORTB, 4		; V2
	BTFSS	FLAGS, 2		; K_ZAP = 0%,   
	BSF	PORTB, 5		; V4
	GOTO	L27
	; > 0.5
L65	BTFSS	FLAGS, 3		; K_ZAP = 100%,   
	BCF	PORTB, 4		; V2
	BTFSS	FLAGS, 2		; K_ZAP = 0%,   
	BSF	PORTB, 5		; V4
	GOTO	L27
	; 3
L29	MOVF	Ti3, 0			;     
	MOVWF	RTCC
	CALL	GET_TIME		;   
	MOVLW	.1
	MOVWF	N_STEP
	MOVLW	.26			;    ,K_ZAP > 50%  K_ZAP < 50%
	SUBWF	K_ZAP, 0	
	BTFSC	STATUS, C	
	GOTO	L31			;K_ZAP > 50%
	; < 0.5
	BTFSS	FLAGS, 3		; K_ZAP = 100%,   
	BCF	PORTB, 5		; V4
	GOTO	L27
	; > 0.5
L31	BTFSS	FLAGS, 2		; K_ZAP = 0%,   
	BSF	PORTB, 4		; V2
	
;******     ******
L27	BTFSC	PORTB, 1		;   ""
	GOTO	L16
	CLRF	KF_ZAD			;   3 (""), K_ZAP:=0%
	CLRF	K_ZAP
	BSF	FLAGS, 2
	BCF	FLAGS, 3

	;    KF_ZAD
L16	BTFSC	FLAGS, 4
	GOTO	IRET
	BSF	FLAGS, 4
	;    
	BTFSS	PORTB, 3		;  /  
	GOTO	L46			;   
	BTFSC	PORTB, 2		;   ""
	GOTO	L18
	BTFSC	PORTB, 0		;   ""
	GOTO	L15
	GOTO	IRET
L46	BTFSC	PORTB, 2		;   ""
	GOTO	L15
	BTFSC	PORTB, 0		;   ""
	GOTO	L18
	GOTO	IRET
	; KF_ZAD  5(2)%
L15	MOVLW	.100		
	SUBWF	KF_ZAD, 0
	BTFSC	STATUS, Z
	GOTO	IRET			;KF_ZAD   100%
	BTFSC	FLAGS, 7		;   ,
	MOVLW	.5			;  KF_ZAD=5%
	BTFSS	FLAGS, 7		;  K_ZAP=2%
	MOVLW	.2
	ADDWF	KF_ZAD, 1
	GOTO	IRET
	; KF_ZAD  5(2)%
L18	MOVF	KF_ZAD, 1
	BTFSS	STATUS, Z
	GOTO	L95
	BTFSS	PORTB, 3		;KF_ZAD   0%
	GOTO	L96			;   
	BCF	PORTB, 3
	GOTO	L15	
L96	BSF	PORTB, 3
	GOTO	L15
L95	BTFSC	FLAGS, 7		;   ,
	MOVLW	.5			;  KF_ZAD=5%
	BTFSS	FLAGS, 7		;  K_ZAP=2%
	MOVLW	.2
	SUBWF	KF_ZAD, 1

	;    
IRET	BCF 	INTCON, RTIF 		;    
	MOVF	BACKUPS, 0
	MOVWF	STATUS
	MOVF 	BACKUPW, 0		;  
	BSF 	INTCON, GIE		; 
	RETFIE				;   

;*************        *********
L17	BTFSS	PORTB, 7
	GOTO	IRET2			;     
	DECFSZ	N_IMPULS, 1
	GOTO	IRET2
	BCF	INTCON, RBIE		;    
	MOVLW	.2
	MOVWF	N_IMPULS
	BTFSC	FLAGS, 0		;  TIMEL,  
	GOTO	L71			;
	; ,        
	MOVF	TIME_IMPA, 0
	SUBWF	TIMEA, 0
	BTFSS	STATUS, C		;  
	INCF	TIME_IMPL, 1
	MOVWF	TIME_IMPA
	MOVF	TIME_IMPL, 0
	SUBWF	TIMEL, 0
	MOVWF	TIME_IMPL
	MOVLW	.1			;    RTCC
	SUBWF	N_STEP, 0
	BTFSS	STATUS, Z
	GOTO	L19
	MOVF	Ti3, 0
	GOTO	L75
L19	MOVF	Ti12, 0
L75	SUBWF	RTCC, 0
	ADDWF	TIME_IMPA, 1
	BTFSS	STATUS, C		;  
	INCF	TIME_IMPL, 1
	MOVF	TIME_IMPA, 0
	MOVWF	F2L
	MOVF	TIME_IMPL, 0
	MOVWF	F2H
L71	BSF	FLAGS, 1		;  STABIL   
	;      
IRET2	MOVLW	.40			;    
	MOVWF	FR_DOGT			;     
	BCF INTCON, RBIF		;    PORTB
	MOVF	BACKUPS, 0
	MOVWF	STATUS			;  STATUS
	MOVF BACKUPW, 0			;  
	BSF INTCON, GIE			; 
	RETFIE				;   
	
;******    *****************************
BEGIN_PROG	
	MOVWF	TRISB		;  0, 1, 2, 7    .
	MOVLW	B'01000111'	;      
	MOVWF	OPTIONS		; 1:128,      
	BCF     STATUS, RP0     ;   0 
	CLRF	PORTB
	CLRF	F_REAL		;   	
	CLRF	K_ZAP		;
	CLRF	KF_ZAD
	MOVLW	.40
	MOVWF	T_KEY1
	CLRF	TIMEA
	CLRF	TIMEL
	MOVLW	.1
	MOVWF	N_STEP
	MOVLW	.2
	MOVWF	N_IMPULS
	MOVLW	.20
	MOVWF	FR_DOGT
	CLRF	TIMER1
	CLRF	TIMER2	
	CLRF	FLAGS
	BSF	FLAGS, 2
	MOVLW	.128
	MOVWF	Ti12	
	MOVWF	Ti3
	MOVLW	.18
	MOVWF	WI
	;       
	CALL	LEEPROM		
	MOVLW	.5
	SUBWF	REZIM, 0
	BTFSC	STATUS, Z
	BSF	FLAGS, 7 
	MOVLW	B'10101000'	;     RB
	MOVWF	INTCON 		;  
		
;******     KF_ZAD, K_ZAP   ****** 
;******   K_ZAP      ******
;******    *************************************
L6	BTFSC	INTCON, RBIE	
	GOTO	L73			;     
	MOVLW	.2			;     
	MOVWF	N_IMPULS	
	BCF	FLAGS, 0
	MOVF	TIMEA, 0		;   
	MOVWF	TIME_IMPA
	MOVF	TIMEL, 0
	MOVWF	TIME_IMPL
	BSF	INTCON, RBIE		;    
	;,    ""    
L73	MOVF	KF_ZAD, 0
	ADDWF	F_REAL, 0
	BTFSS	STATUS, Z
	GOTO	L35			;      
	BTFSS	FLAGS, 5		;     EEPROM
	GOTO	L50			;  .
	CALL	SEEPROM			;  EEROM     
	BCF	FLAGS, 5		;  
L50	BTFSC	PORTB, 1		;   ""
	GOTO	L35
	MOVF	WTIMEL, 0		;  ,    
	MOVWF	NumL			; ""
	MOVF	WTIMEH, 0
	MOVWF	NumH
	CALL	Convert			;     
	CALL	PRN			; .
	MOVLW	.6			;     /
	MOVWF	I			;    
	MOVF	REZIM, 0
	MOVWF	TEMP1
	CALL	LOAD_ST
	BTFSS	PORTB, 0		;   "" (. )
	GOTO	L36
	MOVLW	.5		
	SUBWF	REZIM, 0
	BTFSC	STATUS, Z
	GOTO	L36
	MOVLW	.5			;  ,   
	MOVWF	REZIM			;  
	BSF	FLAGS, 7
	CALL	SEEPROM
L36	BTFSS	PORTB, 2		;   "" (. )
	GOTO	L6
	MOVLW	0x0F
	SUBWF	REZIM, 0
	BTFSC	STATUS, Z
	GOTO	L6
	MOVLW	0x0F			;  ,  
	MOVWF	REZIM			;  
	BCF	FLAGS, 7
	CALL	SEEPROM
	GOTO	L6
	;  ""      
L35	MOVF	KF_ZAD, 0		;    
	MOVWF	NumL			; 
	CLRF	NumH
	CALL	Convert
	CALL	PRN2
	BTFSS	FLAGS, 7		;   ,
	GOTO	L97			;   K_ZAP,  F_REAL
	BCF	STATUS, C
	RLF	K_ZAP, 0
	GOTO	L98
L97	MOVF	F_REAL, 0
L98	MOVWF	NumL
	CLRF	NumH
	CALL	Convert
	CALL	PRN
	MOVLW	.0			;     /
	MOVWF	I			;    
	MOVF	REZIM, 0
	MOVWF	TEMP1
	CALL	LOAD_ST
	GOTO L6				;   

;****************************************************************************
;   ,     .
GET_TIME
	MOVLW	.1			; 1
	SUBWF	N_STEP, 0		
	BTFSS	STATUS, Z
	GOTO	L48			;  1
	MOVF	Ti3, 0		
	GOTO	L51
L48	MOVF	Ti12, 0		
L51	SUBLW	0xFF			;   
	ADDWF	TIMEA, 1		;    .
	BTFSC	STATUS, C
	GOTO	L52
	RETURN
	;*****
	;      
	;  (  ,   )	
L52	DECFSZ	FR_DOGT, 1	;      
	GOTO	L82			;  
	CLRF	F2H
	COMF	F2H, 1
	BSF	FLAGS, 1	
	MOVLW	.20
	MOVWF	FR_DOGT
	;       
	;  (   )
L82	DECFSZ	T_KEY1, 1
	GOTO	L70
	BCF	FLAGS, 4
	MOVLW	.65
	MOVWF	T_KEY1
	;  ,     
	;  
L70	MOVLW	.1
	SUBWF	TIMER1, 0
	BTFSS	STATUS, C
	GOTO	L84
	DECF	TIMER1, 1
L84	MOVLW	.1
	SUBWF	TIMER2, 0
	BTFSS	STATUS, C
	GOTO	L87
	DECF	TIMER2, 1
	;*****
L87	INCFSZ	TIMEL, 1
	RETURN
	BSF	FLAGS, 0		; TIMEL   3.36
	DECFSZ	WI, 1			;     
	RETURN
	BSF	FLAGS, 5		;   
	MOVLW	.18			;    EEPROM.
	MOVWF	WI
	BTFSS	WTIMEH, 5		;  ,   
	GOTO	L37			; 8192 
	CLRF	WTIMEL
	CLRF	WTIMEH
	RETURN	
L37	INCFSZ	WTIMEL, 1
	RETURN
	INCF	WTIMEH, 1
	RETURN

;*****************************************************************************
;     Ti12, Ti3   
;   ,    K_ZAP
GET_K_ZAP
	BTFSC	FLAGS, 2		; K_ZAP  0  100%, 
	RETURN				; 
	BTFSC	FLAGS, 3
	RETURN

	MOVF	K_ZAP, 0		;     
	MOVWF	EEADR

L90	DECF	EEADR, 1
	BCF	STATUS, C		;K_ZAP <= 50%
	RLF	EEADR, 1

	; 
	CALL	CONST_Ti
	MOVWF	Ti12
	INCF	EEADR, 1
	CALL	CONST_Ti
	MOVWF	Ti3
	RETURN
	
;*****************************************************************************
;    HEX16 ( NumL, NumH)   BSD
;( Thou, Hund, Tens, Ones) 
Convert swapf   NumH,w			
        IORLW	B'11110000'		
	movwf   Thou
	addwf   Thou, 1
	addlw   0xE2
	movwf   Hund
     addlw   0x32
     movwf   Ones
     movf    NumH, 0
     andlw   0x0F
     addwf   Hund, 1
     addwf   Hund, 1
     addwf   Ones, 1
     addlw   0xE9
     movwf   Tens
     addwf   Tens, 1
     addwf   Tens, 1
     swapf   NumL, 0
     andlw   0x0F
     addwf   Tens, 1
     addwf   Ones, 1
     rlf     Tens, 1
     rlf     Ones, 1
     comf    Ones, 1
     rlf     Ones, 1
     movf    NumL, 0
     andlw   0x0F
     addwf   Ones, 1
     rlf     Thou, 1
     movlw   0x0A
Lb1: addwf   Ones, 1
     decf    Tens, 1
     btfss   3, 0
     goto   Lb1
Lb2: addwf   Tens, 1
     decf    Hund, 1
     btfss   3, 0
     goto   Lb2
Lb3: addwf   Hund, 1
     decf    Thou, 1
     btfss   3, 0
     goto   Lb3
Lb4: addwf   Thou, 1
     btfss   3, 0
     goto   Lb4
	MOVLW	Thou			;  
	MOVWF	FSR
	MOVLW	3
	MOVWF	I
L54	MOVF	F0, 0
	ANDLW	0x0F
	BTFSS	STATUS, Z
	RETURN				;   0
	MOVLW	0x0F
	MOVWF	F0
	INCF	FSR	
	DECFSZ	I
	GOTO	L54
        RETURN

;****************************************************************************
;    BCD-   ( Thou, Hund,  
; Tens, Ones)      3, 4, 5, 6
PRN2	MOVLW	Hund
	MOVWF	FSR
	MOVLW	3
	MOVWF	I
L4	INCF	I
	MOVF	F0, 0			;  
	MOVWF	TEMP1
	MOVLW	0x0F
	SUBWF	TEMP1, 0
	BTFSS	STATUS, Z
	CALL	LOAD_ST
	MOVLW	.6		
	SUBWF	I, 0
	BTFSC	STATUS, Z
	RETURN
	INCF	FSR			;  
	GOTO	L4
	RETURN

;    BCD-   ( Thou, Hund,
; Tens, Ones)      0, 1, 2
PRN	MOVLW	Thou
	MOVWF	FSR
	MOVLW	0
	MOVWF	I
L56	MOVF	F0, 0			;  
	MOVWF	TEMP1
	MOVLW	0x0F
	SUBWF	TEMP1, 0
	BTFSS	STATUS, Z
	CALL	LOAD_ST
	INCF	I
	MOVLW	.4		
	SUBWF	I, 0
	BTFSC	STATUS, Z
	RETURN
	INCF	FSR			;  
	GOTO	L56
	RETURN

;     ,   TEMP1: 
;0-3 -  , I-   0  6
LOAD_ST	MOVLW	B'00001111'	; ,
	MOVWF	PORTA			; 5
	ANDWF	TEMP1, 1		;    TEMP1
	BTFSC	STATUS, Z		; TEMP1  0
	GOTO	L1			;,  0
	BCF	PORTA, R_ST
	NOP
L2	BSF	PORTA, C_ST		;   TEMP1  5
	NOP
	BCF	PORTA, C_ST
	DECFSZ	TEMP1
	GOTO	L2
L1	MOVF	I, 0			; 
	MOVWF	PORTA
	;  ,    F_REAL   K_ZAP
	CALL	STABIL		 
	RETURN

;****************************************************************************
;         
; K_ZAP                  
STABIL	MOVLW	.200
	MOVWF	J
L76	BTFSS	FLAGS, 1
	GOTO	L83			;F_REAL  
	BCF	INTCON, GIE		; 
	MOVF	F2L, 0
	MOVWF	NumL
	MOVF	F2H, 0
	MOVWF	NumH
	BSF	INTCON, GIE		; 
	CLRF	F_REAL
	MOVLW	0x09			; 15625    	
	MOVWF	TEMP1
	MOVLW	0x3D
	MOVWF	J
L79	MOVF	NumL, 0
	SUBWF	TEMP1, 1
	BTFSC	STATUS, C		;  
	GOTO	L81			; , 
	MOVLW	.1
	SUBWF	J, 1
	BTFSC	STATUS, C		;  
	GOTO	L81			;  , 
	MOVF	NumH, 0
	SUBWF	J, 1
	GOTO	L78	
L81	MOVF	NumH, 0
	SUBWF	J, 1
	BTFSS	STATUS, C		;  
	GOTO	L78			; 
	INCF	F_REAL, 1
	GOTO	L79
L78	MOVF	NumL, 0			;   
	ADDWF	TEMP1, 1		;   
	BTFSS	STATUS, C
	INCF	J, 1
	MOVF	NumH, 0
	ADDWF	J, 1
	BCF	STATUS, C		;   2
	RRF	NumH, 1
	RRF	NumL, 1
	MOVF	NumL, 0			;   
	SUBWF	TEMP1, 0
	BTFSC	STATUS, C
	GOTO	L74
	MOVLW	.1
	SUBWF	J, 1
	BTFSS	STATUS, C
	GOTO	L77
L74	MOVF	NumH, 0
	SUBWF	J, 1
	BTFSC	STATUS, C
	INCF	F_REAL, 1		;   
L77	MOVF	F_REAL, 0		; F_REAL  5
	BCF	STATUS, C
	RLF	F_REAL, 1
	BCF	STATUS, C
	RLF	F_REAL, 1
	ADDWF	F_REAL, 1

	;    
	BTFSS	FLAGS, 2	
	BCF	PORTB, 6		; ,  K_ZAP > 0
	BTFSS	FLAGS, 2	
	GOTO	L99			;K_ZAP > 0
	MOVF	F_REAL, 0
	SUBWF	KF_ZAD, 0
	BTFSS	STATUS, C
	BSF	PORTB, 6		; ,  F_REAL > KF_ZAD
	BTFSC	STATUS, C
	BCF	PORTB, 6		; ,  F_REAL < KF_ZAD

L99	BTFSC	FLAGS, 7	
	GOTO	L55			;  
	MOVF	KF_ZAD, 0		;  
	MOVWF	K_ZAP			;   
	BCF	FLAGS, 2		;    
	BCF	FLAGS, 3
	MOVF	K_ZAP, 1
	BTFSC	STATUS, Z
	BSF	FLAGS, 2		; ,  K_ZAP=0%
	MOVLW	.100
	SUBWF	K_ZAP, 0
	BTFSC	STATUS, Z
	BSF	FLAGS, 3		; , K_ZAP=100%
	BCF	STATUS, C		; K_ZAP  2,     
	RRF	K_ZAP, 1		;    
	CALL	GET_K_ZAP
	BCF	FLAGS, 1		;   0,   F_REAL
	RETURN

	;***  K_ZAP     ***
	;***                  ***
L55	MOVF	F_REAL, 0		;    
	SUBWF	KF_ZAD, 0
	BTFSC	STATUS, Z
	GOTO	L85			; ,  K_ZAP  
	BTFSS	STATUS, C
	GOTO	L86			;, F_REAL > KF_ZAD
	MOVWF	TEMP1			;F_REAL < KF_ZAD
	MOVLW	.1			;      
	MOVWF	J			;     
	MOVLW	.15			; K_ZAP
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	CLRF	TIMER1
	MOVLW	.25
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	RLF	J, 1
	MOVLW	.40
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	RLF	J, 1
	MOVLW	.1			;   
	SUBWF	TIMER1, 0		; K_ZAP     
	BTFSC	STATUS, C		;  
	GOTO	L85
	MOVLW	.50
	MOVWF	TIMER1
	BCF	STATUS, C
	RRF	TIMER2, 1	
L88	BTFSC	FLAGS, 3		; F_REAL < KF_ZAD
	GOTO	L85			;K_ZAP    100%
	INCF	K_ZAP, 1		; K_ZAP  2.5%
	BCF	FLAGS, 2		; ,   K_ZAP=0%
	MOVLW	.50			; K_ZAP  100%,
	SUBWF	K_ZAP, 0		; 
	BTFSC	STATUS, Z
	BSF	FLAGS, 3
	CALL	GET_K_ZAP
	DECFSZ	J, 1
	GOTO	L88
	GOTO	L85

L86	MOVF	KF_ZAD, 0		;F_REAL > KF_ZAD
	SUBWF	F_REAL, 0
	MOVWF	TEMP1			;      
	MOVLW	.1			;     
	MOVWF	J			; K_ZAP
	MOVLW	.15
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	CLRF	TIMER2
	MOVLW	.25
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	RLF	J, 1
	MOVLW	.40
	MOVWF	NumL
	MOVF	TEMP1, 0
	SUBWF	NumL, 0
	BTFSS	STATUS, C
	RLF	J, 1
	MOVLW	.1			;   
	SUBWF	TIMER2, 0		; K_ZAP    
	BTFSC	STATUS, C		;  
	GOTO	L85
	MOVLW	.50
	MOVWF	TIMER2
	BCF	STATUS, C
	RRF	TIMER1, 1	
L91	BTFSC	FLAGS, 2
	GOTO	L85			;K_ZAP    0%
	DECF	K_ZAP, 1		; K_ZAP  2.5%
	BTFSC	STATUS, Z		; K_ZAP  0%,
	BSF	FLAGS, 2		; 
	BCF	FLAGS, 3		; ,   K_ZAP=100%
	CALL	GET_K_ZAP
	DECFSZ	J, 1
	GOTO	L91
L85	BCF	FLAGS, 1		;   1,    F_REAL
	RETURN
L83	DECFSZ	J			;  ,   
	GOTO	L76			;  
	RETURN

;*****************************************************************************
;    WTIMEL, WTIMEH 
;   
SEEPROM	MOVLW	.50
	MOVWF	EEADR
	MOVF	WTIMEL, 0
	CALL	L21
	MOVF	WTIMEH, 0
	CALL	L21
	MOVF	REZIM, 0
	CALL	L21
	RETURN
L21	MOVWF	EEDATA			;  EEROM
	BCF	INTCON, GIE		;  
	BSF     STATUS, RP0		;   1 
	BSF	EECON1, WREN		;   EEROM
	MOVLW	0x55			;    
	MOVWF	EECON2
	MOVLW	0xAA
	MOVWF	EECON2
	BSF	EECON1, WR
L20	NOP				;  
	BTFSC	EECON1, WR
	GOTO	L20
	BCF	EECON1, WREN		;   EEROM
	BCF     STATUS, RP0		;   0
	BSF	INTCON, GIE		;  
	INCF	EEADR, 1
	RETURN

;    WTIMEL, WTIMEH
;   
LEEPROM	MOVLW	.50
	MOVWF	EEADR	
	CALL	RROM
	MOVWF	WTIMEL
	CALL	RROM
	MOVWF	WTIMEH
	CALL	RROM
	MOVWF	REZIM
	RETURN
	;    EEROM

RROM	BSF     STATUS, RP0		;   1 
	BSF	EECON1, RD		;   EEROM	
	BCF     STATUS, RP0		;   0
	INCF	EEADR, 1
	MOVF	EEDATA, 0
	RETURN

CONST_Ti				;   Ti12  Ti3    K_ZAP
	MOVLW	.2
	MOVWF	PCLATH
	MOVF	EEADR, 0
	ADDWF	PCL, 1
        
        RETLW    .248        ; 2%
        RETLW    .1          ; 2%
        RETLW    .247        ; 4%
        RETLW    .80         ; 4%
        RETLW    .247        ; 6%
        RETLW    .141        ; 6%
        RETLW    .247        ; 8%
        RETLW    .171        ; 8%
        RETLW    .247        ; 10%
        RETLW    .190        ; 10%
        RETLW    .247        ; 12%
        RETLW    .202        ; 12%
        RETLW    .246        ; 14%
        RETLW    .211        ; 14%
        RETLW    .246        ; 16%
        RETLW    .218        ; 16%
        RETLW    .246        ; 18%
        RETLW    .223        ; 18%
        RETLW    .246        ; 20%
        RETLW    .228        ; 20%
        RETLW    .246        ; 22%
        RETLW    .231        ; 22%
        RETLW    .245        ; 24%
        RETLW    .234        ; 24%
        RETLW    .245        ; 26%
        RETLW    .237        ; 26%
        RETLW    .245        ; 28%
        RETLW    .239        ; 28%
        RETLW    .245        ; 30%
        RETLW    .241        ; 30%
        RETLW    .244        ; 32%
        RETLW    .243        ; 32%
        RETLW    .244        ; 34%
        RETLW    .245        ; 34%
        RETLW    .244        ; 36%
        RETLW    .246        ; 36%
        RETLW    .243        ; 38%
        RETLW    .248        ; 38%
        RETLW    .243        ; 40%
        RETLW    .249        ; 40%
        RETLW    .242        ; 42%
        RETLW    .250        ; 42%
        RETLW    .242        ; 44%
        RETLW    .251        ; 44%
        RETLW    .241        ; 46%
        RETLW    .253        ; 46%
        RETLW    .241        ; 48%
        RETLW    .254        ; 48%
        RETLW    .240        ; 50%
        RETLW    .255        ; 50%
        RETLW    .241        ; 52%
        RETLW    .254        ; 52%
        RETLW    .241        ; 54%
        RETLW    .253        ; 54%
        RETLW    .242        ; 56%
        RETLW    .251        ; 56%
        RETLW    .242        ; 58%
        RETLW    .250        ; 58%
        RETLW    .243        ; 60%
        RETLW    .249        ; 60%
        RETLW    .243        ; 62%
        RETLW    .248        ; 62%
        RETLW    .244        ; 64%
        RETLW    .246        ; 64%
        RETLW    .244        ; 66%
        RETLW    .245        ; 66%
        RETLW    .244        ; 68%
        RETLW    .243        ; 68%
        RETLW    .245        ; 70%
        RETLW    .241        ; 70%
        RETLW    .245        ; 72%
        RETLW    .239        ; 72%
        RETLW    .245        ; 74%
        RETLW    .237        ; 74%
        RETLW    .245        ; 76%
        RETLW    .234        ; 76%
        RETLW    .246        ; 78%
        RETLW    .231        ; 78%
        RETLW    .246        ; 80%
        RETLW    .228        ; 80%
        RETLW    .246        ; 82%
        RETLW    .223        ; 82%
        RETLW    .246        ; 84%
        RETLW    .218        ; 84%
        RETLW    .246        ; 86%
        RETLW    .211        ; 86%
        RETLW    .247        ; 88%
        RETLW    .202        ; 88%
        RETLW    .247        ; 90%
        RETLW    .190        ; 90%
        RETLW    .247        ; 92%
        RETLW    .171        ; 92%
        RETLW    .247        ; 94%
        RETLW    .141        ; 94%
        RETLW    .247        ; 96%
        RETLW    .80         ; 96%
        RETLW    .248        ; 98%
        RETLW    .1          ; 98%

	END					; .
