 //вывод картинок на дисплеи
#include <Adafruit_GFX.h>
#include <Adafruit_ST7735.h>
#include <SPI.h>
#include <Wire.h>
#include "Adafruit_SSD1306.h"
#include "ris_0.h"//файл хранения массивов графики

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels
#define OLED_RESET     -1 // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

#define CLK 16 //выводы для энкодера
#define DT 27
#define SW 14

#define TFT_CS     5   //не используется по назначению
#define TFT_RST    13 // (RES)
#define TFT_DC     12 // (RS)
#define TFT_CS1    4   // выводы для коммутации дисплеев
#define TFT_CS2    26
#define TFT_CS3    25
#define TFT_CS4    17
// TFT_SCL 18   
// TFT_SDA 23 
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS,  TFT_DC, TFT_RST);//
#define TFT_SCLK 18   // set these to be whatever pins you like!
#define TFT_MOSI 32   // set these to be whatever pins you like!
//Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_MOSI, TFT_SCLK, TFT_RST);//

int VAL=1;//
int predVAL=1;//
int currentStateCLK;
int lastStateCLK;

byte massiv_model[5][8]={ {0,0,0,0,0,0,0,0},//массив-модель игрового поля
                          {2,1,5,4,8,0,6,8},
                          {1,7,3,7,5,6,5,5},
                          {1,2,3,4,2,4,1,2},
                          {1,2,6,4,3,2,3,3},
};
const struct { 
    const unsigned char *bitmap;
  }
 schar_[]={ris_pusto,ris_schar1,ris_schar2,ris_schar3,ris_schar4,ris_schar5,ris_schar6,ris_schar7,ris_schar8};// картинки шариков 
bool fl_scharik=false;//флаг состояния - все шарики в колбах (false) или шарик вынут (true)
int st=0;//счётчик ходов в игре
int zd=0;//счётчик для смены задания игры при 4 кратной попытке поместить шарик в полную колбу
long Y=0;//переменная хранения моментов времени
int sek=0;//счётчик игровых секунд

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
void zadanie_1(){
//предполагаемый результат выполнения задания виден несколько секунд
st=0;//обнуление счётчика ходов

byte N=millis()%200;// псевдослучайное число
for(int q=0;q<8;q++){  
for(int e=1;e<5;e++){
massiv_model[e][q]=q+1;
}
}    
for(int e=0;e<8;e++){
massiv_model[0][e]=0;
}
massiv_model[1][5]=0;
massiv_model[1][2]=0;
massiv_model[1][3]=0;
massiv_model[1][4]=0;
ris_model();
delay(4000);
//перемешивание шаров в колбах
for(int e=0;e<222+N;e++){
byte str_1=random(2,5);
byte sto_1=random(0,8);
byte c= massiv_model[str_1][sto_1];
byte str_2=random(2,5);
byte sto_2=random(0,8);
 massiv_model[str_1][sto_1] = massiv_model[str_2][sto_2];
 massiv_model[str_2][sto_2]=c;
}
ris_model();
stschet();
sek=0;
} 
////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////
void zadanie_2(){
//предполагаемый результат выполнения задания виден несколько секунд
st=0;//обнуление счётчика ходов

byte N=millis()%200;// псевдослучайное число
for(int q=0;q<8;q++){  
for(int e=1;e<5;e++){
if(q!=7){massiv_model[e][q]=q+1;}
else{massiv_model[e][q]=0;}
}
}    
for(int e=0;e<6;e++){
massiv_model[0][e]=0;
}
ris_model();
delay(4000);
//перемешивание шаров в колбах
for(int e=0;e<222+N;e++){
byte str_1=random(1,5);
byte sto_1=random(0,7);
byte c= massiv_model[str_1][sto_1];
byte str_2=random(1,5);
byte sto_2=random(0,7);
 massiv_model[str_1][sto_1] = massiv_model[str_2][sto_2];
 massiv_model[str_2][sto_2]=c;
}
ris_model();
stschet();
sek=0;
}
//////////////////////////////////////////////////////////////////  
void zadanie_3(){
//предполагаемый результат выполнения задания виден несколько секунд
st=0;//обнуление счётчика ходов

byte N=millis()%200;// псевдослучайное число

for(int q=0;q<8;q++){  
for(int e=1;e<5;e++){
massiv_model[e][q]=q+1;
}
}
massiv_model[1][0]=0;
massiv_model[2][0]=0;
massiv_model[1][7]=0;
massiv_model[2][7]=0;     
for(int e=0;e<8;e++){
massiv_model[0][e]=0;
}
ris_model();

delay(4000);
//перемешивание шаров в колбах
for(int e=0;e<216+N;e++){
byte str_1=random(1,5);
byte sto_1=random(1,7);
byte c= massiv_model[str_1][sto_1];
byte str_2=random(1,5);
byte sto_2=random(1,7);
 massiv_model[str_1][sto_1] = massiv_model[str_2][sto_2];
 massiv_model[str_2][sto_2]=c;
}
for(int e=0;e<216+N;e++){
byte str_1=random(3,5);
byte sto_1=random(0,8);
byte c= massiv_model[str_1][sto_1];
byte str_2=random(3,5);
byte sto_2=random(0,8);
 massiv_model[str_1][sto_1] = massiv_model[str_2][sto_2];
 massiv_model[str_2][sto_2]=c;
}
ris_model();
stschet();
sek=0;
}
/////////////////////////////////////////////////////////        
//массив функций
typedef void (* TFunction)(void);
TFunction massiv_fun[]={zadanie_1,zadanie_2,zadanie_3};
//

void setup() {
 // Устанавливаем контакты энкодера как входы
  pinMode(CLK,INPUT_PULLUP);
  pinMode(DT,INPUT_PULLUP);
  pinMode(SW, INPUT_PULLUP);
  // Считываем начальное состояние CLK
  lastStateCLK = digitalRead(CLK);  
 //
 display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS);//инициализация  
display.clearDisplay();//очистка буфера
//display.invertDisplay(true);//инверсия изображения при выводе
 display.cp437(true);  // Use full 256 char 'Code Page 437' font
 display.setTextSize(1);      // Normal 1:1 pixel scale
 display.setTextColor(SSD1306_WHITE); // Draw white text
 display.setCursor(10, 0);     // Start at top-left corner
 display.print(utf8rus("ИГРА-ШАРИКИ И КОЛБЫ"));
 display.setCursor(0, 30);   
 display.print(utf8rus("ХОД НОМЕР:"));
 display.setCursor(0, 45);   
 display.print(utf8rus("СЕКУНД:"));
 display.display();//вывод на дисплей данных буфера 
  // 
 pinMode(TFT_CS1, OUTPUT);
 pinMode(TFT_CS2, OUTPUT);
 pinMode(TFT_CS3, OUTPUT);
 pinMode(TFT_CS4, OUTPUT);
 on_disp();
  tft.initR(INITR_BLACKTAB);
  tft.setRotation(2);
off_disp();
ris_fon();//отрисовка фонового изображения на всех дисплеях
delay(3000);
zad_N();//выбор задания 
  }
void loop() {
vremia();
enkoder();  
knopki();
delay(2); 
}
/////////////////////////////////////////////////////////////////
void drawFoto(int x,int y, const uint8_t *bitmap,int w,int h) {//функция вывода фотокартинки
if(x<0||x+w>128||y<0||y+h>160){return;}

 tft.setAddrWindow(x,y,x+w-1,y+h-1);
 SPI.beginTransaction(SPISettings(40000000, MSBFIRST, SPI_MODE0));
  digitalWrite(TFT_DC, HIGH);
  digitalWrite(TFT_CS, LOW); 
 for(int j=0; j<h; j++) {
    for(int i=0; i<2*w; i=i+2) {
    SPI.transfer(bitmap[i+1+j*2*w]);SPI.transfer(bitmap[i+j*2*w]);
  // SPI.transfer(pgm_read_byte(bitmap+i+1+j*2*w));SPI.transfer(pgm_read_byte(bitmap+i+j*2*w)); 
  
    }
  }
  digitalWrite(TFT_CS, HIGH);
  SPI.endTransaction();
 ///  
}
///////////////////////////////////////////////////////////////
void on_disp(){//включить приём на все дисплеи
 digitalWrite(TFT_CS1,LOW);
 digitalWrite(TFT_CS2,LOW);
 digitalWrite(TFT_CS3,LOW);
 digitalWrite(TFT_CS4,LOW);  
}
///////////////////////////////////////////////////////////////
void off_disp(){//отключить приём на все дисплеи
digitalWrite(TFT_CS1,HIGH);
 digitalWrite(TFT_CS2,HIGH);
 digitalWrite(TFT_CS3,HIGH);
 digitalWrite(TFT_CS4,HIGH);    
}
///////////////////////////////////////////////////////////////
void ris_scharik(int stroka,int stolbez){// функция отрисовки шарика или пусто-места на игровом поле по его положению в массиве-модели
if(stolbez==0||stolbez==1){digitalWrite(TFT_CS1,LOW);}
if(stolbez==2||stolbez==3){digitalWrite(TFT_CS2,LOW);}
if(stolbez==4||stolbez==5){digitalWrite(TFT_CS3,LOW);}   
if(stolbez==6||stolbez==7){digitalWrite(TFT_CS4,LOW);}
if(stolbez%2==0){drawFoto(15,7+30*stroka,schar_[massiv_model[stroka][stolbez]].bitmap,35,25);}else{drawFoto(15+64,7+30*stroka,schar_[massiv_model[stroka][stolbez]].bitmap,35,25);}
off_disp();
}
//////////////////////////////////////////////////////////
void ris_model(){// функция отрисовки всей модели-массива
for(int i=0;i<5;i++){
  for(int j=0;j<8;j++){
    ris_scharik(i,j);
  }
 }
}
//////////////////////////////////////////////////////////
void ris_scharik(int stroka,int stolbez,byte cvet){// функция отрисовки шарика или пусто-места на игровом поле по значению его цвета
if(stolbez==0||stolbez==1){digitalWrite(TFT_CS1,LOW);}
if(stolbez==2||stolbez==3){digitalWrite(TFT_CS2,LOW);}
if(stolbez==4||stolbez==5){digitalWrite(TFT_CS3,LOW);}   
if(stolbez==6||stolbez==7){digitalWrite(TFT_CS4,LOW);}
if(stolbez%2==0){drawFoto(15,7+30*stroka,schar_[cvet].bitmap,35,25);}else{drawFoto(15+64,7+30*stroka,schar_[cvet].bitmap,35,25);}
off_disp();
}
//////////////////////////////////////////////////////////
void ris_polet_scharik(int stolbez_1,int stolbez_2,byte cvet,int T){//функция анимации полёта шарика из стобца 1 в столбец 2 заданного цвета и скорости
while(stolbez_1!=stolbez_2){
if(stolbez_2>=stolbez_1){
 ris_scharik(0,stolbez_1+1,cvet);ris_scharik(0,stolbez_1,0);delay(T);
 stolbez_1++; 
  } 
 else{
 ris_scharik(0,stolbez_1-1,cvet);ris_scharik(0,stolbez_1,0);delay(T);
 stolbez_1--;    
 }
}
}
//////////////////////////////////////////////////////////
void knopki(){// функция отработки нажатия кнопки - игровая анимация шариков
 if(digitalRead(SW)==LOW){//если нажата кнопка энкодера
for(int w=0;w<8;w++){
 if(VAL==w+1){
//  massiv_model[0][0]=w+1;ris_scharik(0,0);
if(fl_scharik==false){
  for(int k=1;k<5;k++){//ищем и поднимаем шарик из колбы
    if(massiv_model[k][w]!=0){massiv_model[0][w]=massiv_model[k][w];massiv_model[k][w]=0;ris_scharik(0,w);ris_scharik(k,w);fl_scharik=true;st++;stschet();goto metka;}
   }
}
else{
for(int k=0;k<8;k++){
  if(massiv_model[0][k]!=0){//если нашли поднятый над колбой шарик
     for(int s=4;s>0;s--){
    if(massiv_model[s][w]==0){//если в выбранной колбе оказалось место
      if(w!=k){
          massiv_model[0][w]=massiv_model[0][k];massiv_model[0][k]=0; ris_polet_scharik(k,w,massiv_model[0][w],75);
         // massiv_model[0][w]=massiv_model[0][k];massiv_model[0][k]=0;ris_scharik(0,w);ris_scharik(0,k);delay(250);
        }
      massiv_model[s][w]=massiv_model[0][w];massiv_model[0][w]=0;ris_scharik(s,w);ris_scharik(0,w);fl_scharik=false;goto metka;
      }
   }
    for(int s=4;s>0;s--){
    if(massiv_model[s][k]==0){massiv_model[s][k]=massiv_model[0][k];massiv_model[0][k]=0;ris_scharik(s,k);ris_scharik(0,k);fl_scharik=false;zd++;if(zd>3){zad_N();}goto metka;}//возврат шарика в исходную колбу если места в указанной не оказалось   
    }
    
    }
}
}
 }
}
 metka:
 delay(200);
}
// delay(20);   
}
////////////////////////////////////////////////////////// 
void zad_N(){//функция смены задания
zd=0; 

massiv_fun[millis()%(sizeof(massiv_fun)/sizeof(massiv_fun[0]))]();// псевдослучайный выбор задания-уровня
} 
/////////////////////////////////////////////////////////////////
void ris_fon (){
 on_disp();  
// tft.fillScreen(tft.Color565(255,255,255)); 
drawFoto(0,0,ris_kolba,64,160);
drawFoto(64,0,ris_kolba,64,160);
off_disp();
int w=12;int h=107;int d=8;
digitalWrite(TFT_CS1,LOW);
tft.fillRect(1+d,50,w,h,tft.Color565(0,66,255));
tft.fillRect(64+d,50,w,h,tft.Color565(255,0,0));
digitalWrite(TFT_CS1,HIGH);
digitalWrite(TFT_CS2,LOW);
tft.fillRect(1+d,50,w,h,tft.Color565(50,30,20));
tft.fillRect(64+d,50,w,h,tft.Color565(250,200,0));
digitalWrite(TFT_CS2,HIGH);
digitalWrite(TFT_CS3,LOW);
tft.fillRect(1+d,50,w,h,tft.Color565(198,188,176));
tft.fillRect(64+d,50,w,h,tft.Color565(195,1,255));
digitalWrite(TFT_CS3,HIGH);
digitalWrite(TFT_CS4,LOW);
tft.fillRect(1+d,50,w,h,tft.Color565(28,200,22));
tft.fillRect(64+d,50,w,h,tft.Color565(0,193,184));
digitalWrite(TFT_CS4,HIGH);
for(int i=0;i<5;i++){
  for(int j=0;j<8;j++){
    ris_scharik(i,j,0);
  }
 }
}
/////////////////////////////////////////////////////////////////
void stschet(){//функция отображения счёта ходов на дисплее дополнительном
display.setTextSize(2);  
display.setCursor(65, 22);
display.fillRoundRect(65,22,60,20,0,SSD1306_BLACK); 
if(st>999){st=0;}
display.print(st);
display.display();
}
//////////////////////////////////////////////////////////////////
/* Функция перекодировки русских букв из UTF-8 в Win-1251 */
String utf8rus(String source)
{
  int i,k;
  String target;
  unsigned char n;
  char m[2] = { '0', '\0' };

  k = source.length(); i = 0;

  while (i < k) {
    n = source[i]; i++;

    if (n >= 0xC0) {
      switch (n) {
        case 0xD0: {
          n = source[i]; i++;
          if (n == 0x81) { n = 0xA8; break; }
          if (n >= 0x90 && n <= 0xBF) n = n + 0x30;
          break;
        }
        case 0xD1: {
          n = source[i]; i++;
          if (n == 0x91) { n = 0xB8; break; }
          if (n >= 0x80 && n <= 0x8F) n = n + 0x70;
          break;
        }
      }
    }
    m[0] = n; target = target + String(m);
  }
return target;
}
//////////////////////////////////////////////////////
void vremia(){
if(millis()-Y>1000){
Y=millis();sek++;if(sek>999){sek=0;}

display.setTextSize(2); 
display.setCursor(65, 47);
display.fillRoundRect(65,47,60,20,0,SSD1306_BLACK); 
display.print(sek);
display.display();   
}
}
//////////////////////////////////////////////////////
void enkoder(){
currentStateCLK = digitalRead(CLK);
 if (currentStateCLK != lastStateCLK  && currentStateCLK == 0){
  if (digitalRead(DT) != currentStateCLK) { 
 predVAL=VAL;VAL--; if(VAL<1){VAL=1;}   
  }
 else {
 predVAL=VAL;VAL++; if(VAL>8){VAL=8;}
 }
kursor();//
  }
lastStateCLK = currentStateCLK; 
}
//////////////////////////////////////////////////////
void kursor(){
if(predVAL==1||predVAL==2){digitalWrite(TFT_CS1,LOW);}
if(predVAL==3||predVAL==4){digitalWrite(TFT_CS2,LOW);}
if(predVAL==5||predVAL==6){digitalWrite(TFT_CS3,LOW);}   
if(predVAL==7||predVAL==8){digitalWrite(TFT_CS4,LOW);}
if((predVAL-1)%2==0){tft.fillRect(0,0,14,14,tft.Color565(255,255,255));}else{tft.fillRect(0+64,0,14,14,tft.Color565(255,255,255));}
off_disp(); 
if(VAL==1||VAL==2){digitalWrite(TFT_CS1,LOW);}
if(VAL==3||VAL==4){digitalWrite(TFT_CS2,LOW);}
if(VAL==5||VAL==6){digitalWrite(TFT_CS3,LOW);}   
if(VAL==7||VAL==8){digitalWrite(TFT_CS4,LOW);}
if((VAL-1)%2==0){tft.fillRect(0,0,14,14,tft.Color565(255,0,0));}else{tft.fillRect(0+64,0,14,14,tft.Color565(255,0,0));}
off_disp(); 
}
//////////////////////////////////////////////////////
