//--Переменные настройки частоты STM32G431.-------------------------//
uint16_t PLLM =   4;                                                // Задает делитель PLLM (1 - 16)
uint16_t PLLN =  40;                                                // Задает множитель PLLN (8 - 127)
uint16_t PLLR =   2;                                                // Задает делитель PLLR (2,4,6,8)
//------------------------------------------------------------------//
void setup()                                                        //
{                                                                   //
  //--Настройка тактирования.---------------------------------------//
  SystemClock_Config();                                             // Настройка частот тактового генератора
  //---Включение тактирования.--------------------------------------//
  __HAL_RCC_GPIOA_CLK_ENABLE();                                     // Включение тактирования порта A (GPIOA)
  GPIO_InitTypeDef GPIO_InitStruct;                                 // Создание структуры для хранения параметров настройки GPIO
  //---Настройка PA8 (MCO) как выход.-------------------------------//
  GPIO_InitStruct.Pin = GPIO_PIN_8;                                 // Выбор пина PA8
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;                           // Настройка режима пина как "Альтернативная функция"
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;                // Установка скорости пина на 80 мГц
  GPIO_InitStruct.Alternate = GPIO_AF0_MCO;                         // Выбор альтернативной функции AF0 для MCO
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);                           // Применение настроек к порту GPIOA
  //----------------------------------------------------------------//
  pinMode(PC6, OUTPUT);                                             // Настройка вывода PC6 как выход
}                                                                   //
//------------------------------------------------------------------//
void loop()                                                         //
{                                                                   //
  digitalWrite(PC6, HIGH);delay( 33);                               //
  digitalWrite(PC6,  LOW);delay(333);                               //
}                                                                   //
//---Объявление функции для настройки тактирования.-----------------//
extern "C" void SystemClock_Config(void)                            //
{                                                                   //
  //---1.Инициализация структур.------------------------------------//
  RCC_OscInitTypeDef RCC_OscInitStruct;                             // Создание структуры для настройки осциллятора
  RCC_ClkInitTypeDef RCC_ClkInitStruct;                             // Создание структуры для настройки тактовых частот системных шин
  //---2.Настройка HSE Oscillator.----------------------------------//
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;        // Устанавливает тип осциллятора как HSE
  RCC_OscInitStruct.HSEState       = RCC_HSE_ON;                    // Включает внешний генератор HSE
  RCC_OscInitStruct.PLL.PLLState   = RCC_PLL_ON;                    // Включает PLL
  RCC_OscInitStruct.PLL.PLLSource  = RCC_PLLSOURCE_HSE;             // Устанавливает источник PLL как HSE
  RCC_OscInitStruct.PLL.PLLM       = PLLM;                          // Устанавливает делитель PLLM
  RCC_OscInitStruct.PLL.PLLN       = PLLN;                          // Устанавливает множитель PLLN
  RCC_OscInitStruct.PLL.PLLR       = PLLR;                          // Устанавливает делитель PLLR
  RCC_OscInitStruct.PLL.PLLQ       = RCC_PLLQ_DIV2;                 // Устанавливает делитель PLLQ = 2
  RCC_OscInitStruct.PLL.PLLP       = RCC_PLLP_DIV2;                 // Устанавливает делитель PLLP = 2
  //---3.Инициализация тактовой системы.----------------------------//
  HAL_RCC_OscConfig(&RCC_OscInitStruct);                            // Применяет настройки осциллятора и PLL
  //---4.Настройка тактовых частот системных шин.-------------------//
  RCC_ClkInitStruct.ClockType      = RCC_CLOCKTYPE_SYSCLK |         // Выбирает тип тактирования (системная шина)
                                     RCC_CLOCKTYPE_HCLK   |         // Тактовая шина AHB
                                     RCC_CLOCKTYPE_PCLK1  |         // Тактовая шина APB1
                                     RCC_CLOCKTYPE_PCLK2;           // Тактовая шина APB2
  RCC_ClkInitStruct.SYSCLKSource   = RCC_SYSCLKSOURCE_PLLCLK;       // Устанавливает источник SYSCLK как PLL
  RCC_ClkInitStruct.AHBCLKDivider  = RCC_SYSCLK_DIV1;               // Устанавливает делитель AHB  = 1
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;                 // Устанавливает делитель APB1 = 1
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;                 // Устанавливает делитель APB2 = 1
  //---5.Финальная конфигурация тактовой системы.-------------------//
  HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5);         // Применяет настройки и задает задержку-flash (5 тактов)
  HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_SYSCLK, RCC_MCODIV_1); // Вывод системной частоты на MCO, деленной на 1 выв (PA8)
}                                                                   //
//------------------------------------------------------------------//