
#include <EEPROM.h>
#include <OneWire.h>
#include <Wire.h>                                     // Required for I2C communication
#include <MsTimer2.h>
#include <UTFT.h>
#include <URTouch.h>
#include <SPI.h>                                      // Подключаем библиотеку  для работы с шиной SPI
#include <Adafruit_BMP280.h>
#include <AHT20.h>
#include <DS3231.h>
#include <SoftwareSerial.h>
#include <DFPlayerMini_Fast.h>

const byte Versiya[]  = {15, 8, 25};
/*-----------------------------------------------------------------------------------------------------*/
SoftwareSerial mySerial(10, 11);                        // RX, TX
DFPlayerMini_Fast MP3;

int  Vol[]          = {10, 25, 0};
int  EQ             = 1;
/*-----------------------------------------------------------------------------------------------------*/
AHT20 Aht20;
float Cels_Aht, Hum_Aht;

Adafruit_BMP280 Bmp;                                  // I2C
float Cels_Bmp, Press_Bmp, Alt_Bmp;
/*-----------------------------------------------------------------------------------------------------*/
#define RS    38
#define WR    39
#define CS    40
#define RST   41

UTFT Display(CTE70, RS, WR, CS, RST);

#define T_CLK   6
#define T_CS    5
#define T_MOSI  4
#define T_MISO  3
#define T_IRQ   2

URTouch myTouch(T_CLK, T_CS, T_MOSI, T_MISO, T_IRQ);    /*  ТЫ НЕ ЗАБЫЛ ОТКАЛИБРОВАТЬ ТАЧСКРИН  URTouchCD.h  */

int X_T, Y_T, Z_T;
int dispx, dispy, text_y_center;
/*-----------------------------------------------------------------------------------------------------*/
extern uint8_t Arial_Rus_16x24[];
extern uint8_t Arial_round_16x24[];                   // 95 символов 16x24
extern uint8_t Arial_Rus_24x32[];                     // 95 символов 24x32
extern uint8_t Point_16x180[];                        // Двоеточие и точки
extern uint8_t Big_Digit_112x180_Num[];               // 10 цифровых символов 112×180
extern uint8_t Big_Space_112x180_Num[];               // Пробел 112×180

const uint8_t utf8_rus_charmap[] PROGMEM = {'A',128,'B',129,130,'E',131,132,133,134,135,'K',136,'M','H','O',137,'P','C','T',138,139,'X',140,141,
142,143,144,145,146,147,148,149,'a',150,151,152,153,'e',154,155,156,157,158,159,160,161,162,'o',163,'p','c',164,'y',165,'x',166,167,168,169,170,
171,172,173,174,175};

int  Color[]      = {VGA_NAVY, VGA_WHITE, VGA_AQUA, VGA_BLUE, VGA_RED, VGA_YELLOW, VGA_GREEN, VGA_BLACK};
byte Set_Color    = 1;
byte Color_Set    = 1;
byte Setup_Color  = 0;
byte Select_Color = 0;
byte Day_Fon      = 0;
byte Day_Digit    = 1;
byte Night_Fon    = 7;
byte Night_Digit  = 1;
byte Num_Color    = 7;
byte Flag_Point   = 0;
byte Day          = 0;
byte Night        = 7;
byte Fon          = 0;
byte Digit        = 7;
byte Celsio_Pres  = 0;
byte D_N          = 0;
byte Ind          = 0;

byte Adress       = 9;
byte Data_Temp[10];

unsigned long Time_P      = 0;
unsigned long Timenext_P  = 0;
unsigned long Time_M      = 0;
unsigned long Timenext_M  = 0;
/*-----------------------------------------------------------------------------------------------------*/
DS3231 Clock;                                           // 0x57 0x68

bool h12 = false;                                       // True is 12-h, false is 24-hour.;
bool PM;
bool Century = false;
float Cels_Ds;

byte Year[]               = {25, 0}; 
byte Month[]              = {7, 0}; 
byte Date[]               = {12, 0}; 
byte Day_Week[]           = {1, 0};
int  Hour[]               = {0, 0, 0, 0, 0, 0};
int  Minute[]             = {0, 0, 0, 0, 0, 0};
byte Second[]             = {0, 0, 0, 0, 0, 0};
byte Hour_Signal[]        = {0, 0};
byte Hour_Bell[]          = {0, 0, 0, 0, 0, 0};
byte Minute_Bell[]        = {0, 0, 0, 0, 0, 0};
byte Setup_Bell           = 0;
byte Bell_ON              = 0;
byte On_Bell              = 0;
byte Select_Time[]        = {0, 0};
byte Save_Time            = 0;

int  Sec[]                = {0, 0};
byte Flag_Clock[]         = {1, 1};
byte Zero                 = 0;
byte Voice                = 0;
byte Kuranty              = 0;

byte Cnt_C = 0;
/*-----------------------------------------------------------------------------------------------------*/
int  X_Point_1 = 265, Y_Point_1 = 150;                                                // Координаты Точек
int  X_Point_2 = 525, Y_Point_2 = 150;                                                // Координаты Точек

int  X_Cels = 17,  Y_Cels = 425;                                                      // Координаты Температуры
int  X_Hum  = 200, Y_Hum  = 425;                                                      // Координаты Влажности
int  X_Alt  = 360, Y_Alt  = 425;                                                      // Координаты Высоты
int  X_Pres = 530, Y_Pres = 425;                                                      // Координаты Давления

int  X_Date  = 545, Y_Date  = 25;                                                     // Координаты даты
int  X_Month = 597, Y_Month = 25;                                                     // Координаты месяца
int  X_Year  = 663, Y_Year  = 25;                                                     // Координаты года
int  X_Week  = 17,  Y_Week  = 25;                                                     // Координаты недели
int  X_Hour1 =  30, Y_Hour1 = 200;                                                    // Координаты часов
int  X_Hour2 = 140, Y_Hour2 = 200;                                                    // Координаты часов
int  X_Minute1 = 290, Y_Minute1 = 200;                                                // Координаты минут
int  X_Minute2 = 400, Y_Minute2 = 200;                                                // Координаты минут
int  X_Second1 = 550, Y_Second1 = 200;                                                // Координаты секунд
int  X_Second2 = 660, Y_Second2 = 200;                                                // Координаты секунд

int  X_Data   = 535,  Y_Data   = 7,   Xe_Data   = 795, Ye_Data   = 70;                // Рамка Дата
int  X_Wek    = 1,    Y_Wek    = 7,   Xe_Wek    = 295, Ye_Wek    = 70;                // Рамка Неделя
int  X_Clock  = 1,   Y_Clock  = 110, Xe_Clock  = 795, Ye_Clock  = 360;                // Рамка часов
int  X_Celsio = 1,   Y_Celsio = 410, Xe_Celsio = 150, Ye_Celsio = 470;                // Рамка Teмпературы
int  X_Hum_P  = 175, Y_Hum_P  = 410, Xe_Hum_P  = 325, Ye_Hum_P  = 470;                // Рамка Влажности
int  X_Alty   = 350,   Y_Alty = 410, Xe_Alty   = 490, Ye_Alty   = 470;                // Рамка Высоты
int  X_Press  = 515, Y_Press  = 410, Xe_Press  = 665, Ye_Press  = 470;                // Рамка Давления
int  X_Set    = 690, Y_Set    = 410, Xe_Set    = 795, Ye_Set    = 470;                // Рамка кнопки SET
int  X_Vol    = 325, Y_Vol    = 7,   Xe_Vol    = 505, Ye_Vol    = 70;                 // Рамка Громкости

int  X_NAVY = 1, Y_NAVY = 100, Xe_NAVY = X_NAVY + 90, Ye_NAVY = Y_NAVY + 46;          // Рамка кнопки NAVY
int  X_WHITE = 126, Y_WHITE = 100, Xe_WHITE = X_WHITE + 90, Ye_WHITE = Y_WHITE + 46;  // Рамка кнопки WHITE
int  X_AQUA = 256, Y_AQUA = 100, Xe_AQUA = X_AQUA + 90, Ye_AQUA = Y_AQUA + 46;        // Рамка кнопки AQUA
int  X_BLUE = 386, Y_BLUE = 100, Xe_BLUE = X_BLUE + 90, Ye_BLUE = Y_BLUE + 46;        // Рамка кнопки BLUE
int  X_RED = 1, Y_RED = 175, Xe_RED = X_RED + 90, Ye_RED = Y_RED + 46;                // Рамка кнопки NAVY
int  X_YELL = 126, Y_YELL = 175, Xe_YELL = X_YELL + 90, Ye_YELL = Y_YELL + 46;        // Рамка кнопки WHITE
int  X_GREEN = 256, Y_GREEN = 175, Xe_GREEN = X_GREEN + 90, Ye_GREEN = Y_GREEN + 46;  // Рамка кнопки AQUA
int  X_BLACK = 386, Y_BLACK = 175, Xe_BLACK = X_BLACK + 90, Ye_BLACK = Y_BLACK + 46;  // Рамка кнопки BLUE

int  X_Day = 1, Y_Day = 20, Xe_Day = X_Day + 90, Ye_Day = Y_Day + 46;                 // Рамка кнопки Day
int  X_Night = 126, Y_Night = 20, Xe_Night = X_Night + 140, Ye_Night = Y_Night + 46;  // Рамка кнопки Night
int  X_Fon = 1, Y_Fon = 245, Xe_Fon = X_Fon + 90, Ye_Fon = Y_Fon + 46;                // Рамка кнопки Fon
int  X_Digit = 126, Y_Digit = 245, Xe_Digit = X_Digit + 140, Ye_Digit = Y_Digit + 46; // Рамка кнопки Digit
int  X_Exit = 360, Y_Exit = 20, Xe_Exit = X_Exit + 115, Ye_Exit = Y_Exit + 46;        // Рамка кнопки Exit
int  X_Save = 360, Y_Save = 245, Xe_Save = X_Save + 115, Ye_Save = Y_Save + 46;       // Рамка кнопки Save

int  X_Bell = 265, Y_Bell = 160, Xe_Bell = X_Bell + 25, Ye_Bell = Y_Bell + 160;       // Кнопка Будильника
/*-----------------------------------------------------------------------------------------------------*/
byte Frame_Set      = 0;
byte Temp;
/*=======================================================================================================
                                              Чтение EEPROM
=======================================================================================================*/
void EEPROM_Read()
{
  for (int v = 0; v <= Adress; v++)
  {
    Data_Temp[v] = EEPROM.read(v);                            // Cчитываем значение по текущему адресу EEPROM
    Serial.print(" : "); Serial.print(v); Serial.print(" = "); Serial.print(Data_Temp[v]);
  }
  Serial.println("   <<  READ  >>  ");

  Voice = Data_Temp[9];
  Vol[1]          = Data_Temp[7]; Vol[0]         = Data_Temp[8];
  Day_Fon         = Data_Temp[1]; Day_Digit      = Data_Temp[2];
  Night_Fon       = Data_Temp[3]; Night_Digit    = Data_Temp[4];
  Hour_Bell[0]    = Data_Temp[5]; Minute_Bell[0] = Data_Temp[6];
  Hour_Bell[5]    = Data_Temp[5]; Minute_Bell[5] = Data_Temp[6];
  Hour_Bell[1]    = Hour_Bell[0] / 10;
  Hour_Bell[2]    = Hour_Bell[0] - (Hour_Bell[1] * 10);
  Minute_Bell[1]  = Minute_Bell[0] / 10;
  Minute_Bell[2]  = Minute_Bell[0] - (Minute_Bell[1] * 10);
}
/*=======================================================================================================
                                              Запись EEPROM
=======================================================================================================*/
void EEPROM_Write()
{
  Hour_Bell[0]   = Hour_Bell[2] + (Hour_Bell[1] * 10);
  Minute_Bell[0] = Minute_Bell[2] + (Minute_Bell[1] * 10);
  Data_Temp[1]   = Day_Fon;      Data_Temp[2] = Day_Digit;
  Data_Temp[3]   = Night_Fon;    Data_Temp[4] = Night_Digit;
  Data_Temp[5]   = Hour_Bell[0]; Data_Temp[6] = Minute_Bell[0];
  Data_Temp[7]   = Vol[1];       Data_Temp[8] = Vol[0];
  Data_Temp[9]   = Voice;

  for (int c = 0; c <= Adress; c++)
  {
    EEPROM.write(c, Data_Temp[c]);
  }
  Serial.println("  <<  WRITE  >>  ");
}
/*=======================================================================================================
                                              Touch_Screen
=======================================================================================================*/
void  Touch_Screen() 
{
  X_T = -1; Y_T = -1;
  if (myTouch.dataAvailable())
  {
    myTouch.read(); X_T = myTouch.getX(); Y_T = myTouch.getY();
     
    if (Bell_ON == 1) {MP3.play(14); delay(500); Bell_ON = 0; On_Bell = 0;}
    Buttons();
  }
}
/*=======================================================================================================
                                            Инициализация
=======================================================================================================*/
void setup()
{  
  Serial.begin(115200);
  mySerial.begin(9600);
  Wire.begin();
  
  Serial.println(F(" "));
  if (!MP3.begin(mySerial))
  {
    Serial.println(F("    Unable to begin:"));
    Serial.println(F(" 1. Please recheck the connection!"));
    Serial.println(F(" 2. Please insert the SD card!"));
  }
  else Serial.println(F(" << DFPlayer MINI on_LINE >> "));
/*-----------------------------------------------------------------------------------------------------*/
  Bmp.begin();
  Bmp.setSampling (Adafruit_BMP280::MODE_NORMAL,                  /* Operating Mode */
                   Adafruit_BMP280::SAMPLING_X2,                  /* Temp. oversampling */
                   Adafruit_BMP280::SAMPLING_X16,                 /* Pressure oversampling */
                   Adafruit_BMP280::FILTER_X16,                   /* Filtering */
                   Adafruit_BMP280::STANDBY_MS_500);              /* Standby time */
  Aht20.begin();
/*-----------------------------------------------------------------------------------------------------*/
  Display.InitLCD(1);
  Display.clrScr();
  
  myTouch.InitTouch();                                  // Инициализируем ТачСкрин
  myTouch.setPrecision(PREC_MEDIUM);

  dispx = Display.getDisplayXSize();
  dispy = Display.getDisplayYSize();
  Serial.print(" :  Disp_X = "); Serial.print(dispx);
  Serial.print(" :  Disp_Y = "); Serial.println(dispy);

  Display.fillScr(VGA_NAVY);                            // Очистка экрана с заливкой заданным цветом
  Display.setColor(VGA_WHITE);
  Display.setBackColor(VGA_NAVY);                       // Выбор цвета для фона текста
  Display.fillScr(VGA_NAVY);                            // Очистка экрана с заливкой заданным цветом
/*-----------------------------------------------------------------------------------------------------*/
//  EEPROM_Write(); 
  EEPROM_Read();  
  Read_Clock();
  if (((Hour[0] >= 0) && (Hour[0] <= 6))) Zero = 0; else Zero = 1;
  if (Hour[0] >= 21) Zero = 0;
  D_N = Zero;
  Day_Night();
/*-----------------------------------------------------------------------------------------------------*/
  MP3.setTimeout(500);
  MP3.standbyMode();    delay(200);
  MP3.normalMode();     delay(200);
  MP3.volume(Vol[D_N]); delay(200);
  MP3.EQSelect(EQ);     delay(200);

  Serial.print(" Vol = ");  Serial.print(MP3.currentVolume());
  Serial.print(" : EQ = "); Serial.print(MP3.currentEQ());
  Serial.print(" : Mode = ");  Serial.print(MP3.currentMode());
  Serial.print(" : Version = "); Serial.print(MP3.currentVersion());
  Serial.print(" : Все треки = "); Serial.print(MP3.numSdTracks());
  Serial.print(" : Play = "); Serial.println(MP3.currentSdTrack());
/*-----------------------------------------------------------------------------------------------------*/
  MsTimer2::set(100, Timer_2_ISR);                        // задаем период прерывания по таймеру 100 мс
  MsTimer2::start();                                      // разрешаем прерывание по таймеру
}
/*=======================================================================================================
                                              Главный цикл
=======================================================================================================*/
void loop()
{
  if (Setup_Color == 0)
  {
    if (Sec[1] >= 10)
    {
      Sec[1] = 0;
      Cels_Aht  = Aht20.getTemperature();
      Hum_Aht   = Aht20.getHumidity();
      Cels_Bmp  = Bmp.readTemperature();
      Press_Bmp = Bmp.readPressure() / 133.322;                       // Пересчитываем давления в мм ртутного столба.
      Alt_Bmp   = Bmp.readAltitude(1013.25);
      Cels_Ds   = Clock.getTemperature();
/*-----------------------------------------------------------------------------------------------------*/
      switch (Celsio_Pres)
      {
        case 0: 
                Display.setFont(Arial_round_16x24);                           // Устанавливаем шрифт
                Display.print("CELS-AHT", X_Celsio + 15, Y_Celsio - 30); 
                Display.setFont(Arial_Rus_24x32);                             // Устанавливаем шрифт
                Display.printNumF(Cels_Aht, 1, X_Cels, Y_Cels); Display.print("C", X_Cels + 98, Y_Cels, 0);
        break;
        case 1: 
                Display.setFont(Arial_round_16x24);                           // Устанавливаем шрифт
                Display.print(" CELS-DS ", X_Celsio + 5, Y_Celsio - 30); 
                Display.setFont(Arial_Rus_24x32);                             // Устанавливаем шрифт
                Display.printNumF(Cels_Ds, 1, X_Cels, Y_Cels); Display.print("C", X_Cels + 98, Y_Cels, 0);
        break;
        case 2: 
                Display.setFont(Arial_round_16x24);                           // Устанавливаем шрифт
                Display.print("CELS-BMP", X_Celsio + 15, Y_Celsio - 30); 
                Display.setFont(Arial_Rus_24x32);                             // Устанавливаем шрифт
                Display.printNumF(Cels_Bmp, 1, X_Cels, Y_Cels); Display.print("C", X_Cels + 98, Y_Cels, 0);
        break;
      }
/*-----------------------------------------------------------------------------------------------------*/
      Display.setFont(Arial_Rus_16x24);
      PrintRus(Display, "ВЛАЖНОСТЬ", X_Hum_P + 8, Y_Hum_P - 30, 0);
      PrintRus(Display, "ВЫСОТА", X_Alty + 25, Y_Alty - 30, 0);
      PrintRus(Display, "ДАВЛЕНИЕ", X_Press + 15, Y_Press - 30, 0);
      Display.print("COLOR", X_Set + 15, Y_Set - 30);

      switch (Voice)
      {
        case 0: PrintRus(Display, " ГОЛОС ", X_Vol + 35, Ye_Vol + 10, 0); break;
        case 1: PrintRus(Display, "КУРАНТЫ", X_Vol + 35, Ye_Vol + 10, 0); break;
        case 2: PrintRus(Display, "  ВЫКЛ ", X_Vol + 35, Ye_Vol + 10, 0); break;
      }
/*-----------------------------------------------------------------------------------------------------*/
      if (Vol[2] != Vol[0])
      {
        if (D_N == 0) Display.setColor(Color[Night_Digit]);           // Устанавливаем цвет текста
        else Display.setColor(Color[Day_Digit]);

        Display.drawLine(375, 53, 455, 25);                           // Треугольник Громкости
        Display.drawLine(374, 52, 456, 24);  
        Display.drawLine(375, 52, 455, 52);  
        Display.drawLine(374, 53, 456, 53);  
        Display.drawLine(455, 25, 455, 52);  
        Display.drawLine(456, 24, 456, 53);  

        Display.setFont(Arial_Rus_24x32);                             // Устанавливаем шрифт
        PrintRus(Display, "-", 340, 25, 0);
        PrintRus(Display, "+", 468, 25, 0);

        Display.setFont(Arial_round_16x24);                           // Устанавливаем шрифт
        Display.printNumI(Vol[D_N], 403, 28);
        Vol[2] = Vol[0];
      }
/*-----------------------------------------------------------------------------------------------------*/
      Display.setFont(Arial_Rus_24x32);                               // Устанавливаем шрифт

      Display.printNumF(Hum_Aht, 1, X_Hum - 5, Y_Hum);
      PrintRus(Display, "%", X_Hum + 95, Y_Hum + 5, 0);

      Display.printNumF(Alt_Bmp, 0, X_Alt, Y_Alt);
      PrintRus(Display, "M", X_Alt + 100, Y_Alt, 0);

      Display.printNumF(Press_Bmp, 0, X_Pres, Y_Pres, 0);
      PrintRus(Display, "mm", X_Pres + 80, Y_Pres + 5, 0);
    }
/*-----------------------------------------------------------------------------------------------------*/
    if (Save_Time == 1) {Save_Time = 0; Save_Clock();}
    Read_Clock();
    if (((Hour[0] >= 0) && (Hour[0] <= 6))) {Set_Color = Night_Digit; Color_Set = Night_Digit;}
    else {Set_Color = Day_Digit; Color_Set = Day_Digit;}
    if (Hour[0] >= 21) {Set_Color = Night_Digit; Color_Set = Night_Digit;}
/*-----------------------------------------------------------------------------------------------------*/
    Ind = 1; Drawing_Clock();

    Day_Night();
    Points();
    Hour_Signals();
  }
  else 
  {
    Set_Colors(); 
    switch (Setup_Color)
    {
      case 1: Frame_Color(); Setup_Color = 2; break;
    }

    if (Bell_ON == 1)
    {
      if (Hour_Bell[0] == Hour[0])
      {
        if (Minute_Bell[0] == Minute[0])
        {
          switch (On_Bell)
          {
            case 0: On_Bell = 1; MP3.play(15); delay(500); break;
          }
        }
      }
    }
  }
}
/*=======================================================================================================
                                            Сигнал каждый час и полчаса
=======================================================================================================*/
void Hour_Signals()
{
  if (Minute[5] != Minute[1])                               // Получасовой сигнал
  {
    Minute[5] = Minute[1];
    if (Minute[1] == 3) MP3.play(14); delay(500);
  }
/*-----------------------------------------------------------------------------------------------------*/
  if (Hour[5] != Hour[0])                                   // Часовой сигнал
  {
    if (Voice == 0)
    {
      if (Hour[0] <= 12) MP3.play(Hour[0]); delay(500);
      if (Hour[0] >= 13) MP3.play(Hour[0] - 12); delay(500);
      if (Hour[0] == 00) MP3.play(12); delay(500);
    }
    if (Voice == 1)
    {
      if (Hour[0] <= 12) {Kuranty = (Hour[0] + 20) - 5; MP3.play(Kuranty); delay(500);}
      if (Hour[0] >= 13) {Kuranty = ((Hour[0] + 20) - 12) - 5; MP3.play(Kuranty); delay(500);}
      if (Hour[0] == 00) {Kuranty = 32 - 5; MP3.play(Kuranty); delay(500);}
    }
    Hour[5] = Hour[0]; 
  }
}
/*=======================================================================================================
                                          Переключатель День / Ночь
=======================================================================================================*/
void Day_Night()
{
  if (Hour[0] >= 21) if (Zero == 0) Days_Night(Night_Digit, Night_Fon, 1);
  if ((Hour[0] >= 0) && (Hour[0] <= 6))  if (Zero == 0) Days_Night(Night_Digit, Night_Fon, 1);
  if ((Hour[0] >= 7) && (Hour[0] <= 20)) if (Zero == 1) Days_Night(Day_Digit, Day_Fon, 0);
}
/*=====================================================================================================*/
void Days_Night(byte Color_Digit, byte Color_Fon, byte Zer)
{
  Display.fillScr(Color[Color_Fon]);                            // Очистка экрана с заливкой заданным цветом
  Display.setBackColor(Color[Color_Fon]);                       // Выбор цвета для фона текста
  Set_Color = Color_Digit;
  Zero_Clock();
  D_N = Zero; MP3.volume(Vol[D_N]); delay(200); Vol[2] = 0;
/*-----------------------------------------------------------------------------------------------------*/
  Frame(X_Data, Y_Data, Xe_Data, Ye_Data, 0, Color_Digit, Color_Fon);
  Frame(X_Wek, Y_Wek, Xe_Wek, Ye_Wek, 0, Color_Digit, Color_Fon);
  Frame(X_Clock, Y_Clock, Xe_Clock, Ye_Clock, 0, Color_Digit, Color_Fon);
  Frame(X_Celsio, Y_Celsio, Xe_Celsio, Ye_Celsio, 0, Color_Digit, Color_Fon);
  Frame(X_Hum_P, Y_Hum_P, Xe_Hum_P, Ye_Hum_P, 0, Color_Digit, Color_Fon);
  Frame(X_Alty, Y_Alty, Xe_Alty, Ye_Alty, 0, Color_Digit, Color_Fon);
  Frame(X_Press, Y_Press, Xe_Press, Ye_Press, 0, Color_Digit, Color_Fon);
  Frame(X_Set, Y_Set, Xe_Set, Ye_Set, 1, Color_Digit, Color_Fon);
  Frame(X_Vol, Y_Vol, Xe_Vol, Ye_Vol, 0, Color_Digit, Color_Fon);
/*-----------------------------------------------------------------------------------------------------*/
  Zero = Zer;
}
/*=======================================================================================================
                                              Рисуем точки
=======================================================================================================*/
void Points()
{
    if (Sec[0] >= 10)                                                 // 1 сек
    {
      Sec[0] = 0;
      Display.setFont(Point_16x180);                                  // Устанавливаем шрифт
      switch (Flag_Point)
      {
        case 0: 
              Flag_Point = 1;
              if (Bell_ON == 0)
              {
                Display.print("2", X_Point_1, Y_Point_1);             // Рисуем точку
                Display.print("2", X_Point_2, Y_Point_2);             // Рисуем точку
              }
              else
              {
                Display.print("0", X_Point_1, Y_Point_1);             // Рисуем точку
                Display.print("0", X_Point_2, Y_Point_2);             // Рисуем точку
              }
        break;
        case 1: 
              Flag_Point = 0;
              if (Bell_ON == 0)
              {
                Display.print("3", X_Point_1, Y_Point_1);             // Рисуем точку
                Display.print("3", X_Point_2, Y_Point_2);             // Рисуем точку
              }
              else
              {
                Display.print("1", X_Point_1, Y_Point_1);             // Рисуем точку
                Display.print("1", X_Point_2, Y_Point_2);             // Рисуем точку
              }
        break;
      }
    }
}
/*=====================================================================================================*/
